/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractXMLConfig;
import IDE.Configuration.XMLConfigField;
import IDE.Configuration.XMLConfigMethod;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

public class XMLConfigClass
extends AbstractXMLConfig {
    private String name;
    private Vector fields = new Vector();
    private Vector methods = new Vector();

    public XMLConfigClass(String name) {
        this.name = name;
    }

    public void addField(XMLConfigField field) {
        this.fields.add(field);
    }

    public void addMethod(XMLConfigMethod method) {
        this.methods.add(method);
    }

    public void serialize(Writer writer) {
        try {
            int i;
            writer.write("<class :name=\"" + Util.normalize(this.name) + "\">");
            int m = this.fields.size();
            for (i = 0; i < m; ++i) {
                writer.write("\n");
                ((XMLConfigField)this.fields.elementAt(i)).serialize(writer);
            }
            m = this.methods.size();
            for (i = 0; i < m; ++i) {
                writer.write("\n");
                ((XMLConfigMethod)this.methods.elementAt(i)).serialize(writer);
            }
            writer.write("</class>\n");
        }
        catch (IOException e) {
            MessageHandler.report("Error writing XMLConfigClass", e);
        }
    }

    public void configure() {
        try {
            int i;
            Class<?> cls = Class.forName(this.name);
            int m = this.fields.size();
            for (i = 0; i < m; ++i) {
                ((XMLConfigField)this.fields.elementAt(i)).configure(cls);
            }
            m = this.methods.size();
            for (i = 0; i < m; ++i) {
                ((XMLConfigMethod)this.methods.elementAt(i)).configure(cls);
            }
        }
        catch (ClassNotFoundException e) {
            errorDuringConfig = true;
            MessageHandler.report("Invalid class in configuration file", e);
        }
    }
}

