/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.Configuration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SplashScreen {
    private static JFrame frame = null;
    private static JLabel text;

    public static void showSplash() {
        JPanel content = new JPanel(new BorderLayout(0, 0));
        JTextArea poem = new JTextArea();
        poem.setEditable(false);
        poem.setFont(new Font("Calligula", 2, 10));
        poem.setForeground(Color.BLUE);
        poem.setBackground(Color.WHITE);
        poem.insert("'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.\n\nBeware the Jabberwock, my son!\n The jaws that bite, the claws that catch!\nBeware the Jubjub bird, and shun\n The frumious Bandersnatch!\n\nHe took his vorpal sword in hand:\n Long time the maxome foe he sought--\nSo rested he by the Tumtum tree,\n And stood awhile in thought.\n\nAnd, as in uffish thought he stood,\n The Jabberwock, with eyes of flame,\nCame whiffling through the tulgey wood,\n And burbled as it came!\n\nOne, two! One, two And through and through\n The vorpal blade went snicker-snack!\nHe left it dead, and with its head\n He went galumphing back.\n\n\"And hast thou slain the Jabberwock?\n Come to my arms, my beamish boy!\nO frabjous day! Callooh! Callay!\"\n He chortled in his joy.\n\n'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.", 0);
        ImageIcon icon = Configuration.getIcon("jabberwocky.jpg");
        JLabel image = new JLabel(icon);
        frame = new JFrame();
        text = new JLabel("Starting ...", 0);
        text.setFont(new Font("Lucida Sans Typewriter", 1, 15));
        content.add((Component)image, "Center");
        content.add((Component)text, "South");
        content.add((Component)poem, "East");
        content.setBackground(poem.getBackground());
        frame.setBackground(poem.getBackground());
        frame.getContentPane().add(content);
        frame.setSize(icon.getIconWidth() + poem.getPreferredSize().width, Math.max(icon.getIconHeight(), poem.getPreferredSize().height) + text.getHeight() + 60);
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int x = bounds.width / 2;
        x = Math.max(0, x - icon.getIconWidth() / 2);
        int y = bounds.height / 2;
        y = Math.max(0, y - icon.getIconHeight() / 2);
        frame.setLocation(x, y);
        frame.setTitle(Configuration.IDEName + " " + Configuration.IDEVersion);
        frame.setVisible(true);
    }

    public static void showMessage(String message) {
        if (text != null) {
            text.setText(message);
            text.repaint();
        }
    }

    public static void disposeSplash() {
        text = null;
        frame.setVisible(false);
        frame.dispose();
        frame = null;
    }
}

