/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractManagedAction;
import IDE.Configuration.ActionKeyMap;
import IDE.Configuration.InstallParameters;
import IDE.Configuration.KeySequence;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.LispScripting.GenerateLispCode;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class Mode {
    public static final String ACTIONNAME = "ACTION";
    private static Hashtable modes = new Hashtable();
    private static TreeMap nameToAction = new TreeMap();
    private static HashMap actionToName = new HashMap();
    private String name;
    protected TreeMap menus = new TreeMap();
    protected JMenuBar menubar;
    protected JPanel toolbars;
    protected ActionKeyMap keymap;
    protected JPopupMenu popupmenu;
    protected HashMap popupmenus = new HashMap();
    protected HashMap nameToToolbar = new HashMap();

    public Mode(String name) {
        this.name = name;
        modes.put(name, this);
        this.menubar = new JMenuBar();
        this.toolbars = new JPanel();
        this.toolbars.setLayout(new BoxLayout(this.toolbars, 1));
        this.keymap = new ActionKeyMap();
        this.popupmenu = new JPopupMenu();
    }

    public Mode createCopy(String name) {
        Mode mode = new Mode(name);
        this.copyMenus(mode);
        this.copyToolbars(mode);
        this.copyBindings(mode);
        this.copyPopupMenu(mode);
        return mode;
    }

    private void copyMenus(Mode mode) {
        int l = this.menubar.getMenuCount();
        for (int i = 0; i < l; ++i) {
            JMenu menu = this.menubar.getMenu(i);
            mode.menubar.add(this.copyMenu(mode, menu, null));
        }
    }

    private JMenu copyMenu(Mode mode, JMenu menu, String path) {
        int l = menu.getMenuComponentCount();
        JMenu newmenu = new JMenu(menu.getText());
        newmenu.setMnemonic(menu.getMnemonic());
        if (path == null) {
            path = "'" + menu.getText() + "'";
            mode.menus.put(path, newmenu);
        } else {
            path = path + "/'" + menu.getText() + "'";
            mode.menus.put(path, newmenu);
        }
        for (int i = 0; i < l; ++i) {
            AbstractManagedAction action;
            Component item = menu.getMenuComponent(i);
            if (item instanceof JMenu) {
                newmenu.add(this.copyMenu(mode, (JMenu)item, path));
                continue;
            }
            if (item instanceof JSeparator) {
                newmenu.addSeparator();
                continue;
            }
            if (item instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem newcb = new JCheckBoxMenuItem(((JCheckBoxMenuItem)item).getText());
                action = (AbstractManagedAction)((JCheckBoxMenuItem)item).getAction();
                if (action != null) {
                    action.addUser(newcb);
                }
                newcb.setAction(action);
                newcb.setState(((JCheckBoxMenuItem)item).getState());
                newcb.setIcon(null);
                newmenu.add(newcb);
                continue;
            }
            if (!(item instanceof AbstractButton)) continue;
            action = (AbstractManagedAction)((AbstractButton)item).getAction();
            JMenuItem newitem = new JMenuItem(action);
            newitem.setIcon(null);
            if (action != null) {
                action.addUser(newitem);
            }
            newmenu.add(newitem);
        }
        return newmenu;
    }

    private void copyPopupMenu(Mode mode) {
        int m = this.popupmenu.getComponentCount();
        for (int i = 0; i < m; ++i) {
            AbstractManagedAction action;
            Component item = this.popupmenu.getComponent(i);
            if (item instanceof JMenu) {
                mode.popupmenu.add(this.copyPopupMenuMenu(mode, (JMenu)item, null));
                continue;
            }
            if (item instanceof JSeparator) {
                mode.popupmenu.addSeparator();
                continue;
            }
            if (!(item instanceof AbstractButton) || (action = (AbstractManagedAction)((AbstractButton)item).getAction()) == null) continue;
            JMenuItem menuitem = mode.popupmenu.add(action);
            action.addUser(menuitem);
        }
    }

    private JMenu copyPopupMenuMenu(Mode mode, JMenu menu, String path) {
        JMenu copymenu = new JMenu();
        int m = menu.getMenuComponentCount();
        copymenu = new JMenu(menu.getText());
        if (path == null) {
            path = "'" + menu.getText() + "'";
            mode.popupmenus.put(path, copymenu);
        } else {
            path = path + "/'" + menu.getText() + "'";
            mode.popupmenus.put(path, copymenu);
        }
        for (int i = 0; i < m; ++i) {
            AbstractManagedAction action;
            Component item = menu.getMenuComponent(i);
            if (item instanceof JMenu) {
                copymenu.add(this.copyPopupMenuMenu(mode, (JMenu)item, path));
                continue;
            }
            if (item instanceof JSeparator) {
                copymenu.addSeparator();
                continue;
            }
            if (!(item instanceof AbstractButton) || (action = (AbstractManagedAction)((AbstractButton)item).getAction()) == null) continue;
            JMenuItem menuitem = copymenu.add(action);
            action.addUser(menuitem);
        }
        return copymenu;
    }

    private void copyToolbars(Mode mode) {
        int m = this.toolbars.getComponentCount();
        for (int i = 0; i < m; ++i) {
            JToolBar toolbar = (JToolBar)this.toolbars.getComponent(i);
            JToolBar newtoolbar = new JToolBar();
            newtoolbar.setLayout(new FlowLayout(0, 0, 0));
            newtoolbar.setName(toolbar.getName());
            JPanel buttonbar = new JPanel();
            buttonbar.setLayout(new FlowLayout(0, 0, 0));
            this.copyButtonBar((JPanel)toolbar.getComponent(0), buttonbar);
            JPanel miscbar = new JPanel();
            miscbar.setLayout(new FlowLayout(0, 0, 0));
            newtoolbar.add(buttonbar);
            newtoolbar.add(miscbar);
            mode.toolbars.add(newtoolbar);
            mode.nameToToolbar.put(toolbar.getName(), newtoolbar);
        }
    }

    private void copyButtonBar(JPanel oldbuttonbar, JPanel newbuttonbar) {
        int l = oldbuttonbar.getComponentCount();
        for (int i = 0; i < l; ++i) {
            if (oldbuttonbar.getComponent(i) instanceof JButton) {
                JButton button = (JButton)oldbuttonbar.getComponent(i);
                AbstractManagedAction action = (AbstractManagedAction)button.getAction();
                JButton newbutton = new JButton(action);
                if (action != null) {
                    action.addUser(newbutton);
                }
                newbutton.setBorder(BorderFactory.createEtchedBorder());
                newbutton.setText(button.getText());
                newbuttonbar.add(newbutton);
                continue;
            }
            if (!(oldbuttonbar.getComponent(i) instanceof JToolBar.Separator)) continue;
            newbuttonbar.add(new JToolBar.Separator());
        }
    }

    private void copyBindings(Mode mode) {
        KeySequence[] sequences = this.keymap.getKeySequences();
        for (int i = 0; i < sequences.length; ++i) {
            mode.bindActionToKeySequence((String)this.keymap.getAction(sequences[i]).getValue(ACTIONNAME), sequences[i]);
        }
    }

    public void addActionToMenu(String path, String actionname) {
        JMenu menu = this.createMenu(path);
        AbstractManagedAction action = Mode.getAction(actionname);
        if (menu != null && action != null) {
            JMenuItem item = new JMenuItem(action);
            menu.add(item);
            action.addUser(item);
            item.setIcon(null);
        }
    }

    public void addToolbar(String name) {
        if (this.nameToToolbar.get(name) != null) {
            MessageHandler.warn("Try to create a existing toolbar");
            return;
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setName(name);
        JPanel miscbar = new JPanel();
        JPanel buttonbar = new JPanel();
        toolbar.setLayout(new FlowLayout(0, 0, 0));
        buttonbar.setLayout(new FlowLayout(0, 0, 0));
        miscbar.setLayout(new FlowLayout(0, 0, 0));
        toolbar.add(buttonbar);
        toolbar.add(miscbar);
        this.nameToToolbar.put(name, toolbar);
        this.toolbars.add(toolbar);
    }

    private JPanel getButtonbarIn(String name) {
        JToolBar toolbar = (JToolBar)this.nameToToolbar.get(name);
        if (toolbar == null) {
            return null;
        }
        return (JPanel)toolbar.getComponent(0);
    }

    private JPanel getMiscBarIn(String name) {
        JToolBar toolbar = (JToolBar)this.nameToToolbar.get(name);
        if (toolbar == null) {
            return null;
        }
        return (JPanel)toolbar.getComponent(1);
    }

    public void addCheckboxToMenu(String path, String actionname, boolean enable) {
        JMenu menu = this.createMenu(path);
        AbstractManagedAction action = Mode.getAction(actionname);
        if (menu != null && action != null) {
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(action);
            action.addUser(cb);
            cb.setState(enable);
            menu.add(cb);
        }
    }

    public void addSeparatorToMenu(String path) {
        JMenu menu = this.createMenu(path);
        if (menu != null) {
            menu.addSeparator();
        }
    }

    private JMenu createMenu(String path) {
        int i = 0;
        int l = path.length();
        StringBuffer name = new StringBuffer();
        boolean enabled = false;
        JMenu menu = null;
        JMenu previous = null;
        while (i < l) {
            int b = i;
            name.delete(0, name.length());
            i = this.parseName(path, i, name);
            if (i == -1) {
                return null;
            }
            menu = (JMenu)this.menus.get(path.substring(0, i - 1));
            if (menu == null) {
                menu = new JMenu(name.toString());
                this.menus.put(path.substring(0, i - 1), menu);
                if (previous == null) {
                    this.menubar.add(menu);
                } else {
                    previous.add(menu);
                }
            }
            previous = menu;
        }
        return menu;
    }

    private int parseName(String path, int i, StringBuffer name) {
        int l = path.length();
        if (path.charAt(i) != '\'') {
            return -1;
        }
        ++i;
        while (i < l && path.charAt(i) != '\'') {
            name.append(path.charAt(i));
            ++i;
        }
        if (i < l) {
            return i + 2;
        }
        return -1;
    }

    public void addActionToPopup(String actionname) {
        AbstractManagedAction action = Mode.getAction(actionname);
        if (action != null) {
            JMenuItem item = this.popupmenu.add(action);
            item.setIcon(null);
            action.addUser(item);
        }
    }

    public void addActionToPopup(String path, String actionname) {
        if (Mode.getAction(actionname) != null) {
            JMenu menu = this.createPopupMenu(path);
            AbstractManagedAction action = Mode.getAction(actionname);
            JMenuItem item = menu.add(action);
            item.setIcon(null);
            action.addUser(item);
        }
    }

    public void addSeparatorToPopup(String path) {
        JMenu menu = this.createPopupMenu(path);
        if (menu == null) {
            this.popupmenu.addSeparator();
        }
    }

    private JMenu createPopupMenu(String path) {
        int i = 0;
        int l = path.length();
        StringBuffer name = new StringBuffer();
        boolean enabled = false;
        JMenu menu = null;
        JMenu previous = null;
        while (i < l) {
            int b = i;
            name.delete(0, name.length());
            i = this.parseName(path, i, name);
            if (i == -1) {
                return null;
            }
            menu = (JMenu)this.popupmenus.get(path.substring(0, i - 1));
            if (menu == null) {
                menu = new JMenu(name.toString());
                this.popupmenus.put(path.substring(0, i - 1), menu);
                if (previous == null) {
                    this.popupmenu.add(menu);
                } else {
                    this.popupmenu.add(menu);
                }
            }
            previous = menu;
        }
        return menu;
    }

    public void addSeparatorToButtonBar(String toolbar) {
        JPanel buttonbar = this.getButtonbarIn(toolbar);
        if (buttonbar == null) {
            MessageHandler.warn("Add seperator to buttonbar of unknown toolbar " + toolbar);
            return;
        }
        buttonbar.add(new JToolBar.Separator());
    }

    public void addButton(String toolbar, String actionname) {
        this.addButton(toolbar, actionname, "");
    }

    public void addButton(String toolbar, String actionname, String text) {
        AbstractManagedAction action = Mode.getAction(actionname);
        if (action == null) {
            MessageHandler.warn("Add button for unknown action");
            return;
        }
        JPanel buttonbar = this.getButtonbarIn(toolbar);
        if (buttonbar == null) {
            MessageHandler.warn("Add button to buttonbar of unknown toolbar " + toolbar);
            return;
        }
        JButton button = new JButton(action);
        button.setBorder(BorderFactory.createEtchedBorder());
        button.setText(text);
        action.addUser(button);
        buttonbar.add(button);
    }

    public void addMiscToMode(String toolbar, JComponent slider) {
        JPanel miscbar = this.getMiscBarIn(toolbar);
        if (miscbar == null) {
            MessageHandler.warn("Add component to miscbar of unknown toolbar " + toolbar);
            return;
        }
        miscbar.add(slider);
        miscbar.revalidate();
        miscbar.repaint();
        this.activate();
    }

    public void removeComponentFromMode(String toolbar, Component component) {
        JPanel miscbar = this.getMiscBarIn(toolbar);
        if (miscbar == null) {
            MessageHandler.warn("Add component to miscbar of unknown toolbar " + toolbar);
            return;
        }
        miscbar.remove(component);
        miscbar.revalidate();
        miscbar.repaint();
        this.activate();
    }

    public void bindActionToKeySequence(String action, KeySequence keystroke) {
        this.keymap.addAction(action, keystroke);
    }

    public void bindActionToKeySequence(String action, int key, int modifier) {
        this.keymap.addAction(action, new KeySequence(key, modifier));
    }

    public void bindActionToKeySequence(String action, int key1, int modifier1, int key2, int modifier2) {
        this.keymap.addAction(action, new KeySequence(new int[][]{{key1, modifier1}, {key2, modifier2}}));
    }

    public void bindActionToKeySequence(String action, int[][] keystroke) {
        this.keymap.addAction(action, new KeySequence(keystroke));
    }

    public static void addAction(String name, String shortDescription, String longDescription, AbstractManagedAction action) {
        action.putValue(ACTIONNAME, name);
        action.putValue("Name", shortDescription);
        action.putValue("ShortDescription", shortDescription);
        action.putValue("LongDescription", longDescription);
        nameToAction.put(name, action);
        actionToName.put(action, name);
    }

    public static AbstractManagedAction getAction(String name) {
        return (AbstractManagedAction)nameToAction.get(name);
    }

    public JMenu getMenu(String name) {
        return (JMenu)this.menus.get(name);
    }

    public String getName() {
        return this.name;
    }

    public static String getNameAction(AbstractManagedAction action) {
        return (String)actionToName.get(action);
    }

    public static int getActionCount() {
        return nameToAction.size();
    }

    public static Mode getMode(String name) {
        Mode mode = (Mode)modes.get(name);
        if (mode == null) {
            MessageHandler.warn("Unknow mode=" + name + ", reverting to base mode");
            return (Mode)modes.get("basic");
        }
        return mode;
    }

    public static ActionKeyMap[] getKeyMaps() {
        Iterator iter = modes.values().iterator();
        ActionKeyMap[] keymaps = new ActionKeyMap[modes.size()];
        int i = 0;
        while (iter.hasNext()) {
            keymaps[i] = ((Mode)iter.next()).keymap;
            ++i;
        }
        return keymaps;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public static Iterator getActionIterator() {
        return nameToAction.values().iterator();
    }

    public void activate() {
        if (this.toolbars.getComponentCount() == 0) {
            this.toolbars.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.toolbars.setBorder(BorderFactory.createEtchedBorder());
        }
        Main.setMode(this, this.menubar, this.toolbars, this.keymap);
    }

    public static void generateDocumentation() {
        try {
            String actionkey;
            String actiondescription;
            String actionname;
            AbstractManagedAction action;
            File installdoc = new File(InstallParameters.getInstallDir() + File.separator + "doc" + File.separator + "actions.html");
            File sourcedoc = new File(InstallParameters.getSourceDir() + File.separator + "doc" + File.separatorChar + "actions.html");
            if (sourcedoc.exists()) {
                sourcedoc.delete();
            }
            sourcedoc.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(installdoc));
            TreeMap<String, AbstractManagedAction> keyToAction = new TreeMap<String, AbstractManagedAction>();
            TreeMap<String, AbstractManagedAction> descriptionToAction = new TreeMap<String, AbstractManagedAction>();
            writer.write("<html>\n");
            writer.write("<head>\n");
            writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html\">\n");
            writer.write("<title></title>\n");
            writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">\n");
            writer.write("</head>\n");
            writer.write("<html>\n");
            writer.write("<h3><a name=\"actionssortedbyname\">Actions sorted by action name</a></h3>");
            writer.write("<table align=\"center\" frame=\"box\" border=\"1\">\n");
            writer.write("  <tbody>\n");
            writer.write("  <thead>\n");
            writer.write("     <tr>\n");
            writer.write("         <td>action</td><td>key</td><td>Lisp Function</td><td>Description</td>\n");
            writer.write("     </tr>\n");
            writer.write("  </thead>\n");
            Iterator<Object> iter = nameToAction.values().iterator();
            while (iter.hasNext()) {
                action = (AbstractManagedAction)iter.next();
                actionname = (String)action.getValue(ACTIONNAME);
                actiondescription = (String)action.getValue("LongDescription");
                String string = actionkey = action.getValue("KeySequence") instanceof KeySequence ? Mode.replaceSpecial(((KeySequence)action.getValue("KeySequence")).toString()) : "";
                if (actionkey.length() != 0) {
                    keyToAction.put(actionkey, action);
                }
                descriptionToAction.put(actiondescription, action);
                writer.write("    <tr>\n");
                writer.write("         <td>" + actionname + "</td>\n");
                writer.write("         <td>" + actionkey + "</td>\n");
                writer.write("         <td>IDE-" + GenerateLispCode.createFunctionName(action) + "</td>\n");
                writer.write("         <td>" + actiondescription + "</td>\n");
                writer.write("    </tr>\n");
            }
            writer.write("  </tbody>\n");
            writer.write("</table>\n");
            writer.write("<h3><a name=\"actionssortedbydescription\">Actions sorted by description</a></h3>");
            writer.write("<table align=\"center\" frame=\"box\" border=\"1\">\n");
            writer.write("  <tbody>\n");
            writer.write("  <thead>\n");
            writer.write("     <tr>\n");
            writer.write("         <td>description</td><td>action</td><td>key</td><td>Lisp Function</td>\n");
            writer.write("     </tr>\n");
            writer.write("  </thead>\n");
            iter = descriptionToAction.values().iterator();
            while (iter.hasNext()) {
                action = (AbstractManagedAction)iter.next();
                actionname = (String)action.getValue(ACTIONNAME);
                actiondescription = (String)action.getValue("ShortDescription");
                actionkey = action.getValue("KeySequence") instanceof KeySequence ? Mode.replaceSpecial(((KeySequence)action.getValue("KeySequence")).toString()) : "";
                writer.write("    <tr>\n");
                writer.write("         <td>" + actiondescription + "</td>\n");
                writer.write("         <td>" + actionname + "</td>\n");
                writer.write("         <td>" + actionkey + "</td>\n");
                writer.write("         <td>IDE-" + GenerateLispCode.createFunctionName(action) + "</td>\n");
                writer.write("    </tr>\n");
            }
            writer.write("  </tbody>\n");
            writer.write("</table>\n");
            writer.write("<h3><a name=\"actionssortedbykeysequence\">Actions sorted by key sequence</a></h3>");
            writer.write("<table align=\"center\" frame=\"box\" border=\"1\">\n");
            writer.write("  <tbody>\n");
            writer.write("  <thead>\n");
            writer.write("     <tr>\n");
            writer.write("         <td>key</td><td>action</td><td>Lisp Function</td><td>Description</td>\n");
            writer.write("     </tr>\n");
            writer.write("  </thead>\n");
            iter = keyToAction.values().iterator();
            while (iter.hasNext()) {
                action = (AbstractManagedAction)iter.next();
                actionname = (String)action.getValue(ACTIONNAME);
                actiondescription = (String)action.getValue("ShortDescription");
                String string = actionkey = action.getValue("KeySequence") instanceof KeySequence ? Mode.replaceSpecial(((KeySequence)action.getValue("KeySequence")).toString()) : "";
                if (actionkey.length() != 0) {
                    keyToAction.put(actionkey, action);
                }
                descriptionToAction.put(actiondescription, action);
                writer.write("    <tr>\n");
                writer.write("         <td>" + actionkey + "</td>\n");
                writer.write("         <td>" + actionname + "</td>\n");
                writer.write("         <td>IDE-" + GenerateLispCode.createFunctionName(action) + "</td>\n");
                writer.write("         <td>" + actiondescription + "</td>\n");
                writer.write("    </tr>\n");
            }
            writer.write("  </tbody>\n");
            writer.write("</table>\n");
            Iterator modeIter = modes.keySet().iterator();
            writer.write("<h3><a name=\"menubinding\">Menu bindings</a></h3>\n");
            writer.write("<ul>\n");
            while (modeIter.hasNext()) {
                String modename = (String)modeIter.next();
                Mode mode = (Mode)modes.get(modename);
                iter = mode.menus.keySet().iterator();
                while (iter.hasNext()) {
                    String menustring = (String)iter.next();
                    JMenuItem menuitem = (JMenuItem)mode.menus.get(menustring);
                    writer.write("<li>\n");
                    writer.write("<p><b>" + Mode.menuToHTML(menustring) + "</b></p>\n");
                    writer.write("<ul>\n");
                    if (menuitem instanceof JMenu) {
                        JMenu menu = (JMenu)menuitem;
                        int m = menu.getMenuComponentCount();
                        for (int i = 0; i < m; ++i) {
                            menuitem = menu.getItem(i);
                            if (menuitem == null || (action = (AbstractManagedAction)menuitem.getAction()) == null) continue;
                            writer.write("<dl>\n");
                            writer.write("<dt>" + action.getValue(ACTIONNAME) + "</dt>\n");
                            writer.write("<dd>" + action.getValue("LongDescription") + "</dd>\n");
                            writer.write("</dl>\n");
                        }
                    }
                    writer.write("</li>\n");
                    writer.write("</ul>\n");
                }
            }
            writer.write("</ul>\n");
            writer.write("</html>\n");
            writer.close();
            if (new File(InstallParameters.getSourceDir()).exists()) {
                int c;
                BufferedReader reader = new BufferedReader(new FileReader(installdoc));
                writer = new BufferedWriter(new FileWriter(sourcedoc));
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                writer.close();
            }
        }
        catch (Exception e) {
            MessageHandler.report("Error creating documentation, " + e.getMessage(), e);
        }
    }

    private static String menuToHTML(String menu) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        int m = menu.length();
        for (int i = 0; i < m; ++i) {
            if (menu.charAt(i) == '\'') {
                if (count % 2 == 0) {
                    buffer.append("&lt;");
                } else {
                    buffer.append("&gt;");
                }
                ++count;
                continue;
            }
            buffer.append(menu.charAt(i));
        }
        return buffer.toString();
    }

    private static String replaceSpecial(String keysequence) {
        StringBuffer result = new StringBuffer();
        int m = keysequence.length();
        for (int i = 0; i < m; ++i) {
            char c = keysequence.charAt(i);
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static void addKeyBinding(String mode, String action, int k0, int k1, int k2, int k3, int k4, int k5, int k6, int k7, int k8, int k9, int m0, int m1, int m2, int m3, int m4, int m5, int m6, int m7, int m8, int m9) {
        int[][] keys = new int[][]{{k0, m0}, {k1, m1}, {k2, m2}, {k3, m3}, {k4, m4}, {k5, m5}, {k6, m6}, {k7, m7}, {k8, m8}, {k9, m9}};
        KeySequence ks = new KeySequence(keys);
        Mode.getMode((String)mode).keymap.addAction(action, ks);
    }

    public static void saveConfiguration(Writer writer) {
        XMLConfigClass cls = new XMLConfigClass("IDE.Configuration.Mode");
        Iterator itermode = modes.values().iterator();
        while (itermode.hasNext()) {
            Mode mode = (Mode)itermode.next();
            KeySequence[] keysequences = mode.keymap.getKeySequences();
            for (int k = 0; k < keysequences.length; ++k) {
                int i;
                KeySequence ks = keysequences[k];
                if (mode.keymap.getAction(ks) == null) continue;
                XMLConfigMethod method = new XMLConfigMethod("addKeyBinding");
                method.addArgument(mode.name);
                method.addArgument((String)mode.keymap.getAction(ks).getValue(ACTIONNAME));
                int[][] keys = ks.getKeys();
                for (i = 0; i < 10; ++i) {
                    method.addArgument(keys[i][0]);
                }
                for (i = 0; i < 10; ++i) {
                    method.addArgument(keys[i][1]);
                }
                cls.addMethod(method);
            }
        }
        cls.serialize(writer);
    }
}

