/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import java.awt.event.KeyEvent;

public class KeySequence
implements Comparable {
    private int[] keycode;
    private int[] keymodifiers;
    private int next;

    public KeySequence() {
        boolean next = false;
        this.keycode = new int[10];
        this.keymodifiers = new int[10];
    }

    public KeySequence(int keycode, int modifiers) {
        boolean next = false;
        this.keycode = new int[10];
        this.keymodifiers = new int[10];
        this.keycode[0] = keycode;
        this.keymodifiers[0] = modifiers;
    }

    public KeySequence(int[][] keymod) {
        boolean next = false;
        this.keycode = new int[10];
        this.keymodifiers = new int[10];
        for (int i = 0; i < 10 && i < keymod.length; ++i) {
            this.keycode[i] = keymod[i][0];
            this.keymodifiers[i] = keymod[i][1];
        }
    }

    protected int[][] getKeys() {
        int[][] keys = new int[10][2];
        for (int i = 0; i < 10; ++i) {
            keys[i][0] = this.keycode[i];
            keys[i][1] = this.keymodifiers[i];
        }
        return keys;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeySequence) {
            KeySequence KeySequence2 = (KeySequence)obj;
            for (int i = 0; i < 10; ++i) {
                if (KeySequence2.keycode[i] == this.keycode[i] && KeySequence2.keymodifiers[i] == this.keymodifiers[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void addKey(int keycode, int keymodifiers) {
        if (this.next < 10) {
            this.keycode[this.next] = keycode;
            this.keymodifiers[this.next] = keymodifiers;
            ++this.next;
        }
    }

    public int size() {
        int size;
        for (size = 0; size < 10 && this.keymodifiers[size] != 0 || this.keycode[size] != 0; ++size) {
        }
        return size;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            if (this.keycode[i] == 0 && this.keymodifiers[i] == 0) continue;
            str.append("<");
            if (this.keymodifiers[i] != 0) {
                str.append(KeyEvent.getKeyModifiersText(this.keymodifiers[i]) + "-");
            }
            str.append(KeyEvent.getKeyText(this.keycode[i]));
            str.append(">");
        }
        return str.toString();
    }

    public String toStringShort(int n) {
        StringBuffer str = new StringBuffer();
        for (int i = n; i < 10; ++i) {
            if (this.keymodifiers[i] != 0) {
                str.append(KeyEvent.getKeyModifiersText(this.keymodifiers[i]) + "-");
            }
            if (this.keycode[i] == 0) continue;
            str.append(KeyEvent.getKeyText(this.keycode[i]));
        }
        return str.toString();
    }

    public boolean isPartOf(KeySequence KeySequence2) {
        for (int i = 0; i < 10; ++i) {
            if (this.keymodifiers[i] == 0 && this.keycode[i] == 0) {
                return true;
            }
            if (this.keymodifiers[i] == KeySequence2.keymodifiers[i] && this.keycode[i] == KeySequence2.keycode[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof KeySequence) {
            KeySequence KeySequence2 = (KeySequence)o;
            for (int i = 0; i < 10; ++i) {
                if (this.keymodifiers[i] < KeySequence2.keymodifiers[i]) {
                    return -1;
                }
                if (this.keymodifiers[i] == KeySequence2.keymodifiers[i]) {
                    if (this.keycode[i] < KeySequence2.keycode[i]) {
                        return -1;
                    }
                    if (this.keycode[i] <= KeySequence2.keycode[i]) continue;
                    return 1;
                }
                if (this.keymodifiers[i] <= KeySequence2.keymodifiers[i]) continue;
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

