/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.KeyCodeModifiersChar;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Messaging.MessageHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DeadKeySequence {
    private static ArrayList deadKeySequences = new ArrayList();
    private KeyCodeModifiersChar[] keycodemodifierschar = new KeyCodeModifiersChar[20];
    private char unicodechar;
    private int next = 0;
    private static SortedMap compiledKeySequence = null;
    private static SortedMap kmcToNext = null;
    private JTable table;
    DeadKeySequencesModel model;
    static /* synthetic */ Class class$IDE$Configuration$DeadKeySequence;
    static /* synthetic */ Class class$java$lang$Character;

    public static void Restart() {
        kmcToNext = null;
    }

    public static char checkForDeadKeys(KeyEvent e) {
        if (compiledKeySequence == null) {
            return '\u0000';
        }
        if (kmcToNext == null) {
            Object found = compiledKeySequence.get(new KeyCodeModifiersChar(e.getKeyCode(), e.getModifiers(), e.getKeyChar(), e.isAltGraphDown()));
            if (found == null) {
                return '\u0000';
            }
            if (found instanceof Character) {
                kmcToNext = null;
                return ((Character)found).charValue();
            }
            kmcToNext = (SortedMap)found;
            return '\u0000';
        }
        Object found = kmcToNext.get(new KeyCodeModifiersChar(e.getKeyCode(), e.getModifiers(), e.getKeyChar(), e.isAltGraphDown()));
        if (found == null) {
            kmcToNext = null;
            return '\u0000';
        }
        if (found instanceof Character) {
            kmcToNext = null;
            return ((Character)found).charValue();
        }
        kmcToNext = (SortedMap)found;
        return '\u0000';
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.next; ++i) {
            buffer.append("(");
            buffer.append(this.keycodemodifierschar[i].keycode);
            buffer.append(",");
            buffer.append(this.keycodemodifierschar[i].modifiers);
            buffer.append(",");
            buffer.append(this.keycodemodifierschar[i].keychar);
            buffer.append(",");
            buffer.append(this.keycodemodifierschar[i].isAltGraph);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static boolean compileKeySequences() {
        if (deadKeySequences.size() == 0) {
            compiledKeySequence = null;
        } else {
            compiledKeySequence = new TreeMap();
            int m = deadKeySequences.size();
            for (int i = 0; i < m; ++i) {
                DeadKeySequence seq = (DeadKeySequence)deadKeySequences.get(i);
                if (seq.next <= 0) continue;
                SortedMap kmcToKmc = compiledKeySequence;
                int j = 0;
                while (j + 1 < seq.next) {
                    Object found = kmcToKmc.get(seq.keycodemodifierschar[j]);
                    if (found == null) {
                        found = new TreeMap();
                        kmcToKmc.put(seq.keycodemodifierschar[j], found);
                        kmcToKmc = (SortedMap)found;
                    } else if (found instanceof SortedMap) {
                        kmcToKmc = (SortedMap)found;
                    } else {
                        MessageHandler.warn("Ambiguous key sequence");
                        return false;
                    }
                    ++j;
                }
                kmcToKmc.put(seq.keycodemodifierschar[seq.next - 1], new Character(seq.unicodechar));
            }
        }
        return true;
    }

    public DeadKeySequence copy() {
        DeadKeySequence seq = new DeadKeySequence();
        for (int i = 0; i < this.next; ++i) {
            KeyCodeModifiersChar kmc = this.keycodemodifierschar[i];
            seq.keycodemodifierschar[i] = new KeyCodeModifiersChar(kmc.keycode, kmc.modifiers, kmc.keychar, kmc.isAltGraph);
        }
        seq.unicodechar = this.unicodechar;
        seq.next = this.next;
        return seq;
    }

    public static void addDeadKeySequence(char unicodechar, int next, int c0, int m0, int ch0, boolean ag0, int c1, int m1, int ch1, boolean ag1, int c2, int m2, int ch2, boolean ag2, int c3, int m3, int ch3, boolean ag3, int c4, int m4, int ch4, boolean ag4, int c5, int m5, int ch5, boolean ag5, int c6, int m6, int ch6, boolean ag6, int c7, int m7, int ch7, boolean ag7, int c8, int m8, int ch8, boolean ag8, int c9, int m9, int ch9, boolean ag9, int c10, int m10, int ch10, boolean ag10, int c11, int m11, int ch11, boolean ag11, int c12, int m12, int ch12, boolean ag12, int c13, int m13, int ch13, boolean ag13, int c14, int m14, int ch14, boolean ag14, int c15, int m15, int ch15, boolean ag15, int c16, int m16, int ch16, boolean ag16, int c17, int m17, int ch17, boolean ag17, int c18, int m18, int ch18, boolean ag18, int c19, int m19, int ch19, boolean ag19) {
        DeadKeySequence seq = new DeadKeySequence();
        seq.unicodechar = unicodechar;
        seq.next = next;
        seq.keycodemodifierschar[0] = new KeyCodeModifiersChar(c0, m0, ch0, ag0);
        seq.keycodemodifierschar[1] = new KeyCodeModifiersChar(c1, m1, ch1, ag1);
        seq.keycodemodifierschar[2] = new KeyCodeModifiersChar(c2, m2, ch2, ag2);
        seq.keycodemodifierschar[3] = new KeyCodeModifiersChar(c3, m3, ch3, ag3);
        seq.keycodemodifierschar[4] = new KeyCodeModifiersChar(c4, m4, ch4, ag4);
        seq.keycodemodifierschar[5] = new KeyCodeModifiersChar(c5, m5, ch5, ag5);
        seq.keycodemodifierschar[6] = new KeyCodeModifiersChar(c6, m6, ch6, ag6);
        seq.keycodemodifierschar[7] = new KeyCodeModifiersChar(c7, m7, ch7, ag7);
        seq.keycodemodifierschar[8] = new KeyCodeModifiersChar(c8, m8, ch8, ag8);
        seq.keycodemodifierschar[9] = new KeyCodeModifiersChar(c9, m9, ch9, ag9);
        seq.keycodemodifierschar[10] = new KeyCodeModifiersChar(c10, m10, ch10, ag10);
        seq.keycodemodifierschar[11] = new KeyCodeModifiersChar(c11, m11, ch11, ag11);
        seq.keycodemodifierschar[12] = new KeyCodeModifiersChar(c12, m12, ch12, ag12);
        seq.keycodemodifierschar[13] = new KeyCodeModifiersChar(c13, m13, ch13, ag13);
        seq.keycodemodifierschar[14] = new KeyCodeModifiersChar(c14, m14, ch14, ag14);
        seq.keycodemodifierschar[15] = new KeyCodeModifiersChar(c15, m15, ch15, ag15);
        seq.keycodemodifierschar[16] = new KeyCodeModifiersChar(c16, m16, ch16, ag16);
        seq.keycodemodifierschar[17] = new KeyCodeModifiersChar(c17, m17, ch17, ag17);
        seq.keycodemodifierschar[18] = new KeyCodeModifiersChar(c18, m18, ch18, ag18);
        seq.keycodemodifierschar[19] = new KeyCodeModifiersChar(c19, m19, ch19, ag19);
        deadKeySequences.add(seq);
    }

    public static void saveConfiguration(Writer writer) {
        XMLConfigMethod method;
        XMLConfigClass cls = new XMLConfigClass((class$IDE$Configuration$DeadKeySequence == null ? (class$IDE$Configuration$DeadKeySequence = DeadKeySequence.class$("IDE.Configuration.DeadKeySequence")) : class$IDE$Configuration$DeadKeySequence).getName());
        int m = deadKeySequences.size();
        for (int i = 0; i < m; ++i) {
            DeadKeySequence seq = (DeadKeySequence)deadKeySequences.get(i);
            method = new XMLConfigMethod("addDeadKeySequence");
            method.addArgument(seq.unicodechar);
            method.addArgument(seq.next);
            for (int j = 0; j < seq.keycodemodifierschar.length; ++j) {
                KeyCodeModifiersChar kmc = seq.keycodemodifierschar[j];
                if (kmc == null) {
                    method.addArgument(0);
                    method.addArgument(0);
                    method.addArgument(0);
                    method.addArgument(true);
                    continue;
                }
                method.addArgument(kmc.keycode);
                method.addArgument(kmc.modifiers);
                method.addArgument(kmc.keychar);
                method.addArgument(kmc.isAltGraph);
            }
            cls.addMethod(method);
        }
        method = new XMLConfigMethod("compileKeySequences");
        cls.addMethod(method);
        cls.serialize(writer);
    }

    public void manageDeadKeySequences() {
        final JDialog dialog = new JDialog();
        dialog.setTitle("Manage special characters");
        dialog.setModal(true);
        this.model = new DeadKeySequencesModel();
        this.table = new JTable(this.model);
        this.table.setDefaultEditor(class$IDE$Configuration$DeadKeySequence == null ? (class$IDE$Configuration$DeadKeySequence = DeadKeySequence.class$("IDE.Configuration.DeadKeySequence")) : class$IDE$Configuration$DeadKeySequence, new DeadKeySequenceCellEditor());
        this.table.setDefaultEditor(class$java$lang$Character == null ? (class$java$lang$Character = DeadKeySequence.class$("java.lang.Character")) : class$java$lang$Character, new CharCellEditor());
        this.table.setDefaultRenderer(class$IDE$Configuration$DeadKeySequence == null ? (class$IDE$Configuration$DeadKeySequence = DeadKeySequence.class$("IDE.Configuration.DeadKeySequence")) : class$IDE$Configuration$DeadKeySequence, new DeadKeySequenceCellRenderer());
        this.table.setDefaultRenderer(class$java$lang$Character == null ? (class$java$lang$Character = DeadKeySequence.class$("java.lang.Character")) : class$java$lang$Character, new DeadKeySequenceCellRenderer());
        JScrollPane scrollpane = new JScrollPane(this.table);
        JButton add = new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent ev) {
                DeadKeySequence.this.model.addNewDeadKeySequence();
                DeadKeySequence.this.table.changeSelection(deadKeySequences.size() - 1, 0, false, false);
            }
        });
        JButton remove = new JButton(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ev) {
                int index = DeadKeySequence.this.table.getSelectedRow();
                if (index < 0) {
                    index = DeadKeySequence.this.table.getEditingRow();
                }
                if (index >= 0) {
                    DeadKeySequence.this.model.removeDeadKeySequence(index);
                    DeadKeySequence.this.table.getCellEditor().cancelCellEditing();
                }
            }
        });
        JButton ok = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                DeadKeySequence.this.model.updateDeadkeysequences();
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JButton cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.add(add);
        buttons.add(remove);
        buttons.add(ok);
        buttons.add(cancel);
        content.add((Component)scrollpane, "Center");
        content.add((Component)buttons, "South");
        dialog.setContentPane(content);
        dialog.setSize(400, 500);
        dialog.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DeadKeySequenceCellEditor
    extends JTextField
    implements TableCellEditor,
    KeyListener {
        ArrayList listeners = new ArrayList();
        DeadKeySequence current = null;
        DeadKeySequence old = null;
        int column;
        int row;

        public DeadKeySequenceCellEditor() {
            this.setEditable(false);
            this.addKeyListener(this);
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.add(l);
        }

        public void cancelCellEditing() {
            this.current = this.old;
        }

        public Object getCellEditorValue() {
            return this.current;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.column = column;
            this.row = row;
            this.current = (DeadKeySequence)value;
            this.old = this.current.copy();
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            if (column == 0) {
                this.setText(this.current.toString());
            } else {
                this.setText(String.valueOf(this.current.unicodechar));
            }
            return this;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (this.column == 0) {
                if (e.getKeyCode() == 112) {
                    this.current.next = 0;
                    this.setText("");
                } else if (this.current.next < this.current.keycodemodifierschar.length) {
                    ((DeadKeySequence)this.current).keycodemodifierschar[((DeadKeySequence)this.current).next] = new KeyCodeModifiersChar(e.getKeyCode(), e.getModifiers(), e.getKeyChar(), e.isAltGraphDown());
                    this.current.next = this.current.next + 1;
                    this.current.copy();
                    this.setText(this.current.toString());
                    DeadKeySequence.this.model.setValueAt(this.current, this.row, this.column);
                    DeadKeySequence.this.model.fireTableDataChanged();
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }
    }

    private class CharCellEditor
    extends JComboBox
    implements TableCellEditor,
    ItemListener {
        ArrayList listeners = new ArrayList();
        char current;
        char old;
        int column;
        int row;

        public CharCellEditor() {
            for (int i = 0; i < 256; ++i) {
                if (Character.isISOControl((char)i)) continue;
                this.addItem(String.valueOf((char)i));
            }
            this.addItemListener(this);
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.add(l);
        }

        public void cancelCellEditing() {
            this.current = this.old;
        }

        public Object getCellEditorValue() {
            return new Character(this.current);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Character character = (Character)value;
            this.current = character.charValue();
            this.column = column;
            this.row = row;
            ComboBoxModel mdl = this.getModel();
            int m = mdl.getSize();
            for (int i = 0; i < m; ++i) {
                if (((String)mdl.getElementAt(i)).charAt(0) != character.charValue()) continue;
                this.setSelectedIndex(i);
                break;
            }
            this.old = this.current;
            return this;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void itemStateChanged(ItemEvent e) {
            String charstring = (String)e.getItem();
            this.current = charstring.charAt(0);
            DeadKeySequence.this.model.setValueAt(new Character(this.current), this.row, this.column);
            DeadKeySequence.this.model.fireTableDataChanged();
        }
    }

    private class DeadKeySequenceCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private DeadKeySequenceCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                this.setText(((DeadKeySequence)value).toString());
            } else {
                this.setText(String.valueOf(value));
            }
            return this;
        }
    }

    private class DeadKeySequencesModel
    extends AbstractTableModel {
        ArrayList sequences = new ArrayList();

        public DeadKeySequencesModel() {
            int m = deadKeySequences.size();
            for (int i = 0; i < m; ++i) {
                this.sequences.add(((DeadKeySequence)deadKeySequences.get(i)).copy());
            }
        }

        public int getRowCount() {
            return this.sequences.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return this.sequences.get(r);
            }
            return new Character(((DeadKeySequence)this.sequences.get(r)).unicodechar);
        }

        public void setValueAt(Object value, int r, int c) {
            switch (c) {
                case 0: {
                    this.sequences.set(r, value);
                    break;
                }
                case 1: {
                    DeadKeySequence dks = (DeadKeySequence)this.sequences.get(r);
                    dks.unicodechar = ((Character)value).charValue();
                }
            }
        }

        public boolean isCellEditable(int r, int c) {
            return true;
        }

        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return "Key Sequence";
                }
                case 1: {
                    return "Unicode Character";
                }
            }
            return "Unknown column";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return class$IDE$Configuration$DeadKeySequence == null ? (class$IDE$Configuration$DeadKeySequence = DeadKeySequence.class$("IDE.Configuration.DeadKeySequence")) : class$IDE$Configuration$DeadKeySequence;
                }
                case 1: {
                    return class$java$lang$Character == null ? (class$java$lang$Character = DeadKeySequence.class$("java.lang.Character")) : class$java$lang$Character;
                }
            }
            return class$java$lang$Character == null ? (class$java$lang$Character = DeadKeySequence.class$("java.lang.Character")) : class$java$lang$Character;
        }

        private void addNewDeadKeySequence() {
            DeadKeySequence seq = new DeadKeySequence();
            int index = this.sequences.size();
            this.sequences.add(seq);
            this.fireTableRowsInserted(index, index);
        }

        private void removeDeadKeySequence(int index) {
            if (index < this.sequences.size()) {
                this.sequences.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }

        private void updateDeadkeysequences() {
            ArrayList oldsequences = (ArrayList)deadKeySequences.clone();
            deadKeySequences.clear();
            int m = this.sequences.size();
            for (int i = 0; i < m; ++i) {
                if (((DeadKeySequence)this.sequences.get(i)).next <= 0) continue;
                deadKeySequences.add(this.sequences.get(i));
            }
            if (!DeadKeySequence.compileKeySequences()) {
                deadKeySequences = oldsequences;
                DeadKeySequence.compileKeySequences();
            }
        }
    }
}

