/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.CodeEditor.CodeEditor;
import IDE.Configuration.AbstractBooleanAction;
import IDE.Configuration.AbstractChoiceAction;
import IDE.Configuration.AbstractColorAction;
import IDE.Configuration.AbstractFontAction;
import IDE.Configuration.AbstractIDEAction;
import IDE.Configuration.AbstractIntegerAction;
import IDE.Configuration.AbstractXMLConfig;
import IDE.Configuration.DeadKeySequence;
import IDE.Configuration.InstallParameters;
import IDE.Configuration.Mode;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigField;
import IDE.Configuration.XMLConfigObject;
import IDE.Configuration.XMLConfigReader;
import IDE.Explorer.FileExtensions;
import IDE.Help.HyperSpec;
import IDE.LispScripting.GenerateLispCode;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class Configuration {
    public static String IDEName = "Jabberwocky";
    public static String IDEVersion = "1.0.04";
    public static String helpbrowser = "konqueror";
    public static String installDirectory = InstallParameters.getInstallDir();
    public static Color colorSelection = new Color(198, 198, 198);
    public static Color colorList = new Color(240, 240, 255);
    public static Color colorComment = new Color(102, 102, 255);
    public static Color colorString = new Color(255, 102, 204);
    public static Color colorKeyword = new Color(153, 50, 0);
    public static Color colorVariable = new Color(0, 153, 51);
    public static Color colorCaller = new Color(153, 0, 153);
    public static Color colorCharacter = new Color(153, 0, 153);
    public static Color colorCursor = Color.red;
    public static Color colorForeground = Color.black;
    public static Color colorBackground = new Color(255, 255, 210);
    public static Color colorEndline = Color.red;
    public static Color colorArray = new Color(255, 0, 0);
    public static Color colorForegroundLine = Color.black;
    public static Color colorBackgroundLine = new Color(230, 230, 230);
    public static Color colorBreakpoint = new Color(255, 204, 204);
    public static Color colorExecutedCode = new Color(255, 175, 175);
    public static Color colorExecutingCode = new Color(153, 153, 255);
    public static Color colorBackQuote = new Color(0, 0, 255);
    public static Color colorQuote = new Color(255, 153, 0);
    public static Color colorNextStop = Color.yellow;
    public static Color colorSearch = Color.yellow;
    public static Color colorProfiling = Color.yellow;
    public static Color colorHint = Color.yellow;
    public static Color colorHook = new Color(120, 180, 255);
    public static Color colorSelected = new Color(160, 180, 230);
    public static boolean lineNumbering = true;
    public static Font font = new Font("Lucida Sans Typewriter", 0, 12);
    public static Font commentFont = new Font("Lucida Sans Typewriter", 0, 12);
    public static Font watchesFont = new Font("Dialog", 1, 10);
    public static Font macrosFont = new Font("Dialog", 1, 10);
    public static Font explorerFont = new Font("Dialog", 1, 10);
    public static int tabwidth = 8;
    public static boolean indentateOnEnter = true;
    public static boolean clickProjectSetCurrentDirectory = true;
    public static boolean clispBug = true;
    public static int blinkingRate = 500;
    public static int hoverTimeout = 50;
    public static int timeoutStopProcess = 10000;
    public static int maxLineLength = 80;
    public static boolean characterCompletion = true;
    public static boolean highligthList = true;
    public static boolean instrumentDebugAfter = true;
    public static boolean instrumentCheckError = true;
    public static int commandHistoryLength = 100;
    public static String lispStartupFile = "";
    public static String lookAndFeel = "";
    public static HashMap nameToIcon = new HashMap();

    public Configuration() {
        this.createOptionActions();
        Configuration.createRootMode();
        Configuration.createBasicMode();
        Configuration.createDebugMode();
        Configuration.createInteractionMode();
        Configuration.createDebugInteractionMode();
        this.loadConfiguration();
    }

    private void createOptionActions() {
        Mode.addAction("defaultfont", "Default Font", "Set the default font used by the buffers.", new AbstractFontAction("Default Font"){

            protected Font getFontValue() {
                return font;
            }

            protected void setFontValue(Font font) {
                Configuration.font = font;
            }
        });
        Mode.addAction("commentfont", "Font Comment", "Set the font used for comment elements.", new AbstractFontAction("Font Comment"){

            protected Font getFontValue() {
                return commentFont;
            }

            protected void setFontValue(Font font) {
                commentFont = font;
            }
        });
        Mode.addAction("explorerfont", "Font Project Explorer", "Set the font used for the Project Explorer", new AbstractFontAction("Font Explorer"){

            protected Font getFontValue() {
                return explorerFont;
            }

            protected void setFontValue(Font font) {
                explorerFont = font;
            }
        });
        Mode.addAction("watchesfont", "Font Watches", "Set the font used for the Watches pane", new AbstractFontAction("Font Watches"){

            protected Font getFontValue() {
                return watchesFont;
            }

            protected void setFontValue(Font font) {
                watchesFont = font;
            }
        });
        Mode.addAction("macrosfont", "Font Macros", "Set the font used for the Macro pane", new AbstractFontAction("Font Macros"){

            protected Font getFontValue() {
                return macrosFont;
            }

            protected void setFontValue(Font font) {
                macrosFont = font;
            }
        });
        Mode.addAction("linenumbers", "Line Numbers", "Turns on/off the display of line numbers in the buffers.", new AbstractBooleanAction("Line Numbers"){

            protected void setBoolValue(boolean value) {
                lineNumbering = value;
                Main.repaintEverything();
            }

            protected boolean getBoolValue() {
                return lineNumbering;
            }
        });
        Mode.addAction("indentateonenter", "Indentate on enter", "Turns on/of the automatically indentation when pressing enter.", new AbstractBooleanAction("Indentate on enter"){

            protected void setBoolValue(boolean value) {
                indentateOnEnter = value;
            }

            protected boolean getBoolValue() {
                return indentateOnEnter;
            }
        });
        Mode.addAction("clispbug", "Workaround CLISP bug", "Work around for a bug in CLISP and sending a single return", new AbstractBooleanAction("Workaround CLISP bug"){

            protected void setBoolValue(boolean value) {
                clispBug = value;
            }

            protected boolean getBoolValue() {
                return clispBug;
            }
        });
        Mode.addAction("charactercompletion", "Character completion", "Turns on/off character completion. With character completion typing a ( you get automatically the ) and typing \" gives the closing \".", new AbstractBooleanAction("Character completion"){

            protected void setBoolValue(boolean value) {
                characterCompletion = value;
            }

            protected boolean getBoolValue() {
                return characterCompletion;
            }
        });
        Mode.addAction("clickProjectSetCurrentDirectory", "Automatic setting of current directory to project directory", "Turns on/off the setting of the current directory to the project directory when clicking on a project.", new AbstractBooleanAction("Automatic setting current directory to project directory"){

            protected void setBoolValue(boolean value) {
                clickProjectSetCurrentDirectory = value;
            }

            protected boolean getBoolValue() {
                return clickProjectSetCurrentDirectory;
            }
        });
        Mode.addAction("highlightlist", "Highlight List", "Turns on/off the automatically highlighting of the element covering the cursor positions.", new AbstractBooleanAction("Highlight List"){

            protected void setBoolValue(boolean value) {
                highligthList = value;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.stopHighlightingList();
                }
            }

            protected boolean getBoolValue() {
                return highligthList;
            }
        });
        Mode.addAction("instrumentdebugafter", "Instrument the debug after code", "Turns on/off the generating of extra debugging code, to allow stopping after evaluating a form", new AbstractBooleanAction("Instrument the debug after code"){

            protected void setBoolValue(boolean value) {
                instrumentDebugAfter = value;
                if (!instrumentDebugAfter && !instrumentCheckError) {
                    Mode.getAction("stopafter").setEnabled(false);
                    Mode.getAction("setnewreturnvalue").setEnabled(false);
                } else {
                    Mode.getAction("stopafter").setEnabled(true);
                    Mode.getAction("setnewreturnvalue").setEnabled(true);
                }
            }

            protected boolean getBoolValue() {
                return instrumentDebugAfter;
            }
        });
        Mode.addAction("instrumentcheckerror", "Instrument the check after code", "Turns on/off the generating of extra debugging code, that causes entering the debugger when a error occurs during execution.", new AbstractBooleanAction("Instrument the check after code"){

            protected void setBoolValue(boolean value) {
                instrumentCheckError = value;
                if (!instrumentDebugAfter && !instrumentCheckError) {
                    Mode.getAction("stopafter").setEnabled(false);
                    Mode.getAction("setnewreturnvalue").setEnabled(false);
                } else {
                    Mode.getAction("stopafter").setEnabled(true);
                    Mode.getAction("setnewreturnvalue").setEnabled(true);
                }
            }

            protected boolean getBoolValue() {
                return instrumentCheckError;
            }
        });
        Mode.addAction("tabwidth", "Width of tab for load", "Sets the number of spaces to be used as a replacement for tab positions.", new AbstractIntegerAction("Width of tab for load", 0, 100){

            protected int getInt() {
                return tabwidth;
            }

            protected void setInt(int i) {
                tabwidth = i;
            }
        });
        Mode.addAction("blinkingrate", "Blinking rate cursor", "Sets the blinking interval of the cursor.", new AbstractIntegerAction("Blinking Rate Cursor", 100, 1000){

            protected int getInt() {
                return blinkingRate;
            }

            protected void setInt(int i) {
                blinkingRate = i;
            }
        });
        Mode.addAction("maxlinelength", "Max Length Line", "Set the max line length used by the indentation engine.", new AbstractIntegerAction("Max Length Line", 50, 500){

            protected int getInt() {
                return maxLineLength;
            }

            protected void setInt(int i) {
                maxLineLength = i;
            }
        });
        Mode.addAction("hovertimeout", "Wait time before displaying value", "Set the wait time before displaying the value of the variable containing the cursor (usefull during debugging).", new AbstractIntegerAction("Wait time before displaying value", 0, 100){

            protected int getInt() {
                return hoverTimeout;
            }

            protected void setInt(int i) {
                hoverTimeout = i;
            }
        });
        Mode.addAction("timeoutstopprocess", "Timeout for stopping a interaction processs", "Set's the time Jabberwocky waits for a interaction process to stop when Jabberwocky stops.", new AbstractIntegerAction("Wait time before displaying value", 0, 100){

            protected int getInt() {
                return timeoutStopProcess;
            }

            protected void setInt(int i) {
                timeoutStopProcess = i;
            }
        });
        Mode.addAction("commandhistorylength", "Length of the command history", "Set the lengh of the command history", new AbstractIntegerAction("Length of the command history", 10, 10000){

            protected int getInt() {
                return commandHistoryLength;
            }

            protected void setInt(int i) {
                commandHistoryLength = i;
            }
        });
        Mode.addAction("colorarray", "Color Array", "Set the foreground color of arrays.", new AbstractColorAction("Color Array"){

            protected Color getColor() {
                return colorArray;
            }

            protected void setColor(Color color) {
                colorArray = color;
            }
        });
        Mode.addAction("colorbackground", "Color Background", "Set the background color of a buffer.", new AbstractColorAction("Color Background"){

            protected Color getColor() {
                return colorBackground;
            }

            protected void setColor(Color color) {
                colorBackground = color;
            }
        });
        Mode.addAction("colorbackgroundline", "Color Background Line", "Set the background color of the linenumbers.", new AbstractColorAction("Color Background Line"){

            protected Color getColor() {
                return colorBackgroundLine;
            }

            protected void setColor(Color color) {
                colorBackgroundLine = color;
            }
        });
        Mode.addAction("colorbreakpoint", "Color Breakpoint", "Set the background color of breakpoints.", new AbstractColorAction("Color Breakpoint"){

            protected Color getColor() {
                return colorBreakpoint;
            }

            protected void setColor(Color color) {
                colorBreakpoint = color;
            }
        });
        Mode.addAction("colorcaller", "Color Caller", "Set the foreground color of the calling function/macro of a lispform.", new AbstractColorAction("Color Caller"){

            protected Color getColor() {
                return colorCaller;
            }

            protected void setColor(Color color) {
                colorCaller = color;
            }
        });
        Mode.addAction("colorcharacter", "Color Character", "Set the foreground color of a LISP character literal.", new AbstractColorAction("Color Character"){

            protected Color getColor() {
                return colorCharacter;
            }

            protected void setColor(Color color) {
                colorCharacter = color;
            }
        });
        Mode.addAction("colorcomment", "Color Comment", "Set the foreground color of the comments.", new AbstractColorAction("Color Comment"){

            protected Color getColor() {
                return colorComment;
            }

            protected void setColor(Color color) {
                colorComment = color;
            }
        });
        Mode.addAction("colorcursor", "Color Cursor", "Set the foreground color of the cursor.", new AbstractColorAction("Color Cursor"){

            protected Color getColor() {
                return colorCursor;
            }

            protected void setColor(Color color) {
                colorCursor = color;
            }
        });
        Mode.addAction("colorendline", "Color Endline", "Set the foreground color of the point representing a end of line.", new AbstractColorAction("Color Endline"){

            protected Color getColor() {
                return colorEndline;
            }

            protected void setColor(Color color) {
                colorEndline = color;
            }
        });
        Mode.addAction("colorexecutedcode", "Color Executed Code", "During debugging, background color of the code executed before entering the debugger.", new AbstractColorAction("Color Executed Code"){

            protected Color getColor() {
                return colorExecutedCode;
            }

            protected void setColor(Color color) {
                colorExecutedCode = color;
            }
        });
        Mode.addAction("colorexecutingcode", "Color Executing Code", "During debugging, background color of the code to be executed when leaving the debugger.", new AbstractColorAction("Color Executing Code"){

            protected Color getColor() {
                return colorExecutingCode;
            }

            protected void setColor(Color color) {
                colorExecutingCode = color;
            }
        });
        Mode.addAction("colorforeground", "Color Foreground", "Foreground color of the buffers.", new AbstractColorAction("Color Foreground"){

            protected Color getColor() {
                return colorForeground;
            }

            protected void setColor(Color color) {
                colorForeground = color;
            }
        });
        Mode.addAction("colorforegroundline", "Color ForegroundLine", "Foreground color of the linenumbers.", new AbstractColorAction("Color ForegroundLine"){

            protected Color getColor() {
                return colorForegroundLine;
            }

            protected void setColor(Color color) {
                colorForegroundLine = color;
            }
        });
        Mode.addAction("colorhook", "Color Hook", "Background color of the hooks (used in parenthese matching).", new AbstractColorAction("Color Hook"){

            protected Color getColor() {
                return colorHook;
            }

            protected void setColor(Color color) {
                colorHook = color;
            }
        });
        Mode.addAction("colorkeyword", "Color Keyword", "Foreground color keywords.", new AbstractColorAction("Color Keyword"){

            protected Color getColor() {
                return colorKeyword;
            }

            protected void setColor(Color color) {
                colorKeyword = color;
            }
        });
        Mode.addAction("colorlist", "Color List", "Background color of the list containing the cursor (if list highlighting is enabled).", new AbstractColorAction("Color List"){

            protected Color getColor() {
                return colorList;
            }

            protected void setColor(Color color) {
                colorList = color;
            }
        });
        Mode.addAction("colornextstop", "Color Next Stop", "Background color of the indicated next stop during  debugging.", new AbstractColorAction("Color Next Stop"){

            protected Color getColor() {
                return colorNextStop;
            }

            protected void setColor(Color color) {
                colorNextStop = color;
            }
        });
        Mode.addAction("colorsearch", "Color Search", "Background color to show matches during search operation.", new AbstractColorAction("Color Search"){

            protected Color getColor() {
                return colorSearch;
            }

            protected void setColor(Color color) {
                colorSearch = color;
            }
        });
        Mode.addAction("colorprofiling", "Color Profiling", "Background color used to highlight the lisp forms executed at least as many times as indicated by the profile slider.", new AbstractColorAction("Color Profiling"){

            protected Color getColor() {
                return colorProfiling;
            }

            protected void setColor(Color color) {
                colorProfiling = color;
            }
        });
        Mode.addAction("colorselection", "Color Selection", "Background color used to highlight the selected text.", new AbstractColorAction("Color Selection"){

            protected Color getColor() {
                return colorSelection;
            }

            protected void setColor(Color color) {
                colorSelection = color;
            }
        });
        Mode.addAction("colorstring", "Color String", "Foreground color of a string literal.", new AbstractColorAction("Color String"){

            protected Color getColor() {
                return colorString;
            }

            protected void setColor(Color color) {
                colorString = color;
            }
        });
        Mode.addAction("colorvariable", "Color Variable", "Sets the color of a lexical bound variable.", new AbstractColorAction("Color Variable"){

            protected Color getColor() {
                return colorVariable;
            }

            protected void setColor(Color color) {
                colorVariable = color;
            }
        });
        Mode.addAction("colorbackquote", "Color Backquote", "Sets the foreground color of backquoted forms.", new AbstractColorAction("Color Backquote"){

            protected Color getColor() {
                return colorBackQuote;
            }

            protected void setColor(Color color) {
                colorBackQuote = color;
            }
        });
        Mode.addAction("colorquote", "Color Quote", "Sets the foreground color of the quoted forms.", new AbstractColorAction("Color Quote"){

            protected Color getColor() {
                return colorQuote;
            }

            protected void setColor(Color color) {
                colorQuote = color;
            }
        });
        Mode.addAction("colorhint", "Color Hint", "Sets the background color of the hint/values", new AbstractColorAction("Color Hint"){

            protected Color getColor() {
                return colorHint;
            }

            protected void setColor(Color color) {
                colorHint = color;
            }
        });
        Mode.addAction("colorselected", "Color Selected", "Sets the background color of the selected nodes in a Project Explorer/Watches and Macros", new AbstractColorAction("Color Selected"){

            protected Color getColor() {
                return colorSelected;
            }

            protected void setColor(Color color) {
                colorSelected = color;
            }
        });
        Mode.addAction("lispstartupscript", "Lisp Startup Script", "Starts a file dialog to select the file to be loaded at the start of a interaction buffer.", new AbstractIDEAction("Lisp Startup Script"){

            public void doWork() {
                JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                chooser.setFileSelectionMode(2);
                chooser.setSelectedFile(new File(lispStartupFile));
                if (chooser.showOpenDialog(null) == 0) {
                    lispStartupFile = Util.getCanonicalFileName(chooser.getSelectedFile());
                }
            }
        });
        Mode.addAction("hyperspecdir", "Directory of the HyperSpec files", "Starts a directory selecton dialog to specify the directory containing the HyperSpec documentation", new AbstractIDEAction("Directory of the HyperSpec files"){

            public void doWork() {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Choose the directory containing the HyperSpec files");
                chooser.setFileSelectionMode(1);
                chooser.setDialogType(0);
                chooser.setSelectedFile(new File(HyperSpec.getHyperSpecDirectory() == null ? "" : HyperSpec.getHyperSpecDirectory()));
                if (chooser.showOpenDialog(null) == 0) {
                    HyperSpec.setHyperSpecDirectory(Util.getCanonicalFileName(chooser.getSelectedFile()));
                }
            }
        });
        Mode.addAction("saveconfiguration", "Save Configuration", "Save the configuration settings in the $HOME/.Jabberwocky./LispIDE file.", new AbstractIDEAction("Save Configuration"){

            public void doWork() {
                Configuration.this.saveConfiguration();
            }
        });
        Mode.addAction("generatelispcode", "Generate Lisp Binding", "Generates a file jabberwocky.lisp in the installation directory and the source directory (if it still exists) containing the lisp function definitions to interact with the IDE from within LISP. These functions are created in the package \"JABBERWOCKY\". For every action and question there will be a equivalent function defined.", new AbstractIDEAction("Generate Lisp Binding"){

            public void doWork() {
                GenerateLispCode.generate();
            }
        });
        Mode.addAction("displayversion", "About", "Display the cersion info of Jabberwocky.t", new AbstractIDEAction("About"){

            public void doWork() {
                JOptionPane.showConfirmDialog(null, IDEName + " " + IDEVersion, "About Jabberwocky", -1);
            }
        });
        Mode.addAction("generatehtmlcode", "Generate HTML documentation of actions", "Generate a file actions.html in the installation directory and the source directory (if it exists) containing the actions, their keybinding , a short description and their associated LISP function in the JABBERWOCKY package.", new AbstractIDEAction("Generate HTML documentation of actions"){

            public void doWork() {
                Mode.generateDocumentation();
            }
        });
        Mode.addAction("setbrowser", "Set the browser for help", "Set the browser for help", new AbstractChoiceAction("Set the browser", new String[]{"native", "konqueror", "mozilla", "netscape", "explorer"}){

            public void setValue(String value) {
                helpbrowser = value;
            }

            public String getValue() {
                return helpbrowser;
            }
        });
        Mode.addAction("editextensions", "Edit file extensions", "Starts a dialog box allowing you to manage the file extensions and their associated parser.", new AbstractIDEAction("Edit the file extensions"){

            public void doWork() {
                FileExtensions.editExtensions();
            }
        });
        Mode.addAction("setlookandfeel", "Set the java look and feel", "Sets the general look and feel of Jabberwocky", new AbstractChoiceAction("Set the look and feel", Configuration.getLookAndFeelNames()){

            public void setValue(String value) {
                try {
                    UIManager.setLookAndFeel(value);
                    SwingUtilities.updateComponentTreeUI(Main.frame);
                    Main.frame.pack();
                    lookAndFeel = value;
                }
                catch (Exception ex) {
                    MessageHandler.warn("Failed to set look and feel, error=" + ex.getMessage());
                }
            }

            public String getValue() {
                return lookAndFeel;
            }
        });
        Mode.addAction("loadconfiguration", "Load Configuration", "Load the configuration settings of a another configuration file", new AbstractIDEAction("loadconfiguration"){

            public void doWork() {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(InstallParameters.getInstallDir() + File.separator + "configurations"));
                chooser.setFileFilter(new FileFilter(this){
                    private final /* synthetic */ 55 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".LispIDE");
                    }

                    public String getDescription() {
                        return "*.LispIDE (Jabberwocky configuration files)";
                    }
                });
                int returnVal = chooser.showOpenDialog(Main.getWorkArea());
                if (returnVal == 0) {
                    Configuration.this.loadConfigFile(chooser.getSelectedFile());
                    Main.repaintEverything();
                }
            }
        });
        Mode.addAction("deadkeymanagment", "Dead key managment", "Allows you to associatie a character with a key combination, used to solve som problems with java an international keyboards.", new AbstractIDEAction("Keysequence to character management"){

            public void doWork() {
                new DeadKeySequence().manageDeadKeySequences();
            }
        });
    }

    private static String[] getLookAndFeelNames() {
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        String[] result = new String[lfs.length];
        for (int i = 0; i < lfs.length; ++i) {
            result[i] = lfs[i].getClassName();
        }
        return result;
    }

    private static void createRootMode() {
        Mode mode = new Mode("root");
        mode.addActionToMenu("'File'", "new");
        mode.addActionToMenu("'File'", "open");
        mode.addActionToMenu("'File'", "save");
        mode.addActionToMenu("'File'", "saveas");
        mode.addActionToMenu("'File'", "close");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "setcurrentdirectory");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "addproject");
        mode.getMenu("'File'").setMnemonic(70);
        mode.addActionToMenu("'Edit'", "copy");
        mode.addActionToMenu("'Edit'", "cut");
        mode.addActionToMenu("'Edit'", "delete");
        mode.addActionToMenu("'Edit'", "paste");
        mode.addSeparatorToMenu("'Edit'");
        mode.addActionToMenu("'Edit'", "undo");
        mode.addActionToMenu("'Edit'", "redo");
        mode.addSeparatorToMenu("'Edit'");
        mode.addActionToMenu("'Edit'", "indentate");
        mode.addActionToMenu("'Edit'", "indentateelement");
        mode.addActionToMenu("'Edit'", "indentatedocument");
        mode.addSeparatorToMenu("'Edit'");
        mode.addActionToMenu("'Edit'", "searchbackward");
        mode.addActionToMenu("'Edit'", "searchforward");
        mode.addActionToMenu("'Edit'", "searchandreplace");
        mode.addActionToMenu("'Edit'", "findandreplace");
        mode.addSeparatorToMenu("'Edit'");
        mode.addActionToMenu("'Edit'", "gotoline");
        mode.addSeparatorToMenu("'Edit'");
        mode.addActionToMenu("'Edit'", "startrecording");
        mode.addActionToMenu("'Edit'", "stoprecording");
        mode.addActionToMenu("'Edit'", "replayrecording");
        mode.getMenu("'Edit'").setMnemonic(69);
        mode.addActionToMenu("'Workarea'", "splitvertical");
        mode.addActionToMenu("'Workarea'", "splithorizontal");
        mode.addActionToMenu("'Workarea'", "replaceeditor");
        mode.getMenu("'Workarea'").setMnemonic(87);
        if (InstallParameters.getCmuclCommand() != null) {
            mode.addActionToMenu("'Interaction'", "newinteractioncmucl");
        }
        if (InstallParameters.getClispCommand() != null) {
            mode.addActionToMenu("'Interaction'", "newinteractionclisp");
        }
        mode.addActionToMenu("'Interaction'", "newwatch");
        mode.addActionToMenu("'Interaction'", "deleteinteraction");
        mode.addActionToMenu("'Interaction'", "deletewatch");
        mode.addActionToMenu("'Interaction'", "execute");
        mode.addActionToMenu("'Interaction'", "debugform");
        mode.addActionToMenu("'Interaction'", "loadeditor");
        mode.addActionToMenu("'Interaction'", "compileeditor");
        mode.addActionToMenu("'Interaction'/'Signal'", "sigint");
        mode.addActionToMenu("'Interaction'/'Signal'", "sigstop");
        mode.addActionToMenu("'Interaction'/'Signal'", "sigcont");
        mode.addActionToMenu("'Interaction'/'Signal'", "sigquit");
        mode.addActionToMenu("'Interaction'/'Signal'", "sigkill");
        mode.addActionToMenu("'Interaction'", "selectcommand");
        mode.getMenu("'Interaction'").setMnemonic(73);
        mode.addActionToMenu("'Options'/'Font'", "defaultfont");
        mode.addActionToMenu("'Options'/'Font'", "commentfont");
        mode.addActionToMenu("'Options'/'Font'", "explorerfont");
        mode.addActionToMenu("'Options'/'Font'", "watchesfont");
        mode.addActionToMenu("'Options'/'Font'", "macrosfont");
        mode.addActionToMenu("'Options'/'Color'", "colorarray");
        mode.addActionToMenu("'Options'/'Color'", "colorbackground");
        mode.addActionToMenu("'Options'/'Color'", "colorbackgroundline");
        mode.addActionToMenu("'Options'/'Color'", "colorbackquote");
        mode.addActionToMenu("'Options'/'Color'", "colorbreakpoint");
        mode.addActionToMenu("'Options'/'Color'", "colorcaller");
        mode.addActionToMenu("'Options'/'Color'", "colorcharacter");
        mode.addActionToMenu("'Options'/'Color'", "colorcomment");
        mode.addActionToMenu("'Options'/'Color'", "colorcursor");
        mode.addActionToMenu("'Options'/'Color'", "colorendline");
        mode.addActionToMenu("'Options'/'Color'", "colorelement");
        mode.addActionToMenu("'Options'/'Color'", "colorexecutedcode");
        mode.addActionToMenu("'Options'/'Color'", "colorexecutingcode");
        mode.addActionToMenu("'Options'/'Color'", "colorforeground");
        mode.addActionToMenu("'Options'/'Color'", "colorforegroundline");
        mode.addActionToMenu("'Options'/'Color'", "colorhint");
        mode.addActionToMenu("'Options'/'Color'", "colorhook");
        mode.addActionToMenu("'Options'/'Color'", "colorkeyword");
        mode.addActionToMenu("'Options'/'Color'", "colorlist");
        mode.addActionToMenu("'Options'/'Color'", "colornextstop");
        mode.addActionToMenu("'Options'/'Color'", "colorprofiling");
        mode.addActionToMenu("'Options'/'Color'", "colorquote");
        mode.addActionToMenu("'Options'/'Color'", "colorsearch");
        mode.addActionToMenu("'Options'/'Color'", "colorselected");
        mode.addActionToMenu("'Options'/'Color'", "colorselection");
        mode.addActionToMenu("'Options'/'Color'", "colorstring");
        mode.addActionToMenu("'Options'/'Color'", "colorvariable");
        mode.addSeparatorToMenu("'Options'");
        mode.addActionToMenu("'Options'/'General'", "setlookandfeel");
        mode.addCheckboxToMenu("'Options'/'General'", "clickProjectSetCurrentDirectory", clickProjectSetCurrentDirectory);
        mode.addActionToMenu("'Options'/'General'", "keybinding");
        mode.addActionToMenu("'Options'/'General'", "editextensions");
        mode.addActionToMenu("'Options'/'General'", "setbrowser");
        mode.addActionToMenu("'Options'/'General'", "hyperspecdir");
        mode.addActionToMenu("'Options'/'General'", "generatelispcode");
        mode.addActionToMenu("'Options'/'General'", "generatehtmlcode");
        mode.addSeparatorToMenu("'Options'/'General'");
        mode.addActionToMenu("'Options'/'General'", "lispstartupscript");
        mode.addCheckboxToMenu("'Options'/'Editor'", "linenumbers", lineNumbering);
        mode.addCheckboxToMenu("'Options'/'Editor'", "charactercompletion", indentateOnEnter);
        mode.addCheckboxToMenu("'Options'/'Editor'", "indentateonenter", characterCompletion);
        mode.addCheckboxToMenu("'Options'/'Editor'", "highlightlist", highligthList);
        mode.addSeparatorToMenu("'Options'/'Editor'");
        mode.addActionToMenu("'Options'/'Editor'", "maxlinelength");
        mode.addActionToMenu("'Options'/'Editor'", "tabwidth");
        mode.addActionToMenu("'Options'/'Editor'", "blinkingrate");
        mode.addActionToMenu("'Options'/'Interaction'", "hovertimeout");
        mode.addActionToMenu("'Options'/'Interaction'", "commandhistorylength");
        mode.addActionToMenu("'Options'/'Interaction'", "timeoutstopprocess");
        mode.addCheckboxToMenu("'Options'/'Interaction'", "instrumentdebugafter", instrumentDebugAfter);
        mode.addCheckboxToMenu("'Options'/'Interaction'", "instrumentcheckerror", instrumentCheckError);
        mode.addCheckboxToMenu("'Options'/'Workarounds'", "clispbug", clispBug);
        mode.addActionToMenu("'Options'/'Workarounds'", "deadkeymanagment");
        mode.addSeparatorToMenu("'Options'");
        mode.addActionToMenu("'Options'", "loadconfiguration");
        mode.addActionToMenu("'Options'", "saveconfiguration");
        mode.getMenu("'Options'").setMnemonic(79);
        mode.addActionToMenu("'Help'", "help");
        mode.addActionToMenu("'Help'", "hyperspec");
        mode.addActionToMenu("'Help'", "hyperspeccontext");
        mode.addActionToMenu("'Help'", "displayversion");
        mode.addActionToMenu("'Help'/'Hint'", "togglehint");
        mode.addActionToMenu("'Help'/'Hint'", "replacebyhint");
        mode.getMenu("'Help'").setMnemonic(72);
        mode.addActionToPopup("'File'", "new");
        mode.addActionToPopup("'File'", "open");
        mode.addActionToPopup("'File'", "save");
        mode.addActionToPopup("'File'", "saveas");
        mode.addActionToPopup("'File'", "close");
        mode.addActionToPopup("'File'", "setcurrentdirectory");
        mode.bindActionToKeySequence("up", 38, 0);
        mode.bindActionToKeySequence("down", 40, 0);
        mode.bindActionToKeySequence("pageup", 33, 0);
        mode.bindActionToKeySequence("pagedown", 34, 0);
        mode.bindActionToKeySequence("left", 37, 0);
        mode.bindActionToKeySequence("right", 39, 0);
        mode.bindActionToKeySequence("remove", 127, 0);
        mode.bindActionToKeySequence("backspace", 8, 0);
        mode.bindActionToKeySequence("undo", 85, 8);
        mode.bindActionToKeySequence("redo", 82, 8);
        mode.bindActionToKeySequence("help", 112, 0);
        mode.bindActionToKeySequence("hyperspeccontext", 112, 1);
        mode.bindActionToKeySequence("hyperspec", 113, 0);
        mode.bindActionToKeySequence("hintup", 38, 8);
        mode.bindActionToKeySequence("hintdown", 40, 8);
        mode.bindActionToKeySequence("replacebyhint", 10, 8);
        mode.bindActionToKeySequence("togglehint", 32, 8);
        mode.bindActionToKeySequence("indentate", 9, 0);
        mode.bindActionToKeySequence("indentateelement", 9, 1);
        mode.bindActionToKeySequence("debugform", 68, 2);
        mode.bindActionToKeySequence("execute", 10, 2);
        mode.bindActionToKeySequence("sigint", 67, 2);
        mode.bindActionToKeySequence("loadeditor", 76, 2);
        mode.bindActionToKeySequence("open", 88, 2, 70, 2);
        mode.bindActionToKeySequence("save", 88, 2, 83, 2);
        mode.bindActionToKeySequence("exit", 88, 2, 67, 2);
        mode.bindActionToKeySequence("startrecording", 77, 2, 66, 2);
        mode.bindActionToKeySequence("stoprecording", 77, 2, 69, 2);
        mode.bindActionToKeySequence("replayrecording", 77, 2, 82, 2);
        mode.bindActionToKeySequence("copy", 155, 2);
        mode.bindActionToKeySequence("cut", 127, 2);
        mode.bindActionToKeySequence("delete", 127, 1);
        mode.bindActionToKeySequence("paste", 155, 1);
        mode.bindActionToKeySequence("searchforward", 78, 2);
        mode.bindActionToKeySequence("searchbackward", 80, 2);
        mode.bindActionToKeySequence("searchandreplace", 82, 2);
        mode.bindActionToKeySequence("findandreplace", 70, 2);
        mode.bindActionToKeySequence("selectcommand", 72, 2);
        mode.bindActionToKeySequence("movetobeginline", 65, 2);
        mode.bindActionToKeySequence("movetoendline", 69, 2);
        mode.bindActionToKeySequence("movetonextleaf", 39, 2);
        mode.bindActionToKeySequence("movetoendlist", 39, 8);
        mode.bindActionToKeySequence("movetoprevleaf", 37, 2);
        mode.bindActionToKeySequence("movetobeginlist", 37, 8);
        mode.bindActionToKeySequence("gotoline", 71, 8);
        mode.bindActionToKeySequence("switch", 73, 2);
        mode.bindActionToKeySequence("next", 84, 2);
        mode.bindActionToKeySequence("selectcurrentleaf", 83, 2, 87, 2);
        mode.bindActionToKeySequence("selectcurrentelement", 83, 2, 69, 2);
        mode.bindActionToKeySequence("selecttoplevelelement", 83, 2, 84, 2);
        mode.bindActionToKeySequence("selectline", 83, 2, 76, 2);
        mode.bindActionToKeySequence("widenselection", 83, 2, 85, 2);
        mode.bindActionToKeySequence("shortenselection", 83, 2, 68, 2);
        mode.bindActionToKeySequence("deletecurrentleaf", 88, 2, 87, 2);
        mode.bindActionToKeySequence("deletecurrentelement", 88, 2, 69, 2);
        mode.bindActionToKeySequence("deletetoplevelelement", 88, 2, 84, 2);
        mode.bindActionToKeySequence("deleteline", 75, 2);
    }

    public static void createBasicMode() {
        Mode mode = Mode.getMode("root").createCopy("basic");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "debug");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "exit");
        mode.addSeparatorToPopup("'File'");
        mode.addActionToPopup("'File'", "debug");
        mode.addActionToPopup("copy");
        mode.addActionToPopup("cut");
        mode.addActionToPopup("delete");
        mode.addActionToPopup("paste");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("undo");
        mode.addActionToPopup("redo");
        mode.addToolbar("debug");
        mode.addButton("debug", "debug");
        mode.addButton("debug", "new");
        mode.addButton("debug", "open");
        mode.addButton("debug", "save");
        mode.addButton("debug", "close");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "cut");
        mode.addButton("debug", "copy");
        mode.addButton("debug", "paste");
        mode.addButton("debug", "undo");
        mode.addButton("debug", "redo");
        mode.addButton("debug", "searchbackward");
        mode.addButton("debug", "searchforward");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "startrecording");
        mode.addButton("debug", "stoprecording");
        mode.addButton("debug", "replayrecording");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "splitvertical");
        mode.addButton("debug", "splithorizontal");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "compileeditor");
        mode.addButton("debug", "execute");
        mode.addSeparatorToButtonBar("debug");
        if (InstallParameters.getCmuclCommand() != null) {
            mode.addButton("debug", "newinteractioncmucl", "CMUCL");
        }
        if (InstallParameters.getClispCommand() != null) {
            mode.addButton("debug", "newinteractionclisp", "CLISP");
        }
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "deleteinteraction");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "togglehint");
        mode.addButton("debug", "help");
        mode.bindActionToKeySequence("debug", 117, 0);
    }

    public static void createInteractionMode() {
        Mode mode = Mode.getMode("root").createCopy("interaction");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "exit");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("sigint");
        mode.addActionToPopup("sigstop");
        mode.addActionToPopup("sigcont");
        mode.addActionToPopup("sigquit");
        mode.addActionToPopup("sigkill");
        mode.addToolbar("interaction");
        mode.addButton("interaction", "debug");
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "cut");
        mode.addButton("interaction", "copy");
        mode.addButton("interaction", "paste");
        mode.addButton("interaction", "undo");
        mode.addButton("interaction", "redo");
        mode.addButton("interaction", "searchbackward");
        mode.addButton("interaction", "searchforward");
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "startrecording");
        mode.addButton("interaction", "stoprecording");
        mode.addButton("interaction", "replayrecording");
        mode.addSeparatorToButtonBar("interaction");
        if (InstallParameters.getCmuclCommand() != null) {
            mode.addButton("interaction", "newinteractioncmucl", "CMUCL");
        }
        if (InstallParameters.getClispCommand() != null) {
            mode.addButton("interaction", "newinteractionclisp", "CLISP");
        }
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "deleteinteraction");
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "togglehint");
        mode.addButton("interaction", "help");
    }

    public static void createDebugMode() {
        Mode mode = Mode.getMode("root").createCopy("debug");
        mode.addActionToMenu("'File'", "undebug");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "exit");
        mode.addActionToMenu("'Debug'", "togglebreakpoint");
        mode.addActionToMenu("'Debug'", "togglecondbreakpoint");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "stepinto");
        mode.addActionToMenu("'Debug'", "stepover");
        mode.addActionToMenu("'Debug'", "stopat");
        mode.addActionToMenu("'Debug'", "continue");
        mode.addActionToMenu("'Debug'", "stopafter");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "addwatch");
        mode.addActionToMenu("'Debug'", "setnewreturnvalue");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "past");
        mode.addActionToMenu("'Debug'", "future");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "startprofiling");
        mode.addActionToMenu("'Debug'", "stopprofiling");
        mode.addSeparatorToPopup("'File'");
        mode.addActionToPopup("'File'", "undebug");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("togglebreakpoint");
        mode.addActionToPopup("togglecondbreakpoint");
        mode.addActionToPopup("stepinto");
        mode.addActionToPopup("stepover");
        mode.addActionToPopup("stopat");
        mode.addActionToPopup("continue");
        mode.addActionToPopup("stopafter");
        mode.addActionToPopup("addwatch");
        mode.addActionToPopup("setnewreturnvalue");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("past");
        mode.addActionToPopup("future");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("startprofiling");
        mode.addActionToPopup("stopprofiling");
        mode.addToolbar("debug");
        mode.addButton("debug", "undebug");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "togglebreakpoint");
        mode.addButton("debug", "togglecondbreakpoint");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "stepinto");
        mode.addButton("debug", "stepover");
        mode.addButton("debug", "stopat");
        mode.addButton("debug", "continue");
        mode.addButton("debug", "stopafter");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "addwatch");
        mode.addButton("debug", "setnewreturnvalue");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "past");
        mode.addButton("debug", "future");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "startprofiling");
        mode.addButton("debug", "stopprofiling");
        mode.bindActionToKeySequence("undebug", 117, 1);
        mode.bindActionToKeySequence("togglebreakpoint", 120, 0);
        mode.bindActionToKeySequence("togglecondbreakpoint", 120, 1);
        mode.bindActionToKeySequence("stepinto", 118, 0);
        mode.bindActionToKeySequence("stepover", 119, 0);
        mode.bindActionToKeySequence("stopat", 115, 0);
        mode.bindActionToKeySequence("continue", 116, 0);
        mode.bindActionToKeySequence("stopafter", 121, 0);
        mode.bindActionToKeySequence("addwatch", 122, 0);
        mode.bindActionToKeySequence("setnewreturnvalue", 123, 0);
    }

    public static void createDebugInteractionMode() {
        Mode mode = Mode.getMode("root").createCopy("debuginteraction");
        mode.addSeparatorToMenu("'File'");
        mode.addActionToMenu("'File'", "exit");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("sigint");
        mode.addActionToPopup("sigstop");
        mode.addActionToPopup("sigcont");
        mode.addActionToPopup("sigquit");
        mode.addActionToPopup("sigkill");
        mode.addToolbar("interaction");
        mode.addButton("interaction", "cut");
        mode.addButton("interaction", "copy");
        mode.addButton("interaction", "paste");
        mode.addButton("interaction", "undo");
        mode.addButton("interaction", "redo");
        mode.addButton("interaction", "searchbackward");
        mode.addButton("interaction", "searchforward");
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "startrecording");
        mode.addButton("interaction", "stoprecording");
        mode.addButton("interaction", "replayrecording");
        mode.addSeparatorToButtonBar("interaction");
        if (InstallParameters.getCmuclCommand() != null) {
            mode.addButton("interaction", "newinteractioncmucl", "CMUCL");
        }
        if (InstallParameters.getClispCommand() != null) {
            mode.addButton("interaction", "newinteractionclisp", "CLISP");
        }
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "deleteinteraction");
        mode.addSeparatorToButtonBar("interaction");
        mode.addButton("interaction", "togglehint");
        mode.addButton("interaction", "help");
        mode.addActionToMenu("'Debug'", "togglebreakpoint");
        mode.addActionToMenu("'Debug'", "togglecondbreakpoint");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "stepinto");
        mode.addActionToMenu("'Debug'", "stepover");
        mode.addActionToMenu("'Debug'", "stopat");
        mode.addActionToMenu("'Debug'", "continue");
        mode.addActionToMenu("'Debug'", "stopafter");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "addwatch");
        mode.addActionToMenu("'Debug'", "setnewreturnvalue");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "past");
        mode.addActionToMenu("'Debug'", "future");
        mode.addSeparatorToMenu("'Debug'");
        mode.addActionToMenu("'Debug'", "startprofiling");
        mode.addActionToMenu("'Debug'", "stopprofiling");
        mode.addSeparatorToPopup("'File'");
        mode.addActionToPopup("'File'", "undebug");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("togglebreakpoint");
        mode.addActionToPopup("togglecondbreakpoint");
        mode.addActionToPopup("stepinto");
        mode.addActionToPopup("stepover");
        mode.addActionToPopup("stopat");
        mode.addActionToPopup("continue");
        mode.addActionToPopup("stopafter");
        mode.addActionToPopup("addwatch");
        mode.addActionToPopup("setnewreturnvalue");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("past");
        mode.addActionToPopup("future");
        mode.addSeparatorToPopup("");
        mode.addActionToPopup("startprofiling");
        mode.addActionToPopup("stopprofiling");
        mode.addToolbar("debug");
        mode.addButton("debug", "undebug");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "togglebreakpoint");
        mode.addButton("debug", "togglecondbreakpoint");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "stepinto");
        mode.addButton("debug", "stepover");
        mode.addButton("debug", "stopat");
        mode.addButton("debug", "continue");
        mode.addButton("debug", "stopafter");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "addwatch");
        mode.addButton("debug", "setnewreturnvalue");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "past");
        mode.addButton("debug", "future");
        mode.addSeparatorToButtonBar("debug");
        mode.addButton("debug", "startprofiling");
        mode.addButton("debug", "stopprofiling");
        mode.bindActionToKeySequence("undebug", 117, 1);
        mode.bindActionToKeySequence("togglebreakpoint", 120, 0);
        mode.bindActionToKeySequence("togglecondbreakpoint", 120, 1);
        mode.bindActionToKeySequence("stepinto", 118, 0);
        mode.bindActionToKeySequence("stepover", 119, 0);
        mode.bindActionToKeySequence("stopat", 115, 0);
        mode.bindActionToKeySequence("continue", 116, 0);
        mode.bindActionToKeySequence("stopafter", 121, 0);
        mode.bindActionToKeySequence("addwatch", 122, 0);
        mode.bindActionToKeySequence("setnewreturnvalue", 123, 0);
    }

    public static ImageIcon getIcon(String filename) {
        String separator = System.getProperty("file.separator");
        String result = installDirectory + separator + "image" + separator + filename;
        ImageIcon icon = (ImageIcon)nameToIcon.get(result);
        if (icon == null) {
            icon = new ImageIcon(result);
            nameToIcon.put(result, icon);
        }
        return icon;
    }

    public void saveConfiguration() {
        File savefile = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky" + File.separator + ".LispIDE");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(savefile));
            Field[] fields = this.getClass().getFields();
            XMLConfigClass xmlclass = new XMLConfigClass(this.getClass().getName());
            for (int i = 0; i < fields.length; ++i) {
                XMLConfigObject xmlobject;
                if (fields[i].getName().compareTo("IDEName") == 0 || fields[i].getName().compareTo("IDEVersion") == 0 || fields[i].getName().compareTo("installDirectory") == 0) continue;
                XMLConfigField xmlfield = new XMLConfigField(fields[i].getName());
                Class<?> cls = fields[i].getType();
                if (cls == Integer.TYPE) {
                    xmlfield.setValue(fields[i].getInt(null));
                    xmlclass.addField(xmlfield);
                    continue;
                }
                if (cls == Boolean.TYPE) {
                    xmlfield.setValue(fields[i].getBoolean(null));
                    xmlclass.addField(xmlfield);
                    continue;
                }
                if (cls == Class.forName("java.lang.String")) {
                    xmlfield.setValue((String)fields[i].get(null));
                    xmlclass.addField(xmlfield);
                    continue;
                }
                if (cls == Class.forName("java.awt.Color")) {
                    xmlobject = new XMLConfigObject(cls.getName());
                    Color color = (Color)fields[i].get(null);
                    xmlobject.addArgument(color.getRed());
                    xmlobject.addArgument(color.getGreen());
                    xmlobject.addArgument(color.getBlue());
                    xmlfield.setValue(xmlobject);
                    xmlclass.addField(xmlfield);
                    continue;
                }
                if (cls != Class.forName("java.awt.Font")) continue;
                xmlobject = new XMLConfigObject(cls.getName());
                Font font = (Font)fields[i].get(null);
                xmlobject.addArgument(font.getFontName());
                xmlobject.addArgument(font.getStyle());
                xmlobject.addArgument(font.getSize());
                xmlfield.setValue(xmlobject);
                xmlclass.addField(xmlfield);
            }
            xmlclass.serialize(writer);
            Mode.saveConfiguration(writer);
            FileExtensions.saveConfiguration(writer);
            HyperSpec.saveConfiguration(writer);
            DeadKeySequence.saveConfiguration(writer);
            writer.close();
        }
        catch (IOException e) {
            MessageHandler.report("Could not write configuration", e);
        }
        catch (IllegalAccessException e) {
            MessageHandler.report("Illegal access error during read Configuration fields", e);
        }
        catch (ClassNotFoundException e) {
            MessageHandler.report("Class not found exception ", e);
        }
    }

    private void loadConfiguration() {
        File logfile;
        File loadfile;
        File directory = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky");
        if (!directory.exists()) {
            MessageHandler.warn("Configuration directory .Jabberwocky does not exist, creating new one");
            directory.mkdir();
            MessageHandler.warn("Copy old configuration files to new location");
            loadfile = new File(System.getProperty("user.home") + File.separator + ".LispIDE");
            if (loadfile.exists()) {
                loadfile.renameTo(new File(directory, loadfile.getName()));
            }
            if ((loadfile = new File(System.getProperty("user.home") + File.separator + ".LispIDEState")).exists()) {
                loadfile.renameTo(new File(directory, loadfile.getName()));
            }
        }
        if ((logfile = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky" + File.separator + "error.log")).exists()) {
            logfile.delete();
        }
        try {
            logfile.createNewFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        loadfile = new File(directory, ".LispIDE");
        if (!loadfile.exists()) {
            MessageHandler.warn("Configuration file does not exist, creating new one");
            this.saveConfiguration();
        }
        this.loadConfigFile(loadfile);
        if (AbstractXMLConfig.errorDuringConfig && JOptionPane.showConfirmDialog(null, "Incorrect Configuration File (this could happen with a new release or because the file is corrupt), do you want to create a new file", "Error configuring Jabberwocky", 0) == 0) {
            this.saveConfiguration();
        }
    }

    private void loadConfigFile(File configFile) {
        try {
            XMLConfigClass cls;
            XMLConfigReader reader = new XMLConfigReader(new BufferedReader(new FileReader(configFile)));
            while ((cls = reader.readXMLConfigClass()) != null) {
                cls.configure();
            }
        }
        catch (FileNotFoundException e) {
            MessageHandler.warn("Configuration file does not exist");
        }
    }

    public static void loadState() {
        File loadfile = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky" + File.separator + ".LispIDEState");
        try {
            XMLConfigClass cls;
            XMLConfigReader reader = new XMLConfigReader(new BufferedReader(new FileReader(loadfile)));
            while ((cls = reader.readXMLConfigClass()) != null) {
                cls.configure();
            }
        }
        catch (FileNotFoundException e) {
            MessageHandler.warn("File does not exists " + e.getMessage());
        }
    }
}

