/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractManagedAction;
import IDE.Configuration.KeySequence;
import IDE.Configuration.Mode;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ActionKeyMap {
    public static final String KEYSEQUENCE = "KeySequence";
    private TreeMap keymap = new TreeMap();
    private KeySequence KeySequence = null;
    private ActionTableModel model;
    static /* synthetic */ Class class$IDE$Configuration$KeySequence;
    static /* synthetic */ Class class$java$lang$String;

    public void addAction(String name, KeySequence KeySequence2) {
        AbstractManagedAction action = Mode.getAction(name);
        if (action != null) {
            if (action.getValue(KEYSEQUENCE) == null || KeySequence2.compareTo(action.getValue(KEYSEQUENCE)) == 0) {
                ActionKeyMap[] keymaps = Mode.getKeyMaps();
                for (int i = 0; i < keymaps.length; ++i) {
                    if (keymaps[i].keymap.containsValue(action)) continue;
                    keymaps[i].keymap.remove(KeySequence2);
                }
                this.keymap.put(KeySequence2, action);
                action.putValue(KEYSEQUENCE, KeySequence2);
                action.refreshInfo();
            } else {
                MessageHandler.warn("Binding action=" + name + " to different key sequences");
                ActionKeyMap[] keymaps = Mode.getKeyMaps();
                for (int i = 0; i < keymaps.length; ++i) {
                    this.rebindActionToKeySequence(action, KeySequence2, keymaps[i].keymap);
                }
                action.putValue(KEYSEQUENCE, KeySequence2);
                action.refreshInfo();
            }
        } else {
            MessageHandler.warn("Try to bind key sequence to non existing action=" + name);
        }
    }

    protected void clearKeymap() {
        this.keymap.clear();
        this.KeySequence = null;
    }

    public KeySequence[] getKeySequences() {
        KeySequence[] keysequences = new KeySequence[this.keymap.size()];
        Iterator iter = this.keymap.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keysequences[i] = (KeySequence)iter.next();
            ++i;
        }
        return keysequences;
    }

    public Action getAction(KeySequence seq) {
        return (Action)this.keymap.get(seq);
    }

    public boolean execute(int key, int modifiers) {
        boolean flag = true;
        if (this.KeySequence == null) {
            flag = false;
            this.KeySequence = new KeySequence();
        }
        this.KeySequence.addKey(key, modifiers);
        AbstractAction action = (AbstractAction)this.keymap.get(this.KeySequence);
        if (action == null) {
            SortedMap map = this.keymap.tailMap(this.KeySequence);
            if (!map.isEmpty() && this.KeySequence.isPartOf(map.firstKey())) {
                this.suggestCompletions(map);
                return true;
            }
            if (flag) {
                MessageHandler.warn("Key sequence is not linked with action");
                this.KeySequence = null;
                return true;
            }
            this.KeySequence = null;
            return false;
        }
        MessageHandler.say("");
        action.actionPerformed(null);
        this.KeySequence = null;
        return true;
    }

    private void suggestCompletions(SortedMap map) {
        KeySequence ks;
        StringBuffer suggestion = new StringBuffer("Suggestions: ");
        Iterator iter = map.keySet().iterator();
        int m = this.KeySequence.size();
        boolean notfirst = false;
        while (iter.hasNext() && this.KeySequence.isPartOf(ks = (KeySequence)iter.next())) {
            if (notfirst) {
                suggestion.append(',');
            } else {
                notfirst = true;
            }
            suggestion.append(ks.toStringShort(m));
            suggestion.append('=');
            suggestion.append(((AbstractAction)map.get(ks)).getValue("Name"));
        }
        MessageHandler.say(suggestion.toString());
    }

    public void cancel() {
        this.KeySequence = null;
        MessageHandler.say("");
    }

    public void changeKeyMap() {
        JDialog dialog = new JDialog();
        dialog.setModal(true);
        dialog.setTitle("Modify keymap for mode " + Main.currentMode().getName() + " (press F1 to clear KeySequence)");
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.model = new ActionTableModel();
        JTable table = new JTable(this.model);
        table.setDefaultRenderer(class$IDE$Configuration$KeySequence == null ? (class$IDE$Configuration$KeySequence = ActionKeyMap.class$("IDE.Configuration.KeySequence")) : class$IDE$Configuration$KeySequence, new KeySequenceRenderer());
        table.setDefaultEditor(class$IDE$Configuration$KeySequence == null ? (class$IDE$Configuration$KeySequence = ActionKeyMap.class$("IDE.Configuration.KeySequence")) : class$IDE$Configuration$KeySequence, new KeySequenceEditor());
        JScrollPane scrollpane = new JScrollPane(table);
        pane.add((Component)scrollpane, "Center");
        JPanel buttonbar = new JPanel();
        buttonbar.add(new JButton(new okAction(dialog, table)));
        buttonbar.add(new JButton(new cancelAction(dialog)));
        pane.add((Component)buttonbar, "South");
        dialog.setContentPane(pane);
        dialog.setSize(400, 500);
        dialog.setVisible(true);
    }

    private void rebindActionToKeySequence(AbstractAction action, KeySequence keysequence, TreeMap keyToAction) {
        Vector keysequences = new Vector();
        Iterator iter = keyToAction.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (keyToAction.get(key) != action) continue;
            keysequences.add(key);
        }
        for (int i = 0; i < keysequences.size(); ++i) {
            keyToAction.remove(keysequences.elementAt(i));
        }
        keyToAction.put(keysequence, action);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KeySequenceEditor
    extends JTextField
    implements TableCellEditor,
    KeyListener {
        private Vector listeners = new Vector();
        private KeySequence value;
        private KeySequence originalvalue;
        private int row;
        private int column;

        public KeySequenceEditor() {
            this.setBorder(null);
            this.addKeyListener(this);
            this.setEditable(false);
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            if (value instanceof KeySequence) {
                this.value = (KeySequence)value;
                this.setText(this.value.toString());
            } else {
                this.value = null;
            }
            this.originalvalue = this.value;
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            return this;
        }

        public void cancelCellEditing() {
            if (this.originalvalue != null) {
                this.setText(this.value.toString());
            }
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(new ChangeEvent(this));
            }
            this.setText("");
        }

        public boolean isCellEditable(EventObject eo) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.removeElement(cellEditorListener);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean stopCellEditing() {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(new ChangeEvent(this));
            }
            this.setText("");
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 112) {
                this.value = null;
                this.setText("");
            } else if (key != 17 && key != 18 && key != 16) {
                if (this.value == null) {
                    this.value = new KeySequence();
                }
                this.value.addKey(key, e.getModifiers());
                this.setText(this.value.toString());
            }
            ActionKeyMap.this.model.setValueAt(this.value, this.row, this.column);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class KeySequenceRenderer
    extends JLabel
    implements TableCellRenderer {
        public KeySequenceRenderer() {
            this.setBorder(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int r, int c) {
            if (value instanceof KeySequence) {
                this.setText(((KeySequence)value).toString());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class ActionTableModel
    extends AbstractTableModel {
        String[] actionnames;
        AbstractManagedAction[] actions;
        KeySequence[] KeySequences;

        public ActionTableModel() {
            int count = Mode.getActionCount();
            Iterator iter = Mode.getActionIterator();
            this.actionnames = new String[count];
            this.actions = new AbstractManagedAction[count];
            this.KeySequences = new KeySequence[count];
            int i = 0;
            while (iter.hasNext()) {
                this.actions[i] = (AbstractManagedAction)iter.next();
                this.actionnames[i] = (String)this.actions[i].getValue("ShortDescription") + "(" + (String)this.actions[i].getValue("Name") + ")";
                KeySequence ks = (KeySequence)this.actions[i].getValue(ActionKeyMap.KEYSEQUENCE);
                if (ks != null && ActionKeyMap.this.keymap.get(ks) == this.actions[i]) {
                    this.KeySequences[i] = ks;
                }
                ++i;
            }
        }

        public int getRowCount() {
            return this.actions.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return this.actionnames[r];
            }
            return this.KeySequences[r];
        }

        public void setValueAt(Object value, int r, int c) {
            if (c == 1) {
                this.KeySequences[r] = (KeySequence)value;
            }
        }

        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }

        public String getColumnName(int c) {
            if (c == 0) {
                return "Action";
            }
            return "Key sequence";
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = ActionKeyMap.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$IDE$Configuration$KeySequence == null ? (class$IDE$Configuration$KeySequence = ActionKeyMap.class$("IDE.Configuration.KeySequence")) : class$IDE$Configuration$KeySequence;
        }

        public AbstractAction getAction(int row) {
            return this.actions[row];
        }

        public void updateStrokes() {
            ActionKeyMap.this.keymap.clear();
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].putValue(ActionKeyMap.KEYSEQUENCE, this.KeySequences[i]);
                this.actions[i].refreshInfo();
                if (this.KeySequences[i] == null) continue;
                ActionKeyMap.this.keymap.put(this.KeySequences[i], this.actions[i]);
                ActionKeyMap[] keymaps = Mode.getKeyMaps();
                for (int j = 0; j < keymaps.length; ++j) {
                    ActionKeyMap.this.rebindActionToKeySequence(this.actions[i], this.KeySequences[i], keymaps[j].keymap);
                }
            }
        }

        public String checkBindings() {
            for (int i = 0; i < this.KeySequences.length; ++i) {
                for (int j = 0; j < this.KeySequences.length; ++j) {
                    if (i == j || this.KeySequences[i] == null || this.KeySequences[j] == null || this.KeySequences[i].compareTo(this.KeySequences[j]) != 0) continue;
                    return this.actionnames[i] + " and " + this.actionnames[j] + " have the same keysequence " + this.KeySequences[i].toString();
                }
            }
            return null;
        }
    }

    private class cancelAction
    extends AbstractAction {
        private JDialog dialog;

        public cancelAction(JDialog dialog) {
            super("Cancel");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent ev) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private class okAction
    extends AbstractAction {
        private JDialog dialog;
        private JTable table;

        public okAction(JDialog dialog, JTable table) {
            super("Ok");
            this.dialog = dialog;
            this.table = table;
        }

        public void actionPerformed(ActionEvent ev) {
            String error;
            KeySequenceEditor editor = (KeySequenceEditor)this.table.getCellEditor();
            ActionTableModel model = (ActionTableModel)this.table.getModel();
            if (editor != null) {
                editor.stopCellEditing();
            }
            if ((error = model.checkBindings()) != null) {
                if (JOptionPane.showConfirmDialog(null, error + ", cancel editing?", "Double keybindings", 0) == 0) {
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                    return;
                }
                return;
            }
            model.updateStrokes();
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

