/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractIDEAction;
import IDE.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractFontAction
extends AbstractIDEAction {
    JList list;
    JComboBox styles;
    JComboBox size;
    JTextArea text;
    Font font;
    Font newfont;
    private String name;

    public AbstractFontAction(String name) {
        super(name);
        this.name = name;
    }

    public void doWork() {
        Font font = this.chooseFont(this.getFontValue());
        if (font != null) {
            this.setFontValue(font);
            Main.repaintEverything();
        }
    }

    protected abstract Font getFontValue();

    protected abstract void setFontValue(Font var1);

    private Font chooseFont(Font defaultfont) {
        final JDialog dialog = new JDialog();
        int index = 0;
        String[] fontfamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Vector<Font> allfonts = new Vector<Font>();
        for (int i = 0; i < fontfamilies.length; ++i) {
            if (fontfamilies[i].length() == 0) continue;
            allfonts.add(new Font(fontfamilies[i], 0, 12));
            if (fontfamilies[i].compareTo(defaultfont.getFamily()) != 0) continue;
            index = i;
        }
        this.font = defaultfont;
        this.text = new JTextArea("abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789");
        dialog.setTitle(this.name);
        dialog.setModal(true);
        dialog.setSize(500, 700);
        this.list = new JList(allfonts);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new fontListCellRenderer());
        this.list.setSelectedIndex(index);
        JButton okbutton = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
                AbstractFontAction.this.newfont = AbstractFontAction.this.font;
            }
        });
        JButton cancelbutton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
                AbstractFontAction.this.newfont = null;
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(okbutton);
        buttons.add(cancelbutton);
        this.styles = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic", "Bold and Italic"});
        switch (this.font.getStyle()) {
            case 0: {
                this.styles.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.styles.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.styles.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.styles.setSelectedIndex(3);
                break;
            }
            default: {
                this.styles.setSelectedIndex(1);
            }
        }
        String[] sizes = new String[95];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = String.valueOf(i + 5);
        }
        this.size = new JComboBox<String>(sizes);
        this.size.setSelectedIndex(Math.min(99, this.font.getSize() - 5));
        JPanel stylesize = new JPanel(new FlowLayout(0));
        stylesize.add(new JLabel("Style: "));
        stylesize.add(this.styles);
        stylesize.add(new JLabel("Size:"));
        stylesize.add(this.size);
        JPanel stylesizetext = new JPanel(new BorderLayout());
        stylesizetext.add((Component)stylesize, "Center");
        JScrollPane textscroll = new JScrollPane(this.text);
        stylesizetext.add((Component)textscroll, "South");
        JPanel central = new JPanel(new BorderLayout());
        JScrollPane scrollpane = new JScrollPane(this.list);
        central.add((Component)scrollpane, "Center");
        central.add((Component)stylesizetext, "South");
        this.size.addActionListener(new styleSizeAction());
        this.styles.addActionListener(new styleSizeAction());
        this.list.addListSelectionListener(new selectionListener());
        this.setFontExample();
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)central, "Center");
        content.add((Component)buttons, "South");
        this.list.ensureIndexIsVisible(index);
        dialog.getContentPane().add(content);
        dialog.setVisible(true);
        return this.newfont;
    }

    private void setFontExample() {
        int intsize = this.size.getSelectedIndex() + 5;
        String family = ((Font)this.list.getSelectedValue()).getFamily();
        switch (this.styles.getSelectedIndex()) {
            case 0: {
                this.font = new Font(family, 0, intsize);
                break;
            }
            case 1: {
                this.font = new Font(family, 1, intsize);
                break;
            }
            case 2: {
                this.font = new Font(family, 2, intsize);
                break;
            }
            case 3: {
                this.font = new Font(family, 3, intsize);
            }
        }
        this.text.setFont(this.font);
        this.text.revalidate();
        this.text.repaint();
    }

    private class selectionListener
    implements ListSelectionListener {
        private selectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbstractFontAction.this.setFontExample();
        }
    }

    private class styleSizeAction
    extends AbstractAction {
        private styleSizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractFontAction.this.setFontExample();
        }
    }

    private class fontListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public fontListCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Courier", 0, 12));
        }

        public Component getListCellRendererComponent(JList list, Object value, int i, boolean isSelected, boolean hasFocus) {
            Font font = (Font)value;
            this.setForeground(Color.black);
            this.setBackground(isSelected ? new Color(153, 153, 204) : Color.white);
            this.setText(font.getName());
            return this;
        }
    }
}

