/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLeafNewLine;
import IDE.CodeEditor.CodeLeafSeparator;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.CodeLineVector;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.LineVector;
import IDE.CodeEditor.Region;
import IDE.Explorer.Explorer;
import IDE.Help.HintInfo;
import IDE.Messaging.MessageHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public abstract class Parser {
    protected CodeDocument document = null;
    private CodeLineVector lines = null;
    protected LeafVector leafs = null;
    protected CodeElementVector elements = null;
    private int iline;
    private int ileaf;
    private Timer timer = new Timer();
    private ParseTimerTask timertask = null;
    private boolean async = true;

    public Parser(boolean async) {
        this.async = async;
    }

    public final void initParser(CodeDocument document, CodeLineVector lines, LeafVector leafs, CodeElementVector elements) {
        this.document = document;
        this.lines = lines;
        this.leafs = leafs;
        this.elements = elements;
        if (this.async) {
            this.timertask = new ParseTimerTask();
            this.timer.schedule((TimerTask)this.timertask, 200L);
        }
    }

    public void stopParsing() {
        if (this.timertask != null) {
            this.timertask.interrupt();
        }
        this.timer.cancel();
        this.document = null;
        this.lines = null;
        this.leafs = null;
        this.elements = null;
    }

    public void interruptParser() {
        if (this.timertask != null) {
            this.timertask.interrupt();
        }
        this.timertask = new ParseTimerTask();
        this.timer.schedule((TimerTask)this.timertask, 200L);
    }

    public final void prepareParseRemoveLinesAndLeafs(int begin, int end) {
        int linecount = this.lines.size();
        int leafcount = this.leafs.size();
        if (linecount == 0) {
            this.iline = 0;
            this.ileaf = 0;
        } else {
            int i = this.document.getIndexLineAt(begin);
            if (i != -1) {
                int ileafend;
                this.iline = i;
                int ilinebegin = i++;
                while (i < linecount && this.lines.lineAt(i).begin() <= end) {
                    ++i;
                }
                int ilineend = i;
                this.ileaf = i = this.document.getIndexLeafAt(this.lines.lineAt(ilinebegin).begin());
                int ileafbegin = i;
                if (ilineend < linecount) {
                    CodeLeafElement leaf = this.lines.lineAt(ilineend).getLeafs().lastLeaf();
                    while (i < leafcount && this.leafs.leafAt(i) != leaf) {
                        this.leafs.leafAt(i).setParent(null);
                        this.cleanupLeaf(this.leafs.leafAt(i));
                        ++i;
                    }
                    ileafend = i;
                } else {
                    ileafend = leafcount;
                    for (i = ileafbegin; i < ileafend; ++i) {
                        this.leafs.leafAt(i).setParent(null);
                        this.cleanupLeaf(this.leafs.leafAt(i));
                    }
                }
                this.lines.removeRangeLines(ilinebegin, Math.min(linecount, ilineend + 1));
                this.leafs.removeRangeLeafs(ileafbegin, Math.min(leafcount, ileafend + 1));
            } else {
                this.iline = this.lines.size();
                this.ileaf = this.lines.size();
            }
        }
    }

    public void prepareParseAdjustLinesAndLeafs() {
        CodeLeafElement leaf;
        int i;
        int end;
        int begin;
        int charcount = this.document.length();
        if (this.leafs.size() == 0) {
            begin = 0;
            end = charcount;
        } else if (this.ileaf < this.leafs.size()) {
            begin = this.ileaf == 0 ? 0 : this.leafs.leafAt(this.ileaf - 1).end();
            end = this.leafs.leafAt(this.ileaf).begin();
        } else {
            begin = this.ileaf == 0 ? 0 : this.leafs.leafAt(this.ileaf - 1).end();
            end = charcount;
        }
        LeafVector newleafs = new LeafVector((int)((double)(end - begin) / 2.3), 100);
        LineVector newlines = new LineVector((int)((double)(end - begin) / 6.0), 100);
        String str = this.document.getString(begin, end - begin);
        charcount = end - begin;
        CodeLine line = new CodeLine();
        int b = 0;
        for (i = 0; i < charcount; ++i) {
            char c = str.charAt(i);
            if (!this.isSeparator(c)) continue;
            if (b < i) {
                leaf = new CodeLeafElement(this.document, begin + b);
                leaf.setLength(i - b);
                newleafs.addLeaf(leaf);
                line.addLeaf(leaf);
            }
            if (c == '\n') {
                leaf = new CodeLeafNewLine(this.document, begin + i);
                ((CodeLeafSeparator)leaf).setSeparatorChar('\n');
                newleafs.addLeaf(leaf);
                line.addLeaf(leaf);
                newlines.addLine(line);
                line = new CodeLine();
            } else {
                leaf = new CodeLeafSeparator(this.document, begin + i);
                ((CodeLeafSeparator)leaf).setSeparatorChar(c);
                newleafs.addLeaf(leaf);
                line.addLeaf(leaf);
            }
            b = i + 1;
        }
        if (b < i) {
            leaf = new CodeLeafElement(this.document, begin + b);
            leaf.setLength(i - b);
            newleafs.addLeaf(leaf);
            line.addLeaf(leaf);
        }
        if (line.getLeafCount() > 0) {
            this.lines.addLine(line);
        }
        this.lines.insertAll(this.iline, newlines);
        this.leafs.insertAll(this.ileaf, newleafs);
        this.parse();
    }

    private final void parse() {
        if (this.async) {
            this.interruptParser();
        } else {
            new ParseTimerTask().parseLeafs();
        }
    }

    private synchronized void finishParseLeafs(final int beginremove, final int endremove, final CodeElementVector newelements) {
        Runnable doWork = new Runnable(){

            public void run() {
                CodeEditor editor = Parser.this.document.getCodeEditor();
                int m = newelements.size();
                for (int i = 0; i < m; ++i) {
                    newelements.codeElementAt(i).acceptChilds();
                }
                Parser.this.elements.removeRangeElements(beginremove, endremove);
                Parser.this.elements.insertAll(beginremove, newelements);
                if (editor != null && m > 0) {
                    int linebegin = Parser.this.document.getIndexLineAt(newelements.codeElementAt(0).begin());
                    int lineend = Parser.this.document.getIndexLineAt(newelements.codeElementAt(m - 1).begin());
                    Parser.this.lines.recalculatePositions(linebegin, lineend);
                    editor.repaintVisible();
                    editor.highlightList();
                }
            }
        };
        try {
            if (this.async) {
                SwingUtilities.invokeAndWait(doWork);
            } else {
                doWork.run();
            }
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            MessageHandler.report("Problem finishParseLeafs ", e);
        }
    }

    public abstract int parseElement(int var1, CodeElementVector var2);

    public abstract boolean isSeparator(char var1);

    public abstract boolean isWhiteSpace(char var1);

    public abstract Region findHooks(int var1);

    public abstract int spacesForIndentation(int var1);

    public abstract Parser cloneParser(boolean var1);

    public abstract void buildDefinitionsList(SortedSet var1);

    public abstract HintInfo getHintInfo(int var1);

    public abstract String getSyntaxDescription(String var1);

    public abstract void replaceLeafByHint(CodeLeafElement var1, String var2);

    public abstract boolean completeCharacter(char var1, int var2, int var3);

    public abstract void cleanupLeaf(CodeLeafElement var1);

    public abstract String indentateElement(CodeElement var1);

    private class ParseTimerTask
    extends TimerTask {
        private boolean interrupted = false;

        private ParseTimerTask() {
        }

        public void run() {
            this.parseLeafs();
        }

        private void interrupt() {
            this.interrupted = true;
            this.cancel();
        }

        public final void parseLeafs() {
            CodeElementVector newelements = new CodeElementVector();
            try {
                CodeElement element;
                int i;
                int m;
                int ifirstnewleaf;
                int ileaf;
                int iremovebegin;
                if (Parser.this.elements.size() == 0) {
                    iremovebegin = 0;
                    ileaf = 0;
                    ifirstnewleaf = 0;
                } else {
                    m = Parser.this.leafs.size();
                    for (i = 0; i < m && Parser.this.leafs.leafAt(i).getParent() != null; ++i) {
                    }
                    if (i == m) {
                        return;
                    }
                    ifirstnewleaf = i;
                    if (this.interrupted) {
                        return;
                    }
                    if (i == 0) {
                        ileaf = 0;
                        iremovebegin = 0;
                    } else {
                        element = Parser.this.leafs.leafAt(i - 1).getTopParent();
                        if (element == null) {
                            ileaf = 0;
                            iremovebegin = 0;
                        } else {
                            m = Parser.this.elements.size();
                            for (i = 0; i < m && Parser.this.elements.codeElementAt(i) != element && Parser.this.elements.codeElementAt(i).isComplete(); ++i) {
                            }
                            iremovebegin = i;
                            if (this.interrupted) {
                                return;
                            }
                            ileaf = Parser.this.document.getIndexLeafAt(element.begin());
                        }
                    }
                }
                if (this.interrupted) {
                    return;
                }
                m = Parser.this.leafs.size();
                int elementcount = Parser.this.elements.size();
                while (!(ileaf >= m || Parser.this.leafs.leafAt(ileaf).isFirstLeaf() && ileaf > ifirstnewleaf)) {
                    ileaf = Parser.this.parseElement(ileaf, newelements);
                }
                if (this.interrupted) {
                    return;
                }
                int iremoveend = ileaf < m ? ((element = Parser.this.leafs.leafAt(ileaf).getTopParent()) == null ? Parser.this.elements.size() : Parser.this.elements.indexOf(element, iremovebegin)) : Parser.this.elements.size();
                if (this.interrupted) {
                    return;
                }
                m = newelements.size();
                for (i = 0; i < m; ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    newelements.codeElementAt(i).analyze();
                }
                if (this.interrupted) {
                    return;
                }
                Parser.this.finishParseLeafs(iremovebegin, iremoveend, newelements);
                if (Parser.this.document.getFile() != null) {
                    Explorer.refreshFileNodeContent(Parser.this.document.getFile(), Parser.this.document);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

