/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLeafNewLine;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.Parser.Definition;
import IDE.CodeEditor.Parser.IndentationBuffer;
import IDE.CodeEditor.Parser.LispArrayElement;
import IDE.CodeEditor.Parser.LispAtomElement;
import IDE.CodeEditor.Parser.LispBackQuoteElement;
import IDE.CodeEditor.Parser.LispCharacterElement;
import IDE.CodeEditor.Parser.LispCommentElement;
import IDE.CodeEditor.Parser.LispFunctionElement;
import IDE.CodeEditor.Parser.LispListElement;
import IDE.CodeEditor.Parser.LispOptionalElement;
import IDE.CodeEditor.Parser.LispQuoteElement;
import IDE.CodeEditor.Parser.LispStringElement;
import IDE.CodeEditor.Parser.LispWhiteElement;
import IDE.CodeEditor.Parser.Parser;
import IDE.CodeEditor.Region;
import IDE.Configuration.Configuration;
import IDE.Explorer.DefinitionInfo;
import IDE.Explorer.Explorer;
import IDE.Help.HintInfo;
import IDE.Interaction.LispInteraction;
import IDE.LispSyntax.LispAnalyzerGen;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class LispParser
extends Parser {
    private HashMap definitions = new HashMap();

    public LispParser(boolean async) {
        super(async);
    }

    public synchronized void buildDefinitionsList(SortedSet accumulatedDefinitions) {
        Iterator iter = this.definitions.values().iterator();
        while (iter.hasNext()) {
            accumulatedDefinitions.add(iter.next());
        }
    }

    public synchronized HintInfo getHintInfo(int position) {
        int ihook;
        char prevleafseparator;
        CodeElementVector elements = new CodeElementVector();
        if (this.document == null) {
            return null;
        }
        CodeLeafElement leaf = this.document.getLeafAt(position);
        CodeLeafElement prevleaf = this.document.getLeafAt(position - 1);
        char leafseparator = leaf == null ? (char)'\u0000' : leaf.getSeparatorChar();
        char c = prevleafseparator = prevleaf == null ? (char)'\u0000' : prevleaf.getSeparatorChar();
        if (this.isSeparator(leafseparator) && !this.isSeparator(prevleafseparator)) {
            leaf = prevleaf;
            --position;
        }
        if ((ihook = this.findIndexEarlistOpeningHook(position)) < 0) {
            return null;
        }
        this.parseElement(ihook, elements);
        if (elements.size() > 0 && elements.codeElementAt(0) instanceof LispListElement) {
            LispListElement list = (LispListElement)elements.codeElementAt(0);
            int indexElement = list.getPosition(position);
            list.analyze();
            return this.getHintInfoBodyContext(position, leaf, indexElement, list, list.getElements());
        }
        if (elements.size() > 0 && elements.codeElementAt(0) instanceof LispFunctionElement) {
            if (((LispFunctionElement)elements.codeElementAt(0)).getFunction() instanceof LispListElement) {
                LispListElement list = (LispListElement)((LispFunctionElement)elements.codeElementAt(0)).getFunction();
                int indexElement = list.getPosition(position);
                list.analyze();
                return this.getHintInfoBodyContext(position, leaf, indexElement, list, list.getElements());
            }
            return null;
        }
        return null;
    }

    private HintInfo getHintInfoBodyContext(int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        HintInfo info = new HintInfo();
        if (elements.size() == 0) {
            info.hints = this.getFunctionsAndMacros();
            info.iHint = 0;
            info.leaf = leaf;
            info.syntaxhint = info.hints.length > 0 ? this.getSyntaxDescription(info.hints[0]) : "";
            return info;
        }
        if (pos == 0 && elements.codeElementAt(0) instanceof LispAtomElement) {
            info.hints = this.getFunctionsAndMacros();
            info.iHint = this.search(info.hints, elements.codeElementAt(0).getString(this.document));
            info.leaf = leaf;
            info.syntaxhint = this.getSyntaxDescription(elements.codeElementAt(0).getString(this.document));
            if ((info.syntaxhint == null || info.syntaxhint.length() == 0) && info.iHint < info.hints.length) {
                info.syntaxhint = this.getSyntaxDescription(info.hints[info.iHint]);
            }
            return info;
        }
        if (elements.size() > 0 && elements.codeElementAt(0) instanceof LispFunctionElement) {
            if (((LispFunctionElement)elements.codeElementAt(0)).getFunction() instanceof LispListElement) {
                list = (LispListElement)((LispFunctionElement)elements.codeElementAt(0)).getFunction();
                int indexElement = list.getPosition(position);
                list.analyze();
                return this.getHintInfoBodyContext(position, leaf, indexElement, list, list.getElements());
            }
            return null;
        }
        if (pos == 0) {
            return null;
        }
        if (elements.codeElementAt(0) instanceof LispAtomElement) {
            String elementstr;
            String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
            CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
            String string = elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
            if (first.compareTo("defun") == 0 || first.compareTo("defmacro") == 0 || first.compareTo("defgeneric") == 0 || first.compareTo("defmethod") == 0) {
                return this.getHintInfoDef(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("case") == 0 || first.compareTo("ccase") == 0 || first.compareTo("ecase") == 0) {
                return this.getHintInfoCase(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("defclass") == 0) {
                return this.getHintInfoDefclass(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("lambda") == 0) {
                return this.getHintInfoLambda(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("let") == 0 || first.compareTo("let*") == 0 || first.compareTo("do") == 0 || first.compareTo("do*") == 0) {
                return this.getHintInfoDoLet(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("cond") == 0) {
                return this.getHintInfoCond(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("do-all-symbols") == 0 || first.compareTo("do-external-symbols") == 0 || first.compareTo("dolist") == 0 || first.compareTo("dotimes") == 0 || first.compareTo("do-symbols") == 0) {
                return this.getHintInfoDoThing(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("subtypep") == 0) {
                return this.getHintInfoSubtypep(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("coerce") == 0) {
                return this.getHintInfoCoerce(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("typep") == 0) {
                return this.getHintInfoTypep(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("handler-bind") == 0) {
                return this.getHintInfoHandlerBind(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("handler-case") == 0) {
                return this.getHintInfoHandlerCase(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("check-type") == 0) {
                return this.getHintInfoCheckType(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("ctypecase") == 0) {
                return this.getHintInfoCtypecase(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("etypecase") == 0) {
                return this.getHintInfoEtypecase(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("make-condition") == 0) {
                return this.getHintInfoMakeCondition(info, position, leaf, pos, list, elements);
            }
            if (first.compareTo("make-instance") == 0) {
                return this.getHintInfoMakeInstance(info, position, leaf, pos, list, elements);
            }
            return this.getHintInfoCall(info, position, leaf, pos, list, elements);
        }
        return null;
    }

    private HintInfo getHintInfoCond(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription("cond");
        info.leaf = null;
        if (this.isCoveredByList(position, element)) {
            CodeElementVector newelements = ((LispListElement)element).getElements();
            int newpos = ((LispListElement)element).getPosition(position);
            element.setParent(list);
            return this.getHintInfoCall(info, position, leaf, newpos, (LispListElement)element, newelements);
        }
        return info;
    }

    private HintInfo getHintInfoCase(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            return this.getHintInfoCall(info, position, leaf, pos, list, elements);
        }
        if (this.isCoveredByList(position, element)) {
            CodeElementVector newelements = ((LispListElement)element).getElements();
            int newpos = ((LispListElement)element).getPosition(position);
            if (pos + 1 == elements.size() && newpos == 0) {
                info.hints = new String[]{"T", "otherwise"};
                info.leaf = leaf;
            }
            element.setParent(list);
            return this.getHintInfoCall(info, position, leaf, newpos, (LispListElement)element, newelements);
        }
        return info;
    }

    private HintInfo getHintInfoSubtypep(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1 || pos == 2) {
            info.hints = this.getVariablesAndTypes(list);
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoCoerce(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 2) {
            info.hints = this.getVariablesAndTypes(list);
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoTypep(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 2) {
            info.hints = this.getVariablesAndTypes(list);
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoHandlerBind(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            if (this.isCoveredByList(position, element)) {
                CodeElementVector newelements;
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElement child = newpos < (newelements = ((LispListElement)element).getElements()).size() ? newelements.codeElementAt(newpos) : null;
                element.setParent(list);
                if (this.isCoveredByList(position, child)) {
                    newpos = ((LispListElement)child).getPosition(position);
                    newelements = ((LispListElement)child).getElements();
                    child.setParent(element);
                    if (newpos == 0) {
                        info.hints = this.getVariablesAndTypes(list);
                        info.iHint = this.search(info.hints, elementstr);
                        info.leaf = leaf;
                        return info;
                    }
                    return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)child, newelements);
                }
                return info;
            }
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoHandlerCase(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            return this.getHintInfoCall(info, position, leaf, pos, list, elements);
        }
        if (this.isCoveredByList(position, element)) {
            int newpos = ((LispListElement)element).getPosition(position);
            CodeElementVector newelements = ((LispListElement)element).getElements();
            if (newpos == 0) {
                info.hints = this.getVariablesAndTypes(list);
                info.iHint = this.search(info.hints, elementstr);
                info.leaf = leaf;
                return info;
            }
            if (newpos == 1) {
                if (element instanceof LispListElement) {
                    element.setParent(list);
                    return this.getHintInfoLambdaContext(info, position, leaf, newpos, (LispListElement)element, newelements, false);
                }
                return info;
            }
            element.setParent(list);
            return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
        }
        return info;
    }

    private HintInfo getHintInfoCheckType(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 2) {
            info.hints = this.getVariablesAndTypes(list);
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoCtypecase(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos > 1) {
            if (this.isCoveredByList(position, element)) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                element.setParent(list);
                if (newpos == 0) {
                    info.hints = this.getVariablesAndTypes(list);
                    info.iHint = this.search(info.hints, elementstr);
                    info.leaf = leaf;
                    return info;
                }
                return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
            }
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoEtypecase(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos > 1) {
            if (this.isCoveredByList(position, element)) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                element.setParent(list);
                if (newpos == 0) {
                    info.hints = this.getVariablesAndTypes(list);
                    info.iHint = this.search(info.hints, elementstr);
                    info.leaf = leaf;
                    return info;
                }
                return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
            }
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoMakeCondition(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            info.hints = this.getVariablesAndTypes(list);
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoDefclass(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            return info;
        }
        if (pos == 2) {
            if (this.isCoveredByList(position, element)) {
                CodeElementVector newelements;
                int newpos = ((LispListElement)element).getPosition(position);
                elementstr = newpos < (newelements = ((LispListElement)element).getElements()).size() ? newelements.codeElementAt(newpos).getString(this.document) : "";
                info.hints = this.getClasses(elements.codeElementAt(1).getString(this.document));
                info.iHint = this.search(info.hints, elementstr);
                info.leaf = leaf;
                return info;
            }
            return info;
        }
        if (pos == 3) {
            if (this.isCoveredByList(position, element)) {
                CodeElementVector newelements;
                CodeElement child;
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElement codeElement = child = newpos < (newelements = ((LispListElement)element).getElements()).size() ? newelements.codeElementAt(newpos) : null;
                if (this.isCoveredByList(position, child)) {
                    String childstr;
                    newpos = ((LispListElement)child).getPosition(position);
                    child = newpos < (newelements = ((LispListElement)child).getElements()).size() ? newelements.codeElementAt(newpos) : null;
                    String string = childstr = child == null ? "" : child.getString(this.document);
                    if (newpos == 0) {
                        return info;
                    }
                    if (newpos % 2 == 0 && this.isCoveredByList(position, child)) {
                        return this.getHintInfoCall(info, position, leaf, newpos, (LispListElement)child, newelements);
                    }
                    if (newpos % 2 == 0) {
                        return info;
                    }
                    info.hints = new String[]{":reader", ":writer", ":accessor", ":allocation", ":initarg", ":initform", ":type", ":documentation"};
                    info.iHint = this.search(info.hints, childstr);
                    info.leaf = leaf;
                    return info;
                }
                return info;
            }
            return info;
        }
        if (pos > 3) {
            if (this.isCoveredByList(position, element)) {
                String childstr;
                CodeElementVector newelements;
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElement child = newpos < (newelements = ((LispListElement)element).getElements()).size() ? newelements.codeElementAt(newpos) : null;
                String string = childstr = child == null ? "" : child.getString(this.document);
                if (newpos == 0) {
                    info.hints = new String[]{":default-initargs", ":documentation", ":metaclass"};
                    info.iHint = this.search(info.hints, childstr);
                    info.leaf = leaf;
                    return info;
                }
                return info;
            }
            return info;
        }
        return info;
    }

    private HintInfo getHintInfoMakeInstance(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            info.hints = this.getQuotedClasses();
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoDoThing(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            if (this.isCoveredByList(position, element)) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                if (newpos == 0) {
                    return info;
                }
                element.setParent(list);
                return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
            }
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoDoLet(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        info.hints = new String[0];
        info.iHint = -1;
        info.syntaxhint = this.getSyntaxDescription(first);
        info.leaf = null;
        if (pos == 1) {
            if (this.isCoveredByList(position, element)) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                if (first.compareTo("do*") == 0 || first.compareTo("let*") == 0) {
                    element.setParent(list);
                } else {
                    element.setParent(list.getParent());
                }
                return this.getHintInfoLambdaContext(info, position, leaf, newpos, (LispListElement)element, newelements, false);
            }
            return info;
        }
        if (pos == 2 && (first.compareTo("do") == 0 || first.compareTo("do*") == 0)) {
            if (this.isCoveredByList(position, element)) {
                CodeElement child;
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                element.setParent(list);
                CodeElement codeElement = child = newpos < elements.size() ? newelements.codeElementAt(newpos) : null;
                if (this.isCoveredByList(position, child)) {
                    child.setParent(element);
                    newpos = ((LispListElement)child).getPosition(position);
                    newelements = ((LispListElement)child).getElements();
                    return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)child, newelements);
                }
                return info;
            }
            return info;
        }
        return this.getHintInfoCall(info, position, leaf, pos, list, elements);
    }

    private HintInfo getHintInfoCall(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String elementstr;
        if (elements.size() == 0) {
            return info;
        }
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String string = elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        if (this.isCoveredByList(position, element)) {
            int newpos = ((LispListElement)element).getPosition(position);
            CodeElementVector newelements = ((LispListElement)element).getElements();
            element.setParent(list);
            return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
        }
        if (element instanceof LispFunctionElement) {
            if (((LispFunctionElement)element).getFunction() instanceof LispListElement) {
                list = (LispListElement)((LispFunctionElement)element).getFunction();
                int indexElement = list.getPosition(position);
                list.analyze();
                return this.getHintInfoBodyContext(position, leaf, indexElement, list, list.getElements());
            }
            return null;
        }
        info.hints = this.getVariables(list);
        info.iHint = this.search(info.hints, elementstr);
        info.leaf = leaf;
        info.syntaxhint = this.getSyntaxDescription(first);
        return info;
    }

    private HintInfo getHintInfoDef(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String elementstr;
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String string = elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        if (pos == 1) {
            info.hints = this.getUndefinedCallers(this.getFunctionsAndMacros());
            info.iHint = this.search(info.hints, elementstr);
            info.leaf = leaf;
            info.syntaxhint = this.getSyntaxDescription(first);
            return info;
        }
        if (pos == 2) {
            info.hints = new String[0];
            info.iHint = -1;
            info.leaf = null;
            info.syntaxhint = this.getSyntaxDescription(first);
            if (element instanceof LispListElement) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                element.setParent(list);
                return this.getHintInfoLambdaContext(info, position, leaf, newpos, (LispListElement)element, newelements, true);
            }
            return info;
        }
        if (this.isCoveredByList(position, element)) {
            int newpos = ((LispListElement)element).getPosition(position);
            CodeElementVector newelements = ((LispListElement)element).getElements();
            element.setParent(list);
            return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
        }
        if (element instanceof LispFunctionElement) {
            if (((LispFunctionElement)element).getFunction() instanceof LispListElement) {
                LispListElement function = (LispListElement)((LispFunctionElement)element).getFunction();
                int indexElement = function.getPosition(position);
                function.setParent(list);
                function.analyze();
                return this.getHintInfoBodyContext(position, leaf, indexElement, function, function.getElements());
            }
            info.hints = this.getFunctions();
            info.iHint = this.search(info.hints, ((LispFunctionElement)element).getFunction().getString(this.document).toLowerCase());
            info.leaf = leaf;
            info.syntaxhint = this.getSyntaxDescription(first);
            return info;
        }
        info.hints = this.getVariables(list);
        info.iHint = this.search(info.hints, elementstr);
        info.leaf = leaf;
        info.syntaxhint = this.getSyntaxDescription(first);
        return info;
    }

    private HintInfo getHintInfoLambda(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements) {
        String elementstr;
        String first = elements.codeElementAt(0).getString(this.document).toLowerCase();
        CodeElement element = pos < elements.size() ? elements.codeElementAt(pos) : null;
        String string = elementstr = element == null ? "" : element.getString(this.document).toLowerCase();
        if (pos == 1) {
            info.hints = new String[0];
            info.iHint = -1;
            info.leaf = null;
            info.syntaxhint = this.getSyntaxDescription(first);
            if (element instanceof LispListElement) {
                int newpos = ((LispListElement)element).getPosition(position);
                CodeElementVector newelements = ((LispListElement)element).getElements();
                element.setParent(list);
                return this.getHintInfoLambdaContext(info, position, leaf, newpos, (LispListElement)element, newelements, true);
            }
            return info;
        }
        if (this.isCoveredByList(position, element)) {
            int newpos = ((LispListElement)element).getPosition(position);
            CodeElementVector newelements = ((LispListElement)element).getElements();
            element.setParent(list);
            return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
        }
        if (element instanceof LispFunctionElement) {
            if (((LispFunctionElement)element).getFunction() instanceof LispListElement) {
                LispListElement function = (LispListElement)((LispFunctionElement)element).getFunction();
                int indexElement = function.getPosition(position);
                function.setParent(list);
                function.analyze();
                return this.getHintInfoBodyContext(position, leaf, indexElement, function, function.getElements());
            }
            info.hints = this.getFunctions();
            info.iHint = this.search(info.hints, ((LispFunctionElement)element).getFunction().getString(this.document).toLowerCase());
            info.leaf = leaf;
            info.syntaxhint = this.getSyntaxDescription(first);
            return info;
        }
        info.hints = this.getVariables(list);
        info.iHint = this.search(info.hints, elementstr);
        info.leaf = leaf;
        info.syntaxhint = this.getSyntaxDescription(first);
        return info;
    }

    private HintInfo getHintInfoLambdaContext(HintInfo info, int position, CodeLeafElement leaf, int pos, LispListElement list, CodeElementVector elements, boolean lambdalist) {
        if (pos < elements.size()) {
            CodeElement element = elements.codeElementAt(pos);
            if (this.isCoveredByList(position, element)) {
                int newpos = ((LispListElement)element).getPosition(position);
                if (newpos == 1) {
                    CodeElementVector newelements = ((LispListElement)element).getElements();
                    if (newpos < newelements.size()) {
                        element = newelements.codeElementAt(newpos);
                        if (this.isCoveredByList(position, element)) {
                            newelements = ((LispListElement)element).getElements();
                            newpos = ((LispListElement)element).getPosition(position);
                            element.setParent(list);
                            return this.getHintInfoBodyContext(position, leaf, newpos, (LispListElement)element, newelements);
                        }
                        return info;
                    }
                    return info;
                }
                return info;
            }
            if (lambdalist) {
                info.hints = new String[]{"&allow-other-keys", "&aux", "&key", "&optional", "&rest"};
                info.leaf = leaf;
                info.iHint = 0;
            }
            return info;
        }
        if (lambdalist) {
            info.hints = new String[]{"&allow-other-keys", "&aux", "&key", "&optional", "&rest"};
            info.leaf = leaf;
            info.iHint = 0;
        }
        return info;
    }

    private boolean isCoveredByList(int position, CodeElement element) {
        return element != null && element instanceof LispListElement && element.begin() < position && position < element.end();
    }

    private int findIndexEarlistOpeningHook(int pos) {
        int iclose;
        Region region = this.findHooks(pos);
        int iopen = region == null ? -1 : region.begin;
        int n = iclose = region == null ? -1 : region.end;
        while ((region = this.findHooks(iopen - 1)) != null && region != null && region.begin != 0 && region.begin <= pos && pos <= region.end) {
            iopen = region.begin;
            iclose = region.end;
        }
        if (region != null && region.begin == 0 && 0 <= pos && pos <= region.end) {
            return this.document.getIndexLeafAt(0);
        }
        if (iopen <= pos && pos <= iclose) {
            return this.document.getIndexLeafAt(iopen);
        }
        return -1;
    }

    private String[] getFunctionsAndMacros() {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        String[] buildins = LispAnalyzerGen.getLispKeywords();
        File file = this.document.getFile();
        DefinitionInfo[] definitions = Explorer.getDefinitionInfos(file, new String[]{"defgeneric", "defmethod", "defun", "defmacro"});
        for (i = 0; i < buildins.length; ++i) {
            result.add(buildins[i].toLowerCase());
        }
        for (i = 0; i < definitions.length; ++i) {
            result.add(definitions[i].name.toLowerCase());
        }
        Iterator iter = result.iterator();
        String[] functionsandmacros = new String[result.size()];
        int i2 = 0;
        while (iter.hasNext()) {
            functionsandmacros[i2] = (String)iter.next();
            ++i2;
        }
        return functionsandmacros;
    }

    private String[] getFunctions() {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        String[] buildins = LispAnalyzerGen.getLispKeywords();
        File file = this.document.getFile();
        DefinitionInfo[] definitions = Explorer.getDefinitionInfos(file, new String[]{"defgeneric", "defmethod", "defun"});
        for (i = 0; i < buildins.length; ++i) {
            result.add(buildins[i].toLowerCase());
        }
        for (i = 0; i < definitions.length; ++i) {
            result.add(definitions[i].name.toLowerCase());
        }
        Iterator iter = result.iterator();
        String[] functions = new String[result.size()];
        int i2 = 0;
        while (iter.hasNext()) {
            functions[i2] = (String)iter.next();
            ++i2;
        }
        return functions;
    }

    private String[] getVariables(LispListElement list) {
        return this.getDefinitionsAndVariables(list, new String[]{"defparameter", "defconstant", "defvar"});
    }

    private String[] getVariablesAndTypes(LispListElement list) {
        return this.getDefinitionsAndVariables(list, new String[]{"defparameter", "defconstant", "defvar", "deftype", "defclass"});
    }

    private String[] getClasses(String classname) {
        DefinitionInfo[] defs = Explorer.getDefinitionInfos(this.document.getFile(), new String[]{"defclass"});
        Vector<String> temp = new Vector<String>();
        for (int i = 0; i < defs.length; ++i) {
            if (defs[i].name.compareTo(classname) == 0) continue;
            temp.add(defs[i].name);
        }
        int m = temp.size();
        String[] hints = new String[m];
        for (int i = 0; i < m; ++i) {
            hints[i] = (String)temp.elementAt(i);
        }
        return hints;
    }

    private String[] getQuotedClasses() {
        DefinitionInfo[] defs = Explorer.getDefinitionInfos(this.document.getFile(), new String[]{"defclass"});
        String[] hints = new String[defs.length];
        for (int i = 0; i < hints.length; ++i) {
            hints[i] = '\'' + defs[i].name;
        }
        return hints;
    }

    private String[] getDefinitionsAndVariables(LispListElement list, String[] types) {
        TreeSet<String> hintset = new TreeSet<String>();
        Vector variables = list.getAllVariables();
        int m = variables.size();
        for (int i = 0; i < m; ++i) {
            hintset.add(((CodeElement)variables.elementAt(i)).getString(this.document));
        }
        DefinitionInfo[] definitions = Explorer.getDefinitionInfos(this.document.getFile(), types);
        for (int i = 0; i < definitions.length; ++i) {
            if (definitions[i].type.compareTo("deftype") == 0 || definitions[i].type.compareTo("defclass") == 0) {
                hintset.add('\'' + definitions[i].name);
                continue;
            }
            hintset.add(definitions[i].name);
        }
        String[] hints = new String[hintset.size()];
        Iterator iter = hintset.iterator();
        int i = 0;
        while (iter.hasNext()) {
            hints[i] = (String)iter.next();
            ++i;
        }
        return hints;
    }

    private int search(String[] strings, String key) {
        int pos = Arrays.binarySearch(strings, key = key.toLowerCase());
        return pos > 0 ? pos : Math.abs(pos) - 1;
    }

    private String[] getUndefinedCallers(String[] defined) {
        TreeSet undefined = new TreeSet();
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            if (!(this.elements.codeElementAt(i) instanceof LispListElement)) continue;
            ((LispListElement)this.elements.codeElementAt(i)).updateUndefinedCallers(this.document, undefined, defined);
        }
        String[] result = new String[undefined.size()];
        Iterator iter = undefined.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i] = (String)iter.next();
            ++i;
        }
        return result;
    }

    public String getSyntaxDescription(String name) {
        return LispInteraction.getSyntaxDescription(name);
    }

    public void replaceLeafByHint(CodeLeafElement leaf, String hint) {
        int b = leaf.begin();
        int e = leaf.end();
        if (leaf.getSeparatorChar() == '(') {
            this.document.getCodeEditor().insertStringAt(hint, b + 1);
            this.document.getCodeEditor().cursor.setCursor(b + hint.length() + 1);
        } else if (leaf.getSeparatorChar() == ')') {
            this.document.getCodeEditor().insertStringAt(hint, b);
            this.document.getCodeEditor().cursor.setCursor(b + hint.length());
        } else {
            this.document.getCodeEditor().replace(b, e - b, hint);
            this.document.getCodeEditor().cursor.setCursor(b + hint.length());
        }
    }

    private synchronized void addDefinition(String type, CodeLeafElement leaf) {
        if (leaf != null) {
            this.definitions.put(leaf, new Definition(type, leaf.getString(this.document), leaf));
        }
    }

    public Parser cloneParser(boolean async) {
        return new LispParser(async);
    }

    public int spacesForIndentation(int pos) {
        int ileafafterhook;
        CodeLine line = this.document.getLineAt(pos);
        if (line == null) {
            return 0;
        }
        int beginline = line.begin();
        if (beginline == 0) {
            return 0;
        }
        int m = this.leafs.size();
        int ileaf = this.document.getIndexLeafAt(line.begin());
        if (ileaf == -1 || ileaf == 0) {
            return 0;
        }
        int ihook = this.findIndexOpeningHook(ileaf);
        if (ihook == ileaf) {
            ihook = this.findIndexOpeningHook(ileaf - 1);
        }
        if (ihook < 0) {
            return 0;
        }
        for (ileafafterhook = ihook + 1; ileafafterhook < m && this.isWhiteSpace(this.leafs.leafAt(ileafafterhook).getSeparatorChar()); ++ileafafterhook) {
        }
        if (ileafafterhook >= ileaf) {
            return this.charsBefore(ihook) + 1;
        }
        CodeLeafElement leaf = this.leafs.leafAt(ileafafterhook);
        String leafstring = leaf.getString(this.document).toUpperCase();
        if (leaf.getSeparatorChar() == '(') {
            return this.charsBefore(ileafafterhook);
        }
        if ("DEFUN".compareTo(leafstring) == 0 || "DEFMACRO".compareTo(leafstring) == 0 || "DEFGENERIC".compareTo(leafstring) == 0 || "DEFMETHOD".compareTo(leafstring) == 0 || "DEFCLASS".compareTo(leafstring) == 0) {
            return this.charsBefore(ileafafterhook) + 1;
        }
        if ("COND".compareTo(leafstring) == 0) {
            return this.charsBefore(ileafafterhook) + leafstring.length() + 1;
        }
        if ("IF".compareTo(leafstring) == 0 || "DO".compareTo(leafstring) == 0 || "DO*".compareTo(leafstring) == 0) {
            int i = this.skipElement(ileafafterhook);
            if (i >= m) {
                return this.charsBefore(ileafafterhook) + leafstring.length() + 1;
            }
            if ((i = this.skipElement(i)) >= ileaf) {
                return this.charsBefore(ileafafterhook) + leafstring.length() + 1;
            }
            return this.charsBefore(ileafafterhook) + 1;
        }
        if ("WHEN".compareTo(leafstring) == 0 || "UNLESS".compareTo(leafstring) == 0 || "LET".compareTo(leafstring) == 0 || "LET*".compareTo(leafstring) == 0) {
            int i = this.skipElement(ileafafterhook);
            if (i >= m) {
                return this.charsBefore(ileafafterhook) + leafstring.length() + 1;
            }
            if (i >= ileaf) {
                return this.charsBefore(ileafafterhook) + leafstring.length() + 1;
            }
            return this.charsBefore(ileafafterhook) + 1;
        }
        int i = this.skipElement(ileafafterhook);
        if (i < ileaf) {
            return this.charsBefore(i);
        }
        return this.charsBefore(ihook) + 1;
    }

    private int skipElement(int ileaf) {
        int nextileaf;
        int m = this.leafs.size();
        if (ileaf >= m) {
            return m;
        }
        for (nextileaf = (c = this.leafs.leafAt(ileaf).getSeparatorChar()) == '(' ? this.skipList(ileaf + 1) : (c == '#' ? this.skipHash(ileaf + 1) : (c == '\"' ? this.skipString(ileaf + 1) : (c == ';' ? this.skipComment(ileaf + 1) : ileaf + 1))); nextileaf < m && this.isWhiteSpace(this.leafs.leafAt(nextileaf).getSeparatorChar()); ++nextileaf) {
        }
        if (nextileaf < m && this.leafs.leafAt(nextileaf).getSeparatorChar() == ';') {
            return this.skipElement(nextileaf);
        }
        return nextileaf;
    }

    private int skipList(int ileaf) {
        return this.findIndexClosingHook(ileaf) + 1;
    }

    private int skipString(int ileaf) {
        int m = this.leafs.size();
        while (ileaf < m && this.leafs.leafAt(ileaf).getSeparatorChar() != '\"') {
            if (this.leafs.leafAt(ileaf).getSeparatorChar() == '\\') {
                ++ileaf;
            }
            ++ileaf;
        }
        return ileaf + 1;
    }

    private int skipComment(int ileaf) {
        int m = this.leafs.size();
        while (ileaf < m && this.leafs.leafAt(ileaf).getSeparatorChar() != '\n') {
            ++ileaf;
        }
        while (ileaf < m && this.isWhiteSpace(this.leafs.leafAt(ileaf).getSeparatorChar())) {
            ++ileaf;
        }
        return ileaf;
    }

    private int skipHash(int ileaf) {
        if (ileaf < this.leafs.size()) {
            char c = this.leafs.leafAt(ileaf).getSeparatorChar();
            if (c == '\\') {
                return ileaf + 2;
            }
            if (c == '\'') {
                if (ileaf + 1 < this.leafs.size()) {
                    return this.skipElement(ileaf + 1);
                }
                return ileaf + 1;
            }
            if (c == '(') {
                return this.findClosingHook(ileaf + 1) + 1;
            }
            if (c == '|') {
                ++ileaf;
                while (ileaf + 1 < this.leafs.size() && (this.leafs.leafAt(ileaf).getSeparatorChar() != '|' || this.leafs.leafAt(ileaf + 1).getSeparatorChar() != '#')) {
                    ++ileaf;
                }
                if (ileaf + 2 < this.leafs.size()) {
                    return this.skipElement(ileaf);
                }
                return ileaf + 2;
            }
            return ileaf;
        }
        return ileaf;
    }

    private int charsBefore(int ileaf) {
        CodeLeafElement leaf = this.leafs.leafAt(ileaf);
        CodeLine line = this.document.getLineAt(leaf.begin());
        if (line == null) {
            return 0;
        }
        return leaf.begin() - line.begin();
    }

    public Region findHooks(int pos) {
        if (this.document == null) {
            return null;
        }
        int ileaf = this.document.getIndexLeafAt(pos);
        if (ileaf == -1) {
            return null;
        }
        int ibegin = this.findIndexOpeningHook(ileaf);
        if (ibegin == -1) {
            return null;
        }
        int iend = this.findIndexClosingHook(ibegin);
        if (iend == -1) {
            return null;
        }
        return new Region(this.leafs.leafAt(ibegin).begin(), this.leafs.leafAt(iend).begin());
    }

    private int findOpeningHook(int ileaf) {
        int ihook = this.findIndexOpeningHook(ileaf);
        if (ihook < 0) {
            return -1;
        }
        return this.leafs.leafAt(ihook).begin();
    }

    private int findIndexOpeningHook(int ileaf) {
        int index;
        CodeLeafElement leaf = this.leafs.leafAt(ileaf);
        CodeElement parent = leaf.getParent();
        if (parent != null) {
            while (!(parent instanceof LispListElement) && parent != null) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return -1;
            }
            return this.document.getIndexLeafAt(parent.begin());
        }
        int iopen = -1;
        if (this.leafs.size() == 0) {
            return -1;
        }
        for (index = ileaf - 1; index >= 0 && this.leafs.leafAt(index).getParent() == null; --index) {
        }
        parent = this.leafs.leafAt(index = Math.max(0, index)).getTopParent();
        index = parent == null ? 0 : this.document.getIndexLeafAt(parent.begin());
        while (index < ileaf && index < this.leafs.size()) {
            while (index < this.leafs.size() && this.leafs.leafAt(index).getSeparatorChar() != '(') {
                index = this.goNext(index);
            }
            int iclose = this.findIndexClosingHook(index);
            if (iclose == -1) {
                return iopen <= ileaf ? iopen : -1;
            }
            if (iclose >= ileaf && index < this.leafs.size() && index <= ileaf) {
                iopen = index;
            }
            index = this.goNext(index);
        }
        return iopen <= ileaf ? iopen : -1;
    }

    private int goNext(int ileaf) {
        if (++ileaf < this.leafs.size()) {
            switch (this.leafs.leafAt(ileaf).getSeparatorChar()) {
                case '#': {
                    return this.goNextHash(ileaf);
                }
                case ';': {
                    return this.goNextComment(ileaf);
                }
                case '\"': {
                    return this.goNextString(ileaf);
                }
            }
            return ileaf;
        }
        return this.leafs.size();
    }

    private int goNextHash(int ileaf) {
        if (++ileaf < this.leafs.size()) {
            switch (this.leafs.leafAt(ileaf).getSeparatorChar()) {
                case '|': {
                    ++ileaf;
                    while (ileaf + 1 < this.leafs.size() && (this.leafs.leafAt(ileaf).getSeparatorChar() != '|' || this.leafs.leafAt(ileaf).getSeparatorChar() != '#')) {
                        ++ileaf;
                    }
                    if (ileaf + 1 >= this.leafs.size()) {
                        return this.leafs.size();
                    }
                    return ileaf + 2;
                }
                case '\\': {
                    return ileaf + 1;
                }
            }
            return ileaf - 1;
        }
        return this.leafs.size();
    }

    private int goNextComment(int ileaf) {
        ++ileaf;
        while (ileaf < this.leafs.size() && this.leafs.leafAt(ileaf).getSeparatorChar() != '\n') {
            ++ileaf;
        }
        return ileaf;
    }

    private int goNextString(int ileaf) {
        ++ileaf;
        block4: while (ileaf < this.leafs.size()) {
            switch (this.leafs.leafAt(ileaf).getSeparatorChar()) {
                case '\\': {
                    ileaf += 2;
                    continue block4;
                }
                case '\"': {
                    return ileaf + 1;
                }
            }
            ++ileaf;
        }
        return this.leafs.size();
    }

    private int findClosingHook(int ileaf) {
        int i = this.findIndexClosingHook(ileaf);
        if (i != -1) {
            return this.leafs.leafAt(i).begin();
        }
        return -1;
    }

    private int findIndexClosingHook(int ileaf) {
        CodeLeafElement leaf = this.leafs.leafAt(ileaf);
        if (leaf == null) {
            return -1;
        }
        CodeElement parent = leaf.getParent();
        if (parent != null) {
            while (!(parent instanceof LispListElement) && parent != null) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return -1;
            }
            return this.document.getIndexLeafAt(parent.end() - 1);
        }
        int nrhooks = 1;
        ileaf = this.goNext(ileaf);
        while (ileaf < this.leafs.size()) {
            switch (this.leafs.leafAt(ileaf).getSeparatorChar()) {
                case ')': {
                    if (nrhooks == 1) {
                        return ileaf;
                    }
                    --nrhooks;
                    break;
                }
                case '(': {
                    ++nrhooks;
                }
            }
            ileaf = this.goNext(ileaf);
        }
        return -1;
    }

    public final boolean isSeparator(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '(' || c == ';' || c == '\"' || c == '\\' || c == '#' || c == ')' || c == '|' || c == '\'' || c == '`';
    }

    public boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public int parseElement(int ileaf, CodeElementVector elements) {
        switch (this.leafs.leafAt(ileaf).getSeparatorChar()) {
            case '\'': {
                ileaf = this.parseQuote(ileaf, elements);
                break;
            }
            case '`': {
                ileaf = this.parseBackQuote(ileaf, elements);
                break;
            }
            case '#': {
                ileaf = this.parseHash(ileaf, elements);
                break;
            }
            case ' ': {
                ileaf = this.parseWhite(ileaf, elements);
                break;
            }
            case '\n': {
                ileaf = this.parseWhite(ileaf, elements);
                break;
            }
            case '\t': {
                ileaf = this.parseWhite(ileaf, elements);
                break;
            }
            case '\r': {
                ileaf = this.parseWhite(ileaf, elements);
                break;
            }
            case '(': {
                ileaf = this.parseList(ileaf, elements);
                break;
            }
            case ';': {
                ileaf = this.parseComment(ileaf, elements);
                break;
            }
            case '\"': {
                ileaf = this.parseString(ileaf, elements);
                break;
            }
            default: {
                ileaf = this.parseAtom(ileaf, elements);
            }
        }
        return ileaf;
    }

    private int parseHash(int ileaf, CodeElementVector elements) {
        if (ileaf + 1 < this.leafs.size()) {
            switch (this.leafs.leafAt(ileaf + 1).getSeparatorChar()) {
                case '|': {
                    ileaf = this.parseHashComment(ileaf, elements);
                    break;
                }
                case '\'': {
                    ileaf = this.parseHashFunction(ileaf, elements);
                    break;
                }
                case '\\': {
                    ileaf = this.parseHashCharacter(ileaf, elements);
                    break;
                }
                case '(': {
                    ileaf = this.parseHashArray(ileaf, elements);
                    break;
                }
                case '+': 
                case '-': {
                    ileaf = this.parseHashOptional(ileaf, elements);
                    break;
                }
                default: {
                    ileaf = this.parseHashPossibleOptionalElement(ileaf, elements);
                    break;
                }
            }
        } else {
            LispAtomElement atom = new LispAtomElement(this.leafs.leafAt(ileaf).getString(this.document), this.leafs.leafAt(ileaf));
            atom.markIncomplete();
            elements.addCodeElement(atom);
            ++ileaf;
        }
        return ileaf;
    }

    private int parseHashPossibleOptionalElement(int ileaf, CodeElementVector elements) {
        String str = this.leafs.leafAt(ileaf + 1).getString(this.document);
        if (str.length() > 0 && (str.charAt(0) == '+' || str.charAt(0) == '-')) {
            LispOptionalElement optional = new LispOptionalElement();
            CodeElementVector childs = optional.getChilds();
            optional.addChild(this.leafs.leafAt(ileaf));
            optional.addChild(this.leafs.leafAt(++ileaf));
            optional.setTest(this.leafs.leafAt(ileaf));
            if (++ileaf < this.leafs.size()) {
                ileaf = this.parseElement(ileaf, childs);
                optional.setCode(childs.codeElementAt(childs.size() - 1));
            } else {
                optional.markIncomplete();
            }
            optional.setAdd(str.charAt(0) == '+');
            elements.addCodeElement(optional);
            return ileaf;
        }
        LispAtomElement atom = new LispAtomElement(this.leafs.leafAt(ileaf).getString(this.document), this.leafs.leafAt(ileaf));
        atom.markIncomplete();
        elements.addCodeElement(atom);
        return ileaf + 1;
    }

    private int parseHashComment(int ileaf, CodeElementVector elements) {
        LispCommentElement comment = new LispCommentElement();
        comment.addChild(this.leafs.leafAt(ileaf));
        comment.addChild(this.leafs.leafAt(++ileaf));
        ++ileaf;
        int m = this.leafs.size();
        while (ileaf + 1 < m && (this.leafs.leafAt(ileaf).getSeparatorChar() != '|' || this.leafs.leafAt(ileaf + 1).getSeparatorChar() != '#')) {
            comment.addChild(this.leafs.leafAt(ileaf));
            ++ileaf;
        }
        if (ileaf + 1 < m) {
            comment.addChild(this.leafs.leafAt(ileaf));
            comment.addChild(this.leafs.leafAt(++ileaf));
            ++ileaf;
        } else {
            comment.markIncomplete();
        }
        elements.addCodeElement(comment);
        return ileaf;
    }

    private int parseHashFunction(int ileaf, CodeElementVector elements) {
        LispFunctionElement function = new LispFunctionElement();
        CodeElementVector childs = function.getChilds();
        function.addChild(this.leafs.leafAt(ileaf));
        function.addChild(this.leafs.leafAt(++ileaf));
        if (++ileaf < this.leafs.size()) {
            ileaf = this.parseElement(ileaf, childs);
            function.setFunction(childs.codeElementAt(childs.size() - 1));
        } else {
            function.markIncomplete();
        }
        elements.addCodeElement(function);
        return ileaf;
    }

    private int parseHashOptional(int ileaf, CodeElementVector elements) {
        LispOptionalElement optional = new LispOptionalElement();
        CodeElementVector childs = optional.getChilds();
        optional.addChild(this.leafs.leafAt(ileaf));
        optional.addChild(this.leafs.leafAt(++ileaf));
        if (this.leafs.leafAt(ileaf).getSeparatorChar() == '+') {
            optional.setAdd(true);
        } else if (this.leafs.leafAt(ileaf).getSeparatorChar() == '-') {
            optional.setAdd(false);
        }
        if (++ileaf < this.leafs.size()) {
            ileaf = this.parseElement(ileaf, childs);
            optional.setTest(childs.codeElementAt(childs.size() - 1));
        } else {
            optional.markIncomplete();
        }
        if (++ileaf < this.leafs.size()) {
            ileaf = this.parseElement(ileaf, childs);
            optional.setCode(childs.codeElementAt(childs.size() - 1));
        } else {
            optional.markIncomplete();
        }
        elements.addCodeElement(optional);
        return ileaf;
    }

    public int parseQuote(int ileaf, CodeElementVector elements) {
        LispQuoteElement quote = new LispQuoteElement();
        CodeElementVector childs = quote.getChilds();
        quote.addChild(this.leafs.leafAt(ileaf));
        if (++ileaf < this.leafs.size()) {
            ileaf = this.parseElement(ileaf, childs);
            quote.setQuoted(childs.codeElementAt(childs.size() - 1));
        } else {
            quote.markIncomplete();
        }
        elements.addCodeElement(quote);
        return ileaf;
    }

    public int parseBackQuote(int ileaf, CodeElementVector elements) {
        LispBackQuoteElement quote = new LispBackQuoteElement();
        CodeElementVector childs = quote.getChilds();
        quote.addChild(this.leafs.leafAt(ileaf));
        if (++ileaf < this.leafs.size()) {
            ileaf = this.parseElement(ileaf, childs);
            quote.setQuoted(childs.codeElementAt(childs.size() - 1));
        } else {
            quote.markIncomplete();
        }
        elements.addCodeElement(quote);
        return ileaf;
    }

    private int parseHashCharacter(int ileaf, CodeElementVector elements) {
        LispCharacterElement character = new LispCharacterElement();
        character.addChild(this.leafs.leafAt(ileaf));
        character.addChild(this.leafs.leafAt(++ileaf));
        if (++ileaf < this.leafs.size()) {
            character.addChild(this.leafs.leafAt(ileaf));
            ++ileaf;
        } else {
            character.markIncomplete();
        }
        elements.addCodeElement(character);
        return ileaf;
    }

    private int parseHashArray(int ileaf, CodeElementVector elements) {
        LispArrayElement array = new LispArrayElement();
        CodeElementVector childs = array.getChilds();
        array.addChild(this.leafs.leafAt(ileaf));
        array.addChild(this.leafs.leafAt(++ileaf));
        ++ileaf;
        int m = this.leafs.size();
        while (ileaf < m && this.leafs.leafAt(ileaf).getSeparatorChar() != ')') {
            ileaf = this.parseElement(ileaf, childs);
        }
        if (ileaf < m) {
            childs.addCodeElement(this.leafs.leafAt(ileaf));
        } else {
            array.markIncomplete();
        }
        elements.addCodeElement(array);
        return ileaf + 1;
    }

    private int parseWhite(int ileaf, CodeElementVector elements) {
        LispWhiteElement white = new LispWhiteElement();
        int m = this.leafs.size();
        while (ileaf < m && this.isWhiteSpace(this.leafs.leafAt(ileaf).getSeparatorChar())) {
            white.addChild(this.leafs.leafAt(ileaf));
            ++ileaf;
        }
        elements.addCodeElement(white);
        return ileaf;
    }

    private int parseList(int ileaf, CodeElementVector elements) {
        int m = this.leafs.size();
        LispListElement list = new LispListElement();
        CodeElementVector childs = list.getChilds();
        list.addChild(this.leafs.leafAt(ileaf));
        ++ileaf;
        while (ileaf < m && this.leafs.leafAt(ileaf).getSeparatorChar() != ')') {
            ileaf = this.parseElement(ileaf, childs);
        }
        int childcount = childs.size();
        for (int i = 1; i < childcount; ++i) {
            if (childs.codeElementAt(i) instanceof LispWhiteElement) continue;
            list.addElement(childs.codeElementAt(i));
        }
        if (ileaf < m) {
            childs.addCodeElement(this.leafs.leafAt(ileaf));
            CodeElementVector listelements = list.getElements();
            if (listelements.size() > 1 && listelements.codeElementAt(1) instanceof LispAtomElement && listelements.codeElementAt(0) instanceof LispAtomElement && ((LispAtomElement)listelements.codeElementAt(0)).isDefKeyword()) {
                this.addDefinition(((LispAtomElement)listelements.codeElementAt(0)).getSymbol().toLowerCase(), ((LispAtomElement)listelements.codeElementAt(1)).getLeaf());
            }
        } else {
            list.markIncomplete();
        }
        elements.addCodeElement(list);
        return ileaf + 1;
    }

    private int parseComment(int ileaf, CodeElementVector elements) {
        LispCommentElement comment = new LispCommentElement();
        int m = this.leafs.size();
        while (ileaf < m && !(this.leafs.leafAt(ileaf) instanceof CodeLeafNewLine)) {
            comment.addChild(this.leafs.leafAt(ileaf));
            ++ileaf;
        }
        if (ileaf < m) {
            comment.addChild(this.leafs.leafAt(ileaf));
        }
        elements.addCodeElement(comment);
        return ileaf + 1;
    }

    private int parseString(int ileaf, CodeElementVector elements) {
        CodeLeafElement leaf;
        LispStringElement string = new LispStringElement();
        int m = this.leafs.size();
        string.addChild(this.leafs.leafAt(ileaf));
        ++ileaf;
        while (ileaf < m && (leaf = this.leafs.leafAt(ileaf)).getSeparatorChar() != '\"') {
            string.addChild(leaf);
            if (leaf.getSeparatorChar() == '\\' && ++ileaf < m) {
                string.addChild(this.leafs.leafAt(ileaf));
            }
            ++ileaf;
        }
        if (ileaf < m) {
            string.addChild(this.leafs.leafAt(ileaf));
        } else {
            string.markIncomplete();
        }
        elements.addCodeElement(string);
        return ileaf + 1;
    }

    private int parseAtom(int ileaf, CodeElementVector elements) {
        LispAtomElement atom = new LispAtomElement(this.leafs.leafAt(ileaf).getString(this.document), this.leafs.leafAt(ileaf));
        if (this.isSeparator(this.leafs.leafAt(ileaf).getSeparatorChar())) {
            atom.markIncomplete();
        }
        elements.addCodeElement(atom);
        return ileaf + 1;
    }

    public boolean completeCharacter(char c, int pos, int modifiers) {
        if (Configuration.characterCompletion) {
            if (2 == (modifiers & 2)) {
                return false;
            }
            if (c == '\"') {
                this.document.insertStringAt("\"\"", pos);
                this.document.getCodeEditor().cursor.setCursor(pos + 1);
                return true;
            }
            if (c == '(') {
                this.document.insertStringAt("()", pos);
                this.document.getCodeEditor().cursor.setCursor(pos + 1);
                return true;
            }
            return false;
        }
        if (2 != (modifiers & 2)) {
            return false;
        }
        if (c == '\"') {
            this.document.insertStringAt("\"\"", pos);
            this.document.getCodeEditor().cursor.setCursor(pos + 1);
            return true;
        }
        if (c == '(') {
            this.document.insertStringAt("()", pos);
            this.document.getCodeEditor().cursor.setCursor(pos + 1);
            return true;
        }
        return false;
    }

    public void cleanupLeaf(CodeLeafElement leaf) {
        this.definitions.remove(leaf);
    }

    public String indentateElement(CodeElement element) {
        IndentationBuffer buffer = new IndentationBuffer();
        if (element instanceof LispListElement) {
            this.indentateList((LispListElement)element, 0, buffer);
            return buffer.toString();
        }
        if (element instanceof LispCommentElement) {
            this.indentateComment((LispCommentElement)element, 0, buffer);
            return buffer.toString();
        }
        return null;
    }

    private void indentateAtomOrList(CodeElement element, int offset, IndentationBuffer buffer) {
        if (element instanceof LispListElement) {
            this.indentateList((LispListElement)element, offset, buffer);
        } else if (element instanceof LispCommentElement) {
            this.indentateComment((LispCommentElement)element, offset, buffer);
        } else if (element instanceof LispBackQuoteElement) {
            this.indentateBackQuote((LispBackQuoteElement)element, offset, buffer);
        } else if (element instanceof LispQuoteElement) {
            this.indentateQuote((LispQuoteElement)element, offset, buffer);
        } else if (element instanceof LispFunctionElement) {
            this.indentateFunction((LispFunctionElement)element, offset, buffer);
        } else {
            buffer.append(element.getString(this.document));
        }
    }

    private void indentateList(LispListElement list, int offset, IndentationBuffer buffer) {
        CodeElementVector elements = list.getElementsAndComments();
        if (elements.size() == 0) {
            buffer.append("()");
        } else {
            String first = elements.codeElementAt(0).getString(this.document).toUpperCase();
            if ("DEFUN".compareTo(first) == 0 || "DEFMACRO".compareTo(first) == 0 || "DEFGENERIC".compareTo(first) == 0 || "DEFMETHOD".compareTo(first) == 0 || "DEFCLASS".compareTo(first) == 0) {
                this.indentateDefinition(elements, offset, buffer);
            } else if ("IF".compareTo(first) == 0) {
                this.indentateIf(elements, offset, buffer);
            } else if ("COND".compareTo(first) == 0) {
                this.indentateCond(elements, offset, buffer);
            } else if ("DO".compareTo(first) == 0 || "DO*".compareTo(first) == 0) {
                this.indentateDo(elements, offset, buffer);
            } else if ("LET".compareTo(first) == 0 || "LET*".compareTo(first) == 0 || "FLET".compareTo(first) == 0 || "LABELS".compareTo(first) == 0) {
                this.indentateLet(elements, offset, buffer);
            } else if ("WHEN".compareTo(first) == 0 || "UNLESS".compareTo(first) == 0) {
                this.indentateWhen(elements, offset, buffer);
            } else if ("CASE".compareTo(first) == 0 || "CCASE".compareTo(first) == 0 || "ECASE".compareTo(first) == 0 || "ETYPECASE".compareTo(first) == 0 || "CTYPECASE".compareTo(first) == 0) {
                this.indentateCase(elements, offset, buffer);
            } else {
                this.indentateNormalList(elements, offset, buffer);
            }
        }
    }

    private void indentateDefinition(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        String first = "(" + list.codeElementAt(0).getString(this.document).toLowerCase() + " ";
        buffer.append(first);
        int offsetarglist = offset + first.length();
        int i = this.indentateComments(list, 1, offset + first.length(), buffer);
        if (i < m) {
            String text = list.codeElementAt(i).getString(this.document) + " ";
            buffer.append(text);
            offsetarglist += text.length();
        }
        if ((i = this.indentateComments(list, i + 1, offsetarglist, buffer)) < m) {
            this.indentateVarDefinition(list.codeElementAt(i), offsetarglist, buffer);
        }
        ++i;
        while (i < m) {
            i = this.indentateElementNextLine(list, i, offset + 2, buffer);
            ++i;
        }
        buffer.append(")");
    }

    private void indentateIf(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        buffer.append("(if ");
        int i = this.indentateComments(list, 1, offset + 4, buffer);
        buffer.setSavePoint();
        boolean ok = true;
        int newoffset = offset + 4;
        for (int j = i; j < m && ok; ++j) {
            this.indentateAtomOrList(list.codeElementAt(j), newoffset, buffer);
            if (j < m - 1) {
                buffer.append(" ");
            }
            if ((newoffset = buffer.getMaxLineLengthAfterSavePoint()) <= Configuration.maxLineLength && (j >= m - 1 || buffer.getNumberLinesAfterSavePoint() <= 0)) continue;
            ok = false;
        }
        if (ok) {
            buffer.commitSavePoint();
        } else {
            buffer.rollback();
            if (list.size() > 1) {
                this.indentateAtomOrList(list.codeElementAt(i), offset + 4, buffer);
            }
            if ((i = this.indentateComments(list, i + 1, offset + 4, buffer)) < m) {
                i = this.indentateElementNextLine(list, i, offset + 4, buffer);
            }
            ++i;
            while (i < m) {
                i = this.indentateElementNextLine(list, i, offset + 2, buffer);
                ++i;
            }
        }
        buffer.append(")");
    }

    private void indentateCond(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        buffer.append("(cond ");
        int i = this.indentateComments(list, 1, offset + 6, buffer);
        if (i < m) {
            if (list.codeElementAt(i) instanceof LispListElement) {
                this.indentateVarDefinition(list.codeElementAt(i), offset + 6, buffer);
            } else {
                this.indentateAtomOrList(list.codeElementAt(i), offset + 6, buffer);
            }
        }
        ++i;
        while (i < m) {
            if (list.codeElementAt(i) instanceof LispCommentElement) {
                i = this.indentateComments(list, i, offset + 6, buffer);
            }
            if (i < m) {
                buffer.addNewLine();
                buffer.addSpaces(offset + 6);
                this.indentateVarDefinition(list.codeElementAt(i), offset + 6, buffer);
            }
            ++i;
        }
        buffer.append(")");
    }

    private void indentateDo(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        String first = "(" + list.codeElementAt(0).getString(this.document).toLowerCase() + " ";
        buffer.append(first);
        int i = this.indentateComments(list, 1, offset + first.length(), buffer);
        if (i < m) {
            this.indentateVarDefinition(list.codeElementAt(i), offset + first.length(), buffer);
        }
        if ((i = this.indentateComments(list, i + 1, offset + first.length(), buffer)) < m) {
            i = this.indentateElementNextLine(list, i, offset + first.length(), buffer);
        }
        ++i;
        while (i < m) {
            i = this.indentateElementNextLine(list, i, offset + 2, buffer);
            ++i;
        }
        buffer.append(")");
    }

    private void indentateLet(CodeElementVector list, int offset, IndentationBuffer buffer) {
        String first = "(" + list.codeElementAt(0).getString(this.document).toLowerCase() + " ";
        int m = list.size();
        buffer.append(first);
        int i = this.indentateComments(list, 1, offset + first.length(), buffer);
        if (i < m) {
            this.indentateVarDefinition(list.codeElementAt(i), offset + first.length(), buffer);
        }
        ++i;
        while (i < m) {
            i = this.indentateElementNextLine(list, i, offset + 2, buffer);
            ++i;
        }
        buffer.append(")");
    }

    private void indentateWhen(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int newoffset;
        int m = list.size();
        buffer.append("(when ");
        int i = this.indentateComments(list, 1, offset + 6, buffer);
        buffer.setSavePoint();
        this.indentateAtomOrList(list.codeElementAt(i), offset + 6, buffer);
        if (i < m - 1) {
            buffer.append(" ");
        }
        if ((newoffset = buffer.getMaxLineLengthAfterSavePoint()) > Configuration.maxLineLength || m > 2 && buffer.getNumberLinesAfterSavePoint() > 0) {
            buffer.rollback();
            for (int j = i; j < m; ++j) {
                j = this.indentateElementNextLine(list, j, offset + 2, buffer);
            }
        } else {
            int j;
            buffer.commitSavePoint();
            boolean ok = true;
            buffer.setSavePoint();
            for (j = i + 1; j < m && ok; ++j) {
                this.indentateAtomOrList(list.codeElementAt(j), newoffset, buffer);
                if (j < m - 1) {
                    buffer.append(" ");
                }
                if ((newoffset = buffer.getMaxLineLengthAfterSavePoint()) <= Configuration.maxLineLength && (j >= m - 1 || buffer.getNumberLinesAfterSavePoint() <= 0)) continue;
                ok = false;
            }
            if (ok) {
                buffer.commitSavePoint();
            } else {
                buffer.rollback();
                for (j = i + 1; j < m; ++j) {
                    j = this.indentateElementNextLine(list, j, offset + 2, buffer);
                }
            }
        }
        buffer.append(")");
    }

    private void indentateCase(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        String first = "(" + list.codeElementAt(0).getString(this.document) + " ";
        buffer.append(first);
        if (m > 1) {
            this.indentateAtomOrList(list.codeElementAt(1), offset + first.length(), buffer);
        }
        for (int i = 2; i < m; ++i) {
            i = this.indentateElementNextLine(list, i, offset + 2, buffer);
        }
        buffer.append(")");
    }

    private void indentateNormalList(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        int firstoffset = 0;
        boolean ok = true;
        if (m == 0) {
            buffer.append("()");
            return;
        }
        buffer.append("(");
        this.indentateAtomOrList(list.codeElementAt(0), offset + 1, buffer);
        if (m > 1) {
            int i;
            buffer.setSavePoint();
            firstoffset = buffer.getMaxLineLengthAfterSavePoint() + 1;
            buffer.commitSavePoint();
            int newoffset = firstoffset;
            buffer.setSavePoint();
            buffer.append(" ");
            for (i = 1; i < m && ok; ++i) {
                this.indentateAtomOrList(list.codeElementAt(i), newoffset, buffer);
                if (i < m - 1) {
                    buffer.append(" ");
                }
                if ((newoffset = buffer.getMaxLineLengthAfterSavePoint()) <= Configuration.maxLineLength && (i >= m - 1 || buffer.getNumberLinesAfterSavePoint() <= 0)) continue;
                ok = false;
            }
            if (ok) {
                buffer.commitSavePoint();
            } else {
                buffer.rollback();
                buffer.setSavePoint();
                buffer.append(" ");
                this.indentateAtomOrList(list.codeElementAt(1), firstoffset, buffer);
                if (buffer.getMaxLineLengthAfterSavePoint() > Configuration.maxLineLength) {
                    buffer.rollback();
                    for (i = 1; i < m; ++i) {
                        i = this.indentateElementNextLine(list, i, offset + 1, buffer);
                    }
                } else {
                    if (list.codeElementAt(1) instanceof LispCommentElement) {
                        firstoffset = offset + 1;
                    }
                    buffer.commitSavePoint();
                    for (i = 2; i < m; ++i) {
                        i = this.indentateElementNextLine(list, i, firstoffset, buffer);
                    }
                }
            }
        }
        buffer.append(")");
    }

    private void indentateVarDefinition(CodeElement definition, int offset, IndentationBuffer buffer) {
        if (definition instanceof LispListElement) {
            this.indentateVarList(((LispListElement)definition).getElementsAndComments(), offset, buffer);
        } else {
            this.indentateAtomOrList(definition, offset, buffer);
        }
    }

    private void indentateVarList(CodeElementVector list, int offset, IndentationBuffer buffer) {
        int m = list.size();
        int firstoffset = 0;
        boolean ok = true;
        if (m == 0) {
            buffer.append("()");
            return;
        }
        buffer.append("(");
        this.indentateAtomOrList(list.codeElementAt(0), offset + 1, buffer);
        if (m > 1) {
            int i;
            buffer.append(" ");
            buffer.setSavePoint();
            firstoffset = buffer.getMaxLineLengthAfterSavePoint();
            buffer.commitSavePoint();
            int newoffset = firstoffset;
            buffer.setSavePoint();
            for (i = 1; i < m && ok; ++i) {
                this.indentateAtomOrList(list.codeElementAt(i), newoffset, buffer);
                if (i < m - 1) {
                    buffer.append(" ");
                }
                if ((newoffset = buffer.getMaxLineLengthAfterSavePoint()) <= Configuration.maxLineLength && (i >= m - 1 || buffer.getNumberLinesAfterSavePoint() <= 0)) continue;
                ok = false;
            }
            if (ok) {
                buffer.commitSavePoint();
            } else {
                buffer.rollback();
                for (i = 1; i < m; ++i) {
                    i = this.indentateElementNextLine(list, i, offset + 1, buffer);
                }
            }
        }
        buffer.append(")");
    }

    private int indentateElementNextLine(CodeElementVector list, int index, int offset, IndentationBuffer buffer) {
        CodeElement element = list.codeElementAt(index);
        if (element instanceof LispCommentElement) {
            index = this.indentateComments(list, index, offset, buffer);
        }
        if (index < list.size()) {
            buffer.addNewLine();
            buffer.addSpaces(offset);
            this.indentateAtomOrList(list.codeElementAt(index), offset, buffer);
        }
        return index;
    }

    private void indentateBackQuote(LispBackQuoteElement quote, int offset, IndentationBuffer buffer) {
        buffer.append("`");
        this.indentateAtomOrList(quote.getQuoted(), offset + 1, buffer);
    }

    private void indentateQuote(LispQuoteElement quote, int offset, IndentationBuffer buffer) {
        buffer.append("'");
        this.indentateAtomOrList(quote.getQuoted(), offset + 1, buffer);
    }

    private void indentateFunction(LispFunctionElement function, int offset, IndentationBuffer buffer) {
        buffer.append("#'");
        this.indentateAtomOrList(function.getFunction(), offset + 1, buffer);
    }

    private int indentateComment(LispCommentElement comment, int offset, IndentationBuffer buffer) {
        String commentstring = comment.getString(this.document);
        int length = buffer.getCurrentLineLength();
        if (commentstring.startsWith("#|") || commentstring.startsWith(";;;")) {
            buffer.addNewLine();
            buffer.append(commentstring);
            buffer.addNewLine();
            return 0;
        }
        if (commentstring.startsWith(";;")) {
            if (length > offset) {
                buffer.addNewLine();
                buffer.addSpaces(offset);
                buffer.append(commentstring);
                buffer.addNewLine();
                return offset;
            }
            buffer.addSpaces(offset - length);
            buffer.append(commentstring);
            buffer.addNewLine();
            return offset;
        }
        if (length == 0) {
            buffer.addSpaces(offset);
            buffer.append(commentstring);
            buffer.addNewLine();
            return offset;
        }
        buffer.append(" ");
        buffer.append(commentstring);
        buffer.addNewLine();
        return length + 1;
    }

    private int indentateComments(CodeElementVector list, int index, int offset, IndentationBuffer buffer) {
        int m = list.size();
        int newoffset = offset;
        while (index < m && list.codeElementAt(index) instanceof LispCommentElement) {
            newoffset = this.indentateComment((LispCommentElement)list.codeElementAt(index), newoffset, buffer);
            ++index;
        }
        return index;
    }
}

