/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodeStructureElement;
import IDE.CodeEditor.Parser.LispAtomElement;
import IDE.CodeEditor.Parser.LispCommentElement;
import IDE.CodeEditor.Parser.LispFunctionElement;
import IDE.Configuration.Configuration;
import IDE.LispSyntax.LispAnalyzerGen;
import java.awt.Color;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;

public class LispListElement
extends CodeStructureElement {
    CodeElementVector elements = new CodeElementVector();
    CodeElementVector keywords = new CodeElementVector();
    CodeElementVector callers = new CodeElementVector();
    CodeElementVector variables = new CodeElementVector();
    private boolean delayedCalled = false;
    boolean isCall = false;

    public void acceptChilds() {
        super.acceptChilds();
        CodeElement first = this.getFirst();
        if (this.parent instanceof LispListElement && this.delayedCalled) {
            ((LispListElement)this.parent).callers.addCodeElement(this);
        }
    }

    public void addElement(CodeElement element) {
        this.elements.addCodeElement(element);
    }

    public void addKeyWord(CodeElement element) {
        this.keywords.addCodeElement(element);
    }

    public void addCaller(CodeElement element) {
        this.callers.addCodeElement(element);
    }

    public void addVariable(CodeElement element) {
        this.variables.addCodeElement(element);
    }

    public CodeElementVector getKeywords() {
        return this.keywords.makeClone();
    }

    public void setKeywords(CodeElementVector keywords) {
        this.keywords = keywords;
    }

    public CodeElementVector getCallers() {
        return this.callers.makeClone();
    }

    public void setCallers(CodeElementVector callers) {
        this.callers = callers;
    }

    public CodeElementVector getVariables() {
        return this.variables.makeClone();
    }

    public void setVariables(CodeElementVector variables) {
        this.variables = variables;
    }

    private void activateSyntax() {
        int i;
        int m = this.variables.size();
        for (i = 0; i < m; ++i) {
            ((LispAtomElement)this.variables.codeElementAt(i)).setType(1);
        }
        m = this.keywords.size();
        for (i = 0; i < m; ++i) {
            ((LispAtomElement)this.keywords.codeElementAt(i)).setType(2);
        }
        m = this.elements.size();
        for (i = 0; i < m; ++i) {
            if (!(this.elements.codeElementAt(i) instanceof LispFunctionElement)) continue;
            ((LispFunctionElement)this.elements.codeElementAt(i)).analyze();
        }
    }

    public boolean analyze() {
        this.isCall = true;
        this.variables.clear(1);
        this.callers.clear(1);
        this.keywords.clear(1);
        if (LispAnalyzerGen.analyze(this)) {
            int m = this.callers.size();
            for (int j = 0; j < m; ++j) {
                if (!(this.callers.codeElementAt(j) instanceof LispListElement)) continue;
                ((LispListElement)this.callers.codeElementAt(j)).analyze();
            }
            this.activateSyntax();
            return true;
        }
        if (this.elements.size() > 0 && this.elements.codeElementAt(0) instanceof LispAtomElement) {
            ((LispAtomElement)this.elements.codeElementAt(0)).setType(3);
            this.delayedCalled = true;
            int m = this.elements.size();
            for (int i = 1; i < m; ++i) {
                CodeElement element = this.elements.codeElementAt(i);
                if (element instanceof LispListElement) {
                    ((LispListElement)element).analyze();
                    continue;
                }
                if (!(element instanceof LispFunctionElement)) continue;
                ((LispFunctionElement)element).analyze();
            }
        }
        return false;
    }

    public void replaceUsedDefinition(CodeDocument document, CodeDocument.UpdateBuffer updatebuffer, String olddefinition, String newdefinition) {
        olddefinition = olddefinition.toUpperCase().intern();
        boolean insidedef = false;
        CodeElementVector children = this.getElements();
        int m = children.size();
        for (int i = 0; i < m; ++i) {
            CodeElement element = children.codeElementAt(i);
            if (i == 0 && element instanceof LispAtomElement && ((LispAtomElement)element).getType() == 3 && ((LispAtomElement)element).isEqualTo(olddefinition)) {
                updatebuffer.addUpdate(element.begin(), element.end(), newdefinition);
                continue;
            }
            if (element instanceof LispListElement) {
                ((LispListElement)element).replaceUsedDefinition(document, updatebuffer, olddefinition, newdefinition);
                continue;
            }
            if (!(element instanceof LispFunctionElement)) continue;
            ((LispFunctionElement)element).replaceUsedDefinition(document, updatebuffer, olddefinition, newdefinition);
        }
    }

    public CodeElement getFirst() {
        int i;
        int m = this.elements.size();
        for (i = 0; i < m && this.elements.codeElementAt(i) instanceof LispCommentElement; ++i) {
        }
        if (i < m) {
            return this.elements.codeElementAt(i);
        }
        return null;
    }

    public int getPosition(int pos) {
        CodeElementVector elements = this.getElements();
        int m = elements.size();
        for (int i = 0; i < m; ++i) {
            CodeElement element = elements.codeElementAt(i);
            if ((element.begin() > pos || pos >= element.end()) && pos >= element.begin()) continue;
            return i;
        }
        return m;
    }

    public Vector getAllVariables() {
        int m;
        Vector result = new Vector();
        CodeElement parent = this.getParent();
        if (parent instanceof LispListElement) {
            Vector parentvariables = ((LispListElement)parent).getAllVariables();
            m = parentvariables.size();
            for (int i = 0; i < m; ++i) {
                result.addElement(parentvariables.elementAt(i));
            }
        }
        m = this.variables.size();
        for (int i = 0; i < m; ++i) {
            result.addElement(this.variables.codeElementAt(i));
        }
        return result;
    }

    public void updateUndefinedCallers(CodeDocument document, TreeSet undefined, String[] defined) {
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            String caller;
            CodeElement element = this.elements.codeElementAt(i);
            if (element instanceof LispListElement) {
                ((LispListElement)element).updateUndefinedCallers(document, undefined, defined);
                continue;
            }
            if (!(element instanceof LispAtomElement) || ((LispAtomElement)element).getType() != 3 || Arrays.binarySearch(defined, caller = element.getString(document).toLowerCase()) >= 0) continue;
            undefined.add(caller);
        }
    }

    public boolean isCall() {
        return this.isCall;
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public boolean startsWith(String symbol) {
        return this.elements.size() > 0 && this.elements.codeElementAt(0) instanceof LispAtomElement && ((LispAtomElement)this.elements.codeElementAt(0)).isEqualTo(symbol);
    }

    public CodeElementVector getElements() {
        CodeElementVector result = new CodeElementVector();
        int m = this.elements.size();
        for (int i = 0; i < m; ++i) {
            if (this.elements.codeElementAt(i) instanceof LispCommentElement) continue;
            result.addCodeElement(this.elements.codeElementAt(i));
        }
        return result;
    }

    protected CodeElementVector getElementsAndComments() {
        return this.elements;
    }

    public boolean isList() {
        return true;
    }

    public Color getColor() {
        if (this.parent == null) {
            return Configuration.colorForeground;
        }
        return this.parent.getColor();
    }
}

