/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.CodeEditor.CodeAtomElement;
import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeLeafElement;
import IDE.Configuration.Configuration;
import java.awt.Color;

public class LispAtomElement
extends CodeAtomElement {
    public static final int Atom = 0;
    public static final int Variable = 1;
    public static final int Keyword = 2;
    public static final int Caller = 3;
    public static final String DEFUN = "DEFUN".intern();
    public static final String DEFMACRO = "DEFMACRO".intern();
    public static final String DEFGENERIC = "DEFGENERIC".intern();
    public static final String DEFMETHOD = "DEFMETHOD".intern();
    public static final String DEFSTRUCT = "DEFSTRUCT".intern();
    public static final String DEFCLASS = "DEFCLASS".intern();
    public static final String DEFPARAMETER = "DEFPARAMETER".intern();
    public static final String DEFVAR = "DEFVAR".intern();
    public static final String DEFCONSTANT = "DEFCONSTANT".intern();
    public static final String DEFTYPE = "DEFTYPE".intern();
    private int type = 0;
    private CodeDocument document;
    private String symbol;

    public LispAtomElement(String symbol, CodeLeafElement leaf) {
        super(leaf);
        this.symbol = symbol.toUpperCase().intern();
    }

    public boolean isEqualTo(String symbol) {
        return symbol == this.symbol;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDefKeyword() {
        return this.symbol == DEFUN || this.symbol == DEFMACRO || this.symbol == DEFGENERIC || this.symbol == DEFMETHOD || this.symbol == DEFSTRUCT || this.symbol == DEFCLASS || this.symbol == DEFPARAMETER || this.symbol == DEFVAR || this.symbol == DEFCONSTANT || this.symbol == DEFTYPE;
    }

    public Color getColor() {
        switch (this.type) {
            case 0: {
                if (this.parent == null) {
                    return Configuration.colorForeground;
                }
                return this.parent.getColor();
            }
            case 1: {
                return Configuration.colorVariable;
            }
            case 2: {
                return Configuration.colorKeyword;
            }
            case 3: {
                return Configuration.colorCaller;
            }
        }
        if (this.parent == null) {
            return Configuration.colorForeground;
        }
        return this.parent.getColor();
    }

    public String getSymbol() {
        return this.symbol;
    }
}

