/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.Messaging.MessageHandler;
import java.util.Stack;

public class IndentationBuffer {
    private StringBuffer content = new StringBuffer();
    private int maxLineLength = 0;
    private int nrLines = 1;
    private int currentLineLength = 0;
    private Stack stack = new Stack();

    public void append(String str) {
        int m = str.length();
        for (int i = 0; i < m; ++i) {
            if (str.charAt(i) == '\n') {
                this.maxLineLength = Math.max(this.maxLineLength, this.currentLineLength);
                this.currentLineLength = 0;
                ++this.nrLines;
                continue;
            }
            ++this.currentLineLength;
        }
        this.maxLineLength = Math.max(this.maxLineLength, this.currentLineLength);
        this.content.append(str);
    }

    public void addNewLine() {
        int i;
        int m = this.content.length();
        for (i = m - 1; i >= 0 && this.content.charAt(i) == ' '; --i) {
        }
        if (i >= 0 && this.content.charAt(i) != '\n') {
            this.content.append('\n');
            this.maxLineLength = Math.max(this.maxLineLength, this.currentLineLength);
            this.currentLineLength = 0;
            ++this.nrLines;
        }
    }

    public void addSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.content.append(' ');
        }
        this.currentLineLength += n;
        this.maxLineLength = Math.max(this.maxLineLength, this.currentLineLength);
    }

    public int getNumberLinesAfterSavePoint() {
        if (this.stack.isEmpty()) {
            return this.nrLines - 1;
        }
        UndoInfo undoinfo = (UndoInfo)this.stack.peek();
        return this.nrLines - undoinfo.nrLines;
    }

    public int getMaxLineLengthAfterSavePoint() {
        if (this.stack.isEmpty()) {
            return this.maxLineLength;
        }
        UndoInfo undoinfo = (UndoInfo)this.stack.peek();
        if (undoinfo.maxLineLength < this.maxLineLength) {
            return this.maxLineLength;
        }
        int m = this.content.length();
        int current = undoinfo.currentLineLength;
        int max = 0;
        for (int i = undoinfo.start; i < m; ++i) {
            if (this.content.charAt(i) == '\n') {
                max = Math.max(max, current);
                current = 0;
                continue;
            }
            ++current;
        }
        max = Math.max(max, current);
        return max;
    }

    public int getCurrentLineLength() {
        return this.currentLineLength;
    }

    public void setSavePoint() {
        this.stack.push(new UndoInfo());
    }

    public void rollback() {
        if (this.stack.isEmpty()) {
            MessageHandler.warn("Invalid rollback in Indentation Buffer");
        } else {
            UndoInfo undoinfo = (UndoInfo)this.stack.pop();
            this.content.delete(undoinfo.start, this.content.length());
            this.maxLineLength = undoinfo.maxLineLength;
            this.nrLines = undoinfo.nrLines;
            this.currentLineLength = undoinfo.currentLineLength;
        }
    }

    public void commitSavePoint() {
        if (this.stack.isEmpty()) {
            MessageHandler.warn("Invalid commit in Indentation Buffer");
        } else {
            this.stack.pop();
        }
    }

    public String toString() {
        return this.content.toString();
    }

    private class UndoInfo {
        private int start;
        private int maxLineLength;
        private int nrLines;
        private int currentLineLength;

        private UndoInfo() {
            this.start = IndentationBuffer.this.content.length();
            this.maxLineLength = IndentationBuffer.this.maxLineLength;
            this.nrLines = IndentationBuffer.this.nrLines;
            this.currentLineLength = IndentationBuffer.this.currentLineLength;
        }
    }
}

