/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor.Parser;

import IDE.CodeEditor.CodeLeafElement;
import javax.swing.text.Position;

public class Definition
implements Comparable {
    private final String type;
    private final String name;
    private final Position begin;

    public Definition(String type, String name, CodeLeafElement leaf) {
        this.type = type;
        this.name = name.intern();
        this.begin = leaf.getBeginPosition();
    }

    public int compareTo(Object obj) {
        if (obj instanceof Definition) {
            Definition definition = (Definition)obj;
            return this.getCompareName().compareTo(definition.getCompareName());
        }
        return -1;
    }

    private String getCompareName() {
        return this.type + this.name + Integer.toString(this.begin.getOffset());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getBeginPosition() {
        return this.begin.getOffset();
    }

    public boolean isOfType(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].compareTo(this.type) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Definition) {
            return ((Definition)obj).name.compareTo(this.name) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

