/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeLine;

public class LineVector {
    protected CodeLine[] lines;
    protected int size;
    protected byte increment;

    public LineVector() {
        this(1, 1);
    }

    public LineVector(int capacity, byte increment) {
        this.lines = new CodeLine[capacity];
        this.increment = increment;
        this.size = 0;
    }

    public CodeLine lineAt(int i) {
        return this.lines[i];
    }

    public CodeLine firstLine() {
        return this.lines[0];
    }

    public CodeLine lastLine() {
        return this.lines[this.size - 1];
    }

    public void addLine(CodeLine line) {
        if (this.size < this.lines.length) {
            this.lines[this.size] = line;
            ++this.size;
        } else {
            CodeLine[] newlines = new CodeLine[this.lines.length + this.increment];
            System.arraycopy(this.lines, 0, newlines, 0, this.lines.length);
            newlines[this.size] = line;
            ++this.size;
            this.lines = newlines;
        }
    }

    public void insertAll(int i, LineVector newlines) {
        if (this.size + newlines.size < this.lines.length) {
            System.arraycopy(this.lines, i, this.lines, i + newlines.size, this.size - i);
            System.arraycopy(newlines.lines, 0, this.lines, i, newlines.size);
            this.size += newlines.size;
        } else {
            CodeLine[] templines = new CodeLine[this.lines.length + newlines.size];
            System.arraycopy(this.lines, 0, templines, 0, i);
            System.arraycopy(newlines.lines, 0, templines, i, newlines.size);
            System.arraycopy(this.lines, i, templines, i + newlines.size(), this.size - i);
            this.size += newlines.size;
            this.lines = templines;
        }
    }

    public void insertLineAt(CodeLine line, int i) {
        if (i == this.size) {
            this.addLine(line);
        } else if (i >= 0 && i < this.size) {
            if (this.size < this.lines.length) {
                System.arraycopy(this.lines, i, this.lines, i + 1, this.size - i);
                this.lines[i] = line;
                ++this.size;
            } else {
                CodeLine[] newlines = new CodeLine[this.lines.length + this.increment];
                System.arraycopy(this.lines, 0, newlines, 0, i);
                newlines[i] = line;
                System.arraycopy(this.lines, i, newlines, i + 1, this.size - i);
                this.lines = newlines;
                ++this.size;
            }
        }
    }

    public void removeRangeLines(int b, int e) {
        if (b >= 0 && b < e && e <= this.size) {
            if (e < this.size) {
                System.arraycopy(this.lines, e, this.lines, b, this.size - e);
            }
            for (int i = this.size - (e - b); i < this.size; ++i) {
                this.lines[i] = null;
            }
            this.size -= e - b;
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.lines = new CodeLine[1];
        this.size = 0;
    }
}

