/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeLeafElement;

public final class LeafVector {
    private CodeLeafElement[] leafs;
    private int size;
    private byte increment;

    public LeafVector() {
        this(1, 1);
    }

    public LeafVector(int capacity, byte increment) {
        this.leafs = new CodeLeafElement[capacity];
        this.increment = increment;
        this.size = 0;
    }

    public CodeLeafElement leafAt(int i) {
        return this.leafs[i];
    }

    public CodeLeafElement firstLeaf() {
        return this.leafs[0];
    }

    public CodeLeafElement lastLeaf() {
        return this.leafs[this.size - 1];
    }

    public void addLeaf(CodeLeafElement leaf) {
        if (this.size < this.leafs.length) {
            this.leafs[this.size] = leaf;
            ++this.size;
        } else {
            CodeLeafElement[] newleafs = new CodeLeafElement[this.leafs.length + this.increment];
            System.arraycopy(this.leafs, 0, newleafs, 0, this.leafs.length);
            newleafs[this.size] = leaf;
            ++this.size;
            this.leafs = newleafs;
        }
    }

    public void insertAll(int i, LeafVector newleafs) {
        if (this.size + newleafs.size < this.leafs.length) {
            System.arraycopy(this.leafs, i, this.leafs, i + newleafs.size, this.size - i);
            System.arraycopy(newleafs.leafs, 0, this.leafs, i, newleafs.size);
            this.size += newleafs.size;
        } else {
            CodeLeafElement[] templeafs = new CodeLeafElement[this.leafs.length + newleafs.size];
            System.arraycopy(this.leafs, 0, templeafs, 0, i);
            System.arraycopy(newleafs.leafs, 0, templeafs, i, newleafs.size);
            System.arraycopy(this.leafs, i, templeafs, i + newleafs.size(), this.size - i);
            this.size += newleafs.size;
            this.leafs = templeafs;
        }
    }

    public void insertLeafAt(CodeLeafElement leaf, int i) {
        if (i == this.size) {
            this.addLeaf(leaf);
        } else if (i >= 0 && i < this.size) {
            if (this.size < this.leafs.length) {
                System.arraycopy(this.leafs, i, this.leafs, i + 1, this.size - i);
                this.leafs[i] = leaf;
                ++this.size;
            } else {
                CodeLeafElement[] newleafs = new CodeLeafElement[this.leafs.length + this.increment];
                System.arraycopy(this.leafs, 0, newleafs, 0, i);
                newleafs[i] = leaf;
                System.arraycopy(this.leafs, i, newleafs, i + 1, this.size - i);
                this.leafs = newleafs;
                ++this.size;
            }
        }
    }

    public void removeRangeLeafs(int b, int e) {
        if (b >= 0 && b < e && e <= this.size) {
            if (e < this.size) {
                System.arraycopy(this.leafs, e, this.leafs, b, this.size - e);
            }
            for (int i = this.size - (e - b); i < this.size; ++i) {
                this.leafs[i] = null;
            }
            this.size -= e - b;
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.leafs = new CodeLeafElement[1];
        this.size = 0;
    }
}

