/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Configuration.SplashScreen;
import IDE.Explorer.Explorer;
import IDE.Explorer.FileExtensions;
import IDE.Interaction.Interactions;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkArea;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class CodePane
extends JScrollPane
implements FocusListener {
    private CodeEditor editor;

    private CodePane() {
        this.addFocusListener(this);
    }

    public CodePane(Parser parser) {
        this.editor = new CodeEditor(this, new CodeDocument(parser));
        this.setViewportView(this.editor);
        this.getViewport().setBackground(Configuration.colorBackground);
        this.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(Configuration.font).getHeight());
        this.addFocusListener(this);
    }

    private CodePane(Parser parser, File file) {
        SplashScreen.showMessage("Opening file: " + file.getName());
        CodeDocument document = new CodeDocument(parser);
        this.editor = new CodeEditor(this, document, file);
        this.setViewportView(this.editor);
        this.getViewport().setBackground(Configuration.colorBackground);
        this.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(Configuration.font).getHeight());
        this.addFocusListener(this);
    }

    public static CodePane createCodePane(Parser parser, File file) {
        CodeEditor existing = WorkArea.getEditorForFile(file);
        if (existing == null) {
            return new CodePane(parser, file);
        }
        if (existing.getCodePane() == null) {
            JOptionPane.showConfirmDialog(null, "File is already opened", "Error creating CodePane", 0);
            return new CodePane(parser);
        }
        return existing.getCodePane().cloneCodePane();
    }

    public CodePane cloneCodePane() {
        CodePane codepane = new CodePane();
        codepane.editor = this.editor.cloneCodeEditor(codepane);
        codepane.setViewportView(codepane.editor);
        codepane.getViewport().setBackground(Configuration.colorBackground);
        codepane.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(Configuration.font).getHeight());
        return codepane;
    }

    public void close() {
    }

    public void refreshBackground() {
        this.getViewport().setBackground(Configuration.colorBackground);
    }

    public CodeEditor getEditor() {
        return this.editor;
    }

    public Rectangle getVisibleRectangleEditor() {
        return this.getViewport().getViewRect();
    }

    public void save() {
        File file;
        File oldfile = file = this.editor.getDocument().getFile();
        if (file == null) {
            JFileChooser chooser = new JFileChooser(Interactions.currentDirectory);
            FileFilter filter = FileExtensions.getFileChooserFilter();
            chooser.addChoosableFileFilter(filter);
            chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(new File("<filename>." + FileExtensions.getExtension(this.editor.getDocument().getParser())));
            while (chooser.showSaveDialog(null) == 0) {
                file = chooser.getSelectedFile();
                if (WorkArea.fileOpenByAnotherEditor(file, this.editor)) {
                    if (JOptionPane.showConfirmDialog(null, "File is already opened in another buffer, retry?", "Error saving", 2) == 0) {
                        continue;
                    }
                } else if (!file.exists() || JOptionPane.showConfirmDialog(null, "File exist, overwrite the file?", "Error saving", 2) == 0) {
                    this.editor.getDocument().setFile(file);
                    this.editor.getDocument().saveFile(file);
                    Explorer.relinkNodeToDocument(this.editor.getDocument(), oldfile, file);
                    Explorer.checkDocumentInExplorer(this.editor.getDocument(), file);
                    WorkArea.refreshTitles();
                }
                break;
            }
        } else {
            this.editor.getDocument().saveFile(file);
        }
    }

    public boolean saveAs() {
        JFileChooser chooser = new JFileChooser(Interactions.currentDirectory);
        File oldfile = this.editor.getDocument().getFile();
        FileFilter filter = FileExtensions.getFileChooserFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(filter);
        File file = oldfile == null ? new File("<filename>." + FileExtensions.getExtension(this.editor.getDocument().getParser())) : oldfile;
        chooser.setSelectedFile(file);
        while (chooser.showSaveDialog(null) == 0) {
            file = chooser.getSelectedFile();
            if (WorkArea.fileOpenByAnotherEditor(file, this.editor)) {
                if (JOptionPane.showConfirmDialog(null, "File is already opened in another buffer, retry?", "Error saving", 2) == 0) continue;
                return false;
            }
            if (file.exists() && (oldfile == null || Util.getCanonicalFileName(file).compareTo(Util.getCanonicalFileName(oldfile)) != 0) && JOptionPane.showConfirmDialog(null, "File exist, overwrite the file?", "Error saving", 2) != 0) {
                return false;
            }
            this.editor.getDocument().setFile(file);
            this.editor.getDocument().saveFile(file);
            Explorer.relinkNodeToDocument(this.editor.getDocument(), oldfile, file);
            Explorer.checkDocumentInExplorer(this.editor.getDocument(), file);
            WorkArea.refreshTitles();
            return true;
        }
        return false;
    }

    public void initAndRepaintVisible() {
        this.editor.initAndRepaintVisible();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.editor.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

