/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.LineVector;
import IDE.Configuration.Configuration;
import java.awt.Dimension;

public class CodeLineVector
extends LineVector {
    private Dimension dim = new Dimension(0, 0);
    private int[] indexToY;
    private CodeEditor editor = null;
    private int linenumberheight = 0;
    private int totalheight = 0;
    private int totalwidth = 0;

    public CodeLineVector() {
        this(1, 1);
    }

    public CodeLineVector(int capacity, byte increment) {
        this.lines = new CodeLine[capacity];
        this.indexToY = new int[capacity];
        this.increment = increment;
        this.size = 0;
    }

    public void setEditor(CodeEditor editor) {
        this.editor = editor;
        this.linenumberheight = Configuration.lineNumbering ? editor.getFontMetrics(Configuration.font).getHeight() : 0;
    }

    public int getIndexLineAfterY(int y) {
        if (y <= 0) {
            return 1;
        }
        if (this.size == 0) {
            return -1;
        }
        int b = 0;
        int e = this.size - 1;
        int i = 0;
        while (b < e - 1) {
            i = b + (e - b) / 2;
            if (this.indexToY[i] > y) {
                e = i;
                continue;
            }
            b = i;
        }
        if (e > 0 && this.indexToY[e - 1] > y) {
            return e - 1;
        }
        if (this.indexToY[e] > y) {
            return e;
        }
        return -1;
    }

    public int getYPositionLine(int i) {
        return this.indexToY[i];
    }

    public int getHeight(CodeEditor editor, int i) {
        if (i + 1 < this.size) {
            return this.indexToY[i + 1] - this.indexToY[i];
        }
        this.lines[i].calculateSize(editor, this.dim);
        return this.dim.height;
    }

    public void calculateSize(Dimension dim) {
        dim.height = this.totalheight;
        dim.width = this.totalwidth;
    }

    public void insertAll(int i, LineVector newlines) {
        if (this.size + newlines.size < this.lines.length) {
            System.arraycopy(this.lines, i, this.lines, i + newlines.size, this.size - i);
            System.arraycopy(newlines.lines, 0, this.lines, i, newlines.size);
            System.arraycopy(this.indexToY, i, this.indexToY, i + newlines.size, this.size - i);
            this.size += newlines.size;
        } else {
            CodeLine[] templines = new CodeLine[this.lines.length + newlines.size];
            System.arraycopy(this.lines, 0, templines, 0, i);
            System.arraycopy(newlines.lines, 0, templines, i, newlines.size);
            System.arraycopy(this.lines, i, templines, i + newlines.size(), this.size - i);
            int[] tempIndexToY = new int[this.indexToY.length + newlines.size];
            System.arraycopy(this.indexToY, 0, tempIndexToY, 0, i);
            System.arraycopy(this.indexToY, i, tempIndexToY, i + newlines.size(), this.size - i);
            this.size += newlines.size;
            this.lines = templines;
            this.indexToY = tempIndexToY;
        }
        if (this.editor != null) {
            int j;
            int y;
            int heightnewlines = 0;
            if (i > 0) {
                this.lines[i - 1].calculateSize(this.editor, this.dim);
                y = this.indexToY[i - 1] + Math.max(this.dim.height, this.linenumberheight);
            } else {
                y = 0;
            }
            for (j = 0; j < newlines.size; ++j) {
                newlines.lines[j].calculateSize(this.editor, this.dim);
                this.indexToY[i + j] = y;
                y += Math.max(this.linenumberheight, this.dim.height);
                heightnewlines += Math.max(this.dim.height, this.linenumberheight);
                this.totalwidth = Math.max(this.totalwidth, this.dim.width);
            }
            for (j = i + newlines.size(); j < this.size; ++j) {
                this.indexToY[j] = this.indexToY[j] + heightnewlines;
            }
            this.totalheight += heightnewlines;
        }
    }

    public void recalculatePositions() {
        this.linenumberheight = Configuration.lineNumbering ? this.editor.getFontMetrics(Configuration.font).getHeight() : 0;
        this.totalheight = 0;
        this.totalwidth = 0;
        int y = 0;
        for (int i = 0; i < this.size; ++i) {
            this.indexToY[i] = y;
            this.lines[i].resetSize();
            this.lines[i].calculateSize(this.editor, this.dim);
            y += Math.max(this.linenumberheight, this.dim.height);
            this.totalwidth = Math.max(this.totalwidth, this.dim.width);
        }
        this.totalheight = y;
    }

    public void recalculatePositions(int b, int e) {
        if (b >= 0 && b <= e && e < this.size && this.editor != null) {
            int totalheight = this.calculateTotalHeight(b, e);
            int newtotalheight = 0;
            int y = this.indexToY[b];
            for (int i = b; i <= e; ++i) {
                this.lines[i].resetSize();
                this.lines[i].calculateSize(this.editor, this.dim);
                this.indexToY[i] = y + newtotalheight;
                newtotalheight += Math.max(this.linenumberheight, this.dim.height);
                this.totalwidth = Math.max(this.totalwidth, this.dim.width);
            }
            int delta = newtotalheight - totalheight;
            if (delta != 0) {
                totalheight += delta;
                for (int i = e + 1; i < this.size; ++i) {
                    this.indexToY[i] = this.indexToY[i] + delta;
                }
            }
        }
    }

    private int calculateTotalHeight(int b, int e) {
        this.lines[e].calculateSize(this.editor, this.dim);
        return this.indexToY[e] - this.indexToY[b] + Math.max(this.linenumberheight, this.dim.height);
    }

    public void removeRangeLines(int b, int e) {
        if (b >= 0 && b < e && e <= this.size && this.editor != null) {
            int i;
            int totalheight = 0;
            if (this.editor != null) {
                totalheight = this.calculateTotalHeight(b, e - 1);
            }
            if (e < this.size) {
                System.arraycopy(this.lines, e, this.lines, b, this.size - e);
                System.arraycopy(this.indexToY, e, this.indexToY, b, this.size - e);
            }
            for (i = this.size - (e - b); i < this.size; ++i) {
                this.lines[i] = null;
            }
            if (this.editor != null) {
                for (i = this.size - (e - b) - 1; i >= b; --i) {
                    this.indexToY[i] = this.indexToY[i] - totalheight;
                }
                this.totalheight -= totalheight;
            }
            this.size -= e - b;
        }
    }
}

