/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLeafNewLine;
import IDE.CodeEditor.LeafVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class CodeLine {
    private LeafVector leafs = new LeafVector();
    private int width = -1;
    private int height = -1;

    public void addLeaf(CodeLeafElement leaf) {
        this.leafs.addLeaf(leaf);
    }

    public LeafVector getLeafs() {
        return this.leafs;
    }

    public int getLeafCount() {
        return this.leafs.size();
    }

    public int begin() {
        return this.leafs.firstLeaf().begin();
    }

    public int end() {
        return this.leafs.lastLeaf().end();
    }

    protected synchronized void resetSize() {
        this.height = -1;
        this.width = -1;
    }

    public synchronized void calculateSize(CodeEditor editor, Dimension dim) {
        CodeDocument document = editor.getDocument();
        if (this.width == -1 || this.height == -1) {
            int x = 0;
            int y = 0;
            int m = this.leafs.size();
            for (int i = 0; i < m; ++i) {
                CodeLeafElement leaf = this.leafs.leafAt(i);
                FontMetrics fm = editor.getFontMetrics(leaf.getFont());
                x += fm.stringWidth(leaf.getString(document));
                y = Math.max(y, fm.getHeight());
            }
            this.width = x;
            this.height = y;
            dim.width = x;
            dim.height = y;
        } else {
            dim.width = this.width;
            dim.height = this.height;
        }
    }

    public int getPosition(CodeEditor editor, int x) {
        int i;
        CodeDocument document = editor.getDocument();
        FontMetrics fm = null;
        CodeLeafElement leaf = null;
        int m = this.leafs.size();
        int w = 0;
        int pos = 0;
        for (i = 0; i < m && w < x; w += fm.stringWidth(leaf.getString(document)), ++i) {
            leaf = this.leafs.leafAt(i);
            fm = editor.getFontMetrics(leaf.getFont());
            pos = pos + leaf.end() - leaf.begin();
        }
        if (leaf == null) {
            return 0;
        }
        if (i < m) {
            String str = leaf.getString(document);
            for (i = str.length() - 1; i >= 0 && w - fm.charWidth(str.charAt(i)) > x; --i) {
                w -= fm.charWidth(str.charAt(i));
                --pos;
            }
            if (i < 0) {
                return 0;
            }
            if ((float)w - (float)fm.charWidth(str.charAt(i)) / 2.0f > (float)x) {
                return Math.min(this.end() - this.begin() - 1, Math.max(0, pos - 1));
            }
            return pos;
        }
        return this.end() - this.begin() - 1;
    }

    public int getXPosition(CodeEditor editor, int pos) {
        FontMetrics fm;
        CodeLeafElement leaf;
        int i;
        CodeDocument document = editor.getDocument();
        int m = this.leafs.size();
        int x = 0;
        for (i = 0; i < m && (leaf = this.leafs.leafAt(i)).end() <= pos; ++i) {
            fm = editor.getFontMetrics(leaf.getFont());
            x += fm.stringWidth(leaf.getString(document));
        }
        if (i < m) {
            leaf = this.leafs.leafAt(i);
            fm = editor.getFontMetrics(leaf.getFont());
            return x + fm.stringWidth(leaf.getString(document).substring(0, Math.max(0, pos - leaf.begin())));
        }
        return x;
    }

    public void paintLine(CodeEditor editor, Graphics g, int y, int xbegin, int xmin, int xmax, int lineheight) {
        CodeDocument document = editor.getDocument();
        int x = xbegin;
        int m = this.leafs.size();
        StringBuffer strbuffer = new StringBuffer();
        int i = 0;
        while (i < m) {
            CodeLeafElement leaf = this.leafs.leafAt(i);
            Font font = leaf.getFont();
            Color color = leaf.getColor();
            int lbegin = leaf.begin();
            int lend = leaf.end();
            if (leaf instanceof CodeLeafNewLine) {
                strbuffer.append(".");
            } else {
                strbuffer.append(leaf.getString(document));
            }
            ++i;
            while (i < m && (leaf = this.leafs.leafAt(i)).getFont() == font && leaf.getColor() == color) {
                if (leaf instanceof CodeLeafNewLine) {
                    strbuffer.append(".");
                } else {
                    strbuffer.append(leaf.getString(document));
                }
                lend = leaf.end();
                ++i;
            }
            String str = strbuffer.toString();
            strbuffer.delete(0, strbuffer.length());
            FontMetrics fm = editor.getFontMetrics(font);
            int width = fm.stringWidth(str);
            if (xmin <= x + width) {
                editor.highlighter.drawBackground(g, fm, lineheight, x, y, lbegin, lend, str);
                g.setFont(font);
                g.setColor(color);
                g.drawString(str, x, y + fm.getMaxAscent());
            }
            if ((x += width) <= xmax) continue;
            break;
        }
    }
}

