/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeElement;
import IDE.Configuration.Configuration;
import java.awt.Color;
import java.awt.Font;
import javax.swing.text.Position;

public class CodeLeafElement
extends CodeElement {
    private Position begin;
    private int length;

    public CodeLeafElement(CodeDocument document, int begin) {
        this.begin = document.createPosition(begin);
    }

    public int begin() {
        return this.begin.getOffset();
    }

    public Position getBeginPosition() {
        return this.begin;
    }

    public int end() {
        return this.begin.getOffset() + this.length;
    }

    public Font getFont() {
        if (this.parent == null) {
            return Configuration.font;
        }
        return this.parent.getFont();
    }

    public Color getColor() {
        if (this.parent == null) {
            return Configuration.colorForeground;
        }
        return this.parent.getColor();
    }

    public CodeElement getTopParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getTopParent();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public char getSeparatorChar() {
        return '\u0000';
    }

    public String getString(CodeDocument document) {
        return document.getString(this.begin.getOffset(), this.length);
    }

    public boolean isFirst(CodeElement child) {
        return false;
    }

    public boolean isFirstLeaf() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isFirst(this);
    }
}

