/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.Configuration.Configuration;
import Install.OsSystem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.text.Position;

public class CodeHighLighter {
    CodeDocument document;
    CodeEditor editor;
    Vector highlights = new Vector();

    public CodeHighLighter(CodeEditor editor) {
        this.document = editor.getDocument();
        this.editor = editor;
    }

    public void addHighLight(String name, Color color) {
        HighLight hl = this.findHighLight(name);
        if (hl == null) {
            hl = new HighLight(name);
            hl.color = color;
            this.insertHighLight(hl);
        } else {
            hl.color = color;
        }
    }

    public void addHighLightRegion(String name, Color color, int begin, int length, boolean repaint) {
        HighLight hl = this.findHighLight(name);
        if (hl != null) {
            hl.color = color;
            hl.addRegion(begin, begin + length);
        } else {
            hl = new HighLight(name);
            hl.color = color;
            hl.addRegion(begin, begin + length);
            this.insertHighLight(hl);
        }
        if (repaint) {
            this.editor.repaintVisible();
        }
    }

    private void insertHighLight(HighLight hl) {
        int i;
        int m = this.highlights.size();
        for (i = 0; i < m && ((HighLight)this.highlights.elementAt(i)).name.compareTo(hl.name) < 0; ++i) {
        }
        this.highlights.insertElementAt(hl, i);
    }

    public void removeHighLightRegion(String name, int begin, int length, boolean repaint) {
        HighLight hl = this.findHighLight(name);
        if (hl != null) {
            hl.removeRegion(begin, begin + length);
            if (repaint) {
                this.editor.repaintVisible();
            }
        }
    }

    public void removeHighLight(String name) {
        this.removeHighLight(name, true);
    }

    public void removeHighLight(String name, boolean repaint) {
        HighLight hl = this.findHighLight(name);
        if (hl != null) {
            this.highlights.remove(hl);
            if (repaint) {
                this.editor.repaintVisible();
            }
        }
    }

    public void clearHighLight(String name) {
        HighLight hl = this.findHighLight(name);
        if (hl != null) {
            hl.endpoints.clear();
            this.editor.repaintVisible();
        }
    }

    public String getHighLightedCode(String name) {
        HighLight hl = this.findHighLight(name);
        if (hl == null) {
            return null;
        }
        return hl.getString();
    }

    public void deleteHighLightedCode(String name) {
        HighLight hl = this.findHighLight(name);
        if (hl != null) {
            hl.deleteHighLightedCode();
            this.highlights.remove(hl);
            this.editor.repaintVisible();
        }
    }

    public void drawBackground(Graphics g, FontMetrics fm, int height, int x, int y, int begin, int end, String str) {
        Color color = Configuration.colorBackground;
        if (!OsSystem.setXORModeHasBug()) {
            g.setColor(color);
            g.setXORMode(color);
        }
        for (int i = 0; i < this.highlights.size(); ++i) {
            ((HighLight)this.highlights.elementAt(i)).drawHighLight(g, fm, height, x, y, begin, end, str);
        }
        if (!OsSystem.setXORModeHasBug()) {
            g.setPaintMode();
        }
    }

    private HighLight findHighLight(String name) {
        int i;
        int m = this.highlights.size();
        for (i = 0; i < m && name.compareTo(((HighLight)this.highlights.elementAt(i)).name) != 0; ++i) {
        }
        if (i < m) {
            return (HighLight)this.highlights.elementAt(i);
        }
        return null;
    }

    private class HighLight {
        private String name;
        private Color color;
        private Vector endpoints = new Vector();

        private HighLight(String name) {
            this.name = name;
        }

        private void addRegion(int begin, int end) {
            block7: {
                if (begin >= end || begin < 0 || end > CodeHighLighter.this.document.length() - 1) {
                    return;
                }
                int i = 0;
                while (i + 1 < this.endpoints.size()) {
                    int b = ((Position)this.endpoints.elementAt(i)).getOffset();
                    int e = ((Position)this.endpoints.elementAt(i + 1)).getOffset();
                    if (end < b) {
                        this.endpoints.insertElementAt(CodeHighLighter.this.document.createPosition(end), i);
                        this.endpoints.insertElementAt(CodeHighLighter.this.document.createPosition(begin), i);
                    } else {
                        if (begin <= b && end < e) {
                            this.endpoints.removeElementAt(i);
                            this.endpoints.removeElementAt(i);
                            end = e;
                            continue;
                        }
                        if (b > begin || end > e) {
                            if (b <= begin && begin <= e && e < end) {
                                this.endpoints.removeElementAt(i);
                                this.endpoints.removeElementAt(i);
                                begin = b;
                                continue;
                            }
                            i += 2;
                            continue;
                        }
                    }
                    break block7;
                }
                this.endpoints.addElement(CodeHighLighter.this.document.createPosition(begin));
                this.endpoints.addElement(CodeHighLighter.this.document.createPosition(end));
            }
        }

        private void removeRegion(int begin, int end) {
            int i = 0;
            while (i + 1 < this.endpoints.size()) {
                int b = ((Position)this.endpoints.elementAt(i)).getOffset();
                int e = ((Position)this.endpoints.elementAt(i + 1)).getOffset();
                if (end <= b) break;
                if (begin <= b && e <= end) {
                    this.endpoints.remove(i);
                    this.endpoints.remove(i);
                    continue;
                }
                if (b < begin && begin <= e && e <= end) {
                    this.endpoints.setElementAt(CodeHighLighter.this.document.createPosition(begin), i + 1);
                    i += 2;
                    continue;
                }
                if (begin <= b && begin < e && end < e) {
                    this.endpoints.setElementAt(CodeHighLighter.this.document.createPosition(end), i);
                    i += 2;
                    continue;
                }
                if (b < begin && end < e) {
                    this.endpoints.insertElementAt(CodeHighLighter.this.document.createPosition(end), i + 2);
                    this.endpoints.insertElementAt(CodeHighLighter.this.document.createPosition(begin), i + 2);
                    i += 4;
                    continue;
                }
                i += 2;
            }
        }

        public void drawHighLight(Graphics g, FontMetrics fm, int height, int x, int y, int begin, int end, String str) {
            int m = this.endpoints.size();
            for (int i = 0; i < m; i += 2) {
                int e;
                int b = Math.max(begin, ((Position)this.endpoints.elementAt(i)).getOffset());
                if (b >= (e = Math.min(end, ((Position)this.endpoints.elementAt(i + 1)).getOffset()))) continue;
                g.setColor(this.color);
                g.fillRect(x + fm.stringWidth(str.substring(0, b - begin)), y, fm.stringWidth(str.substring(b - begin, e - begin)), height);
            }
        }

        public String getString() {
            StringBuffer buffer = new StringBuffer();
            int m = this.endpoints.size();
            for (int i = 0; i < m; i += 2) {
                int b = ((Position)this.endpoints.elementAt(i)).getOffset();
                int e = ((Position)this.endpoints.elementAt(i + 1)).getOffset();
                buffer.append(CodeHighLighter.this.document.getString(b, e - b));
            }
            return buffer.toString();
        }

        public void deleteHighLightedCode() {
            for (int i = this.endpoints.size() - 1; i > 0; i -= 2) {
                int e = ((Position)this.endpoints.elementAt(i)).getOffset();
                int b = ((Position)this.endpoints.elementAt(i - 1)).getOffset();
                CodeHighLighter.this.document.getCodeEditor().remove(b, e - b);
            }
            if (this.endpoints.size() > 0) {
                CodeHighLighter.this.editor.cursor.setCursor(((Position)this.endpoints.elementAt(0)).getOffset());
            }
        }
    }
}

