/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementIterator;

public final class CodeElementVector {
    private CodeElement[] elements;
    private int size;
    private byte increment;

    public CodeElementVector() {
        this(1, 1);
    }

    public CodeElementVector(int capacity, byte increment) {
        this.elements = new CodeElement[capacity];
        this.increment = increment;
        this.size = 0;
    }

    public CodeElement codeElementAt(int i) {
        return this.elements[i];
    }

    public CodeElement firstCodeElement() {
        return this.elements[0];
    }

    public CodeElement lastCodeElement() {
        return this.elements[this.size - 1];
    }

    public void addCodeElement(CodeElement element) {
        if (this.size < this.elements.length) {
            this.elements[this.size] = element;
            ++this.size;
        } else {
            CodeElement[] newelements = new CodeElement[this.elements.length + this.increment];
            System.arraycopy(this.elements, 0, newelements, 0, this.elements.length);
            newelements[this.size] = element;
            ++this.size;
            this.elements = newelements;
        }
    }

    public void insertAll(int i, CodeElementVector newelements) {
        if (this.size + newelements.size < this.elements.length) {
            System.arraycopy(this.elements, i, this.elements, i + newelements.size, this.size - i);
            System.arraycopy(newelements.elements, 0, this.elements, i, newelements.size);
            this.size += newelements.size;
        } else {
            CodeElement[] tempelements = new CodeElement[this.elements.length + newelements.size];
            System.arraycopy(this.elements, 0, tempelements, 0, i);
            System.arraycopy(newelements.elements, 0, tempelements, i, newelements.size);
            System.arraycopy(this.elements, i, tempelements, i + newelements.size(), this.size - i);
            this.size += newelements.size;
            this.elements = tempelements;
        }
    }

    public void insertLeafAt(CodeElement element, int i) {
        if (i == this.size) {
            this.addCodeElement(element);
        } else if (i >= 0 && i < this.size) {
            if (this.size < this.elements.length) {
                System.arraycopy(this.elements, i, this.elements, i + 1, this.size - i);
                this.elements[i] = element;
                ++this.size;
            } else {
                CodeElement[] newelements = new CodeElement[this.elements.length + this.increment];
                System.arraycopy(this.elements, 0, newelements, 0, i);
                newelements[i] = element;
                System.arraycopy(this.elements, i, newelements, i + 1, this.size - i);
                this.elements = newelements;
                ++this.size;
            }
        }
    }

    public void removeRangeElements(int b, int e) {
        if (b >= 0 && b < e && e <= this.size) {
            if (e < this.size) {
                System.arraycopy(this.elements, e, this.elements, b, this.size - e);
            }
            for (int i = this.size - (e - b); i < this.size; ++i) {
                this.elements[i] = null;
            }
            this.size -= e - b;
        }
    }

    public void clear(int capacity) {
        this.size = 0;
        this.elements = new CodeElement[capacity];
    }

    public void clear() {
        this.elements = new CodeElement[1];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public CodeElementVector makeClone() {
        CodeElementVector clone = new CodeElementVector(this.size, this.increment);
        System.arraycopy(this.elements, 0, clone.elements, 0, this.size);
        clone.size = this.size;
        return clone;
    }

    public int indexOf(CodeElement element, int start) {
        for (int i = start; i < this.size; ++i) {
            if (this.elements[i] != element) continue;
            return i;
        }
        return -1;
    }

    public CodeElementIterator makeIterator() {
        return new CodeElementIteratorImp();
    }

    private class CodeElementIteratorImp
    implements CodeElementIterator {
        private int index = 0;

        private CodeElementIteratorImp() {
        }

        public int getPosition() {
            return this.index;
        }

        public void setPosition(int index) {
            this.index = index;
        }

        public CodeElement next() {
            if (this.index < CodeElementVector.this.size) {
                CodeElement next = CodeElementVector.this.elements[this.index];
                ++this.index;
                return next;
            }
            return null;
        }

        public CodeElement peek() {
            if (this.index < CodeElementVector.this.size) {
                return CodeElementVector.this.elements[this.index];
            }
            return null;
        }

        public int getNextCount() {
            return CodeElementVector.this.size - this.index;
        }
    }
}

