/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeCursor;
import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeHighLighter;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.CodeLineVector;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.LineVector;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Configuration.DeadKeySequence;
import IDE.Configuration.Mode;
import IDE.Explorer.Explorer;
import IDE.Help.ValueWindow;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.IInteraction;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Recording.Recording;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkArea;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CodeEditor
extends JComponent
implements FocusListener,
MouseListener,
MouseMotionListener,
KeyListener,
PopupMenuListener {
    private static int editorcount = 0;
    private int nr;
    private CodePane codepane;
    private CodeDocument document;
    private IInteraction interaction;
    private Mode mode;
    public CodeHighLighter highlighter;
    public CodeCursor cursor;
    private int beginselection = -1;
    private int endselection = -1;
    private Vector editorclones = new Vector();
    private Dimension dim = new Dimension(0, 0);
    private int linenumberheight = Configuration.lineNumbering ? this.getFontMetrics(Configuration.font).getHeight() : 0;
    private boolean processKeyTyped = true;

    private CodeEditor() {
        this.setDoubleBuffered(true);
        this.setAutoscrolls(true);
    }

    public CodeEditor(CodePane codepane, CodeDocument document, File file) {
        this(codepane, document);
        document.loadFile(file);
        document.setFile(file);
        this.nr = editorcount;
        Explorer.linkNodeToDocument(document);
    }

    public CodeEditor(CodePane codepane, CodeDocument document) {
        this.setDoubleBuffered(true);
        this.setAutoscrolls(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.codepane = codepane;
        this.document = document;
        this.highlighter = new CodeHighLighter(this);
        this.cursor = new CodeCursor(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (document.getCodeEditor() == null) {
            document.setCodeEditor(this);
        }
        this.mode = Mode.getMode("basic");
        this.editorclones.add(this);
        this.nr = ++editorcount;
    }

    public CodeEditor cloneCodeEditor(CodePane codepane) {
        CodeEditor editor = new CodeEditor();
        editor.codepane = codepane;
        editor.document = this.document;
        editor.highlighter = new CodeHighLighter(editor);
        editor.cursor = new CodeCursor(editor);
        editor.addMouseListener(editor);
        editor.addMouseMotionListener(editor);
        editor.addKeyListener(editor);
        editor.mode = Mode.getMode("basic");
        editor.nr = this.nr;
        this.editorclones.addElement(editor);
        editor.editorclones = this.editorclones;
        return editor;
    }

    public void cleanup() {
        this.editorclones.removeElement(this);
        this.document.getParser().stopParsing();
    }

    public boolean ensureSaved() {
        return !this.document.isModified() || this.codepane.saveAs();
    }

    public void closeEditor() {
        this.editorclones.removeElement(this);
        if (this.editorclones.size() == 0) {
            Explorer.unlinkNodeFromDocument(this.document);
            this.document.getParser().stopParsing();
            JTabbedPane interactions = Main.getInteractions();
            int m = interactions.getTabCount();
            for (int i = 0; i < m; ++i) {
                ((AbstractInteractionPane)interactions.getComponentAt(i)).disableDebugging(this);
            }
        }
        this.codepane.close();
    }

    public void moveToNextLeaf() {
        Parser parser = this.document.getParser();
        int i = this.document.getIndexLeafAt(this.cursor.cursorOffset());
        LeafVector leafs = this.document.getLeafs();
        ++i;
        while (i < leafs.size() && parser.isWhiteSpace(leafs.leafAt(i).getSeparatorChar())) {
            ++i;
        }
        if (i < leafs.size()) {
            this.cursor.setCursor(leafs.leafAt(i).begin());
        }
    }

    public void moveToPrevLeaf() {
        Parser parser = this.document.getParser();
        int pos = this.cursor.cursorOffset();
        int i = this.document.getIndexLeafAt(pos);
        LeafVector leafs = this.document.getLeafs();
        --i;
        while (i >= 0 && (leafs.leafAt(i).end() >= pos || parser.isWhiteSpace(leafs.leafAt(i).getSeparatorChar()))) {
            --i;
        }
        if (i >= 0) {
            this.cursor.setCursor(leafs.leafAt(i).end());
        }
    }

    public void moveToBeginList() {
        CodeElement element;
        int pos = this.cursor.cursorOffset();
        for (element = this.document.getLeafAt(pos); element != null && !element.isList(); element = element.getParent()) {
        }
        if (element != null) {
            if (element.begin() == pos && pos > 0) {
                this.cursor.setCursor(pos - 1);
                this.moveToBeginList();
            } else {
                this.cursor.setCursor(element.begin());
            }
        } else {
            this.moveToPrevLeaf();
        }
    }

    public void moveToEndList() {
        CodeElement element;
        for (element = this.document.getLeafAt(this.cursor.cursorOffset()); element != null && !element.isList(); element = element.getParent()) {
        }
        if (element != null) {
            this.cursor.setCursor(((CodeElement)element).end());
        } else {
            this.moveToNextLeaf();
        }
    }

    public void moveToBeginLine() {
        CodeLine line = this.document.getLineAt(this.cursor.cursorOffset());
        if (line != null) {
            this.cursor.setCursor(line.begin());
        }
    }

    public void moveToEndLine() {
        CodeLine line = this.document.getLineAt(this.cursor.cursorOffset());
        if (line != null) {
            this.cursor.setCursor(line.end() - 1);
        }
    }

    public void selectCurrentLeaf() {
        CodeLeafElement leaf = this.document.getLeafAt(this.cursor.cursorOffset());
        if (leaf != null) {
            this.setSelection(leaf.begin(), leaf.end());
        }
    }

    public void selectCurrentElement() {
        CodeElement element = this.document.getElementAt(this.cursor.cursorOffset());
        if (element != null && (element = element.getParent()) != null) {
            this.setSelection(element.begin(), element.end());
        }
    }

    public void selectToplevelElement() {
        CodeElement element = this.document.getToplevelElementAt(this.cursor.cursorOffset());
        if (element != null) {
            this.setSelection(element.begin(), element.end());
        }
    }

    public void selectLine() {
        CodeLine line = this.document.getLineAt(this.cursor.cursorOffset());
        if (line != null) {
            this.setSelection(line.begin(), line.end());
        }
    }

    public void deleteCurrentLeaf() {
        CodeLeafElement leaf = this.document.getLeafAt(this.cursor.cursorOffset());
        if (leaf != null) {
            int b = leaf.begin();
            this.remove(b, leaf.end() - b);
            this.cursor.setCursor(b);
        }
    }

    public void deleteCurrentElement() {
        CodeElement element = this.document.getElementAt(this.cursor.cursorOffset());
        if (element != null && (element = element.getParent()) != null) {
            int b = element.begin();
            this.remove(b, element.end() - b);
            this.cursor.setCursor(b);
        }
    }

    public void deleteToplevelElement() {
        CodeElement element = this.document.getToplevelElementAt(this.cursor.cursorOffset());
        if (element != null) {
            int b = element.begin();
            this.remove(b, element.end() - b);
            this.cursor.setCursor(b);
        }
    }

    public void deleteLine() {
        CodeLine line = this.document.getLineAt(this.cursor.cursorOffset());
        if (line != null) {
            int b = line.begin();
            this.remove(b, line.end() - b);
            this.cursor.setCursor(b);
        }
    }

    public void widenSelection() {
        int pos = this.beginselection > -1 ? this.beginselection : this.cursor.cursorOffset();
        CodeLeafElement leaf = this.document.getLeafAt(pos);
        if (leaf != null) {
            CodeElement element;
            for (element = leaf.getParent(); element != null && element.begin() >= pos; element = element.getParent()) {
            }
            if (element != null) {
                this.setSelection(element.begin(), element.end());
            }
        }
    }

    public void shortenSelection() {
        if (this.beginselection < 0) {
            return;
        }
        int pos = this.cursor.cursorOffset();
        CodeElement prev = this.document.getLeafAt(pos);
        if (prev != null) {
            for (CodeElement next = prev.getParent(); next != null && next.begin() > this.beginselection; next = next.getParent()) {
                prev = next;
            }
            this.setSelection(((CodeElement)prev).begin(), ((CodeElement)prev).end());
        }
    }

    public Dimension getPreferredSize() {
        CodeLineVector lines = this.document.getLines();
        lines.calculateSize(this.dim);
        int x = this.dim.width;
        int y = this.dim.height;
        if (Configuration.lineNumbering) {
            x += this.calculateLineNumberingWidth(lines);
        }
        return new Dimension(x, y);
    }

    public IInteraction getInteraction() {
        return this.interaction;
    }

    public void setInteraction(IInteraction interaction) {
        Main.setCurrent(this);
        this.interaction = interaction;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        mode.activate();
    }

    public void setCursor(Long pos) {
        this.cursor.setCursor(pos.intValue());
    }

    private int calculateLineNumberingWidth(LineVector lines) {
        if (Configuration.lineNumbering) {
            int nrdigits = lines.size() > 10 ? (int)(Math.log(lines.size()) / Math.log(10.0)) + 1 : 2;
            char[] nines = new char[nrdigits + 2];
            for (int i = 0; i < nines.length; ++i) {
                nines[i] = 57;
            }
            String str = new String(nines);
            return this.getFontMetrics(this.getFont()).stringWidth(str);
        }
        return 0;
    }

    public Point getPoint(int pos) {
        int i = this.document.getIndexLineAt(pos);
        CodeLineVector lines = this.document.getLines();
        if (i < 0) {
            return new Point(0, 0);
        }
        int y = lines.getYPositionLine(i);
        int x = this.calculateLineNumberingWidth(lines) + lines.lineAt(i).getXPosition(this, pos);
        return new Point(x, y);
    }

    public void setSelection(int b, int e) {
        if (b < 0 || e <= b || e > this.document.length()) {
            return;
        }
        this.beginselection = b;
        this.endselection = e;
        this.highlighter.removeHighLight("30select", false);
        this.highlighter.addHighLightRegion("30select", Configuration.colorSelection, b, e - b, true);
    }

    public void updateSelection(int newendselection) {
        if (this.beginselection >= 0) {
            if (this.beginselection < this.endselection) {
                if (newendselection < this.beginselection) {
                    this.highlighter.removeHighLightRegion("30select", this.beginselection, this.endselection - this.beginselection, false);
                    this.highlighter.addHighLightRegion("30select", Configuration.colorSelection, newendselection, this.beginselection - newendselection, true);
                } else if (newendselection < this.endselection) {
                    this.highlighter.removeHighLightRegion("30select", newendselection, this.endselection - newendselection, true);
                } else {
                    this.highlighter.addHighLightRegion("30select", Configuration.colorSelection, this.endselection, newendselection - this.endselection, true);
                }
            } else if (newendselection < this.endselection) {
                this.highlighter.addHighLightRegion("30select", Configuration.colorSelection, newendselection, this.endselection - newendselection, true);
            } else if (newendselection < this.beginselection) {
                this.highlighter.removeHighLightRegion("30select", this.endselection, newendselection - this.endselection, true);
            } else {
                this.highlighter.removeHighLightRegion("30select", this.endselection, this.beginselection - this.endselection, false);
                this.highlighter.addHighLightRegion("30select", Configuration.colorSelection, this.beginselection, newendselection - this.beginselection, true);
            }
        }
        this.endselection = newendselection;
    }

    public void unsetSelection() {
        if (this.beginselection >= 0) {
            this.beginselection = -1;
            this.endselection = -1;
            this.highlighter.removeHighLight("30select");
        }
    }

    public void deleteSelectedText() {
        this.highlighter.deleteHighLightedCode("30select");
        this.unsetSelection();
    }

    public boolean hasSelectedText() {
        return this.beginselection >= 0;
    }

    public void copySelectedText() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        String str = this.highlighter.getHighLightedCode("30select");
        if (str != null) {
            cb.setContents(new StringSelection(str), null);
        }
        this.unsetSelection();
    }

    public void cutSelectedText() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        String str = this.highlighter.getHighLightedCode("30select");
        if (str != null) {
            cb.setContents(new StringSelection(str), null);
        }
        this.highlighter.deleteHighLightedCode("30select");
        this.unsetSelection();
    }

    public void pasteSelection() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        int pos = this.cursor.cursorOffset();
        try {
            String str = (String)cb.getContents(null).getTransferData(DataFlavor.stringFlavor);
            if (this.beginselection >= 0) {
                this.replace(this.beginselection, Math.abs(this.beginselection - this.endselection), str);
                this.unsetSelection();
            } else {
                this.insertStringAt(str, pos);
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Point getAbsolutePoint(int pos) {
        return SwingUtilities.convertPoint(this, this.getPoint(pos), Main.frame);
    }

    public int getLineNumberingWidth() {
        return this.calculateLineNumberingWidth(this.document.getLines());
    }

    public int getPosition(int x, int y) {
        CodeLineVector lines = this.document.getLines();
        int i = lines.getIndexLineAfterY(y) - 1;
        if (i >= 0) {
            CodeLine line = lines.lineAt(i);
            return line.begin() + line.getPosition(this, x - this.calculateLineNumberingWidth(lines));
        }
        if (lines.size() > 0) {
            CodeLine line = lines.lineAt(lines.size() - 1);
            return line.begin() + line.getPosition(this, x - this.calculateLineNumberingWidth(lines));
        }
        return this.document.length() - 1;
    }

    public boolean isCurrent() {
        return this == Main.currentEditor();
    }

    public boolean isInteractionEditor() {
        return this.codepane instanceof AbstractInteractionPane;
    }

    public CodeDocument getDocument() {
        return this.document;
    }

    public Mode getMode() {
        CodeEditor editor = this.getEditorForInteraction();
        if (editor != this && editor.interaction != null && this.codepane instanceof AbstractInteractionPane && ((AbstractInteractionPane)this.codepane).getInteraction() == editor.interaction) {
            return Mode.getMode("debuginteraction");
        }
        return this.mode;
    }

    public CodeEditor getEditorForInteraction() {
        if (this.codepane instanceof AbstractInteractionPane) {
            CodeEditor current = WorkArea.getCurrentEditor();
            if (current == null) {
                return this;
            }
            return current;
        }
        return this;
    }

    public CodePane getCodePane() {
        return this.codepane;
    }

    public String getShortName() {
        String modified;
        String string = modified = this.document.isModified() ? " *" : "";
        if (this.document.getFile() != null) {
            return this.document.getFile().getName() + modified;
        }
        if (this.codepane instanceof AbstractInteractionPane) {
            return ((AbstractInteractionPane)this.codepane).getName();
        }
        return "New<" + this.nr + ">" + "" + modified;
    }

    public String getLongName() {
        String modified;
        String string = modified = this.document.isModified() ? " *" : "";
        if (this.document.getFile() != null) {
            return Util.getCanonicalFileName(this.document.getFile()) + modified;
        }
        if (this.codepane instanceof AbstractInteractionPane) {
            return ((AbstractInteractionPane)this.codepane).getName();
        }
        return "New<" + this.nr + ">" + "" + modified;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        this.paintComponentLines(g, 0, this.document.getLines().size());
    }

    private void paintComponentLines(Graphics g, int beginline, int endline) {
        Rectangle bounds = g.getClipBounds();
        int xmin = bounds.x;
        int ymin = bounds.y;
        int xmax = xmin + bounds.width;
        int ymax = ymin + bounds.height;
        CodeLineVector lines = this.document.getLines();
        int y = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = this.calculateLineNumberingWidth(lines);
        int ibegin = Math.max(0, lines.getIndexLineAfterY(ymin) - 1);
        int iend = lines.getIndexLineAfterY(ymax);
        iend = iend == -1 ? endline : Math.min(lines.size, Math.min(endline, iend));
        for (int i = ibegin; i < iend; ++i) {
            int height;
            CodeLine line = lines.lineAt(i);
            y = lines.getYPositionLine(i);
            if (ymin > y + (height = lines.getHeight(this, i)) || i < beginline) continue;
            if (Configuration.lineNumbering) {
                g.setFont(Configuration.font);
                g.setColor(Configuration.colorBackgroundLine);
                g.fillRect(0, y, width, y + height);
                g.setColor(Configuration.colorForegroundLine);
                g.drawString(" " + String.valueOf(i + 1), 0, y + fm.getMaxAscent());
                line.paintLine(this, g, y, width, xmin, xmax, height);
                continue;
            }
            line.paintLine(this, g, y, 0, xmin, xmax, height);
        }
    }

    public void paintRegion(int begin, int end) {
        if (this.getGraphics() != null) {
            int dy;
            CodeLine line;
            int y;
            CodeLineVector lines = this.document.getLines();
            int dx = 0;
            int x = 0;
            int m = lines.size();
            this.codepane.refreshBackground();
            int ibeginline = this.document.getIndexLineAt(begin);
            if (ibeginline == -1) {
                y = 0;
                dx = 0;
            } else {
                y = lines.getYPositionLine(ibeginline);
                line = lines.lineAt(ibeginline);
                line.calculateSize(this, this.dim);
                dx = this.dim.width;
            }
            int iendline = this.document.getIndexLineAt(end);
            if (iendline == -1) {
                if (lines.size == 0) {
                    dy = 0;
                } else {
                    line = lines.lineAt(lines.size - 1);
                    line.calculateSize(this, this.dim);
                    dy = lines.getYPositionLine(lines.size - 1) - y + this.dim.height;
                    dx = Math.max(dx, this.dim.width);
                }
            } else {
                line = lines.lineAt(iendline);
                line.calculateSize(this, this.dim);
                dy = lines.getYPositionLine(iendline) - y + this.dim.height;
                dx = Math.max(dx, this.dim.width);
            }
            dx = dx + this.calculateLineNumberingWidth(lines) + 10;
            this.repaint(new Rectangle(x, y, dx, dy));
        }
    }

    public void insertCharacter(char c) {
        if (this.beginselection >= 0) {
            this.deleteSelectedText();
        }
        int pos = this.cursor.cursorOffset();
        this.document.insertStringAt(String.valueOf(c), pos);
        this.revalidateThisAndClones();
        this.highlighter.removeHighLight("20hook", false);
        this.repaintVisible();
        this.cursor.moveRight();
    }

    public void insertCharacter(char c, int modifiers) {
        int pos;
        if (this.beginselection >= 0) {
            this.deleteSelectedText();
        }
        if (!this.document.completeCharacter(c, pos = this.cursor.cursorOffset(), modifiers)) {
            this.document.insertStringAt(String.valueOf(c), pos);
            this.revalidateThisAndClones();
            this.highlighter.removeHighLight("20hook", false);
            this.repaintVisible();
            this.cursor.moveRight();
        } else {
            this.highlighter.removeHighLight("20hook", false);
            this.revalidateThisAndClones();
            this.repaintVisible();
        }
    }

    public void insertStringAt(String str, int pos) {
        this.insertStringAt(str, pos, true);
    }

    public void insertStringAt(String str, int pos, boolean toucheditor) {
        if (this.beginselection >= 0) {
            this.deleteSelectedText();
        }
        this.document.insertStringAt(str, pos);
        if (toucheditor) {
            this.cursor.setCursor(pos + str.length());
        } else {
            this.cursor.moveCursorTo(pos + str.length());
        }
        this.revalidateThisAndClones();
        this.highlighter.removeHighLight("20hook", false);
        this.repaintVisible();
    }

    public void removeCharacter(int position) {
        if (this.beginselection >= 0) {
            this.deleteSelectedText();
        } else {
            if (position >= 0 && position + 1 < this.document.length()) {
                this.document.remove(position, 1);
            }
            this.revalidateThisAndClones();
            this.highlighter.removeHighLight("20hook", false);
            this.repaintVisible();
        }
    }

    public void remove(int position, int length) {
        int offset = this.cursor.cursorOffset();
        this.document.remove(position, length);
        if (offset > position + length) {
            this.cursor.setCursor(offset - length);
        } else if (offset > position) {
            this.cursor.setCursor(position);
        }
        this.revalidateThisAndClones();
        this.repaintVisible();
    }

    public void replace(int position, int length, String str) {
        this.document.replace(position, length, str);
        this.cursor.setCursor(this.cursor.cursorOffset() - length + str.length());
        this.revalidateThisAndClones();
        this.repaintVisible();
    }

    protected void revalidateThisAndClones() {
        int m = this.editorclones.size();
        for (int i = 0; i < m; ++i) {
            ((CodeEditor)this.editorclones.elementAt(i)).revalidate();
        }
    }

    public void highlightList() {
        CodeElement element;
        this.highlighter.removeHighLight("10list", false);
        for (element = this.document.getElementAt(this.cursor.cursorOffset() - 1); element != null && !element.isList(); element = element.getParent()) {
        }
        if (element != null) {
            int begin = element.begin();
            int end = element.end();
            this.highlighter.addHighLightRegion("10list", Configuration.colorList, begin, end - begin, true);
        }
    }

    public void repaintVisible() {
        int m = this.editorclones.size();
        for (int i = 0; i < m; ++i) {
            CodeEditor editor = (CodeEditor)this.editorclones.elementAt(i);
            editor.repaint(editor.getCodePane().getVisibleRectangleEditor());
        }
    }

    public void initAndRepaintVisible() {
        CodeLineVector lines = this.document.getLines();
        this.linenumberheight = Configuration.lineNumbering ? this.getFontMetrics(Configuration.font).getHeight() : 0;
        lines.recalculatePositions();
        this.revalidate();
        this.codepane.revalidate();
        this.repaintVisible();
    }

    private boolean checkPopup(MouseEvent e) {
        if (e.isPopupTrigger() && !Recording.isReplaying()) {
            this.removeMouseMotionListener(this);
            this.mode.getPopupMenu().addPopupMenuListener(this);
            this.mode.getPopupMenu().show(this, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    public void mousePressed(MouseEvent e) {
        if (Main.currentEditor() != this) {
            Main.setCurrent(this);
        }
        if (!this.checkPopup(e)) {
            this.beginselection = -1;
            this.highlighter.removeHighLight("30select");
            this.cursor.setCursor(this.getPosition(e.getX(), e.getY()));
        }
        this.requestFocus();
        this.document.setCodeEditor(this);
    }

    public void mouseClicked(MouseEvent e) {
        this.beginselection = -1;
        this.highlighter.removeHighLight("30select");
        this.checkPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int pos = this.getPosition(e.getX(), e.getY());
        this.cursor.setCursor(pos);
        if (this.beginselection < 0) {
            this.endselection = this.beginselection = this.cursor.cursorOffset();
        } else {
            this.updateSelection(pos);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.interaction != null) {
            ValueWindow.displayValueLeaf(this, e.getX(), e.getY());
        }
    }

    public String toString() {
        return this.getShortName();
    }

    public void keyPressed(KeyEvent ev) {
        Recording.recordKeyEventPressed(ev);
        this.processKeyPressed(ev, false);
    }

    public void processKeyPressed(KeyEvent ev, boolean replay) {
        this.processKeyTyped = true;
        MessageHandler.clear();
        int keycode = ev.getKeyCode();
        if (this.isCursorMovement(keycode) && !ev.isControlDown() && !ev.isAltDown()) {
            if (this.beginselection < 0 && ev.isShiftDown()) {
                this.endselection = this.beginselection = this.cursor.cursorOffset();
            }
            if (keycode == 38) {
                this.cursor.moveUp();
            } else if (keycode == 40) {
                this.cursor.moveDown();
            } else if (keycode == 37) {
                this.cursor.moveLeft();
            } else if (keycode == 39) {
                this.cursor.moveRight();
            } else if (keycode == 33) {
                this.cursor.pageUp();
            } else if (keycode == 34) {
                this.cursor.pageDown();
            }
            if (ev.isShiftDown()) {
                this.updateSelection(this.cursor.cursorOffset());
            } else {
                this.unsetSelection();
            }
            this.processKeyTyped = false;
            ev.consume();
        } else if (keycode == 71 && ev.isControlDown()) {
            Main.keymap.cancel();
            this.processKeyTyped = false;
            ev.consume();
        } else if (!replay && Main.keymap.execute(keycode, ev.getModifiers())) {
            if (!ev.isControlDown()) {
                this.unsetSelection();
            }
            this.processKeyTyped = false;
            ev.consume();
        } else {
            if (ev.isAltDown() && '\u001f' < ev.getKeyChar() & ev.getKeyChar() < '\u007f') {
                this.processKeyTyped = false;
                return;
            }
            this.processKeyTyped = true;
        }
    }

    public void keyReleased(KeyEvent ev) {
        char c = DeadKeySequence.checkForDeadKeys(ev);
        if (c != '\u0000') {
            this.insertCharacter(c);
            this.processKeyTyped = false;
        }
    }

    public void processKeyTyped(KeyEvent ev, boolean replay) {
        char c = ev.getKeyChar();
        boolean enterprocessed = false;
        if (c == '\n' && this.codepane instanceof AbstractInteractionPane) {
            enterprocessed = ((AbstractInteractionPane)this.codepane).processEnter();
        }
        if (!Character.isISOControl(c) || c == '\n' && !enterprocessed) {
            this.insertCharacter(c, ev.getModifiers());
        }
        if (c == '\n' && Configuration.indentateOnEnter) {
            this.document.indentateLine();
        }
        if (!ev.isControlDown()) {
            this.unsetSelection();
        }
    }

    public void keyTyped(KeyEvent ev) {
        if (this.processKeyTyped) {
            Recording.recordKeyEventTyped(ev);
            this.processKeyTyped(ev, false);
            DeadKeySequence.Restart();
        }
    }

    private boolean isCursorMovement(int key) {
        return key == 37 || key == 39 || key == 38 || key == 40 || key == 33 || key == 34 || key == 16;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.cursor.setCursor(this.cursor.cursorOffset());
        Main.frame.setTitle(Configuration.IDEName + " " + Configuration.IDEVersion + " (" + this.getShortName() + ")");
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!(focusEvent.getOppositeComponent() instanceof CodeEditor)) {
            CodeCursor.cancelCursor();
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.addMouseMotionListener(this);
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.addMouseMotionListener(this);
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
    }
}

