/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.CodeLineVector;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkArea;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class CodeDocument {
    private File file;
    private GapContent content = new GapContent();
    private CodeLineVector lines = new CodeLineVector();
    private CodeElementVector elements = new CodeElementVector();
    private LeafVector leafs = new LeafVector(5000, 100);
    private UndoManager undomanager = new UndoManager();
    protected Parser parser;
    private CodeEditor editor;
    private boolean readonly = false;
    private boolean modified = false;

    public CodeDocument(Parser parser) {
        this.parser = parser;
        parser.initParser(this, this.lines, this.leafs, this.elements);
    }

    public CodeDocument(Parser parser, File file) {
        this(parser);
        this.file = file;
        this.loadFile(file);
    }

    public void setCodeEditor(CodeEditor editor) {
        this.editor = editor;
        this.lines.setEditor(editor);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public char[] getChars() {
        Segment segment = new Segment();
        try {
            this.content.getChars(0, this.content.length(), segment);
            return segment.array;
        }
        catch (BadLocationException e) {
            return new char[0];
        }
    }

    public int length() {
        return this.content.length();
    }

    public Position createPosition(int offset) {
        try {
            return this.content.createPosition(offset);
        }
        catch (BadLocationException e) {
            MessageHandler.report("Invalid  offset during creation of position", e);
            return null;
        }
    }

    public String getString(int begin, int length) {
        try {
            return this.content.getString(begin, length);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public UndoManager getUndoManager() {
        return this.undomanager;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            WorkArea.refreshTitles();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public Parser getParser() {
        return this.parser;
    }

    public CodeEditor getCodeEditor() {
        return this.editor;
    }

    public boolean insertStringAt(String str, int pos) {
        if (this.insertStringAtImp(str, pos)) {
            this.undomanager.addEdit(new UndoableInsert(str, pos));
            return true;
        }
        return false;
    }

    public boolean insertStringAtImp(String str, int pos) {
        if (this.readonly || str.length() == 0) {
            return false;
        }
        try {
            this.parser.prepareParseRemoveLinesAndLeafs(pos, pos + str.length());
            this.content.insertString(pos, str);
            this.setModified(true);
            this.parser.prepareParseAdjustLinesAndLeafs();
            return true;
        }
        catch (BadLocationException e) {
            MessageHandler.report("Insert string in wrong location", e);
            return false;
        }
    }

    public boolean completeCharacter(char c, int pos, int modifiers) {
        return this.parser.completeCharacter(c, pos, modifiers);
    }

    public boolean remove(int pos, int length) {
        String str = this.getString(pos, length);
        if (this.removeImp(pos, length)) {
            this.undomanager.addEdit(new UndoableRemove(str, pos));
            return true;
        }
        return false;
    }

    public boolean removeImp(int pos, int length) {
        if (this.readonly) {
            return false;
        }
        try {
            this.parser.prepareParseRemoveLinesAndLeafs(pos, pos + length);
            this.content.remove(pos, length);
            this.setModified(true);
            this.parser.prepareParseAdjustLinesAndLeafs();
            return true;
        }
        catch (BadLocationException e) {
            MessageHandler.report("Remove using wrong location and length", e);
            return false;
        }
    }

    public boolean replace(int pos, int length, String str) {
        if (length == 0) {
            return this.insertStringAt(str, pos);
        }
        if (str.length() == 0) {
            return this.remove(pos, length);
        }
        String old = this.getString(pos, length);
        if (this.replaceImp(pos, length, str, old)) {
            this.undomanager.addEdit(new UndoableReplace(pos, str, old));
            return true;
        }
        return false;
    }

    public boolean replaceImp(int pos, int length, String str, String old) {
        if (this.readonly) {
            return false;
        }
        if (this.removeImp(pos, length)) {
            if (this.insertStringAtImp(str, pos)) {
                return true;
            }
            this.insertStringAtImp(old, pos);
            return false;
        }
        return false;
    }

    private void clear() {
        this.content = new GapContent();
        this.lines.clear();
        this.leafs.clear();
        this.elements.clear();
    }

    public void loadFile(File file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            String str = CodeDocument.removeTabs(new String(chars));
            this.clear();
            this.insertStringAtImp(str, 0);
            this.setModified(false);
        }
        catch (FileNotFoundException e) {
            MessageHandler.warn("File " + Util.getCanonicalFileName(file) + " bestaat niet");
        }
        catch (IOException e) {
            MessageHandler.reportAndExit("Error reading file " + Util.getCanonicalFileName(file), e);
        }
    }

    public void saveTemporyFile(File file) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
            Segment segment = new Segment();
            this.content.getChars(0, this.content.length(), segment);
            writer.write(segment.array);
            writer.close();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            MessageHandler.report("Error writing file " + e.getMessage(), e);
        }
    }

    public void saveFile(File file) {
        this.saveTemporyFile(file);
        this.setModified(false);
    }

    public void indentateLine() {
        int pos = this.editor.cursor.cursorOffset();
        CodeLine line = this.getLineAt(pos);
        if (line != null) {
            int spacesNeeded = this.parser.spacesForIndentation(pos);
            int beginLine = line.begin();
            int endLine = line.end();
            String str = this.getString(beginLine, endLine - beginLine);
            int nrspaces = 0;
            for (nrspaces = 0; nrspaces < str.length() && str.charAt(nrspaces) == ' '; ++nrspaces) {
            }
            int delta = spacesNeeded - nrspaces;
            if (delta > 0) {
                StringBuffer spaces = new StringBuffer();
                for (int i = 0; i < delta; ++i) {
                    spaces.append(' ');
                }
                this.insertStringAt(spaces.toString(), beginLine);
                this.editor.cursor.setCursor(pos + delta);
            } else if (delta < 0) {
                this.remove(beginLine, -delta);
                this.editor.cursor.setCursor(pos + delta);
            }
        }
    }

    public static String removeTabs(String str) {
        int tabwidth = Configuration.tabwidth;
        int l = str.length();
        StringBuffer result = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (c == '\t') {
                int n = i / tabwidth;
                n = (n + 1) * tabwidth - i;
                for (int j = 0; j < n; ++j) {
                    result.append(' ');
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public CodeLineVector getLines() {
        return this.lines;
    }

    public CodeElementVector getElements() {
        return this.elements;
    }

    public LeafVector getLeafs() {
        return this.leafs;
    }

    public CodeLine getLineAt(int pos) {
        int i = this.getIndexLineAt(pos);
        if (i == -1) {
            return null;
        }
        return this.lines.lineAt(i);
    }

    public int getIndexLineAt(int pos) {
        if (this.lines.size == 0) {
            return -1;
        }
        CodeLine[] alines = this.lines.lines;
        int b = 0;
        int e = this.lines.size - 1;
        while (b < e - 1) {
            int i = b + (e - b) / 2;
            if (pos < alines[i].end()) {
                e = i;
                continue;
            }
            b = i;
        }
        if (e > 0 && pos < alines[e - 1].end()) {
            return e - 1;
        }
        if (pos < alines[e].end()) {
            return e;
        }
        return -1;
    }

    public int getIndexLeafAt(int pos) {
        if (this.leafs.size() == 0) {
            return -1;
        }
        int b = 0;
        int e = this.leafs.size() - 1;
        while (b < e - 1) {
            int i = b + (e - b) / 2;
            if (pos < this.leafs.leafAt(i).end()) {
                e = i;
                continue;
            }
            b = i;
        }
        if (e > 0 && pos < this.leafs.leafAt(e - 1).end()) {
            return e - 1;
        }
        if (pos < this.leafs.leafAt(e).end()) {
            return e;
        }
        return -1;
    }

    public CodeLeafElement getLeafAt(int pos) {
        int i = this.getIndexLeafAt(pos);
        if (i == -1) {
            return null;
        }
        return this.leafs.leafAt(i);
    }

    public CodeElement getElementAt(int pos) {
        CodeLeafElement leaf = this.getLeafAt(pos);
        if (leaf != null) {
            return leaf.getParent();
        }
        return null;
    }

    public int getIndexElementAt(int pos) {
        if (this.elements.size() == 0) {
            return -1;
        }
        int b = 0;
        int e = this.elements.size() - 1;
        while (b < e - 1) {
            int i = b + (e - b) / 2;
            if (pos < this.elements.codeElementAt(i).end()) {
                e = i;
                continue;
            }
            b = i;
        }
        if (e > 0 && pos < this.elements.codeElementAt(e - 1).end()) {
            return e - 1;
        }
        if (pos < this.elements.codeElementAt(e).end()) {
            return e;
        }
        return -1;
    }

    public CodeElement getToplevelElementAt(int pos) {
        CodeLeafElement leaf = this.getLeafAt(pos);
        if (leaf != null) {
            CodeElement element;
            for (element = leaf.getParent(); element != null && element.getParent() != null; element = element.getParent()) {
            }
            return element;
        }
        return null;
    }

    public void indentateElement(int pos) {
        String newstr;
        if (this.editor == null) {
            return;
        }
        CodeElement element = this.getToplevelElementAt(pos);
        if (element != null && (newstr = this.parser.indentateElement(element)) != null) {
            this.editor.replace(element.begin(), element.end() - element.begin(), newstr);
        }
    }

    public void indentateAllElements() {
        if (this.editor == null) {
            return;
        }
        int m = this.elements.size();
        UpdateBuffer updatebuffer = new UpdateBuffer();
        Main.frame.setCursor(new Cursor(3));
        this.editor.setCursor(new Cursor(3));
        for (int i = 0; i < m; ++i) {
            CodeElement element = this.elements.codeElementAt(i);
            String newstr = this.parser.indentateElement(element);
            if (newstr == null) continue;
            updatebuffer.addUpdate(element.begin(), element.end(), newstr);
        }
        updatebuffer.doUpdate();
        Main.frame.setCursor(new Cursor(0));
        this.editor.setCursor(new Cursor(0));
        this.editor.initAndRepaintVisible();
    }

    public UpdateBuffer createUpdateBuffer() {
        return new UpdateBuffer();
    }

    private class UndoableReplace
    extends AbstractUndoableEdit {
        private String newstr;
        private String oldstr;
        private int offset;

        private UndoableReplace(int offset, String newstr, String oldstr) {
            this.newstr = newstr;
            this.oldstr = oldstr;
            this.offset = offset;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            String removedstr = CodeDocument.this.getString(this.offset, this.newstr.length());
            if (CodeDocument.this.removeImp(this.offset, this.newstr.length())) {
                if (!CodeDocument.this.insertStringAtImp(this.oldstr, this.offset)) {
                    CodeDocument.this.insertStringAtImp(removedstr, this.offset);
                    throw new CannotUndoException();
                }
            } else {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            String removedstr = CodeDocument.this.getString(this.offset, this.oldstr.length());
            if (CodeDocument.this.removeImp(this.offset, this.oldstr.length())) {
                if (!CodeDocument.this.insertStringAtImp(this.newstr, this.offset)) {
                    CodeDocument.this.insertStringAtImp(removedstr, this.offset);
                    throw new CannotRedoException();
                }
            } else {
                throw new CannotRedoException();
            }
        }
    }

    private class UndoableRemove
    extends AbstractUndoableEdit {
        private String str;
        private int offset;

        private UndoableRemove(String str, int offset) {
            this.str = str;
            this.offset = offset;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (!CodeDocument.this.insertStringAtImp(this.str, this.offset)) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (!CodeDocument.this.removeImp(this.offset, this.str.length())) {
                throw new CannotRedoException();
            }
        }
    }

    private class UndoableInsert
    extends AbstractUndoableEdit {
        String str;
        int offset;

        private UndoableInsert(String str, int offset) {
            this.str = str;
            this.offset = offset;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (!CodeDocument.this.removeImp(this.offset, this.str.length())) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (!CodeDocument.this.insertStringAtImp(this.str, this.offset)) {
                throw new CannotRedoException();
            }
        }
    }

    private class Update
    implements Comparable {
        public int begin;
        public int end;

        private Update(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int compareTo(Object obj) {
            if (obj instanceof Update) {
                return ((Update)obj).begin - this.begin;
            }
            return -1;
        }
    }

    public class UpdateBuffer {
        private TreeMap updates = new TreeMap();

        public void addUpdate(int begin, int end, String replace) {
            Update update = new Update(begin, end);
            SortedMap tail = this.updates.tailMap(update);
            if (!tail.isEmpty()) {
                Update last = tail.firstKey();
                if (begin < last.end) {
                    MessageHandler.warn("Added overlapping update to the update buffer");
                    return;
                }
            }
            this.updates.put(update, replace);
        }

        public void doUpdate() {
            if (this.updates.isEmpty()) {
                return;
            }
            Iterator iter = this.updates.keySet().iterator();
            String oldstr = CodeDocument.this.getString(0, CodeDocument.this.content.length());
            StringBuffer newcontent = new StringBuffer(oldstr);
            while (iter.hasNext()) {
                Update update = (Update)iter.next();
                String replace = (String)this.updates.get(update);
                newcontent.replace(update.begin, update.end, replace);
            }
            String newstr = newcontent.toString();
            CodeDocument.this.undomanager.addEdit(new UndoableReplace(0, newstr, oldstr));
            CodeDocument.this.clear();
            CodeDocument.this.insertStringAtImp(newstr, 0);
        }
    }
}

