/*
 * Decompiled with CFR 0.152.
 */
package IDE.CodeEditor;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.Region;
import IDE.Configuration.Configuration;
import IDE.Help.Hint;
import IDE.Main;
import IDE.Messaging.InstructionField;
import IDE.Messaging.MessageHandler;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class CodeCursor {
    private static int oldX = -1;
    private static int oldY = -1;
    private static int oldHeight = -1;
    private static CodeEditor oldEditor = null;
    private static boolean scroll;
    private static Runnable removeCursor;
    private static Timer timer;
    private static HighlightParentheses highlightParenthesesTask;
    private static CursorBlinker cursorBlinkerTask;
    private static HighLightList highlightListTask;
    private CodeEditor editor;
    private int position = 0;
    private int magicposition = 0;

    public CodeCursor(CodeEditor editor) {
        this.editor = editor;
    }

    public void moveLeft() {
        this.setCursor(this.position - 1);
    }

    public void moveRight() {
        this.setCursor(this.position + 1);
    }

    public void moveUp() {
        CodeDocument document = this.editor.getDocument();
        int iline = document.getIndexLineAt(this.position);
        if (iline > 0) {
            CodeLine line = document.getLines().lineAt(iline - 1);
            int lbegin = line.begin();
            int pos = Math.max(lbegin, Math.min(line.end() - 1, lbegin + this.magicposition));
            this.setCursorImp(pos, true);
        }
    }

    public void moveDown() {
        CodeDocument document = this.editor.getDocument();
        int iline = document.getIndexLineAt(this.position);
        if (iline + 1 < document.getLines().size()) {
            CodeLine line = document.getLines().lineAt(iline + 1);
            int lbegin = line.begin();
            int pos = Math.max(lbegin, Math.min(line.end() - 1, lbegin + this.magicposition));
            this.setCursorImp(pos, true);
        }
    }

    public void moveToEnd() {
        this.moveCursorTo(this.editor.getDocument().length() - 1);
    }

    public void moveCursorTo(int position) {
        CodeDocument document;
        CodeLine line;
        if (position != this.position && (line = (document = this.editor.getDocument()).getLineAt(position)) != null) {
            this.magicposition = position - line.begin();
        }
        Point point = this.editor.getPoint(position);
        int lnw = this.editor.getLineNumberingWidth();
        if (point != null) {
            if (point.x <= lnw + 20) {
                this.editor.scrollRectToVisible(new Rectangle(0, Math.max(0, point.y - 50), 20, 80));
            } else {
                this.editor.scrollRectToVisible(new Rectangle(point.x, Math.max(0, point.y - 50), 20, 80));
            }
        }
        this.position = position;
    }

    public void pageDown() {
        Rectangle rectangle = this.editor.getCodePane().getVisibleRectangleEditor();
        rectangle.y += rectangle.height;
        this.editor.scrollRectToVisible(rectangle);
        Point point = this.editor.getPoint(this.position);
        point.y += rectangle.height;
        this.setCursor(this.editor.getPosition(point.x, point.y));
    }

    public void pageUp() {
        Rectangle rectangle = this.editor.getCodePane().getVisibleRectangleEditor();
        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
        this.editor.scrollRectToVisible(rectangle);
        Point point = this.editor.getPoint(this.position);
        point.y = Math.max(0, point.y - rectangle.height);
        this.setCursor(this.editor.getPosition(point.x, point.y));
    }

    public int cursorOffset() {
        return this.position;
    }

    public void setCursor(int position) {
        this.setCursor(position, true);
    }

    public void setCursor(int position, boolean makecurrent) {
        CodeDocument document;
        CodeLine line;
        if (position != this.position && (line = (document = this.editor.getDocument()).getLineAt(position)) != null) {
            this.magicposition = position - line.begin();
        }
        this.setCursorImp(position, makecurrent);
    }

    private void setCursorImp(int position, boolean makeCurrent) {
        CodeDocument document = this.editor.getDocument();
        if (document != null) {
            if (position < 0 || position >= document.length()) {
                return;
            }
            this.position = position;
            int iline = document.getIndexLineAt(position);
            if (makeCurrent) {
                Main.setCurrent(this.editor);
            }
            Main.updateCursorInfo(iline + 1, iline == -1 ? 0 : position - document.getLines().lineAt(iline).begin() + 1);
            CodeCursor.resetCursor(new CursorBlinker());
            if (makeCurrent) {
                highlightParenthesesTask = new HighlightParentheses();
                timer.schedule((TimerTask)highlightParenthesesTask, 100L);
                if (Configuration.highligthList && !this.editor.hasSelectedText()) {
                    highlightListTask = new HighLightList();
                    timer.schedule((TimerTask)highlightListTask, 150L);
                }
                Hint.activateHint();
            }
        }
    }

    private static synchronized void resetCursor(CursorBlinker newCursorBlinker) {
        if (cursorBlinkerTask != null) {
            cursorBlinkerTask.cancel();
        }
        if (highlightParenthesesTask != null) {
            CodeCursor.highlightParenthesesTask.interrupt();
            highlightParenthesesTask.cancel();
        }
        if (highlightListTask != null) {
            highlightListTask.cancel();
        }
        scroll = true;
        cursorBlinkerTask = newCursorBlinker;
        timer.schedule((TimerTask)cursorBlinkerTask, 0L, (long)Configuration.blinkingRate);
    }

    public static void cancelCursor() {
        SwingUtilities.invokeLater(removeCursor);
        if (cursorBlinkerTask != null) {
            cursorBlinkerTask.cancel();
        }
        if (highlightParenthesesTask != null) {
            highlightParenthesesTask.cancel();
        }
        if (highlightListTask != null) {
            highlightListTask.cancel();
        }
    }

    public void stopHighlightingList() {
        if (highlightListTask != null) {
            highlightListTask.cancel();
        }
        this.editor.highlighter.removeHighLight("10list");
    }

    static {
        removeCursor = new Runnable(){

            public void run() {
                if (oldEditor != null) {
                    oldEditor.repaint(0L, oldX, oldY, 2, oldHeight);
                    oldX = -1;
                    oldY = -1;
                    oldHeight = -1;
                    oldEditor = null;
                }
            }
        };
        timer = new Timer();
        highlightParenthesesTask = null;
        cursorBlinkerTask = null;
        highlightListTask = null;
    }

    private class HighlightParentheses
    extends TimerTask {
        private boolean interrupted = false;

        private HighlightParentheses() {
        }

        public void run() {
            CodeDocument document = CodeCursor.this.editor.getDocument();
            Region region = document.getParser().findHooks(CodeCursor.this.position - 1);
            if (region != null) {
                int b = region.begin;
                int e = region.end;
                int e1 = Math.min(e, b + 10);
                int b1 = Math.max(e1 - 1, e - 10);
                String str = document.getString(b, e1 - b) + " ... " + document.getString(b1, e - b1 + 1);
                if (!this.interrupted) {
                    SwingUtilities.invokeLater(new Runnable(this, b, e, str){
                        private final /* synthetic */ int val$b;
                        private final /* synthetic */ int val$e;
                        private final /* synthetic */ String val$str;
                        private final /* synthetic */ HighlightParentheses this$1;
                        {
                            this.this$1 = this$1;
                            this.val$b = val$b;
                            this.val$e = val$e;
                            this.val$str = val$str;
                        }

                        public void run() {
                            CodeCursor.access$800((CodeCursor)HighlightParentheses.access$1400((HighlightParentheses)this.this$1)).highlighter.removeHighLight("20hook");
                            CodeCursor.access$800((CodeCursor)HighlightParentheses.access$1400((HighlightParentheses)this.this$1)).highlighter.addHighLightRegion("20hook", Configuration.colorHook, this.val$b, 1, false);
                            CodeCursor.access$800((CodeCursor)HighlightParentheses.access$1400((HighlightParentheses)this.this$1)).highlighter.addHighLightRegion("20hook", Configuration.colorHook, this.val$e, 1, true);
                            if (!InstructionField.inFocus()) {
                                MessageHandler.say(this.val$str.replace('\n', ' '));
                            }
                        }
                    });
                }
            }
        }

        private void interrupt() {
            this.interrupted = true;
        }

        static /* synthetic */ CodeCursor access$1400(HighlightParentheses x0) {
            return x0.CodeCursor.this;
        }
    }

    private class HighLightList
    extends TimerTask {
        private HighLightList() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ HighLightList this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    CodeCursor.access$800(HighLightList.access$1300(this.this$1)).highlightList();
                    HighLightList.access$1300(this.this$1).new CursorDraw().run();
                }
            });
        }

        static /* synthetic */ CodeCursor access$1300(HighLightList x0) {
            return x0.CodeCursor.this;
        }
    }

    private class CursorBlinker
    extends TimerTask {
        boolean display = true;
        Runnable cursordraw = new CursorDraw();

        private CursorBlinker() {
        }

        public void run() {
            try {
                if (this.display) {
                    SwingUtilities.invokeAndWait(this.cursordraw);
                    this.display = false;
                } else {
                    SwingUtilities.invokeAndWait(removeCursor);
                    this.display = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class CursorDraw
    implements Runnable {
        private CursorDraw() {
        }

        public void run() {
            CodeDocument document = CodeCursor.this.editor.getDocument();
            CodeCursor.this.position = Math.max(0, CodeCursor.this.position);
            CodeCursor.this.position = Math.min(document.length() - 1, CodeCursor.this.position);
            Point p = CodeCursor.this.editor.getPoint(CodeCursor.this.position);
            CodeLeafElement leaf = document.getLeafAt(CodeCursor.this.position);
            FontMetrics fm = CodeCursor.this.editor.getFontMetrics(leaf == null ? CodeCursor.this.editor.getFont() : leaf.getFont());
            Graphics g = CodeCursor.this.editor.getGraphics();
            int lnw = CodeCursor.this.editor.getLineNumberingWidth();
            if (g != null) {
                int X = p.x;
                int Y = p.y;
                int height = fm.getHeight();
                if (scroll) {
                    if (X <= lnw + 20) {
                        CodeCursor.this.editor.scrollRectToVisible(new Rectangle(0, Math.max(0, Y - 50), 20, 80));
                    } else {
                        CodeCursor.this.editor.scrollRectToVisible(new Rectangle(X, Math.max(0, Y - 50), 20, 80));
                    }
                    scroll = false;
                }
                removeCursor.run();
                g.setColor(Configuration.colorCursor);
                g.fillRect(X, Y, 2, height);
                oldX = X;
                oldY = Y;
                oldHeight = height;
                oldEditor = CodeCursor.this.editor;
            }
        }
    }
}

