


CLISP(1)                  User Commands                  CLISP(1)



NNAAMMEE
     clisp - Common Lisp language interpreter and compiler



SSYYNNOOPPSSIISS
     cclliisspp  [ --hh ] [ --mm _m_e_m_s_i_z_e ] [ --WW ] [ --MM _m_e_m_f_i_l_e ] [ --LL _l_a_n_-
     _g_u_a_g_e ] [ --NN _l_o_c_a_l_e_d_i_r ] [ --qq ] [ --II ] [ --CC ] [ --ii  _i_n_i_t_f_i_l_e
     ...   ]  [  --cc [ --ll ] _l_i_s_p_f_i_l_e [ --oo _o_u_t_p_u_t_f_i_l_e ] ...  ] [ --pp
     _p_a_c_k_a_g_e_n_a_m_e ] [ --xx _e_x_p_r_e_s_s_i_o_n ] [ _l_i_s_p_f_i_l_e [ _a_r_g_u_m_e_n_t ] ]



DDEESSCCRRIIPPTTIIOONN
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with --cc, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.



OOPPTTIIOONNSS
     --hh   Displays a help message on how to use cclliisspp.


     --mm _m_e_m_s_i_z_e
          Sets the amount  of  memory  cclliisspp  tries  to  grab  on
          startup.   The amount may be given as _n_n_n_n_n_n_n (measured
          in bytes), _n_n_n_nKK or _n_n_n_nKKBB (measured in  kilobytes)  or
          _nMM  or  _nMMBB  (measured  in  megabytes).   Default  is 2
          megabytes.  The argument is constrained between 100  KB
          and  64  MB.  -- This version of cclliisspp allocates memory
          dynamically.  _m_e_m_s_i_z_e is essentially  ignored.   Never-
          theless,  the  memory size is limited to 16 MB per Lisp
          type (cons, string, structure,  etc.),  unless  the  --WW
          option is given.




     --WW   Specifies  to  call the wide-mode version of cclliisspp.  It
          uses a 64-bit  object  representation  instead  of  the
          usual  32-bit  representation. This version of cclliisspp is
          slower, but has no memory size limitations.


     --MM _m_e_m_f_i_l_e
          Specifies the initial memory image.   This  must  be  a
          memory dump produced by the _s_a_v_e_i_n_i_t_m_e_m function.



SunOS 5.4           Last change: 12 June 1997                   1






CLISP(1)                  User Commands                  CLISP(1)



     --LL _l_a_n_g_u_a_g_e
          Specifies  the  language cclliisspp uses to communicate with
          the user. This may be eenngglliisshh, ddeeuuttsscchh, ffrraannccaaiiss.


     --NN _l_o_c_a_l_e_d_i_r
          Specifies the base directory of  locale  files.   cclliisspp
          will     search     its     message     catalogs     in
          _l_o_c_a_l_e_d_i_r/_l_a_n_g_u_a_g_e/LC_MESSAGES/clisp._e_x_t.


     --qq   Quiet: cclliisspp displays no banner at startup and no good-
          bye message when quitting.


     --II   ILISP  friendly: cclliisspp interacts in a way that ILISP (a
          popular Emacs LISP interface) can deal with.  Currently
          the only effect of this is that unnecessary prompts are
          not suppressed.


     --CC   Compile when load: At startup the value of the variable
          _*_l_o_a_d_-_c_o_m_p_i_l_i_n_g_*  will  be set to tt.  Code being _l_o_a_ded
          will then be compiled  on  the  fly.  This  results  in
          slower loading, but faster execution.


     --ii _i_n_i_t_f_i_l_e _._._.
          Specifies initialization files to be _l_o_a_ded at startup.
          These should be lisp files (source or compiled).


     --cc _l_i_s_p_f_i_l_e _._._.
          Compiles the specified _l_i_s_p_f_i_l_es to bytecode. The  com-
          piled  files  can then be _l_o_a_ded instead of the sources
          to gain efficiency.


     --oo _o_u_t_p_u_t_f_i_l_e
          Specifies the output file or directory for the compila-
          tion of the last specified _l_i_s_p_f_i_l_e.


     --ll   A  bytecode listing of the files being compiled will be
          produced.  Useful only for debugging purposes.


     --pp _p_a_c_k_a_g_e_n_a_m_e
          At startup the value of the variable _*_p_a_c_k_a_g_e_* will  be
          set to the package named _p_a_c_k_a_g_e_n_a_m_e.





SunOS 5.4           Last change: 12 June 1997                   2






CLISP(1)                  User Commands                  CLISP(1)



     --xx _e_x_p_r_e_s_s_i_o_n_s
          Executes a series of arbitrary expressions instead of a
          read-eval-print loop.  The values  of  the  expressions
          will be output to standard output.  Due to the argument
          processing done by the shell, the _e_x_p_r_e_s_s_i_o_n_s  must  be
          enclosed  in double quotes, and double quotes and back-
          slashes must be preceded by backslashes.


     _l_i_s_p_f_i_l_e [_a_r_g_u_m_e_n_t _._._.]
          Loads and executes a _l_i_s_p_f_i_l_e.  There will be no  read-
          eval-print  loop.  Before _l_i_s_p_f_i_l_e is loaded, the vari-
          able _*_a_r_g_s_* will be bound to a list of strings,  repre-
          senting  the _a_r_g_u_m_e_n_ts.  If _l_i_s_p_f_i_l_e is --, the standard
          input is used instead of a file.  This option  must  be
          the last one.




RREEFFEERREENNCCEE
     The language implemented conforms to
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)
     and to the older parts of
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            ("CLtL2" for short)



UUSSEE
     hheellpp to get some on-line help.


     ((aapprrooppooss _n_a_m_e))
          lists the symbols relating to _n_a_m_e.


     ((eexxiitt)) or ((qquuiitt)) or ((bbyyee))
          to quit cclliisspp.





FFIILLEESS
     main executable


     _l_i_s_p_i_n_i_t_._m_e_m



SunOS 5.4           Last change: 12 June 1997                   3






CLISP(1)                  User Commands                  CLISP(1)



          initial memory image


     _c_o_n_f_i_g_._l_s_p
          site-dependent configuration


     _*_._l_s_p
          lisp source


     _*_._f_a_s
          lisp code, compiled by cclliisspp


     _*_._l_i_b
          lisp  source library information, generated and used by
          the cclliisspp compiler


     _*_._c  C code, compiled from lisp source by cclliisspp



EENNVVIIRROONNMMEENNTT
     CCLLIISSPP__LLAANNGGUUAAGGEE
          specifies the language cclliisspp uses to  communicate  with
          the  user.  The value may be eenngglliisshh, ddeeuuttsscchh, ffrraannccaaiiss
          and defaults to eenngglliisshh.  The --LL option can be used  to
          override this environment variable.



     LLAANNGG specifies  the  language cclliisspp uses to communicate with
          the user, unless it is already  specified  through  the
          environment  variable  CCLLIISSPP__LLAANNGGUUAAGGEE or the --LL option.
          The value may begin with a two-letter ISO 639  language
          code, for example eenn, ddee, ffrr.








SSEEEE AALLSSOO
     _c_m_u_c_l(1), _e_m_a_c_s(1).







SunOS 5.4           Last change: 12 June 1997                   4






CLISP(1)                  User Commands                  CLISP(1)



BBUUGGSS
     The function _i_n_s_p_e_c_t is not implemented.



     Not all extensions from CLtL2 are supported.


     No  on-line  documentation  beyond  _a_p_r_o_p_o_s  and _d_e_s_c_r_i_b_e is
     available.





PPRROOJJEECCTTSS
     Writing on-line documentation.


     Write _i_n_s_p_e_c_t.


     Enhance the compiler such that it  can  inline  local  func-
     tions.


     Specify a portable set of window and graphics operations.



AAUUTTHHOORRSS
     Bruno  Haible <haible@ma2s2.mathematik.uni-karlsruhe.de> and
     Michael Stoll.






















SunOS 5.4           Last change: 12 June 1997                   5



