CLISP(1)                      Platform: win32gcc                      CLISP(1)



[1mNAME[0m
       clisp - ANSI Common Lisp compiler, interpreter and debugger.

[1mSYNOPSIS[0m
       [1mclisp [22m[[[1m-h[22m] [[1m--help[22m]] [[1m--version[22m] [[1m--license[22m] [[1m-B [4m[22mlisp-lib-dir[24m]
             [[1m-M [4m[22mmem-file[24m] [[1m-m [4m[22mmem-size[24m] [[1m-L [4m[22mlanguage[24m] [[1m-N [4m[22mlocale-dir[24m]
             [[1m-E[4m[22mdomain[24m [4mencoding[24m] [[[1m-q[22m] [[1m--quiet[22m] [[1m--silent[22m] [[1m-v[22m] [[1m--verbose[22m]]
             [[1m-on-error [4m[22maction[24m] [[1m-repl[22m] [[1m-w[22m] [[1m-I[22m] [[[1m-ansi[22m] [[1m-traditional[22m]]
             [[1m-modern[22m] [[1m-p [4m[22mpackage[24m] [[1m-C[22m] [[1m-norc[22m] [[1m-i [4m[22minit-file[24m...]
             [[1m-c [22m[[1m-l[22m] [4mlisp-file[24m [[1m-o [4m[22moutput-file[24m]...] [[1m-x [4m[22mexpressions[24m...]
             [[4mlisp-file[24m [[4margument[24m...]]

[1mDESCRIPTION[0m
       Invokes the [1][1mCommon Lisp [22minterpreter and compiler. When called
       without arguments, executes the [2][4mread-eval-print[24m [4mloop[24m, in which
       expressions are in turn [3][1mREAD [22mfrom the standard input, [4][1mEVAL[22muated
       by the lisp interpreter, and their results are [5][1mPRINT[22med to the
       standard output. Invoked with [1m-c[22m, compiles the specified lisp files to
       a platform-independent bytecode which can be executed more efficiently.

[1mOPTIONS[0m
       [1m-h[22m,
       [1m--help[0m
              Displays a help message on how to invoke [6][1mCLISP[22m.

       [1m--version[0m
              Displays the [6][1mCLISP [22mversion number, as given by the function
              [7][1mLISP-IMPLEMENTATION-VERSION[22m, the value of the variable
              [4m*FEATURES*[24m, as well some other information.

       [1m--license[0m
              Displays a summary of the licensing information, the
              [8][4mGNU[24m[9][4mGPL[24m.

       [1m-B [4m[22mlisp-lib-dir[0m
              Specifies the installation directory. This is the directory
              containing the linking sets and other data files.  Directory
              [4mlisp-lib-dir[24m can be changed dynamically using the
              [10][4mSYMBOL-MACRO*LIB-DIRECTORY*[24m.

       [1m-M [4m[22mmem-file[0m
              Specifies the initial memory image. This must be a memory dump
              produced by the [1mEXT:SAVEINITMEM [22mfunction by this [1mclisp[22mruntime.

       [1m-m [4m[22mmem-size[0m
              Sets the amount of memory [6][1mCLISP [22mtries to grab on startup. The
              amount may be given as

              [4mnnnnnnn[0m
                     measured in bytes

              [4mnnnn[24m[1mK[22m,
              [4mnnnn[24m[1mKB[0m
                     measured in kilobytes

              [4mn[24m[1mM[22m,
              [4mn[24m[1mMB[0m
                     measured in megabytes

              The default is 2 megabytes.  The argument is constrained above
              100 KB.

              This version of [6][1mCLISP [22mis not likely to actually use the
              entire [4mmem-size[24m since garbage collection will periodically
              reduce the amount of used memory. It is therefore common to
              specify 10 MB even if only 2 MB are going to be used.

       [1m-L [4m[22mlanguage[0m
              Specifies the language[6][1mCLISP [22muses to communicate with the
              user. This may be only [1menglish[22m.  The language may be changed
              dynamically using the [10][4mSYMBOL-MACROCUSTOM:*CURRENT-LANGUAGE*[24m.

       [1m-N [4m[22mlocale-dir[0m
              Specifies the base directory of locale files.  [6][1mCLISP [22mwill
              search its message catalogs in
              [4mlocale-dir/language/LC_MESSAGES/clisp.mo[24m. This directory may be
              changed dynamically using the
              [10][4mSYMBOL-MACROCUSTOM:*CURRENT-LANGUAGE*[24m.

       [1m-E[4m[22mdomain[24m [4mencoding[0m
              Specifies the encoding used for the given domain, overriding the
              default which depends on the [12][4menvironment[24m [4mvariable[24ms [1mLC_ALL[22m,
              [1mLC_CTYPE[22m, [1mLANG[22m.  [4mdomain[24m can be

              [1mfile   [22maffecting [4mCUSTOM:*DEFAULT-FILE-ENCODING*[0m

              [1mpathname[0m
                     affecting [4mCUSTOM:*PATHNAME-ENCODING*[0m

              [1mterminal[0m
                     affecting [4mCUSTOM:*TERMINAL-ENCODING*[0m

              [1mforeign[0m
                     affecting [4mCUSTOM:*FOREIGN-ENCODING*[0m

              [1mmisc   [22maffecting [4mCUSTOM:*MISC-ENCODING*[0m

              [4mblank[24m  affecting all of the above.



              [1mWarning[0m
              Note that the values of these [10][4mSYMBOL-MACRO[24ms that have been
              saved in a memory image are ignored: these [10][4mSYMBOL-MACRO[24ms are
              reset based on the OS environment [4mafter[24m the memory image is
              loaded. You have to use the RC file, [4mCUSTOM:*INIT-HOOKS*[24m or init
              function to set them on startup, but it is best to set the
              aforementioned [12][4menvironment[24m [4mvariable[24ms appropriately for
              consistency with other programs. See Section 30.1, "Customizing
              CLISP Process Initialization and Termination".

       [1m-q[22m,
       [1m--quiet[22m,
       [1m--silent[22m,
       [1m-v[22m,
       [1m--verbose[0m
              Change verbosity level: by default, [6][1mCLISP [22mdisplays a banner
              at startup and a good-bye message when quitting, and initializes
              [13][4m*LOAD-VERBOSE*[24m and [14][4m*COMPILE-VERBOSE*[24m to [15][1mT[22m, and
              [13][4m*LOAD-PRINT*[24m and [14][4m*COMPILE-PRINT*[24m to [16][1mNIL[22m, as per
              [ANSI CL standard]. The first [1m-q [22mremoves the banner and the
              good-bye message, the second sets variables [13][4m*LOAD-VERBOSE*[0m
              and [14][4m*COMPILE-VERBOSE*[24m to [16][1mNIL[22m. The first [1m-v [22msets
              variables [4mCUSTOM:*REPORT-ERROR-PRINT-BACKTRACE*[24m,
              [13][4m*LOAD-PRINT*[24m and [14][4m*COMPILE-PRINT*[24m to [15][1mT[22m, the second
              sets [4mCUSTOM:*LOAD-ECHO*[24m to [15][1mT[22m. These settings affect the
              output produced by [1m-i [22mand [1m-c [22moptions. Note that these settings
              persist into the [2][4mread-eval-print[24m [4mloop[24m. Repeated [1m-q [22mand [1m-v[0m
              cancel each other, e.g., [1m-q -q -v -v -v [22mis equivalent to [1m-v[22m.

       [1m-on-error [4m[22maction[0m
              Override (or force) the batch mode imposed by [1m-c[22m, [1m-x[22m, and
              [4mlisp-file[24m, depending on [4maction[24m:.RS

       appease
              [17][4mcontinuable[24m[18][4mERROR[24ms are turned into [19][4mWARNING[24ms (with
              [1mEXT:APPEASE-CERRORS[22m) other [18][4mERROR[24ms are handled in the default
              way

       debug  [18][4mERROR[24ms [20][1mINVOKE-DEBUGGER [22m(the normal [2][4mread-eval-print[0m
              [4mloop[24m behavior)

       abort  [17][4mcontinuable[24m[18][4mERROR[24ms are appeased, other [18][4mERROR[24ms are
              [21][1mABORT[22med with [1mEXT:ABORT-ON-ERROR[0m

       exit   [17][4mcontinuable[24m[18][4mERROR[24ms are appeased, other [18][4mERROR[24ms
              terminate [6][1mCLISP [22mwith [1mEXT:EXIT-ON-ERROR[0m

              See also [1mEXT:SET-GLOBAL-HANDLER[22m.

       [1m-repl  [22mStart an interactive [2][4mread-eval-print[24m [4mloop[24m after processing
              the [1m-c[22m, [1m-x[22m, and [4mlisp-file[24m options and on any
              [18][4mERROR[24m[22][1mSIGNAL[22med during that processing.

       [1m-w     [22mWait for a keypress after program termination.

       [1m-I     [22mInteract better with [23][4mEmacs[24m (useful when running [6][1mCLISP[0m
              under [23][4mEmacs[24m using [24][4mSLIME[24m, [25][4mILISP[24m et al). With this
              option, [6][1mCLISP [22minteracts in a way that [23][4mEmacs[24m can deal
              with:

              +o  unnecessary prompts are not suppressed.



       [1m-ansi  [22mComply with the [ANSI CL standard] specification
              even where [6][1mCLISP [22mhas been traditionally
              different. It sets the
              [10][4mSYMBOL-MACROCUSTOM:*ANSI*[24m to [15][1mT[22m.

       [1m-traditional[0m
              Traditional: reverses the residual effects of
              [1m-ansi [22min the saved memory image.

       [1m-modern[0m
              Provides a modern view of symbols: at startup the
              [27][4m*PACKAGE*[24m variable will be set to the
              "CS-COMMON-LISP-USER" package, and the
              [28][4m*PRINT-BASE*[24m will be set to [1m:DOWNCASE[22m. This
              has the effect that symbol lookup is
              case-sensitive (except for keywords and old-style
              packages) and that keywords and uninterned symbols
              are printed with lower-case preferrence.

       [1m-p [4m[22mpackage[0m
              At startup the value of the variable [27][4m*PACKAGE*[0m
              will be set to the package named [4mpackage[24m. The
              default is the value of [27][4m*PACKAGE*[24m when the
              image was saved, normally [29][4m"COMMON-LISP-USER"[24m.

       [1m-C     [22mCompile when loading: at startup the value of the
              variable [4mCUSTOM:*LOAD-COMPILING*[24m will be set to
              [15][1mT[22m. Code being [30][1mLOAD[22med will then be
              [31][1mCOMPILE[22md on the fly. This results in slower
              loading, but faster execution.

       [1m-norc  [22mNormally [6][1mCLISP [22mloads the user [32][4m"run[24m [4mcontrol"[0m
              [4m(RC)[24m file on startup (this happens [4mafter[24m the [1m-C[0m
              option is processed). The file loaded is
              [4m.clisprc.lisp[24m or [4m.clisprc.fas[24m in the home
              directory [33][1mUSER-HOMEDIR-PATHNAME[22m, whichever is
              newer. This option, [1m-norc[22m, prevents loading of the
              RC file.

       [1m-i [4m[22minit-file[0m
              Specifies initialization files to be [30][1mLOAD[22med at
              startup. These should be lisp files (source or
              compiled). Several [1m-i [22moptions can be given; all
              the specified files will be loaded in order.

       [1m-c [4m[22mlisp-file[0m
              Compiles the specified [4mlisp-file[24ms to bytecode
              ([4m*.fas[24m). The compiled files can then be [30][1mLOAD[22med
              instead of the sources to gain efficiency.

       [1m-o [4m[22moutputfile[0m
              Specifies the output file or directory for the
              compilation of the last specified [4mlisp-file[24m.

       [1m-l     [22mProduce a bytecode [34][1mDISASSEMBLE [22mlisting ([4m*.lis[24m)
              of the files being compiled. Useful only for
              debugging. See Section 24.1.1, "Function
              COMPILE-FILE" for details.

       [1m-x [4m[22mexpressions[0m
              Executes a series of arbitrary expressions instead
              of a [2][4mread-eval-print[24m [4mloop[24m. The values of the
              expressions will be output to
              [35][4m*STANDARD-OUTPUT*[24m. Due to the argument
              processing done by the shell, the [4mexpressions[24m must
              be enclosed in double quotes, and double quotes
              and backslashes must be escaped with backslashes.

       [4mlisp-file[24m [ [4margument[24m ... ]
              Loads and executes a [4mlisp-file[24m, as described in
              Script execution. There will be no
              [2][4mread-eval-print[24m [4mloop[24m. Before [4mlisp-file[24m is
              loaded, the variable [4mEXT:*ARGS*[24m will be bound to a
              list of strings, representing the [4margument[24ms.  If
              [4mlisp-file[24m is [1m-[22m, the [35][4m*STANDARD-INPUT*[24m is used
              instead of a file. If [4mlisp-file[24m is the empty
              string [1m"" [22mor [1m"--"[22m, the normal [2][4mread-eval-print[0m
              [4mloop[24m is entered, and the rest of the arguments is
              still available in [4mEXT:*ARGS*[24m, for parsing by the
              init function of the current memory image. This
              option must be the last one. No RC file will be
              executed.

[1mLANGUAGE REFERENCE[0m
       The language implemented is [ANSI CL standard]. The
       implementation mostly conforms to the ANSI Common Lisp
       standard.

[1mUSAGE[0m
       help   get context-sensitive on-line help, see
              Chapter 25, Environment [CLHS-25].

       ([36][1mAPROPOS [4m[22mname[24m)
              list the symbols matching to [4mname[24m.

       (exit),
       (quit),
       (bye)
              quit[6][1mCLISP[22m.

       EOF    (Control-Z on [38][1mWin32[22m) leave the current level
              of the [2][4mread-eval-print[24m [4mloop[24m (see also
              Section 1.1, "Special Symbols [CLHS-1.4.1.3]").

[1mFILES[0m
       [1mclisp.exe[0m
              startup driver (executable)

       [4mlisp.run[24m,
       [4mlisp.exe[0m
              main executable (runtime)

       [4mlispinit.mem[0m
              initial memory image

       [4mconfig.lisp[0m
              site-dependent configuration (should have been
              customized before [6][1mCLISP [22mwas built); see
              Section 30.12, "Customizing CLISP behavior"

       [4m*.lisp[24m lisp source

       [4m*.fas[24m  lisp code, compiled by [6][1mCLISP[0m

       [4m*.lib[24m  lisp source library information, generated by
              [1mCOMPILE-FILE[22m, see Section 24.1.3, "Function
              REQUIRE".

       [4m*.c[24m    C code, compiled from lisp source by [6][1mCLISP [22m(see
              Section 31.3, "The Foreign Function Call
              Facility")

       For the [6][1mCLISP [22msource files, see Chapter 33, The source
       files of CLISP.

[1mENVIRONMENT[0m
       All [12][4menvironment[24m [4mvariable[24ms that [6][1mCLISP [22muses are read
       at most once.

       [1mCLISP_LANGUAGE[0m
              specifies the language [6][1mCLISP [22muses to
              communicate with the user. The legal values are
              identical to those of the [1m-L [22moption which can be
              used to override this [12][4menvironment[24m [4mvariable[24m.

       [1mLC_CTYPE[0m
              specifies the locale which determines the
              character set in use. The value can be of the form
              [4mlanguage[24m or [4mlanguage[24m[1m_[4m[22mcountry[24m or
              [4mlanguage[24m[1m_[4m[22mcountry[24m[1m.[4m[22mcharset[24m, where [4mlanguage[24m is a
              two-letter ISO 639 language code (lower case),
              [4mcountry[24m is a two-letter ISO 3166 country code
              (upper case).  [4mcharset[24m is an optional character
              set specification, and needs normally not be given
              because the character set can be inferred from the
              language and country. This [12][4menvironment[0m
              [4mvariable[24m can be overridden with the [1m-Edomain[0m
              [1mencoding [22moption.

       [1mLANG   [22mspecifies the language [6][1mCLISP [22muses to
              communicate with the user, unless it is already
              specified through the [12][4menvironment[0m
              [4mvariable[24m[1mCLISP_LANGUAGE [22mor the [1m-L [22moption.  It also
              specifies the locale determining the character set
              in use, unless already specified through the
              [12][4menvironment[24m [4mvariable[24m[1mLC_CTYPE[22m.  The value may
              begin with a two-letter ISO 639 language code, for
              example [1men[22m, [1mde[22m, [1mfr[22m.

       [1mSHELL[22m,
       [1mCOMSPEC[0m
              is used to find the interactive command
              interpreter called by [1mEXT:SHELL[22m.

       [1mORGANIZATION[0m
              for [43][1mSHORT-SITE-NAME [22mand [43][1mLONG-SITE-NAME [22min
              [4mconfig.lisp[24m.

       [1mCLHSROOT[0m
              for [1mCUSTOM:CLHS-ROOT [22min [4mconfig.lisp[24m.

       [1mIMPNOTES[0m
              for [1mCUSTOM:IMPNOTES-ROOT [22min [4mconfig.lisp[24m.

       [1mEDITOR [22mfor [1meditor-name [22min [4mconfig.lisp[24m.

       [1mLOGICAL_HOST_[4m[22mhost[24m[1m_FROM[22m,
       [1mLOGICAL_HOST_[4m[22mhost[24m[1m_TO[22m,
       [1mLOGICAL_HOST_[4m[22mhost[0m
              for
              [4mCUSTOM:*LOAD-LOGICAL-PATHNAME-TRANSLATIONS-DATABASE*[0m

[1mSEE ALSO[0m
       CLISP impnotes, [44][1mCMU CL [22m- [1mcmucl[22m(1), [23][4mEmacs[24m -
       [1memacs[22m(1), [45][4mXEmacs[24m - [1mxemacs[22m(1).

[1mBUGS[0m
       When you encounter a bug in [6][1mCLISP[22m, please report it to
       the [6][1mCLISP[22m[46][4mSourceForge[24m [4mbug[24m [4mtracker[24m.

       [4mBefore[24m submitting a bug report, please take the following
       basic steps to make the report more useful:

       1. Please do a clean build (remove your build directory
          and build [6][1mCLISP [22mwith [1m./configure --build build [22mor
          at least do a [1mmake distclean [22mbefore [1mmake[22m).

       2. If you are reporting a "hard crash" (segmentation
          fault, bus error, core dump etc), please do
          [1m./configure --with-debug --build build-g ; cd build-g;[0m
          [1mgdb lisp.run[22m, then load the appropriate linking set by
          either [1mbase [22mor [1mfull[22m[47][1mgdb [22mcommand, and report the
          backtrace (see also Q: A.1.1.9).

       3. If you are using pre-built binaries and experience a
          hard crash, the problem is likely to be in the
          incompatibilities between the platform on which the
          binary was built and yours; please try compiling the
          sources and report the problem if it persists.


       When submitting a bug report, please specify the
       following information:

       1. What is your platform ([1muname -a [22mon a [37][1mUNIX [22msystem)?
          Compiler version?  [8][4mGNU[24m[48][4mlibc[24m version (on
          [8][4mGNU[24m/[49][1mLinux[22m)?

       2. Where did you get the sources or binaries? When?
          (Absolute dates - like "2006-01-17" - are preferred
          over the relative ones - like "2 days ago").

       3. How did you build [6][1mCLISP[22m? (What command, options
          &c.)

       4. What is the output of [1mclisp --version[22m?

       5. Please supply the full output (copy and paste) of all
          the error messages, as well as detailed instructions
          on how to reproduce them.


       Known bugs, some of which may be platform-dependent,
       include:

       +o  No on-line documentation beyond [36][1mAPROPOS [22mand
          [42][1mDESCRIBE [22mis available.


[1mPROJECTS[0m
       +o  Write on-line documentation.

       +o  Enhance the compiler so that it can inline local
          functions.

       +o  Specify a portable set of window and graphics
          operations.

       +o  Add Multi-Threading capabilities, via OS threads.

[1mCLISP AUTHORS[0m
       [6][1mCLISP [22mproject was started in late 1980-ies by Bruno
       Haible and Michael Stoll, both in Germany.

       See [4mCOPYRIGHT[24m for the list of other contributors and the
       license.

[1mAUTHOR[0m
       Bruno Haible, Sam Steingold.

[1mREFERENCES[0m
        1. Common Lisp
           http://www.lisp.org

        2. read-eval-print loop
           http://www.lisp.org/HyperSpec/Body/sec_25-1-1.html

        3. READ
           http://www.lisp.org/HyperSpec/Body/fun_readcm_re_g-whitespace.html

        4. EVAL
           http://www.lisp.org/HyperSpec/Body/fun_eval.html

        5. PRINT
           http://www.lisp.org/HyperSpec/Body/fun_writecm_p_rintcm_princ.html

        6. CLISP
           http://clisp.cons.org

        7. LISP-IMPLEMENTATION-VERSION
           http://www.lisp.org/HyperSpec/Body/fun_lisp-impl_tion-version.html

        8. GNU
           http://www.gnu.org

        9. GPL
           http://www.gnu.org/copyleft/gpl.html

       10. SYMBOL-MACRO
           http://www.lisp.org/HyperSpec/Body/mac_define-symbol-macro.html

       11. gzip
           http://www.gzip.org/

       12. environment variable
           basedefs/xbd_chap08.html

       13. *LOAD-VERBOSE*
           http://www.lisp.org/HyperSpec/Body/var_stload-pr_ad-verbosest.html

       14. *COMPILE-VERBOSE*
           http://www.lisp.org/HyperSpec/Body/var_stcompile_le-verbosest.html

       15. T
           http://www.lisp.org/HyperSpec/Body/convar_t.html

       16. NIL
           http://www.lisp.org/HyperSpec/Body/convar_nil.html

       17. continuable
           http://www.lisp.org/HyperSpec/Body/glo_c.html#continuable

       18. ERROR
           http://www.lisp.org/HyperSpec/Body/contyp_error.html

       19. WARNING
           http://www.lisp.org/HyperSpec/Body/contyp_warning.html

       20. INVOKE-DEBUGGER
           http://www.lisp.org/HyperSpec/Body/fun_invoke-debugger.html

       21. ABORT
           http://www.lisp.org/HyperSpec/Body/fun_abortcm_c_cm_use-value.html

       22. SIGNAL
           http://www.lisp.org/HyperSpec/Body/fun_signal.html

       23. Emacs
           http://www.gnu.org/software/emacs/

       24. SLIME
           http://common-lisp.net/project/slime/

       25. ILISP
           http://sourceforge.net/projects/ilisp/

       26. readline
           http://cnswww.cns.cwru.edu/~chet/readline/rltop.html

       27. *PACKAGE*
           http://www.lisp.org/HyperSpec/Body/var_stpackagest.html

       28. *PRINT-BASE*
           http://www.lisp.org/HyperSpec/Body/var_stprint-b_rint-radixst.html

       29. COMMON-LISP-USER
           http://www.lisp.org/HyperSpec/Body/sec_11-1-2-2.html

       30. LOAD
           http://www.lisp.org/HyperSpec/Body/fun_load.html

       31. COMPILE
           http://www.lisp.org/HyperSpec/Body/fun_compile.html

       32. run control (RC)
           http://www.faqs.org/docs/artu/ch10s03.html

       33. USER-HOMEDIR-PATHNAME
           http://www.lisp.org/HyperSpec/Body/fun_user-homedir-pathname.html

       34. DISASSEMBLE
           http://www.lisp.org/HyperSpec/Body/fun_disassemble.html

       35. *STANDARD-OUTPUT*
           http://www.lisp.org/HyperSpec/Body/var_stdebug-i_ace-outputst.html

       36. APROPOS
           http://www.lisp.org/HyperSpec/Body/fun_aproposcm_apropos-list.html

       37. UNIX
           http://www.UNIX-systems.org/online.html

       38. Win32
           http://winehq.com/

       39. #'
           http://www.lisp.org/HyperSpec/Body/sec_2-4-8-2

       40. #P
           http://www.lisp.org/HyperSpec/Body/sec_2-4-8-14

       41. bash
           http://www.gnu.org/software/bash/

       42. DESCRIBE
           http://www.lisp.org/HyperSpec/Body/fun_describe.html

       43. SHORT-SITE-NAME
           http://www.lisp.org/HyperSpec/Body/fun_short-sit_ng-site-name.html

       44. CMU CL
           http://www.cons.org/cmucl/

       45. XEmacs
           http://www.xemacs.org

       46. SourceForge bug tracker
           http://sourceforge.net/tracker/?func=add&group_id=1355&atid=101355

       47. gdb
           http://sources.redhat.com/gdb/

       48. libc
           http://www.gnu.org/software/libc/

       49. Linux
           http://www.linux.org/



CLISP 2.38                 Last modified: 2006-01-23                  CLISP(1)
