#include "modelo.h"

int window;
float caminhar_angulos[2][6];

double movimento_base = 0.0;

float	angulo_virilhaE = 30 ,
		angulo_joelhoE  = 0,
		angulo_virilhaD = -30,
		angulo_joelhoD  = 0,
		zoom			= 0.0;

int rotacaox = 0,
	rotacaoy = 0;
		


void InitGL(){
	
	glClearColor (0.0, 0.0, 0.0, 0.0);
    glClearDepth(1.0);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_DEPTH_TEST);
	glShadeModel(GL_SMOOTH);

   

	caminhar_angulos[0][3] = angulo_virilhaE;
	caminhar_angulos[1][3] = angulo_virilhaD ;
	movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD);

}

/*============================================================================
*
*		FUNCAO QUE DEFINE A ILUMINACAO DO AMBIENTE
*				NAO SEI COMO FUNCIONA
*============================================================================*/

void defineLuzDoAmbiente(){

	 
	GLfloat			diffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0};
    GLfloat			ambientLight[] = { 0.2f, 0.2f, 0.4f, 1.0};
    GLfloat			lightPos[] = { 0.0f, 500.0f, 100.0f, 1.0f };
    glEnable(GL_LIGHTING);
    glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
    glLightfv(GL_LIGHT0, GL_SPECULAR, diffuseLight);
    glLightfv(GL_LIGHT0, GL_POSITION, lightPos);
    glEnable(GL_LIGHT0);
    glEnable(GL_COLOR_MATERIAL);
    glColor3f(1.0f,1.0f,1.0f);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, diffuseLight );
    glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 50);



}

/*===========================================================================*/
void redimensionaJanela(int width, int height){
    
    if ( width >= height)
		glViewport(0, 0, height, height);
	else
		glViewport(0, 0, width, width);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();   
    gluPerspective ( 65.0, ( float )width / ( float ) height, 1.0, 40.0 );
	glMatrixMode   ( GL_MODELVIEW );  
	glLoadIdentity ( );    
	glTranslatef(0.0, 0.0, -5.0);   
  	
}


/*==============================================================================*/
/*	FUNES  CHAMADA QUANDO UMA TECLA  PRESSIONADA
 *
 *
 ********************************************************************************/

void tecla(unsigned char tecla, int x, int y) {

  switch ( tecla ) {

	case 27:{
				glutDestroyWindow(window); 
				exit(0); 
			}break;	
	case '+':
		{
			zoom += 0.5 ;
			glutPostRedisplay() ;
		}break;

	case '-':
		{
			zoom -= 0.5 ;
			glutPostRedisplay() ;
		}break;

	case 'a':
		{
			anima();
			glutPostRedisplay() ;
		}break;

    default:{}	break;
  }

}


void teclas_de_seta ( int tecla, int x, int y )  {

  switch ( tecla ) {

	case GLUT_KEY_UP:
		{
			rotacaox = (rotacaox + 5) % 360 ;
			glutPostRedisplay() ;	
		 }  break;

    case GLUT_KEY_DOWN:	
		{
			rotacaox = (rotacaox - 5) % 360 ;
			glutPostRedisplay() ;
						
		}   break;
	case GLUT_KEY_LEFT: 
		{
			rotacaoy = (rotacaoy + 5) % 360 ;
			glutPostRedisplay() ;				
		}break;

	case GLUT_KEY_RIGHT:
		{
			rotacaoy = (rotacaoy - 5) % 360 ;
			glutPostRedisplay() ;				
		}break;


    default:{
				printf("Teclaram: %d\n", tecla);	
			}    break;
  }
}


/*============================================================================
*					FUNCAO PARA CRIAR O DESENHO
*
*============================================================================
*/


void redesenhaMundo(void) {

	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	defineLuzDoAmbiente();

	glPushMatrix() ;

	glPushMatrix() ;
	glTranslatef(0.0,0.0, zoom) ;  // tran,rot = zooming
	glRotatef(rotacaoy,0.0,1.0,0.0) ;// rot,tran = moving
	glRotatef(rotacaox,1.0,0.0,0.0) ;// rot,tran = moving
	desenhaQuadrilPernas() ;
	glPopMatrix() ;

	glPopMatrix() ;

	glutSwapBuffers() ;
  
	
}

/*===========================================================================*/

int  main(int  argc, char *argv[]){

	glutInit(&argc, argv);
    glutInitDisplayMode (GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
    glutInitWindowSize(400, 400);
	glutInitWindowPosition(200, 200);  
    window = glutCreateWindow("Sistema Hierarquico");

	InitGL();
	

    glutReshapeFunc(redimensionaJanela);
	glutDisplayFunc(redesenhaMundo);	
	glutKeyboardFunc(tecla);
	glutSpecialFunc(teclas_de_seta);
	
	glutMainLoop();
	return 0;
  
}




