#include "modelo.h"


double calculaMovimentoBase(double langle_up, double langle_lo, double rangle_up, double rangle_lo)
{
   double result1, result2, first_result, second_result, radians_up, radians_lo ;

   radians_up = (PI*langle_up)/180.0 ;
   radians_lo = (PI*langle_lo-langle_up)/180.0 ;
   result1 = (ALTURA_COXA + 2*VIRILHA) * cos(radians_up) ;
   result2 = (ALTURA_CANELA + 2*(JOELHO+TORNOZELO)+ALTURA_PE)
             * cos(radians_lo) ;
   first_result = ALTURA_PERNA - (result1 + result2) ;

   radians_up = (PI*rangle_up)/180.0 ;
   radians_lo = (PI*rangle_lo-rangle_up)/180.0 ;
   result1 = (ALTURA_COXA + 2*VIRILHA) * cos(radians_up) ;
   result2 = (ALTURA_CANELA + 2*(JOELHO+TORNOZELO)+ALTURA_PE)
             * cos(radians_lo) ;
   second_result = ALTURA_PERNA - (result1 + result2) ;

   if (first_result <= second_result)
      return (- first_result) ;
   else
      return (- second_result) ;
}


void anima(void)
{
   static quadros = QUADROS,
          zoom_fl = 0,
          flag = 1 ;

   float difVirilhaE ,
      	difVirilhaD ,
      	somaVirilhaE ,
      	somaVirilhaD ,
      	difJoelhoE ,
      	difJoelhoD ,
      	somaJoelhoE ,
      	somaJoelhoD ;

   switch (flag)
   {
      case 1 :
         difVirilhaE = 15 ;
         difVirilhaD = 5 ;
         difJoelhoE = 15 ;
         difJoelhoD = 5 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

       	caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  -= somaVirilhaE ;
         angulo_joelhoE -= somaJoelhoE ;
         angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 2 ;
            quadros = QUADROS ;
         }
         break ;
      case 2 :
         difVirilhaE = 20 ;
         difVirilhaD = -65 ;
         difJoelhoE = -15 ;
         difJoelhoD = 85 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  -= somaVirilhaE ;
         angulo_joelhoE -= somaJoelhoE ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
         movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 3 ;
            quadros = QUADROS ;
         }
         break ;
      case 3 :
         difVirilhaE = 5 ;
         difVirilhaD = -25 ;
         difJoelhoE = 10 ;
         difJoelhoD = -40 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  -= somaVirilhaE ;
         angulo_joelhoE -= somaJoelhoE ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 4 ;
            quadros = QUADROS ;
         }
         break ;
      case 4 :
         difVirilhaE = 20 ;
         difVirilhaD = 25 ;
         difJoelhoE = -10 ;
         difJoelhoD = -50 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  -= somaVirilhaE ;
         angulo_joelhoE -= somaJoelhoE ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 5 ;
            quadros = QUADROS ;
         }
         break ;
		case 5 :
         difVirilhaE = 5 ;
         difVirilhaD = 15 ;
         difJoelhoE = 5 ;
         difJoelhoD = 15 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

       	caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  += somaVirilhaD ;
         angulo_joelhoE += somaJoelhoD ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 6 ;
            quadros = QUADROS ;
         }
         break ;
      case 6 :
         difVirilhaE = -65 ;
         difVirilhaD = 20 ;
         difJoelhoE = 85 ;
         difJoelhoD = -15 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  += somaVirilhaD ;
         angulo_joelhoE += somaJoelhoD ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 7 ;
            quadros = QUADROS ;
         }
         break ;
      case 7 :
         difVirilhaE = -25 ;
         difVirilhaD = 5 ;
         difJoelhoE = -40 ;
         difJoelhoD = 10 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  += somaVirilhaD ;
         angulo_joelhoE += somaJoelhoD ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 8 ;
            quadros = QUADROS ;
         }
         break ;
      case 8 :
         difVirilhaE = 25 ;
         difVirilhaD = 20 ;
         difJoelhoE = -50 ;
         difJoelhoD = -10 ;

         somaVirilhaE = difVirilhaE / QUADROS ;
       	somaVirilhaD = difVirilhaD / QUADROS ;
         somaJoelhoE = difJoelhoE / QUADROS ;
       	somaJoelhoD = difJoelhoD / QUADROS ;

         caminhar_angulos[0][3] += somaVirilhaD ;
   		caminhar_angulos[1][3] += somaVirilhaE ;
       	caminhar_angulos[0][4] += somaJoelhoD ;
   		caminhar_angulos[1][4] += somaJoelhoE ;

         angulo_virilhaE  += somaVirilhaD ;
         angulo_joelhoE += somaJoelhoD ;
   		angulo_virilhaD -= somaVirilhaD ;
         angulo_joelhoD -= somaJoelhoD ;
   		movimento_base = calculaMovimentoBase(angulo_virilhaE,angulo_joelhoE,angulo_virilhaD,angulo_joelhoD ) ;
         quadros-- ;
         if (quadros == 0)
         {
            flag = 1 ;
            quadros = QUADROS ;
         }
         break ;
      default :
         break ;
   }


   glutPostRedisplay() ;
}

void desenhaQuadrilPernas(void)
{
   glPushMatrix() ;
   glTranslatef(0.0,movimento_base,0.0) ;
   desenhaQuadril(SOLIDO) ;
   glTranslatef(0.0,-(ALTURA_QUADRIL),0.0) ;
   glPushMatrix() ;
   glTranslatef(LARGURA_TRONCO * 0.33,0.0,0.0) ;
   desenhaPerna(ESQUERDA,SOLIDO) ;
   glPopMatrix() ;
   glTranslatef(-LARGURA_TRONCO * 0.33,0.0,0.0) ;
   desenhaPerna(DIREITA,SOLIDO) ;
   glPopMatrix() ;
}


//================= Base(frame) ======================

void desenhaQuadril(int frame)
{
	glPushMatrix() ;
   glScalef(LARGURA_QUADRIL, ALTURA_QUADRIL, TRONCO) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
      glutWireCube(1.0) ;
   else
      glutSolidCube(1.0) ;
   glPopMatrix() ;
}

void desenhaCoxa(int frame)
{
   glPushMatrix() ;
   glScalef(VIRILHA, VIRILHA, VIRILHA) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
   	glutWireSphere(1.0,8,8) ;
   else
   	glutSolidSphere(1.0,8,8) ;
   glPopMatrix() ;
   glColor3f(1.0,0.8,0);
   glTranslatef(0.0,- ALTURA_COXA * 0.75, 0.0) ;
   glPushMatrix() ;
   glScalef(LARGURA_COXA,ALTURA_COXA,LARGURA_COXA) ;
   if (frame == ARAME)
   	glutWireCube(1.0) ;
   else
      glutSolidCube(1.0) ;
   glPopMatrix() ;
}

void desenhaCanela(int frame)
{
   glPushMatrix() ;
   glScalef(JOELHO,JOELHO,JOELHO) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
   	glutWireSphere(1.0,8,8) ;
   else
      glutSolidSphere(1.0,8,8) ;
   glPopMatrix() ;
   glTranslatef(0.0,- ALTURA_CANELA * 0.75,0.0) ;
   glPushMatrix() ;
   glScalef(LARGURA_CANELA,ALTURA_CANELA,LARGURA_CANELA) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
   	glutWireCube(1.0) ;
   else
      glutSolidCube(1.0) ;
   glPopMatrix() ;
}

void desenhaPe(int frame)
{
   glPushMatrix() ;
   glScalef(TORNOZELO,TORNOZELO,TORNOZELO) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
   	glutWireCube(1.0) ;
   else
      glutSolidCube(1.0) ;
   glPopMatrix() ;
   glTranslatef(0.0,- TORNOZELO * 2.0, LARGURA_PE * 0.5) ;
   glPushMatrix() ;
   glScalef(LARGURA_PE, ALTURA_PE, PE) ;
   glColor3f(1.0,0.8,0);
   if (frame == ARAME)
   	glutWireCube(1.0) ;
   else
      glutSolidCube(1.0) ;
   glPopMatrix() ;
}

void desenhaPerna(int side, int frame)
{
   glPushMatrix() ;
   glRotatef(caminhar_angulos[side][3],1.0,0.0,0.0) ;
   desenhaCoxa(frame) ;
   glTranslatef(0.0,- ALTURA_COXA * 0.75,0.0) ;
   glRotatef(caminhar_angulos[side][4],1.0,0.0,0.0) ;
   desenhaCanela(frame) ;
   glTranslatef(0.0,- ALTURA_CANELA * 0.625, 0.0) ;
   glRotatef(caminhar_angulos[side][5],1.0,0.0,0.0) ;
   desenhaPe(frame) ;
   glPopMatrix() ;
}

