#include <stdio.h>
#include "glut.h"
#include <windows.h>

const int NUMPERNAS = 2;
const int PARTES_DA_PERNA = 3;
const int FRAMES = 6;
const float RESOLUCAO = 12.0;
const float PESCOCO_ALTO = 30;
const float PESCOCO_BAIXO = 28;
const double PI = 3.1415926535;


/////////   VARIVEIS GLOBAIS PARA OS ANGULOS////////////
float ang = 340;
float ang2 = 0;
float ang3 = 0;

int frame = 0;
int tipoAndar = 0; // 0 = Caminhada, 1 = TROTE
int lightEnable = false;

float angulos[FRAMES][NUMPERNAS][PARTES_DA_PERNA];
float angulosTrote[FRAMES-2][NUMPERNAS][PARTES_DA_PERNA];


void display();


void initAngulos()
{

	//Inicializar matriz de movimentos - CAMINHADA
    //Frame 0
	         //0 dianteira
	         //1 traseira
	
    angulos[0][0][0] = 3;
    angulos[0][0][1] = 3;
    angulos[0][0][2] = 3;
    angulos[0][1][0] = -39;
    angulos[0][1][1] = 33;
    angulos[0][1][2] = 0;
        //Frame 1
    angulos[1][0][0] = -3;
    angulos[1][0][1] = 3;
    angulos[1][0][2] = 9;
    angulos[1][1][0] = -39;
    angulos[1][1][1] = 21;
    angulos[1][1][2] = 0;
    //Frame 2
    angulos[2][0][0] = -15;
    angulos[2][0][1] = -3;
    angulos[2][0][2] = 27;
    angulos[2][1][0] = -39;
    angulos[2][1][1] = 54;
    angulos[2][1][2] = -45;
    //Frame 3
    angulos[3][0][0] = -6;
    angulos[3][0][1] = -39;
    angulos[3][0][2] = -12;
    angulos[3][1][0] = -3;
    angulos[3][1][1] = 51;
    angulos[3][1][2] = -57;
    //Frame 4
    angulos[4][0][0] = 36;
    angulos[4][0][1] = -75;
    angulos[4][0][2] = -21;
    angulos[4][1][0] = -9;
    angulos[4][1][1] = 33;
    angulos[4][1][2] = -24;  
    //Fraangulose 5
    angulos[5][0][0] = 39;
    angulos[5][0][1] = -24;
    angulos[5][0][2] = -6;
    angulos[5][1][0] = -21;
    angulos[5][1][1] = 33;
    angulos[5][1][2] = -12;

    //Inicializar matriz de movimentos - TROTE
    //Frame 0
	         //0 dianteira
	         //1 traseira
	
    angulosTrote[0][0][0] = -21;
    angulosTrote[0][0][1] = -3;
    angulosTrote[0][0][2] = 27;
    angulosTrote[0][1][0] = -33;
    angulosTrote[0][1][1] = 78;
    angulosTrote[0][1][2] = -30;
        //Frame 1
    angulosTrote[1][0][0] = 21;
    angulosTrote[1][0][1] = -78;
    angulosTrote[1][0][2] = -36;
    angulosTrote[1][1][0] = 6;
    angulosTrote[1][1][1] = 36;
    angulosTrote[1][1][2] = -33;
    //Frame 2
    angulosTrote[2][0][0] = 69;
    angulosTrote[2][0][1] = -60;
    angulosTrote[2][0][2] = -51;
    angulosTrote[2][1][0] = -39;
    angulosTrote[2][1][1] = 36;
    angulosTrote[2][1][2] = 3;
    //Frame 3
    angulosTrote[3][0][0] = 45;
    angulosTrote[3][0][1] = -9;
    angulosTrote[3][0][2] = -27;
    angulosTrote[3][1][0] = -81;
    angulosTrote[3][1][1] = 81;
    angulosTrote[3][1][2] = -51;
    
}


class Perna
{
public:
    Perna(float a, float l, bool tras, int frame);
    void desenha();
    void ande(int frame, int numPerna);
    void init(bool tras, int _frame);
  
    float largura;
    float altura;

    float tCoxa;     // comprimento da coxa
    float tCanela;   // comprimento da canela
    float tPe;       // comprimento do pe

    float ang_coxa;
    float ang_canela;
    float ang_pe;

	bool traseira;
};

class Animal
{
public:
    Animal();
    void desenha();
    void init();

    Perna *p1;
    Perna *p2;
    Perna *p3;
    Perna *p4;
           
    float grossura;
    float comprimento;

    float ang_pescoco;
    float ang_corpo;
    float ang_rabo;
};



Perna::Perna(float a, float l, bool tras, int _frame) 
{
   traseira = tras;
   largura = l; 
   altura = a; 
   tCoxa = a*0.49; 
   tCanela = a*0.48; 
   tPe = a*0.09;
   init(tras, _frame);
}

void Perna::init(bool tras, int _frame) 
{
    if(tras) {
      if(tipoAndar == 0)
      {
	      ang_coxa = angulos[_frame][1][0];
		   ang_canela = angulos[_frame][1][1];
	      ang_pe =  angulos[_frame][1][2];		
      }
      else 
      {
         ang_coxa = angulosTrote[_frame][1][0];
		   ang_canela = angulosTrote[_frame][1][1];
	      ang_pe =  angulosTrote[_frame][1][2];		
      }
	}
	else
	{
      if(tipoAndar == 0)
      {
		   ang_coxa = angulos[_frame][0][0];
		   ang_canela = angulos[_frame][0][1];
		   ang_pe = angulos[_frame][0][2];		
      }
      else
      {
         ang_coxa = angulosTrote[_frame][0][0];
		 ang_canela = angulosTrote[_frame][0][1];
	     ang_pe =  angulosTrote[_frame][0][2];		
      }
	}
}




void Perna::ande(int frame, int numPerna)
{
	int proximoFrame = (frame+1)%FRAMES;
   float passoCoxa;
   float passoCanela;
   float passoPe;
	
   if(tipoAndar == 0)
   {
      passoCoxa = (angulos[proximoFrame][numPerna][0] -  angulos[frame][numPerna][0])/RESOLUCAO ;
	   passoCanela = (angulos[proximoFrame][numPerna][1] -  angulos[frame][numPerna][1])/RESOLUCAO ;
   	passoPe = (angulos[proximoFrame][numPerna][2] -  angulos[frame][numPerna][2])/RESOLUCAO ;
   }
   else
   {
      proximoFrame = (frame+1)%(FRAMES-2);
      passoCoxa = (angulosTrote[proximoFrame][numPerna][0] -  angulosTrote[frame][numPerna][0])/RESOLUCAO ;
	   passoCanela = (angulosTrote[proximoFrame][numPerna][1] -  angulosTrote[frame][numPerna][1])/RESOLUCAO ;
   	passoPe = (angulosTrote[proximoFrame][numPerna][2] -  angulosTrote[frame][numPerna][2])/RESOLUCAO ;
	
   }
	ang_coxa += passoCoxa;
	ang_canela += passoCanela;
	ang_pe += passoPe;
}

void Perna::desenha() 
{   
    
	glPushMatrix();  //salva o contexto 
		glRotatef(ang_coxa, 0.0, 0.0, 1.0); //rotaciona para o angulo da conexcao
      if (traseira ) 
         glutSolidSphere(2*largura,8,8);        //desenha a conexao
      else
         glutSolidSphere(1.5*largura,8,8);        //desenha a conexao
      glTranslatef (0.0, -tCoxa/2.0, 0.0); //vai para o meio da coxa
      glPushMatrix();      
      if (traseira ) 
         glScalef (largura*2.8, tCoxa+0.5, largura*1.8);  //escala para o tamanho do osso
      else
         glScalef (largura*1.8, tCoxa, largura*1.8);  //escala para o tamanho do osso
         glutSolidCube (1.0);    //desenha a coxa
      glPopMatrix();    //restaura o contexto
      glTranslatef (0.0, -tCoxa/2.0, 0.0); // vai para a ponta do osso
      glutSolidSphere(largura,8,8);        //desenha o joelho (bola)
      glRotatef(ang_canela, 0.0, 0.0, 1.0); //rotaciona para o angulo da conexcao
      glPushMatrix();  //salva o contexto
			glTranslatef (0.0, -tCanela/2.0, 0.0); //vai para o meio da coxa
			glPushMatrix();   //salva o contexto
            glScalef (largura, tCanela, largura);  //escala para o tamanho do osso
            glutSolidCube (1.0);    //desenha a coxa
         glPopMatrix();    //restaura o contexto
            
			glTranslatef (0.0, -tCanela/2.0, 0.0); // vai para a ponta do osso
         glutSolidSphere(0.8*largura,8,8);        //desenha o joelho (bola)
         glRotatef(ang_pe, 0.0, 0.0, 1.0); //rotaciona para o angulo da conexcao
         glPushMatrix();  //salva o contexto
            glTranslatef (0, - 1.5, 0.0); //
    			//glColor3f(0.37f,0.16f,0.3f);
            glRotatef(-90, 1.0, 0.0, 0);
            glutSolidCone (1,1.0,8,6);    //desenha o p
         glPopMatrix();    //restaura o contexto
       glPopMatrix();
   glPopMatrix();  //restaura o contexto
}


Animal::Animal() 
{ 
   initAngulos();
   
    grossura = 5;
    comprimento = 13;
    p1 = new Perna(9.0,1.0, true,0); //traseira
    p2 = new Perna(9.0,1.0, true,3); //traseira
    p3 = new Perna(9.0,1.0, false,0);
    p4 = new Perna(9.0,1.0, false,3);
    ang_pescoco = 25;
    ang_corpo = 0;
    ang_rabo = 0;
    
}

void Animal::init()
{
    if(tipoAndar == 0)
    {
        p1->init(true,0); //traseira
        p2->init(true,3); //traseira
        p3->init(false,0);
        p4->init(false,3);     
    }
    else 
    {
        p1->init(true,0); //traseira
        p2->init(true,2); //traseira
        p3->init(false,0);
        p4->init(false,2);     
    }
}

void Animal::desenha()
{
   glTranslatef(-3.0, 3.0,0.0);     
   glPushMatrix();   
      //CORPO
      glPushMatrix();
         glTranslatef(comprimento*0.17, grossura*0.6,0.0);
         glRotatef(-5 - ang_corpo, 0, 0, 1.0);
         glScalef (1.3, 1.1, 1.0);  //(1.6, 1.0, 1.0);  
         glutSolidSphere (3.7,11,10);        
      glPopMatrix();
      //CORPO
      glPushMatrix();
        glTranslatef(comprimento*0.7, grossura*0.7,0.0); 
        glRotatef(13 + ang_corpo, 0, 0, 1.0);         
         glScalef (1.6, 1.0, 1.0);  //(1.3, 1.1, 1.0);   
         glutSolidSphere (4.0,11,12);        
      glPopMatrix();
      
      if(tipoAndar == 1) {
        //rabo 1
        glPushMatrix();
          glRotatef(145 +  ang_corpo, 0, 0, 1.0);
          glTranslatef(comprimento*0.33, grossura*-0.4,0.0);
          glScalef (2, 1.0, 1.0);  //(1.3, 1.1, 1.0);   
          glutSolidSphere (1.2,11,12);        
         glPopMatrix();
        //rabo 2
         glPushMatrix();                  
           glTranslatef(comprimento-20, grossura,0.0);     
           glRotatef( ang_corpo+5, 0, 0, 1.0);         
          glScalef (2, 0.5, 1.0);  //(1.3, 1.1, 1.0);   
           glutSolidSphere (2,8,6);        
         glPopMatrix();
      }
      else 
      {
           //rabo 1
        glPushMatrix();
         glRotatef(145 +  ang_corpo, 0, 0, 1.0);
         glTranslatef(comprimento*0.33, grossura*-0.4,0.0);
         glScalef (2, 1.0, 1.0);  //(1.3, 1.1, 1.0);   
         glutSolidSphere (1.2,11,12);        
         glPopMatrix();
         //rabo 2
        glPushMatrix();
         glRotatef(260 +  ang_corpo, 0, 0, 1.0);
         glTranslatef(comprimento*-0.05, grossura*-1.0,0.0);
         glScalef (2, 0.5, 1.0);  //(1.3, 1.1, 1.0);   
         glutSolidSphere (2,8,6);        
         glPopMatrix();
      }
         
         
         //PESCOO
      glPushMatrix();
         glRotatef(ang_pescoco+5, 0, 0, 1.0);
         glTranslatef(comprimento +1, -2,0.0);
         glPushMatrix();
		      glScalef (3, 1.0, 1.0);  
            glutSolidCube (3.5);       
		   glPopMatrix();
         // cabeca
         glTranslatef(6, -1.0,0.0);
         
		   glRotatef(ang_pescoco*3.5, 0, 0, 1.0);
         glScalef (1.7, 0.6, 1.0);  
         glutSolidCube (3.5);       
	   glPopMatrix(); 
      //FIM PESCOO

      //PERNAS:      
      glTranslatef(0.5, 0.0 ,grossura*0.5);
      p1->desenha();
      
      glPushMatrix();
         glTranslatef(0.0,0.0,-grossura);
         p2->desenha();
      glPopMatrix();
      
      glPushMatrix();
         glTranslatef(comprimento*0.9,0.0,0.0);
         p3->desenha();
      glPopMatrix();
      
      glPushMatrix();
         glTranslatef(comprimento*0.9,0.0,- grossura);
         p4->desenha();
      glPopMatrix();
   glPopMatrix();
}


/////////////////////////////////////////////////////////////
Animal m;

///////////////////////////////////////////////////
void init(void)
{
    glClearColor (0.0, 0.0, 0.0, 0.0);
    glClearDepth(1.0);				// Enables Clearing Of The Depth Buffer
    glDepthFunc(GL_LEQUAL);				// The Type Of Depth Test To Do
    glEnable(GL_DEPTH_TEST);			// Enables Depth Testing
    glShadeModel(GL_SMOOTH);			// Enables Smooth Color Shading
}


void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   //////////////ISSO AQUI EH PRA LUZ///////////E EU AINDA N SEI COMO FUNCA/////
    GLfloat			diffuseLight[] = { 0.1f, 0.1f, 0.2f, 0.5};
    GLfloat			ambientLight[] = { 0.3f, 0.1f, 0.1f, 1.0};
    GLfloat			lightPos[] = { 0.0f, 900.0f, 100.0f, 1.0f };
    glEnable(GL_LIGHTING);
   glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
   glLightfv(GL_LIGHT0, GL_SPECULAR, diffuseLight);
    glLightfv(GL_LIGHT0, GL_POSITION, lightPos);
  //  glEnable(GL_LIGHT0);
    glEnable(GL_COLOR_MATERIAL);
    glColor3f(0.99f,0.66f,0.8f);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, diffuseLight );
    glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 50);
    //////////////////////////////////////////////////////////////////////////

    glPushMatrix();

      glTranslatef (-3.0, -3.0, -15.0);
      glRotatef (ang3, 0.0, 0.0, 1.0);
      glRotatef (ang, 0.0, 1.0, 0.0);
      glRotatef (ang2, 1.0, 0.0, 0.0);
      glColor3f(1.0,0.8,0);
	   glScalef (0.6, 0.6, 0.6);  
		

      m.desenha();

    glPopMatrix();

    glutSwapBuffers();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective(55.0, (GLfloat) w/(GLfloat) h, 1.0, 40.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef (0.0, 0.0, -10.0);
}

// desenha o movimento...
void idle()
{
int i = 0;

	float passoP = (PESCOCO_ALTO - PESCOCO_BAIXO)/RESOLUCAO*0.7;
    m.ang_corpo  = 3;

	switch(frame) {
    case 0:
		if(tipoAndar == 0)
      {
          passoP = -passoP;
		  m.ang_pescoco = PESCOCO_ALTO;
	   
		   for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.ang_pescoco += passoP;	
			   m.p1->ande(0,1);
			   m.p2->ande(3,1);
			   m.p3->ande(0,0);
			   m.p4->ande(3,0);
			   display();
		   }
      }
      else 
      {
           passoP = -passoP;
		   m.ang_pescoco = PESCOCO_ALTO;
		   for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.ang_pescoco += passoP;	
			   m.p1->ande(0,1);
			   m.p2->ande(2,1);
			   m.p3->ande(0,0);
			   m.p4->ande(2,0);
			   display();
         }
      }
       break;
    case 1:
		if(tipoAndar == 0)
      {
         m.ang_corpo  = - m.ang_corpo ;
		 m.ang_pescoco = PESCOCO_BAIXO;
         for( i = 0; i < RESOLUCAO; i++) 
		   {
		   	m.ang_pescoco += passoP;
		   	m.p1->ande(1,1);
		   	m.p2->ande(4,1);
	   		m.p3->ande(1,0);
	    		m.p4->ande(4,0);
	   		display();
		   }
       }
       else 
      {
           passoP = -passoP;
           m.ang_corpo  = - m.ang_corpo ;
		   m.ang_pescoco = PESCOCO_ALTO;
	   	   for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.ang_pescoco += passoP;	
			   m.p1->ande(1,1);
			   m.p2->ande(3,1);
			   m.p3->ande(1,0);
			   m.p4->ande(3,0);
			   display();
         }
      }           
      break;
    case 2:
	   if(tipoAndar ==0)
      {
   	   m.ang_pescoco = PESCOCO_ALTO; //(PESCOCO_ALTO - PESCOCO_BAIXO) / 2;
		   passoP = passoP/2;
         for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.p1->ande(2,1);
		   	m.p2->ande(5,1);
		   	m.p3->ande(2,0);
		   	m.p4->ande(5,0);
		   	display();
		   }
       }
       else 
      {
         passoP = -passoP;
		   m.ang_pescoco = PESCOCO_ALTO;
		   for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.ang_pescoco += passoP;	
			   m.p1->ande(2,1);
			   m.p2->ande(0,1);
			   m.p3->ande(2,0);
			   m.p4->ande(0,0);
			   display();
         }
      }
      break;
	case 3:
      if(tipoAndar == 0)
      {
		   passoP = -passoP;
		   m.ang_pescoco = PESCOCO_ALTO;
		   for( i = 0; i < RESOLUCAO; i++) 
	   	{
		   	m.ang_pescoco += passoP;
		     	m.p1->ande(3,1);
		   	m.p2->ande(0,1);
		   	m.p3->ande(3,0);
	   		m.p4->ande(0,0);
	    		display();
		   }
      }
      else 
      {
          m.ang_corpo  = - m.ang_corpo ; 
          passoP = -passoP;
		  m.ang_pescoco = PESCOCO_ALTO;
	      for( i = 0; i < RESOLUCAO; i++) 
		   {
			   m.ang_pescoco += passoP;	
			   m.p1->ande(3,1);
			   m.p2->ande(1,1);
			   m.p3->ande(3,0);
			   m.p4->ande(1,0);
			   display();
         }
      }
      break;
    case 4:
       m.ang_corpo  =  - m.ang_corpo ;
		 m.ang_pescoco = PESCOCO_BAIXO;
       for( i = 0; i < RESOLUCAO; i++) 
		 {
			m.ang_pescoco += passoP;
			m.p1->ande(4,1);
			m.p2->ande(1,1);
			m.p3->ande(4,0);
			m.p4->ande(1,0);
			display();
		 }           
        break;
    case 5:
		m.ang_pescoco = PESCOCO_ALTO;
        for( i = 0; i < RESOLUCAO; i++) 
		{
		//	m.ang_pescoco += passoP;
			m.p1->ande(5,1);
			m.p2->ande(2,1);
			m.p3->ande(5,0);
			m.p4->ande(2,0);
			display();
		}
     break;    
	} //end switch
     
    frame++;
    if(tipoAndar == 0)
    {
      if(frame > 5  ) 
         frame = 0;
     
    } 
    else
    {
      if(frame > 3  )
         frame = 0;
    }

      
      
}

void keyboard (unsigned char key, int x, int y)
{   
   switch(key)
    {
        case 'l':
            if(lightEnable) {
               glDisable(GL_LIGHT0);
               lightEnable = false;
            }
            else {
               glEnable(GL_LIGHT0);
               lightEnable = true;
            }
            break;
        case 'm':
             frame = 0;
             tipoAndar = tipoAndar ==  0 ? 1 : 0;
             m.init();
            break;
        case '.': //>
            ang += 5;
            if (ang>360)
                ang -= 360;
            break;
        case ',': //<
            ang -= 5;
            if (ang<0)
                ang += 360;
            break;
        case ']':
            ang2 += 5;
            if (ang2>360)
                ang2 -= 360;
            break;
        case '[':
            ang2 -= 5;
            if (ang2<0)
                ang2 += 360;
            break;
        case 27: //ESC
			printf("Ang Coxa: %f",m.p1->ang_coxa);
			printf("Ang Canela: %f",m.p1->ang_canela);
			printf("Ang Pe: %f",m.p1->ang_pe);
		//	getchar();
            exit(0);
            break;
        case '9':
            ang3 += 5;
            if (ang3>360)
                ang3 -= 360;
            break;
        case '0':
            ang3 -= 5;
            if (ang3<0)
                ang3 += 360;
            break;
		case '1':
			m.p1->ang_coxa += 3;
			break;
		case '2':
			m.p1->ang_coxa -= 3;
			break;
        case '3':
			m.p1->ang_canela += 3;
			break;
		case '4':
			m.p1->ang_canela -= 3;
			break;
        case '5':
			m.p1->ang_pe += 3;
			break;
        case '6':
			m.p1->ang_pe -= 3;
			break;
            

         default:
            return;
    }
    glutPostRedisplay();
}

int main(int argc, char** argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode (GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
    glutInitWindowSize (800, 600);
    glutInitWindowPosition (100, 100);
    glutCreateWindow (argv[0]);
    init ();


    glutIdleFunc(idle);
    glutDisplayFunc(display);
    glutReshapeFunc(reshape);
    glutKeyboardFunc(keyboard);
    glutMainLoop();
    return 0;
}
