/**
 * UFSC - CTC - INE - CCO
 * INE5341 - Computao Grfica
 * Prof.: Aldo von Wangenheim
 *
 * Alunos : Marcos Aurlio Pereira
 *          Alfredo Domingues B. Junior
 */

#include <windows.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include "tgaLoad.h"
	
/**
 * Este trabalho de uso de OpenGL, mostra uma animao
 * que  a rotao de um planeta juntamente com a sua
 * admosfera.
 *
 * Este programa exemplifica o uso de texturas de objetos 
 * com OpenGL por meio de uma classe para leitura de imagens
 * do tipo TGA.
 */


#define NMT  2     // Numero mximo de texturas

#define TdPT 0     // Textura do Planeta
#define TdN  1     // Textura de Neblina
	
#define TRUE  1
#define FALSE 0

// Array de texturas :
GLuint  textura_id[NMT];

float angulo1, angulo2; // Angulos referente ao planeta.
float anguloDaAdmosfera;  // Angulo de rotao da admosfera.

// Usado para verificar se esta sendo movimentado pelo mouse :
int estaEmMovimento;

int startx, starty;

GLfloat luz_ambiente[]   = {0.2, 0.2, 0.2, 1.0};
GLfloat fonte_de_luz[]   = {0.9, 0.8, 0.8, 1.0};
GLfloat posicao_da_luz[] = {7.0, 0.0, 3.0, 1.0};

void init ( void ) {
	 
	 // Seta o modelo de iluminao :
   glEnable ( GL_LIGHTING );
   glLightModelfv ( GL_LIGHT_MODEL_AMBIENT, luz_ambiente );
   glLightfv ( GL_LIGHT0, GL_DIFFUSE,  fonte_de_luz );
   glLightfv ( GL_LIGHT0, GL_POSITION, posicao_da_luz    );
   glEnable  ( GL_LIGHT0 );

   // Abilita iluminao :
   glEnable ( GL_COLOR_MATERIAL );
   glColorMaterial ( GL_FRONT, GL_AMBIENT_AND_DIFFUSE );

   glEnable ( GL_TEXTURE_2D );
   glPixelStorei ( GL_UNPACK_ALIGNMENT, 1 );
   glGenTextures ( 2, textura_id );

   textura_id [ 0 ] = tgaLoadAndBind (
       "planeta_t.tga",  TGA_LOW_QUALITY 
   );
   textura_id [ 1 ] = tgaLoadAndBind (
       "admosfera_t.tga", TGA_LUMINANCE | TGA_LOW_QUALITY 
   );

   glEnable ( GL_CULL_FACE );
   glEnable ( GL_BLEND     );
   glBlendFunc ( GL_ONE, GL_ONE );

   glClearColor ( 0.0, 0.0, 0.0, 0.0 );
}

/**
 * Desenha a esfera (sem textura).
 * @param int tex_id, textura id.
 */
void desenha_esfera ( int tex_id ) {
   glPushMatrix  ( );
   glRotatef     ( 90.0, 1.0, 0.0, 0.0 );
   glColor4f     ( 1.0, 1.0, 1.0, 1.0  );
   glBindTexture ( GL_TEXTURE_2D, textura_id[tex_id] );
   GLUquadricObj*  q = gluNewQuadric ( );
   gluQuadricDrawStyle ( q, GLU_FILL   );
   gluQuadricNormals   ( q, GLU_SMOOTH );
   gluQuadricTexture   ( q, GL_TRUE    );
   gluSphere ( q, 1.0, 20, 20 );
   gluDeleteQuadric ( q );
   glPopMatrix ( );
}


void display ( void ) {
	
   glClear   ( GL_COLOR_BUFFER_BIT );
   glLightfv ( GL_LIGHT0, GL_POSITION, posicao_da_luz );
   glPushMatrix ( );
   glTranslatef ( 0.0, 0.0, -4.0 );
   glRotatef ( angulo2, 1.0, 0.0, 0.0 );
   glRotatef ( angulo1, 0.0, 1.0, 0.0  );
   desenha_esfera ( TdPT );

   glRotatef   ( anguloDaAdmosfera, 0.0, 1.0, 0.0 );
   desenha_esfera ( TdN );
   glPopMatrix ( );

   glutSwapBuffers ( );
   
}

void reshape ( int w, int h ) {
	
   glViewport ( 0, 0, (GLint) w, (GLint) h );
   glMatrixMode ( GL_PROJECTION );
   glLoadIdentity ( );
   if ( h==0 )
      gluPerspective( 45, (GLdouble)w, 1.0, 2000.0 );
   else
      gluPerspective( 45, (GLdouble)w/ (GLdouble)h,1.0, 2000.0 );

   glMatrixMode ( GL_MODELVIEW );
   glLoadIdentity ( );
}

void mouse ( int button, int state, int x, int y ) {
	
   if ( button == GLUT_LEFT_BUTTON && state == GLUT_DOWN ) {
      estaEmMovimento = TRUE;
      startx = x;
      starty = y;
   }
   if ( button == GLUT_LEFT_BUTTON && state == GLUT_UP )
      estaEmMovimento = FALSE;
}

void motion ( int x, int y ) {
	
   if ( estaEmMovimento ) {
   	  angulo1 = angulo1 - (x - startx);
      angulo2 = angulo2 - (y - starty);
      startx = x;
      starty = y;
      glutPostRedisplay ( );
   }
}

/**
 * Funcionar como um Thread, na qual far a animao dos objetos.
 */
void idle_func ( void ) {
	
	 // Roda o planeta :	
   angulo1 = angulo1 - 1.0;
   if ( angulo1 <= 0 )
      angulo1 = 360;
   
   // Faz a admosfera rodar mais rpido que o planeta :
   anguloDaAdmosfera = anguloDaAdmosfera - 10.0;
   if ( anguloDaAdmosfera <= 0 )
      anguloDaAdmosfera = 360;
      
   glutPostRedisplay ( );
}

#pragma argsused
void keyboard ( unsigned char key, int x, int y ) {
	
   int i;

   switch (key) {
   	  case 27 :  // Escape
         exit(0);
         break;      
      case 'f':  // Tela Cheia (Full Screen)
         glutFullScreen();
         break;
      case 'r':  // Restaura Tela
         glutReshapeWindow(400,400);
         break;
      default:
         break;
   }
}

/**
 * Mtodo de ativamento do programa.
 * @params int argc, char** argv
 */
int main ( int argc, char** argv) {
	
   glutInit ( &argc, argv );
   glutInitDisplayMode ( GLUT_RGB | GLUT_DOUBLE );
   glutInitWindowSize  ( 400, 400);
   glutCreateWindow ( argv[0] );

   init();

   glutReshapeFunc  ( reshape   );
   glutMouseFunc    ( mouse     );
   glutMotionFunc   ( motion    );
   glutKeyboardFunc ( keyboard  );
   glutDisplayFunc  ( display   );
   glutIdleFunc     ( idle_func );
   glutMainLoop ( );

   return 0;
}