#include <iostream>
#include <string.h>
#include <math.h>
#include <GL/glui.h>

#include "window_gml.h"
#include "ring_gml.h"

#define MAX_SCALE 200
#define MIN_SCALE .001
#define FIRST_SCALE 1//10
#define TAX_SCALE .02
#define QUIT 0
#define DRAW 5
#define CREATE_RINGS 17 //17 was choosen by me at random 
#define TEXT_GRAPH 7
#define TEXT_RINGS 8
#define TEXT_SOCIETY 9
#define TEXT_MARRIAGES 10

graph_gml G_draw;
vector <ring_gml *> * VR_draw;

int axcx = 0;
int id_window_glut;
//int id_window_glut2;
int window_width;
//int window_2_width;
int window_height;
//int window_2_height;
double scale;
//double divisor = 1;//20.;
int drag_drop;
int x1_, y1_;
double dif_x, dif_y, pos_x, pos_y;
int wedding;
int size_list = 0;
int curr_string;

char message [1][150];

/*Global GLUI*/
GLUI            *glui;
GLUI_Panel      *panel;
GLUI_List       *list;
GLUI_EditText   *edit_graph;
GLUI_EditText   *edit_rings;
GLUI_EditText   *edit_society;
GLUI_EditText   *edit_marriages;
char            *path_graph;
char            *path_rings;
char            *path_society;
char            *path_marriages;

int create_glui_A1C1();
int create_glui_A2C2();
int create_glui_A3C3();


int adjust_y(){
  //return 800;
  return window_height;
}

int which_ring (char * path){
  FILE *arq;
  char type [5];
  int ret;
  memset (type, '\0', 5);
  arq = fopen (path, "r");
  if (arq == NULL){
    return 0;
  }

  fscanf (arq, "%s ", type);
  if (strcmp (type, "A1C1") == 0)
    ret =  1;
  if (strcmp (type, "A2C2") == 0)
    ret = 2;
  if (strcmp (type, "A3C3") == 0)
    ret =  3;
  fclose (arq);
  return ret;
}


int valid_path (char * path){
  FILE *arq;
  int ret;
  if (path[0] == '\0'){
    return 0;
  }
  arq = fopen (path, "r");
  if (arq == NULL)
    ret = 0;
  ret = 1;
  fclose (arq);
  //cout << ret << endl;
  return ret;
}

void text (int control) {
  char  text [150];
  memset (text, '\0', 150);
  glui->sync_live();
  if (control == TEXT_GRAPH) {
    strcpy (text, edit_graph->get_text());
    /*cout << text << endl;*/
  }
  else if (control == TEXT_RINGS){
    strcpy (text, edit_rings->get_text());
    /*cout << text << endl;*/
  }
}

void measures (graph_gml* G_draw, int *imin_x, int *imin_y, int *imax_x, int *imax_y){
  double min_x, min_y, max_x, max_y;
  min_x = G_draw->node_x[0];
  min_y = G_draw->node_y[0];
  max_x = min_x;
  max_y = min_y;
  *imin_x = *imin_y = *imax_x = *imax_y = 0;

  for (int i = 1; i < G_draw->num_nodes; i++){
    if (min_x > G_draw->node_x[i]){
      min_x = G_draw->node_x[i];
      *imin_x = i;
    }
    if (min_y > G_draw->node_y[i]){
      min_y = G_draw->node_y[i];
      *imin_y = i;
    }
    if (max_x < G_draw->node_x[i]){
      max_x = G_draw->node_x[i];
      *imax_x = i;
    }
    if (max_y < G_draw->node_y[i]){
      max_y = G_draw->node_y[i];
      *imax_y = i;
    }
  }
}

void normalize (graph_gml* G_draw, int imin_x, int imin_y, int imax_x, int imax_y){
  for (int i = 0; i < G_draw->num_nodes; i++){
    G_draw->node_x[i] -= G_draw->node_x[imin_x];
    G_draw->node_y[i] -= G_draw->node_y[imin_y];
    //cout << i << " " << G_draw->node_x[i] << endl;
  }
  for (int i = 0; i < G_draw->num_edges; i++){
    for (int j = 0; j < G_draw->edge_num_points[i]; j++){
      G_draw->edge_points_x[i][j] -= G_draw->node_x[imin_x];
      G_draw->edge_points_y[i][j] -= G_draw->node_y[imin_y];
    }
  }
}

void control_cb (int control) {
 
  if (control == 1){
    list->update_and_draw_text();
    wedding = list->get_current_item();
    //glutSetWindow (id_window_glut2);
    //glutPostRedisplay();
    glutSetWindow (id_window_glut);
    glutPostRedisplay();
  }
  else if (control == CREATE_RINGS){
    
    glui->sync_live();
    pos_x = 0;
    pos_y = 0;
  
    dif_x = 0;
    dif_y = adjust_y();
  
    scale = FIRST_SCALE;
    

    char name_prog [150];
    sprintf (name_prog, "./hierarchical-layout.bin %s", path_society);
    system(name_prog);
    memset (name_prog, '\0', 150);

    sprintf (name_prog, "./k-ring.bin %s %s", path_society, path_marriages);
    system(name_prog);
    //printf("%s %s\n", path_society, path_marriages);
    
  }
  else if (control == DRAW) {
    glui->sync_live();
    pos_x = 0;
    pos_y = 0;
  
    dif_x = 0;
    dif_y = adjust_y();
  
    scale = FIRST_SCALE;

    sprintf (path_graph, "whl-gml-%s", path_society);
    if (curr_string == 0)
      sprintf (path_rings, "a1c1-vis-%s", path_society);
    else if (curr_string == 1)
      sprintf (path_rings, "a2c2-vis-%s", path_society);
    else if (curr_string == 2)
      sprintf (path_rings, "a3c3-vis-%s", path_society);

    if (G_draw.num_nodes != 0)
      G_draw.clear_gml ();
    G_draw.num_nodes = 0;
    //cout << path_graph << endl;
    G_draw.read_gml(path_graph);

    /*G_draw.print_graph_gml();*/

    /****************************************************/
    /*int imin_x, imin_y, imax_x, imax_y;
    if (G_draw.num_nodes != 0){
      measures (&G_draw, &imin_x, &imin_y, &imax_x, &imax_y);
      normalize (&G_draw, imin_x, imin_y, imax_x, imax_y);
      }*/
    /****************************************************/
    if (VR_draw != NULL){
      list->delete_all();
      size_list = 0;
      for (vector<ring_gml *>::iterator it = VR_draw->begin(); it < VR_draw->end(); it++)
	(*it)->clear_gml ();
      VR_draw->clear();
      VR_draw = NULL;
    }

    ring_gml R;

    axcx = which_ring (path_rings);
    //cout << axcx << endl;

    if (axcx != 0){
      if (axcx == 1){
	VR_draw = R.read_A1C1(path_rings, &G_draw);
	//cout << "a1c1" << endl;
	if (VR_draw == NULL)
	  cout << "null" << endl;
	if (VR_draw->empty())
	  cout << "vazio" << endl;
	if (VR_draw != NULL && !VR_draw->empty()){
	  size_list = create_glui_A1C1();
	  //cout << "a1c1-2" << endl;
	  panel->set_name("-(u v)-[s1]");
	}
      }
      else if (axcx == 2){
	VR_draw = R.read_A2C2(path_rings, &G_draw);
	if (VR_draw != NULL && !VR_draw->empty()){
	  size_list = create_glui_A2C2();
	  panel->set_name("-(u v)-(x y)-[s1 s2]");
	}
      }
      else if (axcx == 3){
	VR_draw = R.read_A3C3(path_rings, &G_draw);
	if (VR_draw != NULL && !VR_draw->empty()){
	  size_list = create_glui_A3C3();
	  panel->set_name("-(u v)-(x y)-(w z)-[s1 s2 s3]");
	}
      }

      list->update_and_draw_text();
      if (size_list > 0){
	list->set_start_line(0);
      }
      wedding = list->get_current_item();
      //glutSetWindow (id_window_glut2);
      //glutPostRedisplay();
      glutSetWindow (id_window_glut);
      glutPostRedisplay();

    }
    else{
      printf("Error axcx == 0\n");
    }


  }
  else if (control == QUIT){
    //cout << "The button Quit pressed, so quitting " << endl;
    glutDestroyWindow(id_window_glut);
    //glutDestroyWindow(id_window_glut2);
    if (G_draw.num_nodes != 0){
      G_draw.clear_gml();
    }
    if (VR_draw != NULL){
      for (vector<ring_gml *>::iterator it = VR_draw->begin(); it < VR_draw->end(); it++)
	(*it)->clear_gml ();
      VR_draw->clear();
    }
    exit(0);
  }


}

void output_10 (int x, int y, char *string){
  int len, i;
  void * font = GLUT_BITMAP_HELVETICA_12;//GLUT_BITMAP_TIMES_ROMAN_10;

  glRasterPos2f(x, y);
  len = 6;
  for (i = 0; i < len; i++) {
    glutBitmapCharacter(font, string[i]);
  }
}

void output_18 (int x, int y, char *string, int len){
  //int len, i;
  int i;
  void * font = GLUT_BITMAP_HELVETICA_12;/*GLUT_BITMAP_HELVETICA_18;*//*GLUT_BITMAP_TIMES_ROMAN_24;*/

  glRasterPos2f(x, y);
  //len = 4;
  for (i = 0; i < len; i++) {
    glutBitmapCharacter(font, string[i]);
  }
}

int create_glui_A3C3 () {

  int ncas = 0;

  if (VR_draw != NULL && G_draw.num_nodes != 0) {

    int c1, c2, c3, c4, c5, c6, c7, c8, c9;
    char st[100];
    int VR_size = VR_draw->size();
    for (int i = 0; i < VR_size; i++){
      c1 = VR_draw->at(i)->pair_u;
      c2 = VR_draw->at(i)->pair_v;
      c3 = VR_draw->at(i)->pair_x;
      c4 = VR_draw->at(i)->pair_y;
      c5 = VR_draw->at(i)->pair_w;
      c6 = VR_draw->at(i)->pair_z;
      c7 = VR_draw->at(i)->s_uv;
      c8 = VR_draw->at(i)->s_xy;
      c9 = VR_draw->at(i)->s_wz;

      /*printf ("%d %d %d %d %d %d %d %d %d\n\n", c1, c2, c3, c4, c5, c6, c7, c8, c9);*/
      sprintf (st, "%d: -(%s %s)-(%s %s)-(%s %s)-[%s %s %s]%c",
           i+1,
	       G_draw.node_label[c1].c_str(),
	       G_draw.node_label[c2].c_str(),
	       G_draw.node_label[c3].c_str(),
	       G_draw.node_label[c4].c_str(),
	       G_draw.node_label[c5].c_str(),
	       G_draw.node_label[c6].c_str(),
	       G_draw.node_label[c7].c_str(),
	       G_draw.node_label[c8].c_str(),
	       G_draw.node_label[c9].c_str(), '\0');
      //st[54] = '\0';
      list->add_item(ncas, st);
      ncas++;
    }

    //list->set_h (650);
    //list->set_w (390);

    list->set_h (window_height * .5);
    list->set_w (window_width * .2053);
  }
  return ncas;
}

int create_glui_A2C2 () {

  int ncas = 0;
  if (VR_draw != NULL && G_draw.num_nodes != 0){
    int c1, c2, c3, c4, c5, c6;
    char st[100];
    int VR_size = VR_draw->size();

    for (int i = 0; i < VR_size; i++){

      c1 = VR_draw->at(i)->pair_u;
      c2 = VR_draw->at(i)->pair_v;
      c3 = VR_draw->at(i)->pair_x;
      c4 = VR_draw->at(i)->pair_y;
      c5 = VR_draw->at(i)->s_uv;
      c6 = VR_draw->at(i)->s_xy;

      /*printf ("%d %d %d %d %d %d %d\n\n", i, c1, c2, c3, c4, c5, c6);*/
      sprintf (st, "%d: -(%s %s)-(%s %s)-[%s %s]%c",
           i+1,
	       G_draw.node_label[c1].c_str(),
	       G_draw.node_label[c2].c_str(),
	       G_draw.node_label[c3].c_str(),
	       G_draw.node_label[c4].c_str(),
	       G_draw.node_label[c5].c_str(),
	       G_draw.node_label[c6].c_str(),
           '\0');
      //st[36] = '\0';
      list->add_item(ncas, st);
      ncas++;
    }

    //list->set_h (650);
    //list->set_w (280);

    list->set_h (window_height * .5);
    list->set_w (window_width * .1474);

  }
  return ncas;
}

int create_glui_A1C1 () {

  int ncas = 0;

  //cout << "create" << endl;

  if (VR_draw != NULL && G_draw.num_nodes != 0) {
    int c1, c2, c3;
    char st[100];
    int VR_size = VR_draw->size();
    //cout << VR_size << endl;
    //cout << VR_size << endl;
    for (int i = 0; i < VR_size; i++){
      c1 = VR_draw->at(i)->pair_u;
      c2 = VR_draw->at(i)->pair_v;
      c3 = VR_draw->at(i)->s_uv;
      if (c1 != -1 && c2 != -1 && c3 != -1){
	//cout << i << endl;
	//cout << c1 << " " << c2 << " " << c3 << endl;
	sprintf (st, "%d: -(%s %s)-[%s]%c",
         i+1,
		 G_draw.node_label[c1].c_str(),
		 G_draw.node_label[c2].c_str(),
		 G_draw.node_label[c3].c_str(),
         '\0');
	//cout << i << endl;
	//st[19] = '\0';
	//cout << i << endl;
	list->add_item(ncas, st);
	ncas++;
      }
      else{
	printf("Erro no create_glui_A1C1\n.");
	exit(0);
      }
    }

    //list->set_h (650);
    //list->set_w (180);

    list->set_h (window_height * .5);
    list->set_w (window_width * .09474);
  }
  return ncas;
}

void draw_nodes () {

  if (G_draw.num_nodes != 0 && VR_draw != NULL) {

    int n = G_draw.num_nodes;

    glColor3f (0.9, 0.9, 0.9); /*same color of the edges*/

    for (int j = 0; j < n; j++) {

      /*x1 = (G_draw.node_x[j]) - 1;
	x2 = (G_draw.node_x[j]) + 1;
	y1 = (G_draw.node_y[j]) - 1;
	y2 = (G_draw.node_y[j]) + 1;
	
	glRectf (x1, y1, x2, y2);
      */
      
      if (G_draw.node_type[j].compare("rectangle") == 0){
	glBegin(GL_TRIANGLES);
	glVertex2f(G_draw.node_x[j], G_draw.node_y[j] - 5);
	glVertex2f(G_draw.node_x[j] - 5, G_draw.node_y[j] + 5);
	glVertex2f(G_draw.node_x[j] + 5, G_draw.node_y[j] + 5);
	glEnd();
      }
      else {
	glBegin(GL_TRIANGLE_FAN);
	int sections = 40;
	GLfloat radius = 5.f; //radius
	GLfloat twoPi = 2.0f * 3.14159f;
	glVertex2f(G_draw.node_x[j], G_draw.node_y[j]); // origin
	for(int i = 0; i <= sections; i++) { // make $section number of circles
	  glVertex2f((G_draw.node_x[j]) + radius * cos(i *  twoPi / sections),
		     (G_draw.node_y[j]) + radius* sin(i * twoPi / sections));
	}
	glEnd();
      }
    }
  }
}

void draw_edges () {

  if (G_draw.num_nodes != 0 && VR_draw != NULL){
    int m = G_draw.num_edges;
    double xs, ys, xt, yt;

    glColor3f (0.9, 0.9, 0.9);

    for (int i = 0; i < m; i++) {
      if (G_draw.edge_num_points[i] == 0) {
	xs = (G_draw.node_x[G_draw.edge_source[i]]);
	ys = (G_draw.node_y[G_draw.edge_source[i]]);
	xt = (G_draw.node_x[G_draw.edge_target[i]]);
	yt = (G_draw.node_y[G_draw.edge_target[i]]);

	glBegin (GL_LINES);
	glVertex2f (xs, ys);
	glVertex2f (xt, yt);
	glEnd ();

      }
      else {
	xs = (G_draw.edge_points_x[i][0]);
	ys = (G_draw.edge_points_y[i][0]);
	for (int j = 1; j < G_draw.edge_num_points[i]; j++) {
	  xt = (G_draw.edge_points_x[i][j]);
	  yt = (G_draw.edge_points_y[i][j]);
	  glBegin (GL_LINES);
	  glVertex2f (xs, ys);
	  glVertex2f (xt, yt);
	  glEnd ();
	  xs = xt;
	  ys = yt;
	}
      }
    }
  }
}



void draw_info (int wedding) {
  if (VR_draw != NULL && G_draw.num_nodes != 0){
    vector<int>::iterator it = VR_draw->at(wedding)->path->begin();

    char c [5];
    char carac[1] = {'N'};
    double x1 = 0, y1 = 30;
    double x2 = 50, y2 = 60;
    glColor3f (.0, .0, .0);

    bool decreasing = false;
    if (*it == VR_draw->at(wedding)->s_uv)
      decreasing = true;

    carac[0] = 'X'; /*gen.push_back('X');*/
    while (it < VR_draw->at(wedding)->path->end()){
      strcpy (c, G_draw.node_label[*it].c_str());
      output_18 (x1, y1, c, 4);
      x1+=50;
      it++;
      if ((it < VR_draw->at(wedding)->path->end()) && ((*it) != VR_draw->at(wedding)->pair_x) &&
	  ((*it) != VR_draw->at(wedding)->pair_w)){
	if (!decreasing){
	  if (G_draw.node_type[*it].compare("rectangle") == 0){
	    carac[0] = 'F';/*gen.push_back('F');*/
	    output_18 (x2, y2, carac, 1);
	  }
	  else{
	    carac[0] = 'M';/*gen.push_back('M');*/
	    output_18 (x2, y2, carac, 1);
	  }
	}
	else{
	  if (G_draw.node_type[*it].compare("rectangle") == 0){
	    carac[0] = 'S';/*gen.push_back('S');*/
	    output_18 (x2, y2, carac, 1);
	  }
	  else{
	    carac[0] = 'D';/*gen.push_back('D');*/
	    output_18 (x2, y2, carac, 1);
	  }
	}
	if (*it == VR_draw->at(wedding)->s_uv || *it == VR_draw->at(wedding)->s_xy || *it == VR_draw->at(wedding)->s_wz)
	  decreasing = true;
      }
      if (it < VR_draw->at(wedding)->path->end() &&
	  (*it == VR_draw->at(wedding)->pair_x || *it == VR_draw->at(wedding)->pair_w)){
	if (G_draw.node_type[*it].compare("rectangle") == 0){
	  carac[0] = 'H';/*gen.push_back('H');*/
	  output_18 (x2, y2, carac, 1);
	}
	else{
	  carac[0] = 'W';/*gen.push_back('W');*/
	  output_18 (x2, y2, carac, 1);
	}
	decreasing = false;
	if (*it == VR_draw->at(wedding)->s_xy || *it == VR_draw->at(wedding)->s_wz)
	  decreasing = true;
      }
      x2+=50;
    }
  }

}

/*void my_display_2 () {

  glClearColor(0.9602941, 0.9602941, 0.9602941, .0);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,window_2_width,0,window_2_height, -1, 1);

  if (wedding != -1)
    draw_info (wedding);

  //glFlush();//força desenhar a janela do opengl.
  glutSwapBuffers();


}

void my_reshape_2 (int x, int y) {

  window_2_width = x;
  window_2_height = y;

  glViewport( 0, 0, x, y );

  glutPostRedisplay();

  }*/

void draw_weddings(ring_gml * R){
  double xs, ys, xt, yt;
  
  if (axcx == 1){
    xs = (G_draw.node_x[R->w[0]]);
    ys = (G_draw.node_y[R->w[0]]);
    xt = (G_draw.node_x[R->w[1]]);
    yt = (G_draw.node_y[R->w[1]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();
  }
  else if (axcx == 2){
    xs = (G_draw.node_x[R->w[0]]);
    ys = (G_draw.node_y[R->w[0]]);
    xt = (G_draw.node_x[R->w[1]]);
    yt = (G_draw.node_y[R->w[1]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();

    xs = (G_draw.node_x[R->w[2]]);
    ys = (G_draw.node_y[R->w[2]]);
    xt = (G_draw.node_x[R->w[3]]);
    yt = (G_draw.node_y[R->w[3]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();
    

  }
  else if (axcx == 3){
    xs = (G_draw.node_x[R->w[0]]);
    ys = (G_draw.node_y[R->w[0]]);
    xt = (G_draw.node_x[R->w[1]]);
    yt = (G_draw.node_y[R->w[1]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();

    xs = (G_draw.node_x[R->w[2]]);
    ys = (G_draw.node_y[R->w[2]]);
    xt = (G_draw.node_x[R->w[3]]);
    yt = (G_draw.node_y[R->w[3]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();

    xs = (G_draw.node_x[R->w[4]]);
    ys = (G_draw.node_y[R->w[4]]);
    xt = (G_draw.node_x[R->w[5]]);
    yt = (G_draw.node_y[R->w[5]]);
   
    glColor3f (1, 0., 0.);/*red*/
    glBegin (GL_LINES);
    glVertex2f (xs, ys);
    glVertex2f (xt, yt);
    glEnd ();
  }
}

void draw_ring_in_graph () {

  glLineWidth (2.5);
  if (VR_draw != NULL && G_draw.num_nodes != 0){
    vector <int>::iterator it =  VR_draw->at(wedding)->path->begin();
    int id_edge;
    double /*x1, x2, y1, y2,*/ xs, ys, xt, yt;

    while (it < VR_draw->at(wedding)->path->end() - 1){

      draw_weddings(VR_draw->at(wedding));

      /**********************************************************/

      if (G_draw.node_cla[*it].compare("AW") == 0)
	glColor3f (1, 0., 0.);/*red*/
      else if (G_draw.node_cla[*it].compare("AH") == 0)
	glColor3f (0., 1., 0.);/*green*/
      else if (G_draw.node_cla[*it].compare("KL") == 0)
	glColor3f (1., 1., 0.);/*yellow*/
      else if (G_draw.node_cla[*it].compare("KK") == 0)
	glColor3f (0., 0., 1.);/*blue*/
      else if (G_draw.node_cla[*it].compare("MR") == 0)
	glColor3f (1., 0.5, 0.);/*orange*/
      else if (G_draw.node_cla[*it].compare("XX") == 0)
	glColor3f (1., 1., 1.);/*white*/
      else if (G_draw.node_cla[*it].compare("KN") == 0)
	glColor3f (0.647059, 0.164706, 0.164706);/*brown*/
      else if (G_draw.node_cla[*it].compare("ML") == 0)
	glColor3f (1., 0., 1.);/*magenta*/
      else if (G_draw.node_cla[*it].compare("LH") == 0)
	glColor3f (0.5, 0., 0.); /*gray*/
      else if (G_draw.node_cla[*it].compare("KH") == 0)
	glColor3f (0., 0., 0.);/*black*/
      else{
	//cout << G_draw.node_cla[*it] << endl;
	glColor3f (0.01, 0.01, 0.01);/*almost black*/

      }


      if (strcmp (G_draw.node_type [*it].c_str(), "rectangle") == 0){

 	glBegin(GL_TRIANGLES);
	glVertex2f(G_draw.node_x[*it], G_draw.node_y[*it] - 5);
	glVertex2f(G_draw.node_x[*it] - 5, G_draw.node_y[*it] + 5);
	glVertex2f(G_draw.node_x[*it] + 5, G_draw.node_y[*it] + 5);
	glEnd();
      }
      else {
	glBegin(GL_TRIANGLE_FAN);
	int sections = 40;
	GLfloat radius = 5.f; //radius
	GLfloat twoPi = 2.0f * 3.14159f;
	glVertex2f(G_draw.node_x[*it], G_draw.node_y[*it]); // origin
	for(int i = 0; i <= sections; i++) { // make $section number of circles
	  glVertex2f((G_draw.node_x[*it]) + radius * cos(i *  twoPi / sections),
		     (G_draw.node_y[*it]) + radius* sin(i * twoPi / sections));
	}
	glEnd();
      }

      /*x1 = (G_draw.node_x[*it]) - 1;
	x2 = (G_draw.node_x[*it]) + 1;
	y1 = (G_draw.node_y[*it]) - 1;
	y2 = (G_draw.node_y[*it]) + 1;*/

      glColor3f (0., 0., 0.);/*black*/
      char c[7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
      //sprintf (c, "%c%c%s", 'i', ':', G_draw.node_label[*it].c_str());
      sprintf (c, "%s", G_draw.node_label[*it].c_str());
      output_10 ((G_draw.node_x[*it]) - 10 + 0, (G_draw.node_y[*it]) - 15, c);
      char nasc [7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
      sprintf (nasc, "%c%c%d", 'n', ':', G_draw.node_nasc[*it]);
      //output_10 ((G_draw.node_x[*it]) - 1 + 0, (G_draw.node_y[*it]) - 1 - 9, nasc);
      char morte [7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
      sprintf (morte, "%c%c%d", 'm', ':', G_draw.node_morte[*it]);
      //output_10 ((G_draw.node_x[*it]) - 1 + 0, (G_draw.node_y[*it]) - 1 - 15, morte);

      /*glRectf (x1, y1, x2, y2);*/

      /*********************************************************/
      glColor3f (.0, .0, .0);
      /*********************************************************/
      id_edge = G_draw.find_edge_id_gml (atoi(G_draw.node_label[*it].c_str()),
					  atoi(G_draw.node_label[*(it + 1)].c_str()));
      //if (id_edge == -1) {
	/*printf ("Error: Edge %s - %s not found.\n", G_draw.node_label[*it].c_str(), G_draw.node_label[*(it + 1)].c_str());*/
	//printf ("Wedding %s - %s.\n", G_draw.node_label[*it].c_str(), G_draw.node_label[*(it + 1)].c_str());
      //}
      //else {
      if (!(id_edge == -1)){
	if (G_draw.edge_num_points[id_edge] == 0) {
	  xs = (G_draw.node_x[G_draw.edge_source[id_edge]]);
	  ys = (G_draw.node_y[G_draw.edge_source[id_edge]]);
	  xt = (G_draw.node_x[G_draw.edge_target[id_edge]]);
	  yt = (G_draw.node_y[G_draw.edge_target[id_edge]]);

	  glBegin (GL_LINES);
	  glVertex2f (xs, ys);
	  glVertex2f (xt, yt);
	  glEnd ();
	}
	else {
	  xs = (G_draw.edge_points_x[id_edge][0]);
	  ys = (G_draw.edge_points_y[id_edge][0]);
	  for (int j = 1; j < G_draw.edge_num_points[id_edge]; j++) {
	    xt = (G_draw.edge_points_x[id_edge][j]);
	    yt = (G_draw.edge_points_y[id_edge][j]);
	    glBegin (GL_LINES);
	    glVertex2f (xs, ys);
	    glVertex2f (xt, yt);
	    glEnd ();
	    xs = xt;
	    ys = yt;
	  }
	}
      }
      /*********************************************************/
      it++;
    }
    /**********************************************************/

    if (G_draw.node_cla[*it].compare("AW") == 0)
	glColor3f (1, 0., 0.);/*red*/
      else if (G_draw.node_cla[*it].compare("AH") == 0)
	glColor3f (0., 1., 0.);/*green*/
      else if (G_draw.node_cla[*it].compare("KL") == 0)
	glColor3f (1., 1., 0.);/*yellow*/
      else if (G_draw.node_cla[*it].compare("KK") == 0)
	glColor3f (0., 0., 1.);/*blue*/
      else if (G_draw.node_cla[*it].compare("MR") == 0)
	glColor3f (1., 0.5, 0.);/*orange*/
      else if (G_draw.node_cla[*it].compare("XX") == 0)
	glColor3f (1., 1., 1.);/*white*/
      else if (G_draw.node_cla[*it].compare("KN") == 0)
	glColor3f (0.647059, 0.164706, 0.164706);/*brown*/
      else if (G_draw.node_cla[*it].compare("ML") == 0)
	glColor3f (1., 0., 1.);/*magenta*/
      else if (G_draw.node_cla[*it].compare("LH") == 0)
	glColor3f (0.5, 0., 0.); /*gray*/
      else if (G_draw.node_cla[*it].compare("KH") == 0)
	glColor3f (0., 0., 0.);/*black*/
      else{
	//cout << G_draw.node_cla[*it] << endl;
	glColor3f (0.01, 0.01, 0.01);
      }
    if (strcmp (G_draw.node_type [*it].c_str(), "rectangle") == 0){
      glBegin(GL_TRIANGLES);
      glVertex2f(G_draw.node_x[*it], G_draw.node_y[*it] - 5);
      glVertex2f(G_draw.node_x[*it] - 5, G_draw.node_y[*it] + 5);
      glVertex2f(G_draw.node_x[*it] + 5, G_draw.node_y[*it] + 5);
      glEnd();
    }
    else {
      glBegin(GL_TRIANGLE_FAN);
      int sections = 40;
      GLfloat radius = 5.f; //radius
      GLfloat twoPi = 2.0f * 3.14159f;
      glVertex2f(G_draw.node_x[*it], G_draw.node_y[*it]); // origin
      for(int i = 0; i <= sections; i++) { // make $section number of circles
	glVertex2f((G_draw.node_x[*it]) + radius * cos(i *  twoPi / sections),
		   (G_draw.node_y[*it]) + radius* sin(i * twoPi / sections));
      }
      glEnd();
    }

    /*x1 = (G_draw.node_x[*it]) - 1;
      x2 = (G_draw.node_x[*it]) + 1;
      y1 = (G_draw.node_y[*it]) - 1;
      y2 = (G_draw.node_y[*it]) + 1;*/

    glColor3f (0., 0., 0.);/*black*/
    char c[7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
    //sprintf (c, "%c%c%s", 'i', ':', (G_draw.node_label[*it].c_str()));
    sprintf (c, "%s", (G_draw.node_label[*it].c_str()));
    output_10 ((G_draw.node_x[*it]) - 10 + 0, (G_draw.node_y[*it]) - 15, c);
    char nasc [7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
    sprintf (nasc, "%c%c%d", 'n', ':', G_draw.node_nasc[*it]);
    //output_10 ((G_draw.node_x[*it]) - 1 + 0, (G_draw.node_y[*it]) - 1 - 9, nasc);
    char morte [7] = {'\0', '\0','\0','\0','\0', '\0', '\0'};
    sprintf (morte, "%c%c%d", 'm', ':', G_draw.node_morte[*it]);
    //output_10 ((G_draw.node_x[*it]) - 1 + 0, (G_draw.node_y[*it]) - 1 - 15, morte);

    /*glRectf (x1, y1, x2, y2);*/

    /*********************************************************/
  }
  glLineWidth (1.5);
}

void my_display () {

  glClearColor(0.9602941, 0.9602941, 0.9602941, 0.);
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,window_width,0,window_height, -1, 1);
  /*glFrustum( -xy_aspect*.04, xy_aspect*.04, -.04, .04, -1, 1);*/

  glColor3ub( 0, 0, 0 );
  glRasterPos2i( 20, -5 );
  for (unsigned int i = 0; i < strlen(message[0]); i++)
    glutBitmapCharacter( GLUT_BITMAP_HELVETICA_18,  message[0][i]);


  if (VR_draw != NULL && G_draw.num_nodes != 0 && wedding != -1){
    vector<int>::iterator it = VR_draw->at(wedding)->path->begin();
    
    bool decreasing = false;
    if (*it == VR_draw->at(wedding)->s_uv)
      decreasing = true;
    
    char percurse [200];
    char relative [200];
    char str_aux [20];
    percurse[0] = '\0';
    relative[0] = '\0';
    strcat(percurse, "PATHS: ");
    strcat(relative, "RELATIVES: ");
    
    while (it < VR_draw->at(wedding)->path->end()){
      strcat (percurse, G_draw.node_label[*it].c_str());
      strcat (percurse, " ");
      it++;
      if ((it < VR_draw->at(wedding)->path->end()) && ((*it) != VR_draw->at(wedding)->pair_x) &&
	  ((*it) != VR_draw->at(wedding)->pair_w)){
	if (!decreasing){
	  if (G_draw.node_type[*it].compare("rectangle") == 0){
	    sprintf(str_aux, "%2c", 'F');
	    strcat(relative, str_aux);
	  }
	  else{
	    sprintf(str_aux, "%2c", 'M');
	    strcat(relative, str_aux);
	  }
	}
	else{
	  if (G_draw.node_type[*it].compare("rectangle") == 0){
	     sprintf(str_aux, "%2c", 'S');
	    strcat(relative, str_aux);
	  }
	  else{
	    sprintf(str_aux, "%2c", 'D');
	    strcat(relative, str_aux);
	  }
	}
	if (*it == VR_draw->at(wedding)->s_uv || *it == VR_draw->at(wedding)->s_xy || *it == VR_draw->at(wedding)->s_wz)
	  decreasing = true;
      }
      
      if (it < VR_draw->at(wedding)->path->end() &&
	  (*it == VR_draw->at(wedding)->pair_x || *it == VR_draw->at(wedding)->pair_w)){
	if (G_draw.node_type[*it].compare("rectangle") == 0){
	  sprintf(str_aux, "%2c", 'H');
	  strcat(relative, str_aux);
	}
	else{
	  sprintf(str_aux, "%2c", 'W');
	  strcat(relative, str_aux);
	}
	decreasing = false;
	if (*it == VR_draw->at(wedding)->s_xy || *it == VR_draw->at(wedding)->s_wz)
	  decreasing = true;
      }

    }
    glRasterPos2i(20, -window_height + 50);
    for (unsigned int i = 0; i < strlen(percurse); i++)
      glutBitmapCharacter( GLUT_BITMAP_HELVETICA_18,  percurse[i]);
    glRasterPos2i(20, -window_height + 75);
    for (unsigned int i = 0; i < strlen(relative); i++)
      glutBitmapCharacter( GLUT_BITMAP_HELVETICA_18,  relative[i]);
    
  }

  pos_x += -dif_x;
  pos_y += +dif_y;
  glTranslatef (pos_x, pos_y, 0);

  glScalef( scale, scale, 1.0);

  //  Print current width and height on the screen
  //printf ("Window Width: %d, Window Height: %d.\n", window_width, window_height);

  draw_edges ();

  draw_nodes ();

  if (wedding != -1){
    draw_ring_in_graph ();
  }

  /*find_color ();*/

  //glFlush();//força desenhar a janela do opengl.
  glutSwapBuffers();

  dif_y = 0;
}

void my_reshape (int x, int y) {

  window_width = x;
  window_height = y;

  glViewport( 0, 0, (GLsizei)x, (GLsizei)y );

  glutPostRedisplay();

}


/*void my_keyboard_2 (unsigned char key, int x, int y) {
  if(key == 'q' || key == 'Q'){
      cout << "Got q,so quitting " << endl;
      glutDestroyWindow(id_window_glut);
      glutDestroyWindow(id_window_glut2);
      if (G_draw.num_nodes != 0)
	G_draw.clear_gml ();
      exit(0);
  }
  }*/

void my_keyboard (unsigned char key, int x, int y) {

  //cout << "Pressed key " << key << " on coordinates (" << x << "," << y << ")";
  //cout << endl;
  if (key == 'm') {
    scale -= TAX_SCALE;
    if (scale < MIN_SCALE){
      //cout << scale << " - minimum scale equal to " << MIN_SCALE << "." << endl;
      scale = MIN_SCALE;
    }
    //cout << scale << " - scale" << endl;
    glutPostRedisplay ();
  }
  else if (key == 'M') {
    scale += TAX_SCALE;
    if (scale > MAX_SCALE){
      //cout << scale << " - maximum scale equal to " << MAX_SCALE << "." << endl;
      scale = MAX_SCALE;
    }
    //cout << scale << " - scale" << endl;
    glutPostRedisplay ();
  }
  else if(key == 'q' || key == 'Q'){
    //cout << "Got q, so quitting " << endl;
    glutDestroyWindow(id_window_glut);
    //glutDestroyWindow(id_window_glut2);
    if (G_draw.num_nodes != 0)
      G_draw.clear_gml ();
    exit(0);
  }
}

void my_motion (int x2, int y2) {

  dif_x = (x1_ - x2) * 5;
  dif_y = (y1_ - y2) * 5;

  x1_ = x2;
  y1_ = y2;

  glutPostRedisplay ();
}

void my_mouse (int button, int state, int x, int y) {
  //cout << x << " " << y << endl;
  switch(button){

  case GLUT_LEFT_BUTTON :

    if (drag_drop == 0) {
      x1_ = x;
      y1_ = y;
      drag_drop++;
    }
    else {
      drag_drop = 0;
      dif_x = 0;
      dif_y = 0;
    }
    break;

  case GLUT_RIGHT_BUTTON :

    /*cout << x << " " << y << endl;*/

    /*glutPostRedisplay ();*/
    break;
    }
}

/*more global variables*/
GLUI_Panel * panelText;
GLUI_Panel *panelButton;
char string_list[3][20]; 

void window_gml::init_openGL () {
  int argc = 0;
  char ** argv = (char **) malloc (sizeof (char *));
  /*Initial glut functions*/

  glutInit(&argc, argv);
  window_width = glutGet(GLUT_SCREEN_WIDTH);
  window_height = glutGet(GLUT_SCREEN_HEIGHT);
  //printf("%d %d\n", window_width, window_height);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);

  /****************************************************/
  glutInitWindowPosition( 0, 0 );
  glutInitWindowSize( window_width, window_height );

  /*glut window*/
  id_window_glut = glutCreateWindow("Kinship Machine");

  glutDisplayFunc( my_display );
  GLUI_Master.set_glutReshapeFunc( my_reshape );
  GLUI_Master.set_glutKeyboardFunc( my_keyboard );
  GLUI_Master.set_glutSpecialFunc( NULL );
  GLUI_Master.set_glutMouseFunc( my_mouse );
  glutMotionFunc( my_motion );

  glutFullScreen();

  /*gl functions and variable*/
  GLfloat values[2];
  glGetFloatv (GL_LINE_WIDTH_GRANULARITY, values);
  //printf ("GL_LINE_WIDTH_GRANULARITY value is %3.1f\n", values[0]);
  glGetFloatv (GL_LINE_WIDTH_RANGE, values);
  //printf ("GL_LINE_WIDTH_RANGE values are %3.1f %3.1f\n", values[0], values[1]);
  glEnable (GL_LINE_SMOOTH);
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glHint (GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
  glLineWidth (1.5);
  glPointSize(1);
  /*glClearColor (.60, .60, .60, 0.);*/

  /*glut callbacks*/
  /*glutDisplayFunc (my_display);
  glutReshapeFunc (my_reshape);
  glutKeyboardFunc (my_keyboard);
  glutMouseFunc (my_mouse);
  glutMotionFunc (my_motion);*/

  glRotatef (180., 1., 0., 0);

  /*******************************************************/

  /*glutInitWindowPosition( 50, 50 );
  glutInitWindowSize( window_2_width, window_2_height );

  id_window_glut2 = glutCreateWindow("Info.");

  glGetFloatv (GL_LINE_WIDTH_GRANULARITY, values);
  printf ("GL_LINE_WIDTH_GRANULARITY value is %3.1f\n", values[0]);
  glGetFloatv (GL_LINE_WIDTH_RANGE, values);
  printf ("GL_LINE_WIDTH_RANGE values are %3.1f %3.1f\n", values[0], values[1]);
  glEnable (GL_LINE_SMOOTH);
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glHint (GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
  glLineWidth (1.5);
  glPointSize(1);
  
  glutDisplayFunc (my_display_2);
  glutReshapeFunc (my_reshape_2);
  glutKeyboardFunc (my_keyboard_2);*/

  /*******************************************************/

  //glui = GLUI_Master.create_glui ("Control", 0, 700, 50); /* name, flags, x, and y */

  glui = GLUI_Master.create_glui_subwindow( id_window_glut, GLUI_SUBWINDOW_RIGHT );
  /*******************************Generating rings - Start**********************************************/
  /*GLUI_Panel * panelTextRing = glui->add_panel ("Select the society and marriages. Max. charac.: 150");
  edit_society = glui->add_edittext_to_panel(panelTextRing, "Society", GLUI_EDITTEXT_TEXT,
							  path_society, TEXT_SOCIETY, (GLUI_Update_CB)text );
  edit_society->set_w (500);
  edit_marriages = glui->add_edittext_to_panel(panelTextRing, "Marriages", GLUI_EDITTEXT_TEXT,
							  path_marriages, TEXT_MARRIAGES, (GLUI_Update_CB)text );
  edit_marriages->set_w (500);

  GLUI_Panel *panelButtonRing = glui->add_panel( "" );

  glui->add_button_to_panel (panelButtonRing, "Draw", DRAW, (GLUI_Update_CB)control_cb);
  glui->add_column_to_panel (panelTextRing, true);
  glui->add_button_to_panel (panelButtonRing, "Quit", QUIT, (GLUI_Update_CB)control_cb);*/

  /*******************************Generating rings - End**********************************************/

  /*******************************Generating draw - Start**********************************************/
  panelText = glui->add_panel ("Max. charac.: 150");

  edit_graph = glui->add_edittext_to_panel(panelText, "Society", GLUI_EDITTEXT_TEXT,
							  path_society, TEXT_GRAPH, (GLUI_Update_CB)text );
  //edit_graph->set_w (300);
  edit_graph->set_w (window_width * 0.1579);
  edit_rings = glui->add_edittext_to_panel(panelText, "Marriages", GLUI_EDITTEXT_TEXT,
							  path_marriages, TEXT_RINGS, (GLUI_Update_CB)text );
  //edit_rings->set_w (300);
  edit_rings->set_w (window_width * 0.1579);

  panelButton = glui->add_panel( "" );

  glui->add_button_to_panel (panelButton, "Create Rings", CREATE_RINGS, (GLUI_Update_CB)control_cb);

  /**** Add listbox ****/
  curr_string = 0;
  strcpy (string_list[0], "1-ring");
  strcpy (string_list[1], "2-ring");
  strcpy (string_list[2], "3-ring");
  glui->add_statictext( "" );
  GLUI_Listbox *list2 = glui->add_listbox( "k-ring:", &curr_string );
  for( int i=0; i</*2*/3; i++ )
    list2->add_item( i, string_list[i] );
  
  glui->add_statictext( "" );
  
 
  
  GLUI_Panel *panelButton2 = glui->add_panel( "" );
  //glui->add_column_to_panel (panelButton, true);
  glui->add_button_to_panel (panelButton2, "Load", DRAW, (GLUI_Update_CB)control_cb);
  //glui->add_column_to_panel (panelButton2, true);
  

   panel = glui->add_panel("");
  list = new GLUI_List (panel, true, 1, control_cb);

  GLUI_Panel *panelButton3 = glui->add_panel( "" );
  glui->add_button_to_panel (panelButton3, "Quit", QUIT, (GLUI_Update_CB)control_cb);
  /*******************************Generating draw - End**********************************************/
 
  glui->set_main_gfx_window( id_window_glut );

   
  //panel = glui2->add_panel("");

  /*glut main loop*/
  glutMainLoop();

  free (argv);
}

window_gml::window_gml () {

}

void window_gml::draw_graph_gml (graph_gml * G, vector<ring_gml *> *VR, int type) {
}


void window_gml::draw_graph_gml () {
  
  /*Initialize global variables*/
  //window_width = 1900;
  //window_height = 1000;
  //window_width = GLUT_SCREEN_WIDTH;
  //window_height = GLUT_SCREEN_HEIGHT;
  //window_2_width = 500;
  //window_2_height = 100;

  /*pos_x = 50;
    pos_y = 50;*/

  pos_x = 0;
  pos_y = 0;

  dif_x = 0;
  dif_y = adjust_y();

  path_graph = (char *) malloc (sizeof (char) * 150);
  path_rings = (char *) malloc (sizeof (char) * 150);
  path_society = (char *) malloc (sizeof (char) * 150);
  path_marriages = (char *) malloc (sizeof (char) * 150);

  memset (path_graph, '\0', 150);
  memset (path_rings, '\0', 150);
  memset (path_society, '\0', 150);
  memset (path_marriages, '\0', 150);

  /*strcpy (path_graph, "grafo_EN-layout.gml");
  strcpy (path_rings, "a2c2-EN-31jul2011.txt");*/
  /*/home/alvaro/Doutorado/maqpar_my_results/a1c1-EN-31jul2011.txt*/
  /*strcpy (path_graph, "grafo_DENI-layout.gml");
    strcpy (path_rings, "/home/alvaro/Doutorado/maqpar/my-results/A1C1-VIS/a1c1-DENI.txt");*/


  scale = FIRST_SCALE;
  drag_drop = 0;

  G_draw.num_nodes = 0;
  VR_draw = NULL;

  axcx = 0;

  wedding = -1;

  //cout << "init_openGL" << flush << endl;

  strcpy (message[0], "Select the window and press Q or q to exit; M to zoom +; m to zoom -.");

  this->init_openGL ();

}
