#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <cstring>
#include "ring_gml.h"

#define tstr 10

void treat (char *s) {
  strcpy (s, s+3);
}

ring_gml::ring_gml () {}

vector<ring_gml *> * ring_gml::read_A1C1 (string file_name, graph_gml * G){
  FILE *in;
  int ls, lu, lv, li;
  int lw[2];
  char c;
  char str[tstr];
  vector<int> * path;
  ring_gml * R;
  vector<ring_gml *> * A1C1;
  char type [5];

  in = fopen (file_name.c_str(),"r");

  if (in == NULL) {
    printf ("Error: open file %s\n", file_name.c_str());
    this->clear_gml ();
    return NULL;
  }

  fscanf (in, "%s ", type);

  if (feof(in))
    return NULL;

  A1C1 = new vector<ring_gml *>();

  /****acelerating the loading*****/
  int * already_find_node = (int *) calloc(10000, sizeof(int));
  /*******************************/
  

  while (!feof (in)){
    path = new vector<int>();
    R = new ring_gml();
    fscanf (in, "%d %c %d ", &lw[0], &c, &lw[1]);
    if (already_find_node[lw[0]] == 0)
      already_find_node[lw[0]] = G->find_node_id_gml(lw[0]);
    R->w[0] = already_find_node[lw[0]];
    
    if (already_find_node[lw[1]] == 0)
      already_find_node[lw[1]] =  G->find_node_id_gml(lw[1]);
    R->w[1] = already_find_node[lw[1]];
       
    R->w[2] = -1;
    R->w[3] = -1;
    R->w[4] = -1;
    R->w[5] = -1;

    fscanf (in, "%s %d %c %d %c %d ", str, &ls, &c, &lu, &c, &lv);
   
    if (already_find_node[lu] == 0)
      already_find_node[lu] = G->find_node_id_gml (lu);
    R->pair_u = already_find_node[lu];
    if (already_find_node[lv] == 0)
      already_find_node[lv] = G->find_node_id_gml (lv);
    R->pair_v =  already_find_node[lv];
    if (already_find_node[ls] == 0)
      already_find_node[ls] = G->find_node_id_gml (ls);
    R->s_uv = already_find_node[ls];
    
    R->pair_x = -1;
    R->pair_y = -1;
    R->s_xy = -1;

    R->pair_w = -1;
    R->pair_z = -1;
    R->s_wz = -1;

    do {
      fscanf (in, "%d ", &li);
      if (already_find_node[li] == 0)
	already_find_node[li] = G->find_node_id_gml(li);
      path->push_back(already_find_node[li]);
    } while (li != lw[1]);
      
    R->path = path;
    
    A1C1->push_back(R);
  }
  
  fclose (in);

  return A1C1;
}

vector<ring_gml *> * ring_gml::read_A2C2 (string file_name, graph_gml * G){
  FILE *in;
  int ls1, ls2, lu, lv, lx, ly, li;
  int lw[4];
  char c;
  char str[tstr];
  vector<int> * path;
  ring_gml * R;
  vector<ring_gml *> * A2C2;
  char type [5];

  in = fopen (file_name.c_str(),"r");
  
  if (in == NULL) {
    printf ("Error: open file %s\n", file_name.c_str());
    this->clear_gml ();
    return NULL;
  }

  fscanf (in, "%s ", type);

  if (feof(in))
    return NULL;

  A2C2 = new vector<ring_gml *>();

   /****acelerating the loading*****/
  int * already_find_node = (int *) calloc(10000, sizeof(int));
  /*******************************/

  while (!feof (in)){
    path = new vector<int>();
    R = new ring_gml();
    fscanf (in, "%d %c %d %d %c %d ", &lw[0], &c, &lw[1], &lw[2], &c, &lw[3]);
    
    if (already_find_node[lw[0]] == 0)
      already_find_node[lw[0]] = G->find_node_id_gml (lw[0]);
    R->w[0] = already_find_node[lw[0]];

    if (already_find_node[lw[1]] == 0)
      already_find_node[lw[1]] = G->find_node_id_gml (lw[1]);
    R->w[1] = already_find_node[lw[1]];

    if (already_find_node[lw[2]] == 0)
      already_find_node[lw[2]] = G->find_node_id_gml (lw[2]);
    R->w[2] = already_find_node[lw[2]];

    if (already_find_node[lw[3]] == 0)
      already_find_node[lw[3]] = G->find_node_id_gml (lw[3]);
    R->w[3] = already_find_node[lw[3]];

    R->w[4] = -1;
    R->w[5] = -1;
    
    fscanf (in, "%s %d %c %d %c %d %s %d %c %d %c %d ", str, &ls1, &c, &lu, &c, &lv, str, &ls2, &c, &lx, &c, &ly);
     

    if (already_find_node[lu] == 0)
      already_find_node[lu] = G->find_node_id_gml (lu);
    R->pair_u = already_find_node[lu];
    
    if (already_find_node[lv] == 0)
      already_find_node[lv] = G->find_node_id_gml (lv);
    R->pair_v = already_find_node[lv];

    if (already_find_node[ls1] == 0)
      already_find_node[ls1] = G->find_node_id_gml (ls1);
    R->s_uv = already_find_node[ls1];

    if (already_find_node[lx] == 0)
      already_find_node[lx] = G->find_node_id_gml (lx);
    R->pair_x = already_find_node[lx];
    
    if (already_find_node[ly] == 0)
      already_find_node[ly] = G->find_node_id_gml (ly);
    R->pair_y = already_find_node[ly];

    if (already_find_node[ls2] == 0)
      already_find_node[ls2] = G->find_node_id_gml (ls2);
    R->s_xy = already_find_node[ls2];
 
    R->pair_w = -1;
    R->pair_z = -1;
    R->s_wz = -1;
    
    do {
      fscanf (in, "%d ", &li);
      if (already_find_node[li] == 0)
	already_find_node[li] = G->find_node_id_gml(li);
      path->push_back(already_find_node[li]);
    } while (li != lw[1]);
      
    R->path = path;
    
    A2C2->push_back(R);
  }
  
  fclose (in);

  return A2C2;
}

vector<ring_gml *> * ring_gml::read_A3C3 (string file_name, graph_gml * G){
  FILE *in;
  int ls1, ls2, ls3, lu, lv, lx, ly, lw, lz, li;
  int lwe[6];
  char c;
  char str[tstr];
  vector<int> * path;
  ring_gml * R;
  vector<ring_gml *> * A3C3;
  char type [5];
  
  
  in = fopen (file_name.c_str(),"r");
  
  if (in == NULL) {
    printf ("Error: open file %s\n", file_name.c_str());
    this->clear_gml ();
    return NULL;
  }

  fscanf (in, "%s ", type);
  
  if (feof(in))
    return NULL;

  
  A3C3 = new vector<ring_gml *>();

  /****acelerating the loading*****/
  int * already_find_node = (int *) calloc(10000, sizeof(int));
  /*******************************/

  while (!feof (in)){
    path = new vector<int>();
    R = new ring_gml();
    fscanf (in, "%d %c %d %d %c %d %d %c %d ", 
	    &lwe[0], &c, &lwe[1], &lwe[2], &c, &lwe[3], &lwe[4], &c, &lwe[5]);

    
    if (already_find_node[lwe[0]] == 0)
      already_find_node[lwe[0]] = G->find_node_id_gml (lwe[0]);
    R->w[0] = already_find_node[lwe[0]];

    if (already_find_node[lwe[1]] == 0)
      already_find_node[lwe[1]] = G->find_node_id_gml (lwe[1]);
    R->w[1] = already_find_node[lwe[1]];

    if (already_find_node[lwe[2]] == 0)
      already_find_node[lwe[2]] = G->find_node_id_gml (lwe[2]);
    R->w[2] = already_find_node[lwe[2]];

    if (already_find_node[lwe[3]] == 0)
      already_find_node[lwe[3]] = G->find_node_id_gml (lwe[3]);
    R->w[3] = already_find_node[lwe[3]];

    if (already_find_node[lwe[4]] == 0)
      already_find_node[lwe[4]] = G->find_node_id_gml (lwe[4]);
    R->w[4] = already_find_node[lwe[4]];

    if (already_find_node[lwe[5]] == 0)
      already_find_node[lwe[5]] = G->find_node_id_gml (lwe[5]);
    R->w[5] = already_find_node[lwe[5]];
    
      
    fscanf (in, "%s %d %c %d %c %d %s %d %c %d %c %d %s %d %c %d %c %d ", 
	    str, &ls1, &c, &lu, &c, &lv, str, &ls2, &c, &lx, &c, &ly, str, &ls3, &c, &lw, &c, &lz);
     
    if (already_find_node[lu] == 0)
      already_find_node[lu] = G->find_node_id_gml (lu);
    R->pair_u = already_find_node[lu];
    
    if (already_find_node[lv] == 0)
      already_find_node[lv] = G->find_node_id_gml (lv);
    R->pair_v = already_find_node[lv];

    if (already_find_node[ls1] == 0)
      already_find_node[ls1] = G->find_node_id_gml (ls1);
    R->s_uv = already_find_node[ls1];

    if (already_find_node[lx] == 0)
      already_find_node[lx] = G->find_node_id_gml (lx);
    R->pair_x = already_find_node[lx];
    
    if (already_find_node[ly] == 0)
      already_find_node[ly] = G->find_node_id_gml (ly);
    R->pair_y = already_find_node[ly];

    if (already_find_node[ls2] == 0)
      already_find_node[ls2] = G->find_node_id_gml (ls2);
    R->s_xy = already_find_node[ls2];

    if (already_find_node[lw] == 0)
      already_find_node[lw] = G->find_node_id_gml (lw);
    R->pair_w = already_find_node[lw];
    
    if (already_find_node[lz] == 0)
      already_find_node[lz] = G->find_node_id_gml (lz);
    R->pair_z = already_find_node[lz];

    if (already_find_node[ls3] == 0)
      already_find_node[ls3] = G->find_node_id_gml (ls3);
    R->s_wz = already_find_node[ls3];

    
    do {
      fscanf (in, "%d ", &li);
      if (already_find_node[li] == 0)
	already_find_node[li] = G->find_node_id_gml(li);
      path->push_back(already_find_node[li]);
    } while (li != lwe[1]);
      
    R->path = path;
    
    A3C3->push_back(R);
  }
  
  fclose (in);

  return A3C3;
}



void ring_gml::print_A1C1_rings (graph_gml * G) {
  printf ("%4s - %4s\n", G->node_label[this->w[0]].c_str(), G->node_label[this->w[1]].c_str());
  printf ("s1%5s u%5s v%5s\n", G->node_label[this->s_uv].c_str(), 
	  G->node_label[this->pair_u].c_str(), G->node_label[this->pair_v].c_str());
  for (vector<int>::iterator it = this->path->begin(); it < this->path->end(); it++)
    printf ("%5d", *it);
  printf ("\n");
}

void ring_gml::clear_gml () {
  for (unsigned int i = 0; i < this->path->size(); i++) 
    this->path->clear();
				  
}
