#include <iostream>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "graph_gml.h"


void remove_aspas (char word2 []) {
  int i = 1;
  while (word2[i] != '"'){
    word2[i-1] = word2[i];
    i++;
  }
  word2[i-1] = '\0';  
}

graph_gml::graph_gml (){}

graph_gml::graph_gml (string file_gml) {
  FILE * in;
  char word1 [100], word2[100], word3[100], word4[100], word5[100];
  int n, m, id, source, target, inside;
  string label, fill, line, type;
  double x, y, w, h, lineWidth, width;
  double * v_x;
  double * v_y;

  in = fopen (file_gml.c_str(), "r");

  if (in == NULL){
    cout << "Error opening "<< file_gml.c_str() << endl;
    exit (0);
  }

  fscanf (in, "%s ", word1);
  
  while (strcmp (word1, "node") != 0) {
    fscanf (in, "%s ", word1);
  }
  
  n = 0;
  m = 0;
  
  while (strcmp (word1, "node") == 0) {
    /*[*/
    fscanf (in, "%s ", word1);
    
    /*id*/
    fscanf (in, "%s %d ", word1, &id);
    this->node_id.push_back (id);
    
    /*template*/
    fscanf (in, "%s %s %s %s %s ", word1, word2, word3, word4, word5);
    word2[0] = word2[1];
    word2[1] = word2[2];
    word2[2] = '\0';
    this->node_cla.push_back (word2);
    this->node_subcla.push_back (word3);
    this->node_nasc.push_back (atoi(word4));
    word5[5] = '\0';
    this->node_morte.push_back (atoi(word5));
    /*cout << this->node_cla.at(n) << " " << this->node_subcla.at(n) << " " <<
      this->node_nasc.at(n) << " " << this->node_morte.at(n) << endl;*/
    
    /*label*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_label.push_back (word2);
    
    /*graphics [*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*x*/
    fscanf (in, "%s %lf ", word1, &x);
    this->node_x.push_back (x);
    
    /*y*/
    fscanf (in, "%s %lf ", word1, &y);
    this->node_y.push_back (y);
    
    /*w*/
    fscanf (in, "%s %lf ", word1, &w);
    this->node_w.push_back (w);
    
    /*h*/
    fscanf (in, "%s %lf ", word1, &h);
    this->node_h.push_back (h);
    
    /*fill*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_fill.push_back (word2);
    
    /*line*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_line.push_back (word2);
    
    /*pattern*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*stipple*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*lineWidth*/
    fscanf (in, "%s %lf ", word1, &lineWidth);
    this->node_lineWidth.push_back (lineWidth);
    
    /*type*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_type.push_back (word2);
    
    /*width*/
    fscanf (in, "%s %lf ", word1, &width);
    this->node_width.push_back (width);
    
    /*] ]*/
    fscanf (in, "%s %s ", word1, word2);
    
    n++;
    
    /*node or edge*/
    fscanf (in, "%s ", word1);
    
  }
  
  while (strcmp (word1, "edge") == 0) {
    
    /*[*/
    fscanf (in, "%s ", word1);
    
    /*source*/
    fscanf (in, "%s %d ", word1, &source);
    this->edge_source.push_back (source);
    
    /*target*/
    fscanf (in, "%s %d ", word1, &target);
    this->edge_target.push_back (target);
    
    /*graphics [*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*type*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*arrow*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*stipple*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*lineWidth*/
    fscanf (in, "%s %lf ", word1, &lineWidth);
    this->edge_lineWidth.push_back (lineWidth);
    
    inside = 0;
    /*Line or fill*/
    fscanf (in, "%s %s ", word1, word2);
    if (strcmp (word1, "Line") == 0) {
      
      int k = 0;
      v_x = (double *) malloc (sizeof (double) * MAX_POINTS_EDGES);
      v_y = (double *) malloc (sizeof (double) * MAX_POINTS_EDGES);
      inside = 1;
      
      /*point*/
      fscanf (in, "%s ", word1);
      while (strcmp (word1, "point") == 0) {
	/*[*/
	fscanf (in, "%s ", word2);
	/*x*/
	fscanf (in, "%s %lf ", word1, &x);
	v_x[k] = x;
	/*y*/
	fscanf (in, "%s %lf ", word1, &y);
	v_y[k] = y;
	/*]*/
	fscanf (in, "%s ", word2);
	/*point or ]*/
	fscanf (in, "%s ", word1);
	k++;
	
	if (k > MAX_POINTS_EDGES){
	  printf ("Error: const MAX_POINTS_EDGES isn't enought.\n");
	  this->clear_gml ();
	  exit (0);
	}
	
      }
      
      this->edge_num_points.push_back (k);
      this->edge_points_x.push_back (v_x);
      this->edge_points_y.push_back (v_y);
      
    }
    else {
      this->edge_num_points.push_back (0);
      this->edge_points_x.push_back (NULL);
      this->edge_points_y.push_back (NULL);      
      remove_aspas (word2);
      this->edge_fill.push_back (word2);
    }
    if (inside) {
      /*fill*/
      fscanf (in, "%s %s ", word1, word2);
      remove_aspas (word2);
      this->edge_fill.push_back (word2);
    }
    
    /*]]*/
    fscanf (in, "%s ", word1);    
    fscanf (in, "%s ", word1);
    
    m++;
    
    /*edge or ]*/
    fscanf (in, "%s ", word1);
  }
    
  fclose (in);

  this->num_nodes = n;
  this->num_edges = m;

}

graph_gml::~graph_gml (){}

void graph_gml::read_gml (char * file_gml){
  FILE * in;
  char word1 [100], word2[100], word3[100], word4[100], word5[100];
  int n, m, id, source, target, inside;
  string label, fill, line, type;
  double x, y, w, h, lineWidth, width;
  double * v_x;
  double * v_y;

  if (file_gml[0] == '\0')
    return;

  in = fopen (file_gml, "r");

  if (in == NULL){
    cout << "Error opening "<< file_gml << endl;
    return;
  }

  fscanf (in, "%s ", word1);
  
  while (strcmp (word1, "node") != 0) {
    fscanf (in, "%s ", word1);
  }
  
  n = 0;
  m = 0;
  
  //cout << "3" << endl;
  
  while (strcmp (word1, "node") == 0) {
    /*[*/
    fscanf (in, "%s ", word1);
    
    /*id*/
    fscanf (in, "%s %d ", word1, &id);
    this->node_id.push_back (id);
    
    /*template*/
    fscanf (in, "%s %s %s %s %s ", word1, word2, word3, word4, word5);
    word2[0] = word2[1];
    word2[1] = word2[2];
    word2[2] = '\0';
    this->node_cla.push_back (word2);
    this->node_subcla.push_back (word3);
    this->node_nasc.push_back (atoi(word4));
    word5[5] = '\0';
    this->node_morte.push_back (atoi(word5));
    /*cout << this->node_cla.at(n) << " " << this->node_subcla.at(n) << " " <<
      this->node_nasc.at(n) << " " << this->node_morte.at(n) << endl;*/
    
    /*label*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_label.push_back (word2);
    
    /*graphics [*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*x*/
    fscanf (in, "%s %lf ", word1, &x);
    this->node_x.push_back (x);
    
    /*y*/
    fscanf (in, "%s %lf ", word1, &y);
    this->node_y.push_back (y);
    
    /*w*/
    fscanf (in, "%s %lf ", word1, &w);
    this->node_w.push_back (w);
    
    /*h*/
    fscanf (in, "%s %lf ", word1, &h);
    this->node_h.push_back (h);
    
    /*fill*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_fill.push_back (word2);
    
    /*line*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_line.push_back (word2);
    
    /*pattern*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*stipple*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*lineWidth*/
    fscanf (in, "%s %lf ", word1, &lineWidth);
    this->node_lineWidth.push_back (lineWidth);
    
    /*type*/
    fscanf (in, "%s %s ", word1, word2);
    remove_aspas (word2);
    this->node_type.push_back (word2);
    
    /*width*/
    fscanf (in, "%s %lf ", word1, &width);
    this->node_width.push_back (width);
    
    /*] ]*/
    fscanf (in, "%s %s ", word1, word2);
    
    n++;
    
    /*node or edge*/
    fscanf (in, "%s ", word1);
    
  }
  
  while (strcmp (word1, "edge") == 0) {
    
    /*[*/
    fscanf (in, "%s ", word1);
    
    /*source*/
    fscanf (in, "%s %d ", word1, &source);
    this->edge_source.push_back (source);
    
    /*target*/
    fscanf (in, "%s %d ", word1, &target);
    this->edge_target.push_back (target);
    
    /*graphics [*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*type*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*arrow*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*stipple*/
    fscanf (in, "%s %s ", word1, word2);
    
    /*lineWidth*/
    fscanf (in, "%s %lf ", word1, &lineWidth);
    this->edge_lineWidth.push_back (lineWidth);
    
    inside = 0;
    /*Line or fill*/
    fscanf (in, "%s %s ", word1, word2);
    if (strcmp (word1, "Line") == 0) {
      
      int k = 0;
      v_x = (double *) malloc (sizeof (double) * MAX_POINTS_EDGES);
      v_y = (double *) malloc (sizeof (double) * MAX_POINTS_EDGES);
      inside = 1;
      
      /*point*/
      fscanf (in, "%s ", word1);
      while (strcmp (word1, "point") == 0) {
	/*[*/
	fscanf (in, "%s ", word2);
	/*x*/
	fscanf (in, "%s %lf ", word1, &x);
	v_x[k] = x;
	/*y*/
	fscanf (in, "%s %lf ", word1, &y);
	v_y[k] = y;
	/*]*/
	fscanf (in, "%s ", word2);
	/*point or ]*/
	fscanf (in, "%s ", word1);
	k++;
	
	if (k > MAX_POINTS_EDGES){
	  printf ("Error: const MAX_POINTS_EDGES isn't enought.\n");
	  this->clear_gml ();
	  exit (0);
	}
	
      }
      
      this->edge_num_points.push_back (k);
      this->edge_points_x.push_back (v_x);
      this->edge_points_y.push_back (v_y);
      
    }
    else {
      this->edge_num_points.push_back (0);
      this->edge_points_x.push_back (NULL);
      this->edge_points_y.push_back (NULL);      
      remove_aspas (word2);
      this->edge_fill.push_back (word2);
    }
    if (inside) {
      /*fill*/
      fscanf (in, "%s %s ", word1, word2);
      remove_aspas (word2);
      this->edge_fill.push_back (word2);
    }
    
    /*]]*/
    fscanf (in, "%s ", word1);    
    fscanf (in, "%s ", word1);
    
    m++;
    
    /*edge or ]*/
    fscanf (in, "%s ", word1);
  }
    
  fclose (in);

  this->num_nodes = n;
  this->num_edges = m;
}

void graph_gml::print_gml (){

}

void graph_gml::print_graph_gml (){
  int n, m;
  n = this->num_nodes;
  m = this->num_edges;

  cout << "Nodes number: " << n << endl;
  cout << "Edges number: " << m << endl;
  cout << endl;

  for (int i = 0; i < n; i++){
    cout << this->node_id[i] << endl;
    cout << this->node_label[i] << endl;
    cout << this->node_x[i] << endl;
    cout << this->node_y[i] << endl;
    cout << this->node_w[i] << endl;
    cout << this->node_h[i] << endl;
    cout << this->node_fill[i] << endl;
    cout << this->node_line[i] << endl;
    cout << this->node_lineWidth[i] << endl;
    cout << this->node_type[i] << endl;
    cout << this->node_width[i] << endl;
    cout << endl;
  }
  
  for (int i = 0; i < m; i++) {
    cout << this->edge_source[i] << endl;
    cout << this->edge_target[i] << endl;
    cout << this->edge_lineWidth[i] << endl;
    
    if (this->edge_num_points[i] > 0)
      for (int j = 0; j < this->edge_num_points[i]; j++)
	cout << this->edge_points_x[i][j] << " " << this->edge_points_y[i][j] << endl;
    
    cout << this->edge_fill[i] << endl;
    cout << endl;
  }

}

void graph_gml::clear_gml (){
  /*nodes*/
  this->node_id.clear ();
  this->node_label.clear ();
  this->node_x.clear ();
  this->node_y.clear ();
  this->node_w.clear ();
  this->node_h.clear ();
  this->node_fill.clear ();
  this->node_line.clear ();
  this->node_lineWidth.clear ();
  this->node_type.clear ();
  this->node_width.clear ();
  this->node_cla.clear ();

  /*edges*/
  this->edge_source.clear ();
  this->edge_target.clear ();
  this->edge_lineWidth.clear ();
  this->edge_fill.clear ();
  for (int i = 0; i < this->edge_num_points[i]; i++){
    free (this->edge_points_x[i]);
    free (this->edge_points_y[i]);
  }
  this->edge_num_points.clear ();
  this->edge_points_x.clear ();
  this->edge_points_y.clear ();  
}

int graph_gml::find_node_id_gml (int label) {
  int i, n;
  int node_label;
  n = this->num_nodes;
  for (i = 0; i < n; i++){
    node_label = atoi ((this->node_label[i]).c_str());
    if (label == node_label)
      return this->node_id [i];
  }
  return -1;
}

/*Recebe uma aresta $e$ (não sabemos a direção dessa aresta).
  Devolve o indice de $e$ na estrutura.*/
int graph_gml::find_edge_id_gml (int label1, int label2) {
  int id_1 = this->find_node_id_gml (label1);
  int id_2 = this->find_node_id_gml (label2);
  int m = this->num_edges;
  for (int i = 0; i < m; i++) {
    if ((this->edge_target[i] == id_1 && this->edge_source[i] == id_2) ||
	(this->edge_target[i] == id_2 && this->edge_source[i] == id_1))
      return i;
  }
  return -1;
}

bool graph_gml::son (int label_v, int label_w) {
  int id_v = this->find_node_id_gml (label_v);
  int id_w = this->find_node_id_gml (label_w);
  int m = this->num_edges;
  for (int i = 0; i < m; i++) {
    if (this->edge_target[i] == id_v && this->edge_source[i] == id_w)
      return true;
  }
  return false;
}


